/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.collect.Maps;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Config;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Log;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.util.MessageBundle;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MaskEditor
extends PropertyEditor
implements DocumentListener,
ActionListener {
    protected JFormattedTextField _field;
    protected JButton _button;
    protected JPopupMenu _popup;
    protected String[] _flags;
    protected static Map<String, String[]> _modes = Maps.newHashMap();

    static {
        Config config = new Config("/rsrc/config/editor/mask");
        Iterator it = config.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            _modes.put(key, config.getValue(key, ArrayUtil.EMPTY_STRING));
        }
    }

    public static int getFlag(String mode, String flag) {
        Object[] flags = _modes.get(mode);
        int idx = flags == null ? -1 : ListUtil.indexOf((Object[])flags, (Object)flag);
        return idx == -1 ? 0 : 1 << idx;
    }

    public static String toString(String mode, int bits) {
        if (bits == 0) {
            return "<none>";
        }
        String[] flags = _modes.get(mode);
        StringBuilder buf = new StringBuilder();
        int ii = 0;
        int nn = flags.length;
        while (bits != 0 && ii < nn) {
            if ((bits & 1) == 1) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(flags[ii]);
            }
            bits >>>= 1;
            ++ii;
        }
        if (bits != 0) {
            buf.append(" _leftover-bits-").append(bits << flags.length);
        }
        return buf.toString();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        long value;
        try {
            value = Long.parseLong(this._field.getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        Number nvalue = this.fromLong(value);
        if (!this._property.get(this._object).equals(nvalue)) {
            this._property.set(this._object, nvalue);
            this.fireStateChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JCheckBoxMenuItem item;
        if (event.getSource() != this._button) {
            long value = 0L;
            int ii = 0;
            int nn = this._popup.getComponentCount();
            while (ii < nn) {
                JCheckBoxMenuItem item2 = (JCheckBoxMenuItem)this._popup.getComponent(ii);
                int idx = ListUtil.indexOf((Object[])this._flags, (Object)item2.getText());
                if (item2.isSelected()) {
                    value |= 1L << idx;
                }
                ++ii;
            }
            Number nvalue = this.fromLong(value);
            if (!this._property.get(this._object).equals(nvalue)) {
                this._property.set(this._object, nvalue);
                this.fireStateChanged();
            }
            this.update();
            return;
        }
        if (this._popup == null) {
            this._popup = new JPopupMenu();
            String[] nn = this._flags;
            int nvalue = this._flags.length;
            int n = 0;
            while (n < nvalue) {
                String flag = nn[n];
                if (!StringUtil.isBlank((String)flag)) {
                    item = new JCheckBoxMenuItem(flag);
                    this._popup.add(item);
                    item.addActionListener(this);
                }
                ++n;
            }
        }
        long value = ((Number)this._property.get(this._object)).longValue();
        int ii = 0;
        int nn = this._popup.getComponentCount();
        while (ii < nn) {
            int idx = ListUtil.indexOf((Object[])this._flags, (Object)(item = (JCheckBoxMenuItem)this._popup.getComponent(ii)).getText());
            item.setSelected((value & 1L << idx) != 0L);
            ++ii;
        }
        this._popup.show(this._button, 0, this._button.getHeight());
    }

    @Override
    public void update() {
        this._field.getDocument().removeDocumentListener(this);
        this._field.setValue(this._property.get(this._object));
        this._field.getDocument().addDocumentListener(this);
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        fmt.setGroupingUsed(false);
        this._field = new JFormattedTextField(fmt);
        this.add(this._field);
        this._field.setColumns(4);
        this._field.setHorizontalAlignment(4);
        this._field.getDocument().addDocumentListener(this);
        this._button = new JButton("...");
        this.add(this._button);
        this._button.setPreferredSize(new Dimension(20, 20));
        this._button.addActionListener(this);
        String mode = this.getMode();
        String[] names = _modes.get(mode);
        if (names == null) {
            if (!StringUtil.isBlank((String)mode)) {
                Log.log.warning((Object)"Unknown mask mode.", new Object[]{"mode", mode});
            }
            this._flags = new String[8];
            int ii = 0;
            while (ii < this._flags.length) {
                this._flags[ii] = String.valueOf(ii);
                ++ii;
            }
        } else {
            MessageBundle msgs = this._ctx.getMessageManager().getBundle("editor.mask");
            this._flags = new String[names.length];
            int ii = 0;
            while (ii < names.length) {
                String name = names[ii];
                this._flags[ii] = StringUtil.isBlank((String)name) ? name : this.getLabel(name, msgs);
                ++ii;
            }
        }
    }

    protected Number fromLong(long value) {
        Class<?> type = this._property.getType();
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (int)value;
        }
        if (type == Long.TYPE || type == Long.class) {
            return value;
        }
        return (short)value;
    }
}

