/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Reference;
import com.threerings.config.ReferenceConstraints;
import com.threerings.config.swing.ConfigBox;
import com.threerings.editor.Log;
import com.threerings.editor.swing.PropertyEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;

public class ConfigEditor
extends PropertyEditor
implements ActionListener {
    protected ConfigBox _box;

    @Override
    public void actionPerformed(ActionEvent event) {
        String value = this._box.getSelectedConfig();
        if (!Objects.equal((Object)this._property.get(this._object), (Object)value)) {
            this._property.set(this._object, value);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        this._box.setSelectedConfig((String)this._property.get(this._object));
    }

    @Override
    protected void didInit() {
        ConfigGroup<ManagedConfig>[] groups;
        this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
        Reference ref = this._property.getAnnotation(Reference.class);
        ConfigGroup<ManagedConfig>[] configGroupArray = groups = ref != null ? this._ctx.getConfigManager().getGroups(ref.value()) : this._ctx.getConfigManager().getGroups(this.getMode());
        if (groups.length == 0) {
            Log.log.warning((Object)"Missing groups for config editor.", new Object[]{"type", ref != null ? ref.value() : this.getMode()});
            return;
        }
        this._box = new ConfigBox(this._msgs, groups, this._property.nullable(), this._property.getAnnotation(ReferenceConstraints.class), new Supplier<Predicate<? super ManagedConfig>>(){

            public Predicate<? super ManagedConfig> get() {
                if (!(ConfigEditor.this._object instanceof ManagedConfig)) {
                    return Predicates.alwaysTrue();
                }
                final ManagedConfig ourCfg = (ManagedConfig)ConfigEditor.this._object;
                return new Predicate<ManagedConfig>(){

                    public boolean apply(ManagedConfig cfg) {
                        return ourCfg.getName() != cfg.getName() || ourCfg.getConfigGroup() != cfg.getConfigGroup();
                    }
                };
            }
        });
        this._box.addActionListener(this);
        this.add(this._box);
    }
}

