/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.samskivert.util.Config;
import com.samskivert.util.ListUtil;
import com.threerings.editor.swing.PropertyEditor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ArrayMaskEditor
extends PropertyEditor
implements ActionListener {
    protected JComboBox _box;
    protected String[] _flags;
    protected static Map<String, String[]> _modes = Maps.newHashMap();

    static {
        Config config = new Config("/rsrc/config/editor/arraymask");
        Iterator it = config.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            _modes.put(key, config.getValue(key, new String[0]));
        }
    }

    public static int getIndex(String mode, String flag) {
        Object[] flags = _modes.get(mode);
        int idx = flags == null ? -1 : ListUtil.indexOf((Object[])flags, (Object)flag);
        return idx;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object selected = this._box.getSelectedItem();
        if (!Objects.equal((Object)this._property.get(this._object), (Object)selected)) {
            this._property.set(this._object, selected);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        Object[] options = this.getOptions();
        this._box.setModel(new DefaultComboBoxModel<Object>(options));
        this._box.setSelectedItem(this._property.get(this._object));
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(String.valueOf(this.getPropertyLabel()) + ":"));
        this._box = new JComboBox();
        this.add(this._box);
        this._box.addActionListener(this);
        String mode = this.getMode();
        String[] names = _modes.get(mode);
        this._flags = names == null || names.length == 0 ? new String[0] : names;
    }

    protected Object[] getOptions() {
        return this._flags;
    }
}

