/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Property;
import com.threerings.editor.swing.BasePropertyEditor;
import com.threerings.editor.swing.DirectDialog;
import com.threerings.editor.swing.ParameterHighlighter;
import com.threerings.editor.util.EditorContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public abstract class BaseEditorPanel
extends BasePropertyEditor {
    protected Property[] _ancestors;
    protected boolean _omitColumns;
    protected Object _object;
    protected DirectDialog _ddialog;

    public BaseEditorPanel(EditorContext ctx, Property[] ancestors, boolean omitColumns) {
        this._ctx = ctx;
        this._ancestors = ancestors;
        this._omitColumns = omitColumns;
        this._msgmgr = ctx.getMessageManager();
        this._msgs = this._msgmgr.getBundle("editor.default");
        if (ancestors == null) {
            this.getInputMap(2).put(KeyStroke.getKeyStroke(67, 3), "copy_path");
            this.getActionMap().put("copy_path", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    BaseEditorPanel.this.copyPropertyPath(BaseEditorPanel.this.getMousePath());
                }
            });
            this.getInputMap(2).put(KeyStroke.getKeyStroke(68, 3), "direct_path");
            this.getActionMap().put("direct_path", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    BaseEditorPanel.this.createDirectPath(BaseEditorPanel.this.getMousePath());
                }
            });
            new ParameterHighlighter(this);
        }
        this.setLayout((LayoutManager)new VGroupLayout(this.isEmbedded() ? GroupLayout.NONE : GroupLayout.STRETCH, GroupLayout.STRETCH, 5, GroupLayout.TOP));
    }

    public Property[] getAncestors() {
        return this._ancestors;
    }

    public boolean getOmitColumns() {
        return this._omitColumns;
    }

    public void setObject(Object object) {
        this._object = object;
    }

    public Object getObject() {
        return this._object;
    }

    protected boolean isEmbedded() {
        return this._ancestors != null;
    }

    protected void createDirectPath(String path) {
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.length() > 0 && this._object instanceof ParameterizedConfig) {
            if (((ParameterizedConfig)this._object).isInvalidParameterPath(path)) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            String name = path.substring(path.lastIndexOf(".") + 1);
            if (name.endsWith("]")) {
                int brack1 = name.lastIndexOf(91);
                int quote2 = name.lastIndexOf(34);
                String string = name = quote2 > brack1 ? name.substring(brack1 + 2, quote2) : name.substring(0, brack1);
            }
            if (this._ddialog == null) {
                this._ddialog = DirectDialog.createDialog((Component)((Object)this), this._ctx);
            }
            this._ddialog.show(this, name, path);
        }
    }

    public abstract void update();
}

