/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.tools;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.primitives.Primitives;
import com.samskivert.util.DependencyGraph;
import com.samskivert.util.StringUtil;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.util.ConfigId;
import com.threerings.config.util.DependencyGatherer;
import com.threerings.editor.Strippable;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.export.Exporter;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.util.MessageManager;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ConfigFlattener {
    protected Set<SuppressableWarning> _suppressedWarnings = EnumSet.noneOf(SuppressableWarning.class);

    public static void main(String[] args) throws IOException {
        boolean isXML = true;
        String ext = ".xml";
        switch (args.length) {
            default: {
                ConfigFlattener.errUsageAndExit();
                return;
            }
            case 3: {
                ext = args[2];
                isXML = ".xml".equalsIgnoreCase(ext);
            }
            case 2: 
        }
        String rsrcDir = args[0];
        String outDir = args[1];
        new ConfigFlattener().flattenAndStrip(rsrcDir, outDir, ext, isXML);
    }

    protected static void errUsageAndExit() {
        System.err.println("Args: <rsrcDir> <outDir> [fileExtension (default='.xml')]");
        System.err.println("If the extension is provided and not '.xml', output will be binary.");
        System.exit(1);
    }

    public ConfigFlattener suppressWarnings(SuppressableWarning ... warnings) {
        this._suppressedWarnings.addAll(Arrays.asList(warnings));
        return this;
    }

    public void flattenAndStrip(String rsrcDir, String outDir) throws IOException {
        this.flattenAndStrip(rsrcDir, outDir, ".xml", true);
    }

    public void flattenAndStrip(String rsrcDir, String outDir, String extension, boolean isXML) throws IOException {
        FlattenContext ctx = new FlattenContext(rsrcDir, outDir, true);
        Exporter.Replacer replacer = this.flatten(ctx.cfgmgr);
        ctx.cfgmgr.saveAll(ctx.destDir, extension, isXML);
        this.copyManagerProperties(new File(ctx.configDir, "manager.properties"), new File(ctx.destDir, "manager.txt"));
    }

    public Exporter.Replacer flatten(ConfigManager cfgmgr) {
        ConfigId id;
        FlatDependencyGatherer gatherer = new FlatDependencyGatherer(cfgmgr);
        ReferenceMapper mapper = this.createReferenceMapper(gatherer);
        int count = 0;
        while ((id = gatherer.getNextAvailable()) != null) {
            ++count;
            ConfigGroup<? extends ManagedConfig> group = cfgmgr.getGroup(id.clazz);
            ManagedConfig cfg = group.getRawConfig(id.name);
            List<ConfigReference<?>> list = mapper.getReferences(id);
            if (!list.isEmpty()) {
                HashMap newNames;
                HashSet paramNames;
                if (cfg instanceof ParameterizedConfig) {
                    paramNames = Sets.newHashSet();
                    Parameter[] parameterArray = ((ParameterizedConfig)cfg).parameters;
                    int n = ((ParameterizedConfig)cfg).parameters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Parameter p = parameterArray[n2];
                        paramNames.add(p.name);
                        ++n2;
                    }
                    newNames = Maps.newHashMap();
                } else {
                    paramNames = ImmutableSet.of();
                    newNames = null;
                }
                for (ConfigReference<?> ref : list) {
                    ArgumentMap args = ref.getArguments();
                    args.keySet().retainAll(paramNames);
                    if (args.isEmpty()) continue;
                    String newName = (String)newNames.get(args);
                    if (newName == null) {
                        ArgumentMap key = args.clone();
                        int code = this.generateHash(key);
                        newName = Integer.toHexString(code);
                        while (newNames.containsValue(newName)) {
                            newName = Integer.toHexString(++code);
                        }
                        ManagedConfig newCfg = cfg.getInstance(key);
                        newCfg.setName(String.valueOf(id.name) + "~" + newName);
                        this.clearParameters(newCfg);
                        group.addConfig(newCfg, false);
                        newNames.put(key, newName);
                        mapper.noteFlattenedConfig(newCfg);
                    }
                    new ConfigReference(String.valueOf(id.name) + "~" + newName).copy(ref);
                }
            }
            ManagedConfig newCfg = cfg.getInstance((ArgumentMap)null);
            this.clearParameters(newCfg);
            group.addConfig(newCfg, false);
            mapper.noteFlattenedConfig(newCfg);
        }
        return mapper.getReplacer(cfgmgr);
    }

    public Properties getManagerProperties(File source) throws IOException {
        Properties props = new Properties();
        props.load(new FileReader(source));
        return props;
    }

    public void copyManagerProperties(File source, File dest) throws IOException {
        Files.write((byte[])this.getStrippedManagerProperties(this.getManagerProperties(source)), (File)dest);
    }

    public byte[] getStrippedManagerProperties(Properties props) throws IOException {
        this.stripManagerProperties(props);
        StringWriter writer = new StringWriter();
        props.store(writer, "");
        String value = writer.toString();
        String PATTERN = "(?m)^\\#.*[\\r\\n]+";
        value = value.replaceAll("(?m)^\\#.*[\\r\\n]+", "");
        return value.getBytes(Charsets.UTF_8);
    }

    public void stripManagerProperties(Properties props) {
        ArrayList types = Lists.newArrayList((Object[])StringUtil.parseStringArray((String)props.getProperty("types", "")));
        types.add("resource");
        for (String type : types) {
            String key = String.valueOf(type) + ".classes";
            ArrayList classes = Lists.newArrayList((Object[])StringUtil.parseStringArray((String)props.getProperty(key, "")));
            boolean changed = false;
            Iterator itr = classes.iterator();
            while (itr.hasNext()) {
                try {
                    Class<?> clazz = Class.forName((String)itr.next());
                    if (!clazz.isAnnotationPresent(Strippable.class)) continue;
                    itr.remove();
                    changed = true;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("This shouldn't happen", e);
                }
            }
            if (!changed) continue;
            props.put(key, StringUtil.joinEscaped((String[])((String[])Iterables.toArray((Iterable)classes, String.class))));
        }
    }

    protected void clearParameters(ManagedConfig cfg) {
        if (cfg instanceof ParameterizedConfig) {
            ((ParameterizedConfig)cfg).parameters = Parameter.EMPTY_ARRAY;
        }
    }

    protected int generateHash(ArgumentMap args) {
        int hash = 0;
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            hash += entry.getKey().hashCode() ^ this.generateHash(entry.getValue());
        }
        return hash;
    }

    protected int generateHash(Object obj) {
        if (obj != null) {
            if (obj instanceof String || Primitives.isWrapperType(obj.getClass())) {
                return obj.hashCode();
            }
            if (obj instanceof ArgumentMap) {
                return this.generateHash((ArgumentMap)obj);
            }
        }
        return 0;
    }

    protected ReferenceMapper createReferenceMapper(FlatDependencyGatherer gatherer) {
        return new ReferenceMapper(gatherer);
    }

    protected void warn(SuppressableWarning type, Object ... details) {
        if (!this._suppressedWarnings.contains((Object)type)) {
            ClydeLog.log.warning((Object)type.message, details);
        }
    }

    protected class FlatDependencyGatherer
    extends DependencyGatherer.PreExamined {
        protected ConfigId _current;
        protected final Set<Class<?>> _cfgClasses;
        protected final DependencyGraph<ConfigId> _graph;

        public FlatDependencyGatherer(ConfigManager cfgmgr) {
            super(cfgmgr);
            this._cfgClasses = Sets.newHashSet();
            this._graph = new DependencyGraph();
            for (ConfigGroup<?> group : cfgmgr.getGroups()) {
                Class<?> clazz = group.getConfigClass();
                this._cfgClasses.add(clazz);
                for (ManagedConfig cfg : group.getRawConfigs()) {
                    this._graph.add((Object)new ConfigId(clazz, cfg.getName()));
                }
            }
            this.gather(cfgmgr);
        }

        public ConfigId getNextAvailable() {
            return this._graph.isEmpty() ? null : (ConfigId)this._graph.removeAvailableElement();
        }

        @Override
        protected void findReferences(ManagedConfig cfg) {
            Class<ManagedConfig> clazz = cfg.getConfigGroup().getConfigClass();
            this._current = new ConfigId(clazz, cfg.getName());
            try {
                super.findReferences(cfg);
            }
            finally {
                this._current = null;
            }
        }

        @Override
        public void add(Class<? extends ManagedConfig> clazz, ConfigReference<?> ref) {
            if (ref == null || ref.getArguments().isEmpty() || !this._cfgClasses.contains(clazz)) {
                return;
            }
            ConfigId id = new ConfigId(clazz, ref.getName());
            try {
                if (!this._graph.dependsOn((Object)id, (Object)this._current)) {
                    this._graph.addDependency((Object)id, (Object)this._current);
                }
            }
            catch (Exception e) {
                ClydeLog.log.warning((Object)"Oh fugging shit", new Object[]{"id", id, "current", this._current, e});
            }
        }

        @Override
        public Class<? extends ManagedConfig> getParameterConfigType(ConfigId id, String param) {
            return super.getParameterConfigType(id, param);
        }

        @Override
        protected void findArgumentReferences(ConfigReference<?> ref, Class<? extends ManagedConfig> clazz, Set<Object> seen) {
            ConfigId oldCurrent = this._current;
            this._current = new ConfigId(clazz, ref.getName());
            try {
                super.findArgumentReferences(ref, clazz, seen);
            }
            finally {
                this._current = oldCurrent;
            }
        }
    }

    protected static class FlattenContext {
        public final ConfigManager cfgmgr;
        public final File configDir;
        public final File destDir;

        public FlattenContext(String rsrcDir, String outDir, boolean stripOnSave) throws IOException {
            FileResourceManager rsrcmgr = new FileResourceManager(rsrcDir);
            this.configDir = rsrcmgr.getResourceFile("config/");
            Preconditions.checkArgument((boolean)this.configDir.isDirectory(), (String)"%s isn't a directory", (Object[])new Object[]{this.configDir});
            Preconditions.checkArgument((new File(this.configDir, "manager.properties").exists() || new File(this.configDir, "manager.txt").exists() ? 1 : 0) != 0, (Object)"cannot find manager descriptor");
            this.destDir = new File(outDir);
            Preconditions.checkArgument((boolean)this.destDir.isDirectory(), (String)"%s isn't a directory", (Object[])new Object[]{this.destDir});
            this.cfgmgr = stripOnSave ? new StripOnSaveConfigManager((ResourceManager)rsrcmgr, null, "config/") : new ConfigManager((ResourceManager)rsrcmgr, null, "config/");
            this.cfgmgr.init();
        }
    }

    protected class ReferenceMapper
    extends DependencyGatherer {
        protected final FlatDependencyGatherer _flatGatherer;
        protected final ListMultimap<ConfigId, ConfigReference<?>> _refs = ArrayListMultimap.create();
        protected final Map<ConfigReference<?>, Class<?>> _refToClass = Maps.newIdentityHashMap();
        protected final Map<String, Class<?>> _bareToClass = Maps.newIdentityHashMap();

        public ReferenceMapper(FlatDependencyGatherer flatGatherer) {
            this._flatGatherer = flatGatherer;
        }

        public void noteFlattenedConfig(ManagedConfig cfg) {
            this.findReferences(cfg);
        }

        public List<ConfigReference<?>> getReferences(ConfigId id) {
            return Collections.unmodifiableList(this._refs.get((Object)id));
        }

        public Exporter.Replacer getReplacer(ConfigManager cfgmgr) {
            return null;
        }

        @Override
        public void add(Class<? extends ManagedConfig> clazz, ConfigReference<?> ref) {
            if (ref != null) {
                this.mapRefToClass(ref, clazz);
            }
            if (ref == null || ref.getArguments().isEmpty() || !this._flatGatherer._cfgClasses.contains(clazz)) {
                return;
            }
            ConfigId id = new ConfigId(clazz, ref.getName());
            this._refs.put((Object)id, ref);
        }

        @Override
        protected Class<? extends ManagedConfig> getParameterConfigType(ConfigId id, String param) {
            return this._flatGatherer.getParameterConfigType(id, param);
        }

        @Override
        protected String addBareReference(Class<? extends ManagedConfig> clazz, String cfgName) {
            cfgName = new String(cfgName);
            this._bareToClass.put(cfgName, clazz);
            super.addBareReference(clazz, cfgName);
            return cfgName;
        }

        @Override
        protected void noteNoDependency(ConfigReference<?> ref, Field f) {
            Class<? extends ManagedConfig> clazz = this.getConfigReferenceType(f.getGenericType());
            if (clazz == null) {
                ClydeLog.log.warning((Object)"I can't figure out the type of a @NoDependency config", new Object[]{"field name", f.getName()});
                return;
            }
        }

        protected void mapRefToClass(ConfigReference<?> ref, Class<? extends ManagedConfig> clazz) {
            Class<? extends ManagedConfig> oldValue = this._refToClass.put(ref, clazz);
            if (oldValue != null && oldValue != clazz) {
                ClydeLog.log.warning((Object)"Holy shnikes, the same config ref for two types?", new Object[]{"ref", ref, "clazz", clazz, "oldClass", oldValue});
            }
        }
    }

    public static class StripOnSaveConfigManager
    extends ConfigManager {
        public StripOnSaveConfigManager(ResourceManager rsrcmgr, MessageManager msgmgr, String configPath) {
            super(rsrcmgr, msgmgr, configPath);
        }

        public StripOnSaveConfigManager() {
        }

        @Override
        protected ManagedConfig[] toSaveableArray(Class<? extends ManagedConfig> groupClass, Iterable<? extends ManagedConfig> configs, Class<? extends ManagedConfig> arrayElementClass) {
            if (groupClass.isAnnotationPresent(Strippable.class)) {
                return null;
            }
            List stripList = (List)PropertyUtil.strip(this, Lists.newArrayList(configs));
            return super.toSaveableArray(groupClass, stripList, arrayElementClass);
        }
    }

    public static enum SuppressableWarning {
        REFERENCE_NOT_SATISFIED("Reference not satisfied?");

        public final String message;

        private SuppressableWarning(String msg) {
            this.message = msg;
        }
    }
}

