/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.data.actor;

import com.threerings.config.ConfigReference;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;
import com.threerings.tudey.config.ActorConfig;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.util.ActorAdvancer;
import com.threerings.tudey.util.DirectionUtil;
import com.threerings.tudey.util.MobileAdvancer;
import com.threerings.util.DeepOmit;

public class Mobile
extends Actor {
    public static final int MOVING = 2;
    public static final int INVISIBLE = 4;
    public static final int UNCOLLIDABLE = 8;
    public static final int LAST_FLAG = 8;
    @DeepOmit
    protected float _maxStep;
    @DeepOmit
    protected float _direction;

    public Mobile(ConfigReference<ActorConfig> config, int id, int created, Vector2f translation, float rotation) {
        super(config, id, created, translation, rotation);
    }

    public Mobile() {
    }

    public void stopMoving() {
        this.clear(2);
    }

    public void setDirection(float direction) {
        this._direction = direction;
        this.setDirty(true);
    }

    public float getDirection() {
        return this._direction;
    }

    public void setMaxStep(float maxStep) {
        if (maxStep != this._maxStep) {
            this._maxStep = maxStep;
            this.setDirty(true);
        }
    }

    public float getMaxStep() {
        return this._maxStep;
    }

    public float getMaxStepSquared() {
        return this._maxStep * this._maxStep;
    }

    public int getTurnDirection() {
        return 0;
    }

    public float getTurnRate() {
        return 0.0f;
    }

    public float getSpeed() {
        return ((ActorConfig.Mobile)this._original).speed * this.getScale();
    }

    public void step(float elapsed, int timestamp, int directions) {
        float length;
        Vector2f step;
        if (this.isSet(2) && DirectionUtil.alterStep(step = new Vector2f((length = this.getSpeed() * elapsed) * FloatMath.cos(this._direction), length * FloatMath.sin(this._direction)), directions)) {
            this._translation.addLocal(step);
            this.setDirty(true);
        }
    }

    @Override
    public Actor extrapolate(float elapsed, int timestamp, Actor result) {
        super.extrapolate(elapsed, timestamp, result);
        ((Mobile)result).step(elapsed, timestamp, 0);
        return result;
    }

    @Override
    public ActorAdvancer createAdvancer(ActorAdvancer.Environment environment, int timestamp) {
        return new MobileAdvancer(environment, this, timestamp);
    }

    @Override
    public Object copy(Object dest) {
        Mobile result = (Mobile)super.copy(dest);
        result._direction = this._direction;
        result._maxStep = this._maxStep;
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        Mobile omobile = (Mobile)other;
        return this._direction == omobile._direction && this._maxStep == omobile._maxStep;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Float.floatToIntBits(this._direction);
        hash = 31 * hash + Float.floatToIntBits(this._maxStep);
        return hash;
    }
}

