/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.client.sprite;

import com.threerings.expr.Bound;
import com.threerings.expr.Scope;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.Updater;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector2f;
import com.threerings.opengl.model.Animation;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.scene.Scene;
import com.threerings.tudey.client.TudeySceneView;
import com.threerings.tudey.client.sprite.ActorSprite;
import com.threerings.tudey.client.sprite.Sprite;
import com.threerings.tudey.config.EffectConfig;
import com.threerings.tudey.config.EffectSpriteConfig;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.util.TudeyContext;

public class EffectSprite
extends Sprite
implements TudeySceneView.TickParticipant {
    protected boolean _disposed;
    protected Effect _effect;
    protected Implementation _impl;
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null){};

    public EffectSprite(TudeyContext ctx, TudeySceneView view, Effect effect) {
        super(ctx, view);
        this._effect = effect;
        view.addTickParticipant(this);
    }

    public Effect getEffect() {
        return this._effect;
    }

    @Override
    public boolean tick(int delayedTime) {
        int timestamp = this._effect.getTimestamp();
        if (delayedTime < timestamp) {
            return true;
        }
        if (this._impl == null) {
            EffectConfig config = this._ctx.getConfigManager().getConfig(EffectConfig.class, this._effect.getConfig());
            this._impl = config == null ? null : config.createSpriteImplementation(this._ctx, this, this._effect);
            this._impl = this._impl == null ? NULL_IMPLEMENTATION : this._impl;
        }
        return this._impl.tick(delayedTime - timestamp);
    }

    @Override
    public void dispose() {
        if (this._disposed) {
            return;
        }
        super.dispose();
        if (this._impl != null) {
            this._impl.dispose();
        }
        this._disposed = true;
    }

    public static class Animator
    extends Original {
        public Animator(TudeyContext ctx, Scope parentScope, EffectSpriteConfig.Animator config, Effect effect) {
            super(ctx, parentScope, config, effect);
            Animation anim;
            if (this._targetModel != null && config.animation != null && (anim = this._targetModel.createAnimation(config.animation)) != null) {
                anim.start();
            }
        }
    }

    public static class Original
    extends Implementation {
        protected Scene.Transient _trans;
        protected Model _targetModel;
        @Bound
        protected TudeySceneView _view;

        public Original(TudeyContext ctx, Scope parentScope, EffectSpriteConfig config, Effect effect) {
            super(parentScope);
            int expired;
            Transform3D transform;
            Sprite sprite = this._view.getSprite(effect.getTarget());
            Model model = this._targetModel = sprite == null ? null : sprite.getModel();
            if (config.model == null) {
                return;
            }
            if (sprite instanceof ActorSprite && config.attachToTarget) {
                this._trans = ((ActorSprite)sprite).spawnAttachedTransientModel(config.model, config.rotateWithTarget, effect.getLifespan() > 0 ? effect.getLifespan() + this._view.getAdvancedTime() : 0);
                return;
            }
            if (this._targetModel != null) {
                transform = this._targetModel.getLocalTransform();
            } else {
                Vector2f translation = effect.getTranslation();
                transform = this._view.getFloorTransform(translation.x, translation.y, effect.getRotation(), config.floorMask);
            }
            this._trans = this._view.getScene().spawnTransient(config.model, transform);
            int n = expired = effect.getLifespan() > 0 ? effect.getLifespan() + this._view.getAdvancedTime() : 0;
            if (expired > 0 && this._trans != null) {
                this._trans.setUpdater(new Updater(){

                    @Override
                    public void update() {
                        if (expired > 0 && expired < Original.this._view.getAdvancedTime()) {
                            Original.this._view.getScene().remove(Original.this._trans);
                            Original.this._view.getScene().returnToTransientPool(Original.this._trans);
                            Original.this._trans = null;
                        }
                    }
                });
            }
        }

        @Override
        public void dispose() {
            if (this._trans != null) {
                this._view.getScene().remove(this._trans);
                this._view.getScene().returnToTransientPool(this._trans);
                this._trans = null;
            }
            super.dispose();
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        public Implementation(Scope parentScope) {
            super(parentScope);
        }

        public boolean tick(float elapsed) {
            return false;
        }

        @Override
        public String getScopeName() {
            return "impl";
        }
    }
}

