/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.util;

import com.threerings.opengl.renderer.Texture1D;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.Texture3D;
import com.threerings.opengl.renderer.TextureCubeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.lwjgl.opengl.GLContext;

public class DDSLoader {
    protected static final int DDSD_MIPMAPCOUNT = 131072;
    protected static final int DDPF_FOURCC = 4;
    protected static final int DDPF_ALPHAPIXELS = 1;
    protected static final int DDSCAPS2_CUBEMAP = 512;
    protected static final int DDSCAPS2_VOLUME = 0x200000;

    public static void load(File file, Texture1D texture, boolean border) throws IOException {
        ByteBuffer buf = DDSLoader.load(file);
        Header header = new Header(buf);
        if ((header.caps2 & 0x200200) != 0 || header.height != 1) {
            throw new IOException("Not a 1D texture: " + file);
        }
        if (header.fourCC != null) {
            throw new IOException("Compression not supported for 1D textures: " + header.fourCC);
        }
        int width = header.width;
        int format = (header.pixelFormatFlags & 1) == 0 ? 6407 : 6408;
        int dformat = header.getUncompressedFormat();
        int nn = header.getLevels();
        for (int ii = 0; ii < nn; ++ii) {
            int pitch = width * (format == 6407 ? 3 : 4);
            buf.limit(buf.position() + pitch);
            texture.setImage(ii, format, width, border, dformat, 5121, buf);
            width = Math.max(width / 2, 1);
            buf.position(buf.limit());
        }
    }

    public static void load(File file, Texture2D texture, boolean border) throws IOException {
        ByteBuffer buf = DDSLoader.load(file);
        Header header = new Header(buf);
        if ((header.caps2 & 0x200200) != 0) {
            throw new IOException("Not a 2D texture: " + file);
        }
        if (header.fourCC == null) {
            int width = header.width;
            int height = header.height;
            int format = (header.pixelFormatFlags & 1) == 0 ? 6407 : 6408;
            int dformat = header.getUncompressedFormat();
            int nn = header.getLevels();
            for (int ii = 0; ii < nn; ++ii) {
                int pitch = width * (format == 6407 ? 3 : 4);
                buf.limit(buf.position() + height * pitch);
                texture.setImage(ii, format, width, height, border, dformat, 5121, buf);
                width = Math.max(width / 2, 1);
                height = Math.max(height / 2, 1);
                buf.position(buf.limit());
            }
        } else {
            int width = header.width;
            int height = header.height;
            int format = header.getCompressedFormat();
            int nn = header.getLevels();
            for (int ii = 0; ii < nn; ++ii) {
                int size = Math.max(width / 4, 1) * Math.max(height / 4, 1) * (format == 33776 ? 8 : 16);
                buf.limit(buf.position() + size);
                texture.setCompressedImage(ii, format, width, height, border, buf);
                width = Math.max(width / 2, 1);
                height = Math.max(height / 2, 1);
                buf.position(buf.limit());
            }
        }
    }

    public static void load(File file, Texture3D texture, boolean border) throws IOException {
        ByteBuffer buf = DDSLoader.load(file);
        Header header = new Header(buf);
        if ((header.caps2 & 0x200000) == 0) {
            throw new IOException("Not a volume texture: " + file);
        }
        if (header.fourCC != null) {
            throw new IOException("Compression not supported for 3D textures: " + header.fourCC);
        }
        int width = header.width;
        int height = header.height;
        int depth = header.depth;
        int format = (header.pixelFormatFlags & 1) == 0 ? 6407 : 6408;
        int dformat = header.getUncompressedFormat();
        int nn = header.getLevels();
        for (int ii = 0; ii < nn; ++ii) {
            int pitch = width * (format == 6407 ? 3 : 4);
            buf.limit(buf.position() + depth * height * pitch);
            texture.setImage(ii, format, width, height, depth, border, dformat, 5121, buf);
            width = Math.max(width / 2, 1);
            height = Math.max(height / 2, 1);
            depth = Math.max(depth / 2, 1);
            buf.position(buf.limit());
        }
    }

    public static void load(File file, TextureCubeMap texture, boolean border) throws IOException {
        ByteBuffer buf = DDSLoader.load(file);
        Header header = new Header(buf);
        if ((header.caps2 & 0x200) == 0 || header.width != header.height) {
            throw new IOException("Not a cube map texture: " + file);
        }
        if (header.fourCC == null) {
            int width = header.width;
            int format = (header.pixelFormatFlags & 1) == 0 ? 6407 : 6408;
            int dformat = header.getUncompressedFormat();
            for (int target : TextureCubeMap.FACE_TARGETS) {
                int nn = header.getLevels();
                for (int ii = 0; ii < nn; ++ii) {
                    int pitch = width * (format == 6407 ? 3 : 4);
                    buf.limit(buf.position() + width * pitch);
                    texture.setImage(target, ii, format, width, border, dformat, 5121, buf);
                    width = Math.max(width / 2, 1);
                    buf.position(buf.limit());
                }
            }
        } else {
            int width = header.width;
            int format = header.getCompressedFormat();
            for (int target : TextureCubeMap.FACE_TARGETS) {
                int nn = header.getLevels();
                for (int ii = 0; ii < nn; ++ii) {
                    int mwidth = Math.max(width / 4, 1);
                    int size = mwidth * mwidth * (format == 33776 ? 8 : 16);
                    buf.limit(buf.position() + size);
                    texture.setCompressedImage(target, ii, format, width, border, buf);
                    width = Math.max(width / 2, 1);
                    buf.position(buf.limit());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteBuffer load(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            FileChannel channel = in.getChannel();
            ByteBuffer buf = ByteBuffer.allocateDirect((int)channel.size()).order(ByteOrder.LITTLE_ENDIAN);
            channel.read(buf);
            buf.rewind();
            ByteBuffer byteBuffer = buf;
            return byteBuffer;
        }
    }

    protected static class Header {
        public int flags;
        public int height;
        public int width;
        public int pitchOrLinearSize;
        public int depth;
        public int mipMapCount;
        public int pixelFormatFlags;
        public String fourCC;
        public int rgbBitCount;
        public int rBitMask;
        public int gBitMask;
        public int bBitMask;
        public int alphaBitMask;
        public int caps1;
        public int caps2;

        public Header(ByteBuffer buf) throws IOException {
            byte[] bytes = new byte[4];
            buf.get(bytes);
            String magic = new String(bytes, "US-ASCII");
            if (!magic.equals("DDS ")) {
                throw new IOException("Bad magic: " + magic);
            }
            int size = buf.getInt();
            if (size != 124) {
                throw new IOException("Wrong header size: " + size);
            }
            this.flags = buf.getInt();
            this.height = buf.getInt();
            this.width = buf.getInt();
            this.pitchOrLinearSize = buf.getInt();
            this.depth = buf.getInt();
            this.mipMapCount = buf.getInt();
            buf.position(buf.position() + 44);
            size = buf.getInt();
            if (size != 32) {
                throw new IOException("Wrong pixel format size: " + size);
            }
            this.pixelFormatFlags = buf.getInt();
            buf.get(bytes);
            this.fourCC = (this.pixelFormatFlags & 4) == 0 ? null : new String(bytes, "US-ASCII");
            this.rgbBitCount = buf.getInt();
            this.rBitMask = buf.getInt();
            this.gBitMask = buf.getInt();
            this.bBitMask = buf.getInt();
            this.alphaBitMask = buf.getInt();
            this.caps1 = buf.getInt();
            this.caps2 = buf.getInt();
            buf.position(buf.position() + 8);
            buf.position(buf.position() + 4);
        }

        public int getLevels() {
            return (this.flags & 0x20000) == 0 ? 1 : this.mipMapCount;
        }

        public int getUncompressedFormat() throws IOException {
            if (this.rBitMask == 255 && this.gBitMask == 65280 && this.bBitMask == 0xFF0000) {
                if ((this.pixelFormatFlags & 1) == 0) {
                    return 6407;
                }
                if (this.alphaBitMask == -16777216) {
                    return 6408;
                }
            } else if (this.rBitMask == 0xFF0000 && this.gBitMask == 65280 && this.bBitMask == 255) {
                if (!GLContext.getCapabilities().GL_EXT_bgra) {
                    throw new IOException("BGRA format not supported.");
                }
                if ((this.pixelFormatFlags & 1) == 0) {
                    return 32992;
                }
                if (this.alphaBitMask == -16777216) {
                    return 32993;
                }
            }
            throw new IOException("Unknown format: " + this.rBitMask + "/" + this.gBitMask + "/" + this.bBitMask + "/" + this.alphaBitMask);
        }

        public int getCompressedFormat() throws IOException {
            int format;
            if ("DXT1".equals(this.fourCC)) {
                format = 33776;
            } else if ("DXT3".equals(this.fourCC)) {
                format = 33778;
            } else if ("DXT5".equals(this.fourCC)) {
                format = 33779;
            } else {
                throw new IOException("Unknown format: " + this.fourCC);
            }
            if (!GLContext.getCapabilities().GL_EXT_texture_compression_s3tc) {
                throw new IOException("S3TC texture compression not supported.");
            }
            return format;
        }
    }
}

