/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer.config;

import com.google.common.collect.Lists;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.export.Exportable;
import com.threerings.expr.FloatExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.math.FloatMath;
import com.threerings.math.Plane;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.media.image.Colorization;
import com.threerings.opengl.Log;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.compositor.Compositor;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.Texture1D;
import com.threerings.opengl.renderer.Texture2D;
import com.threerings.opengl.renderer.Texture3D;
import com.threerings.opengl.renderer.TextureCubeMap;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.opengl.renderer.config.ColorizationConfig;
import com.threerings.opengl.renderer.state.TextureState;
import com.threerings.opengl.scene.config.ShadowConfig;
import com.threerings.opengl.util.DDSLoader;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.List;
import org.lwjgl.opengl.GLContext;

public class TextureConfig
extends ParameterizedConfig {
    @Editable
    public Implementation implementation = new Original2D();

    public static BufferedImage getImage(GlContext ctx, String file, ColorizationConfig[] colorizations) {
        Colorization[] zations = new Colorization[colorizations.length];
        for (int ii = 0; ii < zations.length; ++ii) {
            zations[ii] = colorizations[ii].getColorization(ctx);
        }
        return ctx.getImageCache().getBufferedImage(file, zations);
    }

    public boolean isSupported(GlContext ctx, boolean fallback) {
        return this.implementation.isSupported(ctx, fallback);
    }

    public Texture getTexture(GlContext ctx) {
        return this.getTexture(ctx, null, null, null, null, null);
    }

    public Texture getTexture(GlContext ctx, TextureState state, TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
        return this.implementation.getTexture(ctx, state, unit, scope, adders, updaters);
    }

    public Texture getFromPool(GlContext ctx) {
        return this.implementation.getFromPool(ctx);
    }

    public void returnToPool(GlContext ctx, Texture texture) {
        this.implementation.returnToPool(ctx, texture);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateResources(HashSet<String> paths) {
        this.implementation.getUpdateResources(paths);
    }

    protected static class Texture2DTarget
    extends Texture2D
    implements Renderer.Observer {
        protected Format _format;
        protected boolean _border;
        protected boolean _mipmap;

        public Texture2DTarget(Renderer renderer, Format format, boolean border, boolean mipmap) {
            super(renderer);
            this._format = format;
            this._border = border;
            this._mipmap = mipmap;
            this.sizeChanged(renderer.getWidth(), renderer.getHeight());
            renderer.addObserver(this);
        }

        @Override
        public void sizeChanged(int width, int height) {
            this.setImage(this._format.getConstant(null), width, height, this._border, this._mipmap);
        }
    }

    public static class Frame
    extends BaseDerived {
    }

    public static class Derived
    extends BaseDerived {
        @Override
        public Texture getFromPool(GlContext ctx) {
            TextureConfig config = this.getConfig(ctx);
            return config == null ? null : config.getFromPool(ctx);
        }

        @Override
        public void returnToPool(GlContext ctx, Texture texture) {
            TextureConfig config = this.getConfig(ctx);
            if (config != null) {
                config.returnToPool(ctx, texture);
            }
        }
    }

    public static class Animated
    extends Implementation {
        @Editable
        public FloatExpression frame = new FloatExpression.Constant(0.0f);
        @Editable
        public Frame[] frames = new Frame[0];

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            for (Frame frame : this.frames) {
                if (frame.isSupported(ctx, fallback)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Texture getTexture(GlContext ctx, final TextureState state, final TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
            if (adders == null) {
                Log.log.warning((Object)"Tried to create animated texture in static context.", new Object[0]);
                return null;
            }
            if (this.frames.length == 0) {
                return null;
            }
            final FloatExpression.Evaluator frame = this.frame.createEvaluator(scope);
            final Texture[] textures = new Texture[this.frames.length];
            for (int ii = 0; ii < textures.length; ++ii) {
                textures[ii] = this.frames[ii].getTexture(ctx);
            }
            updaters.add(new Updater(){

                @Override
                public void update() {
                    int idx = FloatMath.ifloor(frame.evaluate()) % textures.length;
                    unit.setTexture(textures[idx < 0 ? idx + textures.length : idx]);
                    state.setDirty(true);
                }
            });
            return null;
        }

        @Override
        public void invalidate() {
            this.frame.invalidate();
        }
    }

    public static class Shadow
    extends BaseDerived {
        @Editable
        public boolean depth;

        @Override
        public Texture getTexture(final GlContext ctx, TextureState state, TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
            if (adders == null) {
                Log.log.warning((Object)"Tried to create shadow texture in static context.", new Object[0]);
                return null;
            }
            TextureConfig config = this.getConfig(ctx);
            if (config == null) {
                return null;
            }
            HashIntMap dependencies = IntMaps.newHashIntMap();
            ShadowConfig.TextureData data = ScopeUtil.resolve(scope, "data", null, ShadowConfig.TextureData.class);
            adders.add(new Dependency.Adder((IntMap)dependencies, data, config){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ ShadowConfig.TextureData val$data;
                final /* synthetic */ TextureConfig val$config;
                {
                    this.val$dependencies = intMap;
                    this.val$data = textureData;
                    this.val$config = textureConfig;
                }

                @Override
                public boolean add() {
                    Compositor compositor = ctx.getCompositor();
                    int depth = compositor.getSubrenderDepth();
                    Object source = compositor.getSubrenderSource();
                    if (source != null && source == this.val$dependencies.get(depth - 1)) {
                        return false;
                    }
                    Dependency.ShadowTexture dependency = (Dependency.ShadowTexture)this.val$dependencies.get(depth);
                    if (dependency == null) {
                        dependency = new Dependency.ShadowTexture(ctx);
                        this.val$dependencies.put(depth, (Object)dependency);
                    }
                    dependency.data = this.val$data;
                    dependency.depth = null;
                    dependency.color = null;
                    compositor.addDependency(dependency);
                    if (Shadow.this.depth) {
                        if (dependency.depth == null) {
                            dependency.depth = this.val$config.getFromPool(ctx);
                            dependency.depthConfig = this.val$config;
                        }
                    } else if (dependency.color == null) {
                        dependency.color = this.val$config.getFromPool(ctx);
                        dependency.colorConfig = this.val$config;
                    }
                    return true;
                }
            });
            updaters.add(new Updater((IntMap)dependencies, ctx, unit, state){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ GlContext val$ctx;
                final /* synthetic */ TextureUnit val$unit;
                final /* synthetic */ TextureState val$state;
                {
                    this.val$dependencies = intMap;
                    this.val$ctx = glContext;
                    this.val$unit = textureUnit;
                    this.val$state = textureState;
                }

                @Override
                public void update() {
                    Dependency.ShadowTexture dependency = (Dependency.ShadowTexture)this.val$dependencies.get(this.val$ctx.getCompositor().getSubrenderDepth());
                    this.val$unit.setTexture(Shadow.this.depth ? dependency.depth : dependency.color);
                    this.val$state.setDirty(true);
                }
            });
            return null;
        }
    }

    public static class CubeRender
    extends BaseDerived {
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float near = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="f")
        public float far = 100.0f;
        @Editable(editor="mask", mode="cube_map_face", hgroup="m")
        public int faces = 63;
        @Editable(min=0.0, hgroup="m")
        public int maxDepth;

        @Override
        public Texture getTexture(final GlContext ctx, TextureState state, TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
            if (adders == null) {
                Log.log.warning((Object)"Tried to create cube render texture in static context.", new Object[0]);
                return null;
            }
            TextureConfig config = this.getConfig(ctx);
            if (config == null) {
                return null;
            }
            HashIntMap dependencies = IntMaps.newHashIntMap();
            Transform3D transform = ScopeUtil.resolve(scope, "worldTransform", new Transform3D());
            adders.add(new Dependency.Adder((IntMap)dependencies, transform, config){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ Transform3D val$transform;
                final /* synthetic */ TextureConfig val$config;
                {
                    this.val$dependencies = intMap;
                    this.val$transform = transform3D;
                    this.val$config = textureConfig;
                }

                @Override
                public boolean add() {
                    Compositor compositor = ctx.getCompositor();
                    int depth = compositor.getSubrenderDepth();
                    Object source = compositor.getSubrenderSource();
                    if (depth > CubeRender.this.maxDepth || source != null && source == this.val$dependencies.get(depth - 1)) {
                        return false;
                    }
                    Dependency.CubeTexture dependency = (Dependency.CubeTexture)this.val$dependencies.get(depth);
                    if (dependency == null) {
                        dependency = new Dependency.CubeTexture(ctx);
                        this.val$dependencies.put(depth, (Object)dependency);
                    }
                    this.val$transform.extractTranslation(dependency.origin);
                    dependency.near = CubeRender.this.near;
                    dependency.far = CubeRender.this.far;
                    dependency.faces = CubeRender.this.faces;
                    dependency.texture = null;
                    compositor.addDependency(dependency);
                    if (dependency.texture == null) {
                        dependency.texture = this.val$config.getFromPool(ctx);
                        dependency.config = this.val$config;
                    }
                    return true;
                }
            });
            updaters.add(new Updater((IntMap)dependencies, ctx, unit, state){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ GlContext val$ctx;
                final /* synthetic */ TextureUnit val$unit;
                final /* synthetic */ TextureState val$state;
                {
                    this.val$dependencies = intMap;
                    this.val$ctx = glContext;
                    this.val$unit = textureUnit;
                    this.val$state = textureState;
                }

                @Override
                public void update() {
                    Dependency.CubeTexture dependency = (Dependency.CubeTexture)this.val$dependencies.get(this.val$ctx.getCompositor().getSubrenderDepth());
                    this.val$unit.setTexture(dependency.texture);
                    this.val$state.setDirty(true);
                }
            });
            return null;
        }
    }

    public static class Refraction
    extends BaseDerived {
        @Editable(hgroup="f")
        public boolean front = true;
        @Editable(hgroup="f")
        public boolean back;
        @Editable(min=0.0, hgroup="f")
        public int maxDepth;
        @Editable(min=0.0, step=0.01, hgroup="n")
        public float sourceIndex = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="n")
        public float destIndex = 1.5f;

        @Override
        public Texture getTexture(final GlContext ctx, TextureState state, TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
            if (adders == null) {
                Log.log.warning((Object)"Tried to create refraction texture in static context.", new Object[0]);
                return null;
            }
            TextureConfig config = this.getConfig(ctx);
            if (config == null) {
                return null;
            }
            HashIntMap dependencies = IntMaps.newHashIntMap();
            Transform3D transform = ScopeUtil.resolve(scope, "worldTransform", new Transform3D());
            Box bounds = ScopeUtil.resolve(scope, "bounds", new Box(), Box.class);
            adders.add(new Dependency.Adder((IntMap)dependencies, transform, bounds, config){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ Transform3D val$transform;
                final /* synthetic */ Box val$bounds;
                final /* synthetic */ TextureConfig val$config;
                {
                    this.val$dependencies = intMap;
                    this.val$transform = transform3D;
                    this.val$bounds = box;
                    this.val$config = textureConfig;
                }

                @Override
                public boolean add() {
                    boolean away;
                    Compositor compositor = ctx.getCompositor();
                    int depth = compositor.getSubrenderDepth();
                    Object source = compositor.getSubrenderSource();
                    if (depth > Refraction.this.maxDepth || source != null && source == this.val$dependencies.get(depth - 1)) {
                        return false;
                    }
                    Dependency.RefractionTexture dependency = (Dependency.RefractionTexture)this.val$dependencies.get(depth);
                    if (dependency == null) {
                        dependency = new Dependency.RefractionTexture(ctx);
                        this.val$dependencies.put(depth, (Object)dependency);
                    }
                    Plane.XY_PLANE.transform(this.val$transform, dependency.worldPlane);
                    Plane eyePlane = dependency.eyePlane;
                    Camera camera = compositor.getCamera();
                    dependency.worldPlane.transform(camera.getViewTransform(), eyePlane);
                    Vector3f normal = eyePlane.getNormal();
                    boolean bl = away = normal.z < 0.0f;
                    if (Math.abs(normal.z) < 1.0E-6f || !(away ? Refraction.this.back : Refraction.this.front) || eyePlane.constant / normal.z < camera.getNear()) {
                        return false;
                    }
                    if (away) {
                        dependency.worldPlane.negateLocal();
                        eyePlane.negateLocal();
                    }
                    dependency.bounds.set(this.val$bounds);
                    dependency.ratio = Refraction.this.sourceIndex / Refraction.this.destIndex;
                    dependency.texture = null;
                    compositor.addDependency(dependency);
                    if (dependency.texture == null) {
                        dependency.texture = this.val$config.getFromPool(ctx);
                        dependency.config = this.val$config;
                    }
                    return true;
                }
            });
            updaters.add(new Updater((IntMap)dependencies, unit, state){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ TextureUnit val$unit;
                final /* synthetic */ TextureState val$state;
                {
                    this.val$dependencies = intMap;
                    this.val$unit = textureUnit;
                    this.val$state = textureState;
                }

                @Override
                public void update() {
                    Compositor compositor = ctx.getCompositor();
                    Dependency.RefractionTexture dependency = (Dependency.RefractionTexture)this.val$dependencies.get(compositor.getSubrenderDepth());
                    this.val$unit.setTexture(dependency.texture);
                    compositor.getCamera().getTexGenPlanes(this.val$unit.genPlaneS, this.val$unit.genPlaneT, this.val$unit.genPlaneQ);
                    this.val$state.setDirty(true);
                }
            });
            return null;
        }
    }

    public static class Reflection
    extends BaseDerived {
        @Editable(hgroup="f")
        public boolean front = true;
        @Editable(hgroup="f")
        public boolean back;
        @Editable(min=0.0, hgroup="f")
        public int maxDepth;

        @Override
        public Texture getTexture(final GlContext ctx, TextureState state, TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
            if (adders == null) {
                Log.log.warning((Object)"Tried to create reflection texture in static context.", new Object[0]);
                return null;
            }
            TextureConfig config = this.getConfig(ctx);
            if (config == null) {
                return null;
            }
            HashIntMap dependencies = IntMaps.newHashIntMap();
            Transform3D transform = ScopeUtil.resolve(scope, "worldTransform", new Transform3D());
            Box bounds = ScopeUtil.resolve(scope, "bounds", new Box(), Box.class);
            adders.add(new Dependency.Adder((IntMap)dependencies, transform, bounds, config){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ Transform3D val$transform;
                final /* synthetic */ Box val$bounds;
                final /* synthetic */ TextureConfig val$config;
                {
                    this.val$dependencies = intMap;
                    this.val$transform = transform3D;
                    this.val$bounds = box;
                    this.val$config = textureConfig;
                }

                @Override
                public boolean add() {
                    boolean away;
                    Compositor compositor = ctx.getCompositor();
                    int depth = compositor.getSubrenderDepth();
                    Object source = compositor.getSubrenderSource();
                    if (depth > Reflection.this.maxDepth || source != null && source == this.val$dependencies.get(depth - 1)) {
                        return false;
                    }
                    Dependency.ReflectionTexture dependency = (Dependency.ReflectionTexture)this.val$dependencies.get(depth);
                    if (dependency == null) {
                        dependency = new Dependency.ReflectionTexture(ctx);
                        this.val$dependencies.put(depth, (Object)dependency);
                    }
                    Plane.XY_PLANE.transform(this.val$transform, dependency.worldPlane);
                    Plane eyePlane = dependency.eyePlane;
                    Camera camera = compositor.getCamera();
                    dependency.worldPlane.transform(camera.getViewTransform(), eyePlane);
                    Vector3f normal = eyePlane.getNormal();
                    boolean bl = away = normal.z < 0.0f;
                    if (Math.abs(normal.z) < 1.0E-6f || !(away ? Reflection.this.back : Reflection.this.front) || eyePlane.constant / normal.z < camera.getNear()) {
                        return false;
                    }
                    if (away) {
                        dependency.worldPlane.negateLocal();
                        eyePlane.negateLocal();
                    }
                    dependency.bounds.set(this.val$bounds);
                    dependency.texture = null;
                    compositor.addDependency(dependency);
                    if (dependency.texture == null) {
                        dependency.texture = this.val$config.getFromPool(ctx);
                        dependency.config = this.val$config;
                    }
                    return true;
                }
            });
            updaters.add(new Updater((IntMap)dependencies, unit, state){
                final /* synthetic */ IntMap val$dependencies;
                final /* synthetic */ TextureUnit val$unit;
                final /* synthetic */ TextureState val$state;
                {
                    this.val$dependencies = intMap;
                    this.val$unit = textureUnit;
                    this.val$state = textureState;
                }

                @Override
                public void update() {
                    Compositor compositor = ctx.getCompositor();
                    Dependency.ReflectionTexture dependency = (Dependency.ReflectionTexture)this.val$dependencies.get(compositor.getSubrenderDepth());
                    this.val$unit.setTexture(dependency.texture);
                    compositor.getCamera().getTexGenPlanes(this.val$unit.genPlaneS, this.val$unit.genPlaneT, this.val$unit.genPlaneQ);
                    this.val$state.setDirty(true);
                }
            });
            return null;
        }
    }

    public static abstract class BaseDerived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<TextureConfig> texture;

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            TextureConfig config = this.getConfig(ctx);
            return config == null || config.isSupported(ctx, fallback);
        }

        @Override
        public Texture getTexture(GlContext ctx, TextureState state, TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
            TextureConfig config = this.getConfig(ctx);
            return config == null ? null : config.getTexture(ctx, state, unit, scope, adders, updaters);
        }

        protected TextureConfig getConfig(GlContext ctx) {
            return ctx.getConfigManager().getConfig(TextureConfig.class, this.texture);
        }
    }

    public static class OriginalCubeMap
    extends Original {
        @Editable(category="data")
        public Contents contents = new ImageFiles();

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            this.contents.getUpdateResources(paths);
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return super.isSupported(ctx, fallback) && GLContext.getCapabilities().GL_ARB_texture_cube_map;
        }

        @Override
        protected Texture createTexture(GlContext ctx) {
            TextureCubeMap texture = new TextureCubeMap(ctx.getRenderer());
            this.contents.load(ctx, texture, this.format, this.border, this.minFilter.isMipmapped());
            return texture;
        }

        public static class FileTrio
        extends DeepObject
        implements Exportable {
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
            public String x;
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
            public String y;
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
            public String z;

            public void getUpdateResources(HashSet<String> paths) {
                if (this.x != null) {
                    paths.add(this.x);
                }
                if (this.y != null) {
                    paths.add(this.y);
                }
                if (this.z != null) {
                    paths.add(this.z);
                }
            }
        }

        public static class ImageFiles
        extends Contents {
            @Editable
            public FileTrio negative = new FileTrio();
            @Editable
            public FileTrio positive = new FileTrio();
            @Editable
            public ColorizationConfig[] colorizations = new ColorizationConfig[0];
            @Editable
            public boolean premultiply = true;

            @Override
            public void getUpdateResources(HashSet<String> paths) {
                this.negative.getUpdateResources(paths);
                this.positive.getUpdateResources(paths);
            }

            @Override
            public void load(GlContext ctx, TextureCubeMap texture, Format format, boolean border, boolean mipmap) {
                BufferedImage[] images = new BufferedImage[]{this.positive.x == null ? null : TextureConfig.getImage(ctx, this.positive.x, this.colorizations), this.negative.x == null ? null : TextureConfig.getImage(ctx, this.negative.x, this.colorizations), this.positive.y == null ? null : TextureConfig.getImage(ctx, this.positive.y, this.colorizations), this.negative.y == null ? null : TextureConfig.getImage(ctx, this.negative.y, this.colorizations), this.positive.z == null ? null : TextureConfig.getImage(ctx, this.positive.z, this.colorizations), this.negative.z == null ? null : TextureConfig.getImage(ctx, this.negative.z, this.colorizations)};
                int constant = -1;
                for (BufferedImage image : images) {
                    if (image == null) continue;
                    constant = format.getConstant(image);
                    break;
                }
                if (constant == -1) {
                    return;
                }
                texture.setImages(constant, border, images, this.premultiply, true, mipmap);
            }
        }

        public static class ImageFile
        extends Contents {
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
            public String file;
            @Editable
            public ColorizationConfig[] colorizations = new ColorizationConfig[0];
            @Editable
            public boolean premultiply = true;
            @Editable(min=1.0, max=6.0, hgroup="d")
            public int divisionsS = 3;
            @Editable(min=1.0, max=6.0, hgroup="d")
            public int divisionsT = 2;

            @Override
            public void getUpdateResources(HashSet<String> paths) {
                if (this.file != null) {
                    paths.add(this.file);
                }
            }

            @Override
            public void load(GlContext ctx, TextureCubeMap texture, Format format, boolean border, boolean mipmap) {
                if (this.file == null) {
                    return;
                }
                if (this.file.endsWith(".dds")) {
                    try {
                        DDSLoader.load(ctx.getResourceManager().getResourceFile(this.file), texture, border);
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                BufferedImage image = TextureConfig.getImage(ctx, this.file, this.colorizations);
                texture.setImages(format.getConstant(image), border, image, this.divisionsS, this.divisionsT, this.premultiply, true, mipmap);
            }
        }

        public static class Blank
        extends Contents {
            @Editable(min=1.0)
            public int size = 1;

            @Override
            public void load(GlContext ctx, TextureCubeMap texture, Format format, boolean border, boolean mipmap) {
                texture.setImages(format.getConstant(null), this.size, border, mipmap);
            }
        }

        @EditorTypes(value={Blank.class, ImageFile.class, ImageFiles.class})
        public static abstract class Contents
        extends DeepObject
        implements Exportable {
            public void getUpdateResources(HashSet<String> paths) {
            }

            public abstract void load(GlContext var1, TextureCubeMap var2, Format var3, boolean var4, boolean var5);
        }
    }

    public static class Original3D
    extends Original {
        @Editable(category="data")
        public Contents contents = new ImageFile();

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            this.contents.getUpdateResources(paths);
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return super.isSupported(ctx, fallback) && GLContext.getCapabilities().OpenGL12;
        }

        @Override
        protected Texture createTexture(GlContext ctx) {
            Texture3D texture = new Texture3D(ctx.getRenderer());
            this.contents.load(ctx, texture, this.format, this.border, this.minFilter.isMipmapped());
            return texture;
        }

        public static class ImageFile
        extends Contents {
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
            public String file;
            @Editable
            public ColorizationConfig[] colorizations = new ColorizationConfig[0];
            @Editable
            public boolean premultiply = true;
            @Editable(min=1.0, hgroup="d")
            public int divisionsS = 1;
            @Editable(min=1.0, hgroup="d")
            public int divisionsT = 1;
            @Editable(min=1.0, hgroup="d")
            public int depth = 1;

            @Override
            public void getUpdateResources(HashSet<String> paths) {
                if (this.file != null) {
                    paths.add(this.file);
                }
            }

            @Override
            public void load(GlContext ctx, Texture3D texture, Format format, boolean border, boolean mipmap) {
                if (this.file == null) {
                    return;
                }
                if (this.file.endsWith(".dds")) {
                    try {
                        DDSLoader.load(ctx.getResourceManager().getResourceFile(this.file), texture, border);
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                BufferedImage image = TextureConfig.getImage(ctx, this.file, this.colorizations);
                texture.setImages(format.getConstant(image), border, image, this.divisionsS, this.divisionsT, this.depth, this.premultiply, true, mipmap);
            }
        }

        public static class Blank
        extends Contents {
            @Editable(min=1.0, hgroup="d")
            public int width = 1;
            @Editable(min=1.0, hgroup="d")
            public int height = 1;
            @Editable(min=1.0, hgroup="d")
            public int depth = 1;

            @Override
            public void load(GlContext ctx, Texture3D texture, Format format, boolean border, boolean mipmap) {
                texture.setImage(format.getConstant(null), this.width, this.height, this.depth, border, mipmap);
            }
        }

        @EditorTypes(value={Blank.class, ImageFile.class})
        public static abstract class Contents
        extends DeepObject
        implements Exportable {
            public void getUpdateResources(HashSet<String> paths) {
            }

            public abstract void load(GlContext var1, Texture3D var2, Format var3, boolean var4, boolean var5);
        }
    }

    public static class OriginalRectangle
    extends Original2D {
        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return super.isSupported(ctx, fallback) && GLContext.getCapabilities().GL_ARB_texture_rectangle;
        }

        @Override
        protected Texture createTexture(GlContext ctx) {
            Texture2D texture = new Texture2D(ctx.getRenderer(), true);
            this.contents.load(ctx, texture, this.format, this.border, this.minFilter.isMipmapped());
            return texture;
        }
    }

    public static class Original2DTarget
    extends Original {
        @Override
        protected Texture createTexture(GlContext ctx) {
            return new Texture2DTarget(ctx.getRenderer(), this.format, this.border, this.minFilter.isMipmapped());
        }
    }

    public static class Original2D
    extends Original {
        @Editable(category="data")
        public Contents contents = new ImageFile();

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            this.contents.getUpdateResources(paths);
        }

        @Override
        protected Texture createTexture(GlContext ctx) {
            Texture2D texture = new Texture2D(ctx.getRenderer(), false);
            this.contents.load(ctx, texture, this.format, this.border, this.minFilter.isMipmapped());
            return texture;
        }

        public static class ImageFile
        extends Contents {
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
            public String file;
            @Editable
            public ColorizationConfig[] colorizations = new ColorizationConfig[0];
            @Editable
            public boolean premultiply = true;

            @Override
            public void getUpdateResources(HashSet<String> paths) {
                if (this.file != null) {
                    paths.add(this.file);
                }
            }

            @Override
            public void load(GlContext ctx, Texture2D texture, Format format, boolean border, boolean mipmap) {
                if (this.file == null) {
                    return;
                }
                if (this.file.endsWith(".dds")) {
                    try {
                        DDSLoader.load(ctx.getResourceManager().getResourceFile(this.file), texture, border);
                        return;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                BufferedImage image = TextureConfig.getImage(ctx, this.file, this.colorizations);
                texture.setImage(format.getConstant(image), border, image, this.premultiply, true, mipmap);
            }
        }

        public static class Blank
        extends Contents {
            @Editable(min=1.0, hgroup="d")
            public int width = 1;
            @Editable(min=1.0, hgroup="d")
            public int height = 1;

            @Override
            public void load(GlContext ctx, Texture2D texture, Format format, boolean border, boolean mipmap) {
                texture.setImage(format.getConstant(null), this.width, this.height, border, mipmap);
            }
        }

        @EditorTypes(value={Blank.class, ImageFile.class})
        public static abstract class Contents
        extends DeepObject
        implements Exportable {
            public void getUpdateResources(HashSet<String> paths) {
            }

            public abstract void load(GlContext var1, Texture2D var2, Format var3, boolean var4, boolean var5);
        }
    }

    public static class Original1D
    extends Original {
        @Editable(category="data")
        public Contents contents = new ImageFile();

        @Override
        public void getUpdateResources(HashSet<String> paths) {
            this.contents.getUpdateResources(paths);
        }

        @Override
        protected Texture createTexture(GlContext ctx) {
            Texture1D texture = new Texture1D(ctx.getRenderer());
            this.contents.load(ctx, texture, this.format, this.border, this.minFilter.isMipmapped());
            return texture;
        }

        public static class ImageFile
        extends Contents {
            @Editable(editor="resource", nullable=true)
            @FileConstraints(description="m.image_files_desc", extensions={".png", ".jpg", ".dds"}, directory="image_dir")
            public String file;
            @Editable
            public ColorizationConfig[] colorizations = new ColorizationConfig[0];
            @Editable
            public boolean premultiply = true;

            @Override
            public void getUpdateResources(HashSet<String> paths) {
                if (this.file != null) {
                    paths.add(this.file);
                }
            }

            @Override
            public void load(GlContext ctx, Texture1D texture, Format format, boolean border, boolean mipmap) {
                if (this.file == null) {
                    return;
                }
                if (this.file.endsWith(".dds")) {
                    try {
                        DDSLoader.load(ctx.getResourceManager().getResourceFile(this.file), texture, border);
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                BufferedImage image = TextureConfig.getImage(ctx, this.file, this.colorizations);
                texture.setImage(format.getConstant(image), border, image, this.premultiply, true, mipmap);
            }
        }

        public static class Blank
        extends Contents {
            @Editable(min=1.0)
            public int width = 1;

            @Override
            public void load(GlContext ctx, Texture1D texture, Format format, boolean border, boolean mipmap) {
                texture.setImage(format.getConstant(null), this.width, border, mipmap);
            }
        }

        @EditorTypes(value={Blank.class, ImageFile.class})
        public static abstract class Contents
        extends DeepObject
        implements Exportable {
            public void getUpdateResources(HashSet<String> paths) {
            }

            public abstract void load(GlContext var1, Texture1D var2, Format var3, boolean var4, boolean var5);
        }
    }

    public static abstract class Original
    extends Implementation {
        @Editable(category="data")
        public Format format = Format.DEFAULT;
        @Editable(category="data")
        public String identity = "";
        @Editable(category="filter", hgroup="f")
        public MinFilter minFilter = MinFilter.LINEAR_MIPMAP_LINEAR;
        @Editable(category="filter", hgroup="f")
        public MagFilter magFilter = MagFilter.LINEAR;
        @Editable(min=1.0, step=0.01, category="filter")
        public float maxAnisotropy = 1.0f;
        @Editable(category="wrap", hgroup="w")
        public Wrap wrapS = Wrap.REPEAT;
        @Editable(category="wrap", hgroup="w")
        public Wrap wrapT = Wrap.REPEAT;
        @Editable(category="wrap", hgroup="w")
        public Wrap wrapR = Wrap.REPEAT;
        @Editable(category="wrap", hgroup="b")
        public boolean border;
        @Editable(mode="alpha", category="wrap", hgroup="b")
        public Color4f borderColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
        @Editable(category="compare", hgroup="c")
        public CompareMode compareMode = CompareMode.NONE;
        @Editable(category="compare", hgroup="c")
        public CompareFunc compareFunc = CompareFunc.LEQUAL;
        @Editable(category="compare")
        public DepthMode depthMode = DepthMode.LUMINANCE;
        @DeepOmit
        protected transient SoftReference<Texture> _texture;
        @DeepOmit
        protected transient List<SoftReference<Texture>> _pool;

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return this.format.isSupported(fallback) && this.wrapS.isSupported(fallback) && this.wrapT.isSupported(fallback) && this.wrapR.isSupported(fallback) && this.compareMode.isSupported(fallback);
        }

        @Override
        public Texture getTexture(GlContext ctx, TextureState state, TextureUnit unit, Scope scope, List<Dependency.Adder> adders, List<Updater> updaters) {
            Texture texture;
            Texture texture2 = texture = this._texture == null ? null : this._texture.get();
            if (texture == null) {
                texture = this.createTexture(ctx);
                this._texture = new SoftReference<Texture>(texture);
                this.configureTexture(texture);
            }
            return texture;
        }

        @Override
        public Texture getFromPool(GlContext ctx) {
            List<SoftReference<Texture>> pool = this.getPool();
            for (int ii = pool.size() - 1; ii >= 0; --ii) {
                Texture texture = pool.remove(ii).get();
                if (texture == null) continue;
                return texture;
            }
            Texture texture = this.createTexture(ctx);
            this.configureTexture(texture);
            return texture;
        }

        @Override
        public void returnToPool(GlContext ctx, Texture texture) {
            this.getPool().add(new SoftReference<Texture>(texture));
        }

        @Override
        public void invalidate() {
            this._texture = null;
            this._pool = null;
        }

        protected abstract Texture createTexture(GlContext var1);

        protected void configureTexture(Texture texture) {
            texture.setFilters(this.minFilter.getConstant(), this.magFilter.getConstant());
            texture.setMaxAnisotropy(this.maxAnisotropy);
            texture.setWrap(this.wrapS.getConstant(), this.wrapT.getConstant(), this.wrapR.getConstant());
            texture.setBorderColor(this.borderColor);
            texture.setCompare(this.compareMode.getConstant(), this.compareFunc.getConstant());
            texture.setDepthMode(this.depthMode.getConstant());
        }

        protected List<SoftReference<Texture>> getPool() {
            if (this._pool == null) {
                this._pool = Lists.newArrayList();
            }
            return this._pool;
        }
    }

    @EditorTypes(value={Original1D.class, Original2D.class, Original2DTarget.class, OriginalRectangle.class, Original3D.class, OriginalCubeMap.class, Reflection.class, Refraction.class, CubeRender.class, Shadow.class, Animated.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        @Deprecated
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public void getUpdateResources(HashSet<String> paths) {
        }

        public abstract boolean isSupported(GlContext var1, boolean var2);

        public Texture getTexture(GlContext ctx) {
            return this.getTexture(ctx, null, null, null, null, null);
        }

        public abstract Texture getTexture(GlContext var1, TextureState var2, TextureUnit var3, Scope var4, List<Dependency.Adder> var5, List<Updater> var6);

        public Texture getFromPool(GlContext ctx) {
            return null;
        }

        public void returnToPool(GlContext ctx, Texture texture) {
        }

        public void invalidate() {
        }
    }

    public static enum DepthMode {
        LUMINANCE(6409),
        INTENSITY(32841),
        ALPHA(6406);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private DepthMode(int constant) {
            this._constant = constant;
        }
    }

    public static enum CompareFunc {
        LEQUAL(515),
        GEQUAL(518);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private CompareFunc(int constant) {
            this._constant = constant;
        }
    }

    public static enum CompareMode {
        NONE(0),
        COMPARE_R_TO_TEXTURE(34894){

            @Override
            public boolean isSupported(boolean fallback) {
                return GLContext.getCapabilities().GL_ARB_shadow;
            }
        };

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        public boolean isSupported(boolean fallback) {
            return true;
        }

        private CompareMode(int constant) {
            this._constant = constant;
        }
    }

    public static enum Wrap {
        CLAMP(10496),
        CLAMP_TO_EDGE(33071){

            @Override
            public int getConstant() {
                return GLContext.getCapabilities().OpenGL12 ? this._constant : 10496;
            }

            @Override
            public boolean isSupported(boolean fallback) {
                return GLContext.getCapabilities().OpenGL12 || fallback;
            }
        }
        ,
        REPEAT(10497),
        CLAMP_TO_BORDER(33069){

            @Override
            public int getConstant() {
                return GLContext.getCapabilities().GL_ARB_texture_border_clamp ? this._constant : 10496;
            }

            @Override
            public boolean isSupported(boolean fallback) {
                return GLContext.getCapabilities().GL_ARB_texture_border_clamp || fallback;
            }
        }
        ,
        MIRRORED_REPEAT(33648){

            @Override
            public int getConstant() {
                if (GLContext.getCapabilities().OpenGL14) {
                    return this._constant;
                }
                if (GLContext.getCapabilities().GL_ARB_texture_mirrored_repeat) {
                    return 33648;
                }
                return 10497;
            }

            @Override
            public boolean isSupported(boolean fallback) {
                return GLContext.getCapabilities().OpenGL14 || GLContext.getCapabilities().GL_ARB_texture_mirrored_repeat || fallback;
            }
        };

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        public boolean isSupported(boolean fallback) {
            return true;
        }

        private Wrap(int constant) {
            this._constant = constant;
        }
    }

    public static enum MagFilter {
        NEAREST(9728),
        LINEAR(9729);

        protected final int _constant;

        public int getConstant() {
            return this._constant;
        }

        private MagFilter(int constant) {
            this._constant = constant;
        }
    }

    public static enum MinFilter {
        NEAREST(9728, false),
        LINEAR(9729, false),
        NEAREST_MIPMAP_NEAREST(9984, true),
        LINEAR_MIPMAP_NEAREST(9985, true),
        NEAREST_MIPMAP_LINEAR(9986, true),
        LINEAR_MIPMAP_LINEAR(9987, true);

        protected final int _constant;
        protected final boolean _mipmapped;

        public int getConstant() {
            return this._constant;
        }

        public boolean isMipmapped() {
            return this._mipmapped;
        }

        private MinFilter(int constant, boolean mipmapped) {
            this._constant = constant;
            this._mipmapped = mipmapped;
        }
    }

    public static enum Format {
        DEFAULT(-1){

            @Override
            public int getConstant(BufferedImage image) {
                switch (image == null ? 4 : image.getColorModel().getNumComponents()) {
                    case 1: {
                        return LUMINANCE.getConstant(image);
                    }
                    case 2: {
                        return LUMINANCE_ALPHA.getConstant(image);
                    }
                    case 3: {
                        return RGB.getConstant(image);
                    }
                }
                return RGBA.getConstant(image);
            }
        }
        ,
        COMPRESSED_DEFAULT(-1){

            @Override
            public int getConstant(BufferedImage image) {
                switch (image == null ? 4 : image.getColorModel().getNumComponents()) {
                    case 1: {
                        return COMPRESSED_LUMINANCE.getConstant(image);
                    }
                    case 2: {
                        return COMPRESSED_LUMINANCE_ALPHA.getConstant(image);
                    }
                    case 3: {
                        return COMPRESSED_RGB.getConstant(image);
                    }
                }
                return COMPRESSED_RGBA.getConstant(image);
            }
        }
        ,
        ALPHA(6406),
        COMPRESSED_ALPHA(34025, 6406),
        LUMINANCE(6409),
        COMPRESSED_LUMINANCE(34026, 6409),
        LUMINANCE_ALPHA(6410),
        COMPRESSED_LUMINANCE_ALPHA(34027, 6410),
        INTENSITY(32841),
        COMPRESSED_INTENSITY(34028, 32841),
        RGB(6407),
        COMPRESSED_RGB(34029, 6407),
        RGBA(6408),
        COMPRESSED_RGBA(34030, 6408),
        DEPTH_COMPONENT(6402, -1, true);

        protected final int _constant;
        protected final int _uncompressed;
        protected final boolean _depth;

        public int getConstant(BufferedImage image) {
            if (this._uncompressed != -1 && !GLContext.getCapabilities().GL_ARB_texture_compression) {
                return this._uncompressed;
            }
            return this._constant;
        }

        public boolean isSupported(boolean fallback) {
            return !this._depth || GLContext.getCapabilities().GL_ARB_depth_texture;
        }

        private Format(int constant) {
            this(constant, -1);
        }

        private Format(int constant, int uncompressed) {
            this(constant, uncompressed, false);
        }

        private Format(int constant, int uncompressed, boolean depth) {
            this._constant = constant;
            this._uncompressed = uncompressed;
            this._depth = depth;
        }
    }
}

