/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.renderer;

import com.samskivert.util.IntListUtil;
import com.samskivert.util.ListUtil;
import com.samskivert.util.ObserverList;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.WeakObserverList;
import com.threerings.math.FloatMath;
import com.threerings.math.Matrix4f;
import com.threerings.math.Plane;
import com.threerings.math.Quaternion;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.math.Vector4f;
import com.threerings.opengl.gui.util.Rectangle;
import com.threerings.opengl.renderer.Batch;
import com.threerings.opengl.renderer.BufferObject;
import com.threerings.opengl.renderer.ClientArray;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Framebuffer;
import com.threerings.opengl.renderer.Light;
import com.threerings.opengl.renderer.Program;
import com.threerings.opengl.renderer.Query;
import com.threerings.opengl.renderer.Renderbuffer;
import com.threerings.opengl.renderer.Texture;
import com.threerings.opengl.renderer.TextureUnit;
import com.threerings.opengl.renderer.state.RenderState;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBBufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.Pbuffer;

public class Renderer {
    protected Drawable _drawable;
    protected int _width;
    protected int _height;
    protected WeakObserverList<Observer> _observers = WeakObserverList.newFastUnsafe();
    protected int _alphaBits;
    protected int _stencilBits;
    protected int _maxClipPlanes;
    protected int _maxLights;
    protected int _maxTextureUnits;
    protected int _maxTextureImageUnits;
    protected int _maxVertexAttribs;
    protected boolean _nvidia;
    protected boolean _ati;
    protected boolean _intel;
    protected int _textureChangeCount;
    protected int _batchCount;
    protected int _primitiveCount;
    protected RenderState[] _states = RenderState.createDefaultSet();
    protected Color4f _clearColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    protected float _clearDepth = 1.0f;
    protected int _clearStencil;
    protected Rectangle _viewport = new Rectangle();
    protected float _left = -1.0f;
    protected float _right = 1.0f;
    protected float _bottom = -1.0f;
    protected float _top = 1.0f;
    protected float _near = 1.0f;
    protected float _far = -1.0f;
    protected Vector3f _nearFarNormal = new Vector3f(Vector3f.UNIT_Z);
    protected boolean _ortho = true;
    protected ClipPlaneRecord[] _clipPlanes;
    protected int _clipPlaneEnd;
    protected Boolean _scissorTestEnabled = false;
    protected Rectangle _scissor = new Rectangle();
    protected Query _samplesPassed;
    protected Boolean _alphaTestEnabled = false;
    protected int _alphaTestFunc = 519;
    protected float _alphaTestRef;
    protected Boolean _blendEnabled = false;
    protected int _srcBlendFactor = 1;
    protected int _destBlendFactor = 0;
    protected BufferObject _arrayBuffer;
    protected BufferObject _elementArrayBuffer;
    protected int _clientActiveUnit;
    protected ClientArrayRecord[] _vertexAttribArrays;
    protected int _vertexAttribArrayStart;
    protected int _vertexAttribArrayEnd;
    protected ClientArrayRecord[] _texCoordArrays;
    protected int _texCoordArrayEnd;
    protected ClientArrayRecord _colorArray = new ClientArrayRecord();
    protected ClientArrayRecord _normalArray = new ClientArrayRecord();
    protected ClientArrayRecord _vertexArray = new ClientArrayRecord();
    protected Color4f _color = new Color4f(1.0f, 1.0f, 1.0f, 1.0f);
    protected Boolean _redMask = true;
    protected Boolean _greenMask = true;
    protected Boolean _blueMask = true;
    protected Boolean _alphaMask = true;
    protected Boolean _cullFaceEnabled = false;
    protected int _cullFace = 1029;
    protected int _frontFace = 2305;
    protected Boolean _normalize = false;
    protected Boolean _rescaleNormal = false;
    protected Boolean _depthTestEnabled = false;
    protected int _depthTestFunc = 513;
    protected Boolean _depthMask = true;
    protected Boolean _fogEnabled = false;
    protected boolean _wouldEnableFog;
    protected int _fogMode = 2048;
    protected float _fogDensity = 1.0f;
    protected float _fogStart = 0.0f;
    protected float _fogEnd = 1.0f;
    protected Color4f _fogColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    protected Boolean _lightingEnabled = false;
    protected LightRecord[] _lights;
    protected int _lightEnd;
    protected float _lineWidth = 1.0f;
    protected Color4f _globalAmbient = new Color4f(0.2f, 0.2f, 0.2f, 1.0f);
    protected Color4f _frontAmbient = new Color4f(0.2f, 0.2f, 0.2f, 1.0f);
    protected Color4f _frontDiffuse = new Color4f(0.8f, 0.8f, 0.8f, 1.0f);
    protected Color4f _frontSpecular = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
    protected Color4f _frontEmission = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
    protected float _frontShininess = 0.0f;
    protected Color4f _backAmbient = new Color4f(0.2f, 0.2f, 0.2f, 1.0f);
    protected Color4f _backDiffuse = new Color4f(0.8f, 0.8f, 0.8f, 1.0f);
    protected Color4f _backSpecular = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
    protected Color4f _backEmission = new Color4f(0.0f, 0.0f, 0.0f, 1.0f);
    protected float _backShininess = 0.0f;
    protected Boolean _colorMaterialEnabled = false;
    protected int _colorMaterialFace = 1032;
    protected int _colorMaterialMode = 5634;
    protected Boolean _twoSide = false;
    protected Boolean _localViewer = false;
    protected Boolean _separateSpecular = false;
    protected Boolean _flatShading = false;
    protected float _pointSize = 1.0f;
    protected int _frontPolygonMode = 6914;
    protected int _backPolygonMode = 6914;
    protected Boolean _polygonOffsetFillEnabled = false;
    protected Boolean _polygonOffsetLineEnabled = false;
    protected Boolean _polygonOffsetPointEnabled = false;
    protected float _polygonOffsetFactor;
    protected float _polygonOffsetUnits;
    protected Program _program;
    protected Boolean _vertexProgramTwoSide = false;
    protected Boolean _stencilTestEnabled = false;
    protected int _stencilTestFunc = 519;
    protected int _stencilTestRef = 0;
    protected int _stencilTestMask = Integer.MAX_VALUE;
    protected int _stencilFailOp = 7680;
    protected int _stencilDepthFailOp = 7680;
    protected int _stencilPassOp = 7680;
    protected int _stencilWriteMask = Integer.MAX_VALUE;
    protected TextureUnitRecord[] _units;
    protected int _unitEnd;
    protected int _activeUnit;
    protected int _matrixMode = 5888;
    protected Transform3D _modelview = new Transform3D();
    protected boolean _modelviewMatrixValid;
    protected Framebuffer _framebuffer;
    protected Renderbuffer _renderbuffer;
    protected int _drawBuffer;
    protected int _readBuffer;
    protected int _bufferObjectCount;
    protected int _bufferObjectBytes;
    protected int _displayListCount;
    protected int _shaderObjectCount;
    protected int _textureCount;
    protected int _textureBytes;
    protected int[] _finalizedBufferObjects;
    protected int _finalizedBufferObjectBytes;
    protected int[] _finalizedDisplayLists;
    protected int[] _finalizedFramebuffers;
    protected Object[] _finalizedPbuffers;
    protected int[] _finalizedQueries;
    protected int[] _finalizedRenderbuffers;
    protected int[] _finalizedShaderObjects;
    protected int[] _finalizedTextures;
    protected int _finalizedTextureBytes;
    protected Matrix4f _mat = new Matrix4f();
    protected FloatBuffer _vbuf = BufferUtils.createFloatBuffer((int)16);
    protected DoubleBuffer _dbuf = BufferUtils.createDoubleBuffer((int)16);
    protected static final BufferObject INVALID_BUFFER = new BufferObject();
    protected static final Program INVALID_PROGRAM = new Program();
    protected static final Texture INVALID_TEXTURE = new Texture(){

        @Override
        public int getWidth() {
            return -1;
        }

        @Override
        public int getHeight() {
            return -1;
        }
    };

    public void init(Drawable drawable, int width, int height) {
        int ii;
        this._drawable = drawable;
        this._width = width;
        this._height = height;
        IntBuffer buf = BufferUtils.createIntBuffer((int)16);
        GL11.glGetInteger((int)3413, (IntBuffer)buf);
        this._alphaBits = buf.get(0);
        GL11.glGetInteger((int)3415, (IntBuffer)buf);
        this._stencilBits = buf.get(0);
        GL11.glGetInteger((int)3378, (IntBuffer)buf);
        this._maxClipPlanes = buf.get(0);
        GL11.glGetInteger((int)3377, (IntBuffer)buf);
        this._maxLights = buf.get(0);
        ContextCapabilities caps = GLContext.getCapabilities();
        if (caps.GL_ARB_multitexture) {
            GL11.glGetInteger((int)34018, (IntBuffer)buf);
            this._maxTextureUnits = buf.get(0);
        } else {
            this._maxTextureUnits = 1;
        }
        if (caps.GL_ARB_fragment_shader) {
            GL11.glGetInteger((int)34930, (IntBuffer)buf);
            this._maxTextureImageUnits = buf.get(0);
        } else {
            this._maxTextureImageUnits = this._maxTextureUnits;
        }
        if (caps.GL_ARB_vertex_shader) {
            GL11.glGetInteger((int)34921, (IntBuffer)buf);
            this._maxVertexAttribs = buf.get(0);
        } else {
            this._maxVertexAttribs = 0;
        }
        String vendor = GL11.glGetString((int)7936).toLowerCase();
        this._nvidia = vendor.contains("nvidia");
        this._ati = vendor.contains("ati");
        this._intel = vendor.contains("intel");
        GL11.glGetInteger((int)3073, (IntBuffer)buf);
        this._drawBuffer = buf.get(0);
        GL11.glGetInteger((int)3074, (IntBuffer)buf);
        this._readBuffer = buf.get(0);
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        this._viewport.set(0, 0, width, height);
        this._clipPlanes = new ClipPlaneRecord[this._maxClipPlanes];
        for (ii = 0; ii < this._maxClipPlanes; ++ii) {
            this._clipPlanes[ii] = new ClipPlaneRecord();
        }
        this._scissor.set(0, 0, width, height);
        this._vertexAttribArrays = new ClientArrayRecord[this._maxVertexAttribs];
        for (ii = 0; ii < this._maxVertexAttribs; ++ii) {
            this._vertexAttribArrays[ii] = new ClientArrayRecord();
        }
        this._texCoordArrays = new ClientArrayRecord[this._maxTextureUnits];
        for (ii = 0; ii < this._maxTextureUnits; ++ii) {
            this._texCoordArrays[ii] = new ClientArrayRecord();
        }
        this._lights = new LightRecord[this._maxLights];
        for (ii = 0; ii < this._maxLights; ++ii) {
            this._lights[ii] = new LightRecord(ii);
        }
        this._units = new TextureUnitRecord[this._maxTextureImageUnits];
        for (ii = 0; ii < this._maxTextureImageUnits; ++ii) {
            this._units[ii] = new TextureUnitRecord();
        }
    }

    public Drawable getDrawable() {
        return this._drawable;
    }

    public void setSize(int width, int height) {
        if (this._width == width && this._height == height) {
            return;
        }
        this._width = width;
        this._height = height;
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer observer) {
                observer.sizeChanged(Renderer.this._width, Renderer.this._height);
                return true;
            }
        });
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void addObserver(Observer observer) {
        this._observers.add((Object)observer);
    }

    public void removeObserver(Observer observer) {
        this._observers.remove((Object)observer);
    }

    public int getAlphaBits() {
        return this._alphaBits;
    }

    public int getStencilBits() {
        return this._stencilBits;
    }

    public int getMaxClipPlanes() {
        return this._maxClipPlanes;
    }

    public int getMaxLights() {
        return this._maxLights;
    }

    public int getMaxTextureUnits() {
        return this._maxTextureUnits;
    }

    public int getMaxTextureImageUnits() {
        return this._maxTextureImageUnits;
    }

    public int getMaxVertexAttribs() {
        return this._maxVertexAttribs;
    }

    public int getTextureChangeCount() {
        return this._textureChangeCount;
    }

    public int getBatchCount() {
        return this._batchCount;
    }

    public int getPrimitiveCount() {
        return this._primitiveCount;
    }

    public void resetStats() {
        this._textureChangeCount = 0;
        this._batchCount = 0;
        this._primitiveCount = 0;
    }

    public int getBufferObjectCount() {
        return this._bufferObjectCount;
    }

    public int getBufferObjectBytes() {
        return this._bufferObjectBytes;
    }

    public int getDisplayListCount() {
        return this._displayListCount;
    }

    public int getShaderObjectCount() {
        return this._shaderObjectCount;
    }

    public int getTextureCount() {
        return this._textureCount;
    }

    public int getTextureBytes() {
        return this._textureBytes;
    }

    public void cleanup() {
        this.deleteFinalizedObjects();
    }

    public void setClearColor(Color4f color) {
        if (!this._clearColor.equals(color)) {
            GL11.glClearColor((float)color.r, (float)color.g, (float)color.b, (float)color.a);
            this._clearColor.set(color);
        }
    }

    public Color4f getClearColor() {
        return this._clearColor;
    }

    public void setClearDepth(float depth) {
        if (this._clearDepth != depth) {
            this._clearDepth = depth;
            GL11.glClearDepth((double)this._clearDepth);
        }
    }

    public float getClearDepth() {
        return this._clearDepth;
    }

    public void setClearStencil(int stencil) {
        if (this._clearStencil != stencil) {
            this._clearStencil = stencil;
            GL11.glClearStencil((int)this._clearStencil);
        }
    }

    public int getClearStencil() {
        return this._clearStencil;
    }

    public void setViewport(Rectangle viewport) {
        this.setViewport(viewport.x, viewport.y, viewport.width, viewport.height);
    }

    public void setViewport(int x, int y, int width, int height) {
        if (this._viewport.x != x || this._viewport.y != y || this._viewport.width != width || this._viewport.height != height) {
            this._viewport.x = x;
            this._viewport.y = y;
            this._viewport.width = width;
            this._viewport.height = height;
            GL11.glViewport((int)this._viewport.x, (int)this._viewport.y, (int)this._viewport.width, (int)this._viewport.height);
        }
    }

    public Rectangle getViewport() {
        return this._viewport;
    }

    public void setProjection(float left, float right, float bottom, float top, float near, float far, Vector3f nearFarNormal, boolean ortho) {
        if (this._left == left && this._right == right && this._bottom == bottom && this._top == top && this._near == near && this._far == far && this._nearFarNormal.equals(nearFarNormal) && this._ortho == ortho) {
            return;
        }
        this.setMatrixMode(5889);
        if (this._nearFarNormal.set(nearFarNormal).equals(Vector3f.UNIT_Z)) {
            GL11.glLoadIdentity();
            this._ortho = ortho;
            if (this._ortho) {
                this._left = left;
                this._right = right;
                this._bottom = bottom;
                this._top = top;
                this._near = near;
                this._far = far;
                GL11.glOrtho((double)this._left, (double)this._right, (double)this._bottom, (double)this._top, (double)this._near, (double)this._far);
            } else {
                this._left = left;
                this._right = right;
                this._bottom = bottom;
                this._top = top;
                this._near = near;
                this._far = far;
                GL11.glFrustum((double)this._left, (double)this._right, (double)this._bottom, (double)this._top, (double)this._near, (double)this._far);
            }
            return;
        }
        this._ortho = ortho;
        if (this._ortho) {
            this._left = left;
            this._right = right;
            this._bottom = bottom;
            this._top = top;
            this._near = near;
            this._far = far;
            this._mat.setToOrtho(this._left, this._right, this._bottom, this._top, this._near, this._far, this._nearFarNormal);
        } else {
            this._left = left;
            this._right = right;
            this._bottom = bottom;
            this._top = top;
            this._near = near;
            this._far = far;
            this._mat.setToFrustum(this._left, this._right, this._bottom, this._top, this._near, this._far, this._nearFarNormal);
        }
        this._mat.get(this._vbuf).rewind();
        GL11.glLoadMatrix((FloatBuffer)this._vbuf);
    }

    public float getLeft() {
        return this._left;
    }

    public float getRight() {
        return this._right;
    }

    public float getBottom() {
        return this._bottom;
    }

    public float getTop() {
        return this._top;
    }

    public float getNear() {
        return this._near;
    }

    public float getFar() {
        return this._far;
    }

    public Vector3f getNearFarNormal() {
        return this._nearFarNormal;
    }

    public boolean isOrtho() {
        return this._ortho;
    }

    public void setClipPlanes(Plane[] planes) {
        int numPlanes = planes == null ? 0 : planes.length;
        int nn = Math.max(this._clipPlaneEnd, numPlanes);
        for (int ii = 0; ii < nn; ++ii) {
            ClipPlaneRecord prec = this._clipPlanes[ii];
            Plane plane = ii < numPlanes ? planes[ii] : null;
            boolean planeEnabled = plane != null;
            int pname = 12288 + ii;
            if (prec.enabled != Boolean.valueOf(planeEnabled)) {
                prec.enabled = planeEnabled;
                Renderer.setCapability(pname, prec.enabled);
            }
            if (!planeEnabled || prec.equals(plane)) continue;
            Matrix4f mat = this.getModelviewMatrix();
            Vector3f normal = prec.set(plane).getNormal();
            this._dbuf.put(normal.x * mat.m00 + normal.y * mat.m01 + normal.z * mat.m02);
            this._dbuf.put(normal.x * mat.m10 + normal.y * mat.m11 + normal.z * mat.m12);
            this._dbuf.put(normal.x * mat.m20 + normal.y * mat.m21 + normal.z * mat.m22);
            this._dbuf.put(normal.x * mat.m30 + normal.y * mat.m31 + normal.z * mat.m32 + prec.constant);
            this._dbuf.rewind();
            GL11.glClipPlane((int)pname, (DoubleBuffer)this._dbuf);
        }
        this._clipPlaneEnd = numPlanes;
    }

    public void setScissor(Rectangle box) {
        boolean scissorTestEnabled;
        boolean bl = scissorTestEnabled = box != null;
        if (this._scissorTestEnabled != Boolean.valueOf(scissorTestEnabled)) {
            this._scissorTestEnabled = scissorTestEnabled;
            Renderer.setCapability(3089, this._scissorTestEnabled);
        }
        if (scissorTestEnabled && !this._scissor.equals(box)) {
            GL11.glScissor((int)box.x, (int)box.y, (int)box.width, (int)box.height);
            this._scissor.set(box);
        }
    }

    public Rectangle getScissor() {
        return this._scissorTestEnabled == Boolean.TRUE ? this._scissor : null;
    }

    public void setFrontFace(int face) {
        if (this._frontFace != face) {
            this._frontFace = face;
            GL11.glFrontFace((int)this._frontFace);
        }
    }

    public int getFrontFace() {
        return this._frontFace;
    }

    public void setNormalize(boolean normalize, boolean rescaleNormal) {
        if (this._normalize != Boolean.valueOf(normalize)) {
            this._normalize = normalize;
            Renderer.setCapability(2977, this._normalize);
        }
        if (this._rescaleNormal != Boolean.valueOf(rescaleNormal)) {
            this._rescaleNormal = rescaleNormal;
            Renderer.setCapability(32826, this._rescaleNormal);
        }
    }

    public void startQuery(Query query) {
        if (query.getTarget() != 35092 || this._samplesPassed == query) {
            return;
        }
        if (this._samplesPassed != null) {
            ARBOcclusionQuery.glEndQueryARB((int)35092);
        }
        this._samplesPassed = query;
        ARBOcclusionQuery.glBeginQueryARB((int)query.getTarget(), (int)query.getId());
    }

    public void stopQuery(Query query) {
        if (this._samplesPassed != query) {
            return;
        }
        ARBOcclusionQuery.glEndQueryARB((int)35092);
        this._samplesPassed = null;
    }

    public void setStates(RenderState[] states) {
        for (int ii = 0; ii < 16; ++ii) {
            RenderState state = states[ii];
            if (state == null || this._states[ii] == state && !state.isDirty()) continue;
            state.apply(this);
            state.setDirty(false);
            this._states[ii] = state;
        }
    }

    public void setState(RenderState state) {
        int type = state.getType();
        if (this._states[type] != state || state.isDirty()) {
            state.apply(this);
            state.setDirty(false);
            this._states[type] = state;
        }
    }

    public void setAlphaState(int alphaTestFunc, float alphaTestRef, int srcBlendFactor, int destBlendFactor) {
        boolean blendEnabled;
        boolean alphaTestEnabled;
        this._states[0] = null;
        boolean bl = alphaTestEnabled = alphaTestFunc != 519;
        if (this._alphaTestEnabled != Boolean.valueOf(alphaTestEnabled)) {
            this._alphaTestEnabled = alphaTestEnabled;
            Renderer.setCapability(3008, this._alphaTestEnabled);
        }
        if (alphaTestEnabled && (this._alphaTestFunc != alphaTestFunc || this._alphaTestRef != alphaTestRef)) {
            this._alphaTestFunc = alphaTestFunc;
            this._alphaTestRef = alphaTestRef;
            GL11.glAlphaFunc((int)this._alphaTestFunc, (float)this._alphaTestRef);
        }
        boolean bl2 = blendEnabled = srcBlendFactor != 1 || destBlendFactor != 0;
        if (this._blendEnabled != Boolean.valueOf(blendEnabled)) {
            this._blendEnabled = blendEnabled;
            Renderer.setCapability(3042, this._blendEnabled);
        }
        if (blendEnabled && (this._srcBlendFactor != srcBlendFactor || this._destBlendFactor != destBlendFactor)) {
            this._srcBlendFactor = srcBlendFactor;
            this._destBlendFactor = destBlendFactor;
            GL11.glBlendFunc((int)this._srcBlendFactor, (int)this._destBlendFactor);
        }
    }

    public void invalidateAlphaState() {
        this._blendEnabled = null;
        this._alphaTestEnabled = null;
        this._destBlendFactor = -1;
        this._srcBlendFactor = -1;
        this._alphaTestFunc = -1;
        this._alphaTestRef = -1.0f;
        this._states[0] = null;
    }

    public void setArrayState(int firstVertexAttribIndex, ClientArray[] vertexAttribArrays, ClientArray[] texCoordArrays, ClientArray colorArray, ClientArray normalArray, ClientArray vertexArray, BufferObject elementArrayBuffer) {
        boolean enableVertexArray;
        boolean enableNormalArray;
        boolean enableColorArray;
        this._states[1] = null;
        int numVertexAttribArrays = vertexAttribArrays == null ? 0 : vertexAttribArrays.length;
        int lastVertexAttribIndex = firstVertexAttribIndex + numVertexAttribArrays;
        int nn = Math.max(this._vertexAttribArrayEnd, lastVertexAttribIndex);
        for (int ii = Math.min(this._vertexAttribArrayStart, firstVertexAttribIndex); ii < nn; ++ii) {
            boolean enableVertexAttribArray;
            ClientArrayRecord arec = this._vertexAttribArrays[ii];
            ClientArray vertexAttribArray = ii >= firstVertexAttribIndex && ii < lastVertexAttribIndex ? vertexAttribArrays[ii - firstVertexAttribIndex] : null;
            boolean bl = enableVertexAttribArray = vertexAttribArray != null;
            if (arec.array == vertexAttribArray && (!enableVertexAttribArray || !vertexAttribArray.dirty)) continue;
            if (arec.enabled != Boolean.valueOf(enableVertexAttribArray)) {
                arec.enabled = enableVertexAttribArray;
                if (arec.enabled.booleanValue()) {
                    ARBVertexShader.glEnableVertexAttribArrayARB((int)ii);
                } else {
                    ARBVertexShader.glDisableVertexAttribArrayARB((int)ii);
                }
            }
            arec.array = vertexAttribArray;
            if (!enableVertexAttribArray) continue;
            vertexAttribArray.dirty = false;
            if (arec.equals(vertexAttribArray)) continue;
            this.setVertexAttribArray(ii, arec.set(vertexAttribArray));
        }
        this._vertexAttribArrayStart = firstVertexAttribIndex;
        this._vertexAttribArrayEnd = lastVertexAttribIndex;
        int numTexCoordArrays = texCoordArrays == null ? 0 : texCoordArrays.length;
        int nn2 = Math.max(this._texCoordArrayEnd, numTexCoordArrays);
        for (int ii = 0; ii < nn2; ++ii) {
            boolean enableTexCoordArray;
            ClientArrayRecord arec = this._texCoordArrays[ii];
            ClientArray texCoordArray = ii < numTexCoordArrays ? texCoordArrays[ii] : null;
            boolean bl = enableTexCoordArray = texCoordArray != null;
            if (arec.array == texCoordArray && (!enableTexCoordArray || !texCoordArray.dirty)) continue;
            if (arec.enabled != Boolean.valueOf(enableTexCoordArray)) {
                this.setClientActiveUnit(ii);
                arec.enabled = enableTexCoordArray;
                Renderer.setClientCapability(32888, arec.enabled);
            }
            arec.array = texCoordArray;
            if (!enableTexCoordArray) continue;
            texCoordArray.dirty = false;
            if (arec.equals(texCoordArray)) continue;
            this.setClientActiveUnit(ii);
            this.setTexCoordArray(arec.set(texCoordArray));
        }
        this._texCoordArrayEnd = numTexCoordArrays;
        boolean bl = enableColorArray = colorArray != null;
        if (this._colorArray.array != colorArray || enableColorArray && colorArray.dirty) {
            if (this._colorArray.enabled != Boolean.valueOf(enableColorArray)) {
                this._colorArray.enabled = enableColorArray;
                Renderer.setClientCapability(32886, this._colorArray.enabled);
            }
            this._colorArray.array = colorArray;
            if (enableColorArray) {
                colorArray.dirty = false;
                if (!this._colorArray.equals(colorArray)) {
                    this.setColorArray(this._colorArray.set(colorArray));
                }
            }
        }
        boolean bl2 = enableNormalArray = normalArray != null;
        if (this._normalArray.array != normalArray || enableNormalArray && normalArray.dirty) {
            if (this._normalArray.enabled != Boolean.valueOf(enableNormalArray)) {
                this._normalArray.enabled = enableNormalArray;
                Renderer.setClientCapability(32885, this._normalArray.enabled);
            }
            this._normalArray.array = normalArray;
            if (enableNormalArray) {
                normalArray.dirty = false;
                if (!this._normalArray.equals(normalArray)) {
                    this.setNormalArray(this._normalArray.set(normalArray));
                }
            }
        }
        boolean bl3 = enableVertexArray = vertexArray != null;
        if (this._vertexArray.array != vertexArray || enableVertexArray && vertexArray.dirty) {
            if (this._vertexArray.enabled != Boolean.valueOf(enableVertexArray)) {
                this._vertexArray.enabled = enableVertexArray;
                Renderer.setClientCapability(32884, this._vertexArray.enabled);
            }
            this._vertexArray.array = vertexArray;
            if (enableVertexArray) {
                vertexArray.dirty = false;
                if (!this._vertexArray.equals(vertexArray)) {
                    this.setVertexArray(this._vertexArray.set(vertexArray));
                }
            }
        }
        if (this._elementArrayBuffer != elementArrayBuffer) {
            int id = elementArrayBuffer == null ? 0 : elementArrayBuffer.getId();
            ARBBufferObject.glBindBufferARB((int)34963, (int)id);
            this._elementArrayBuffer = elementArrayBuffer;
        }
    }

    public void invalidateArrayState() {
        for (ClientArrayRecord arec : this._vertexAttribArrays) {
            arec.invalidate();
        }
        this._vertexAttribArrayStart = 0;
        this._vertexAttribArrayEnd = this._vertexAttribArrays.length;
        for (ClientArrayRecord arec : this._texCoordArrays) {
            arec.invalidate();
        }
        this._texCoordArrayEnd = this._texCoordArrays.length;
        this._colorArray.invalidate();
        this._normalArray.invalidate();
        this._vertexArray.invalidate();
        if (GLContext.getCapabilities().GL_ARB_vertex_buffer_object) {
            this._elementArrayBuffer = INVALID_BUFFER;
        }
        this._states[1] = null;
    }

    public void setColorState(Color4f color) {
        if (!this._color.equals(color)) {
            GL11.glColor4f((float)color.r, (float)color.g, (float)color.b, (float)color.a);
            this._color.set(color);
            this._states[2] = null;
        }
    }

    public void setColorState(float r, float g, float b, float a) {
        if (this._color.r != r || this._color.g != g || this._color.b != b || this._color.a != a) {
            GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
            this._color.set(r, g, b, a);
            this._states[2] = null;
        }
    }

    public void invalidateColorState() {
        this._color.r = -1.0f;
        this._states[2] = null;
    }

    public void setColorMaskState(boolean red, boolean green, boolean blue, boolean alpha) {
        if (this._redMask != Boolean.valueOf(red) || this._greenMask != Boolean.valueOf(green) || this._blueMask != Boolean.valueOf(blue) || this._alphaMask != Boolean.valueOf(alpha)) {
            this._redMask = red;
            this._greenMask = green;
            this._blueMask = blue;
            this._alphaMask = alpha;
            GL11.glColorMask((boolean)this._redMask, (boolean)this._greenMask, (boolean)this._blueMask, (boolean)this._alphaMask);
            this._states[3] = null;
        }
    }

    public void invalidateColorMaskState() {
        this._alphaMask = null;
        this._blueMask = null;
        this._greenMask = null;
        this._redMask = null;
        this._states[3] = null;
    }

    public void setCullState(int cullFace) {
        boolean cullFaceEnabled;
        this._states[4] = null;
        boolean bl = cullFaceEnabled = cullFace != -1;
        if (this._cullFaceEnabled != Boolean.valueOf(cullFaceEnabled)) {
            this._cullFaceEnabled = cullFaceEnabled;
            Renderer.setCapability(2884, this._cullFaceEnabled);
        }
        if (cullFaceEnabled && this._cullFace != cullFace) {
            this._cullFace = cullFace;
            GL11.glCullFace((int)this._cullFace);
        }
    }

    public void invalidateCullState() {
        this._cullFaceEnabled = null;
        this._cullFace = -1;
        this._states[4] = null;
    }

    public void setDepthState(int depthTestFunc, boolean depthMask) {
        boolean depthTestEnabled;
        this._states[5] = null;
        boolean bl = depthTestEnabled = depthTestFunc != 519 || depthMask;
        if (this._depthTestEnabled != Boolean.valueOf(depthTestEnabled)) {
            this._depthTestEnabled = depthTestEnabled;
            Renderer.setCapability(2929, this._depthTestEnabled);
        }
        if (!depthTestEnabled) {
            return;
        }
        if (this._depthTestFunc != depthTestFunc) {
            this._depthTestFunc = depthTestFunc;
            GL11.glDepthFunc((int)this._depthTestFunc);
        }
        if (this._depthMask != Boolean.valueOf(depthMask)) {
            this._depthMask = depthMask;
            GL11.glDepthMask((boolean)this._depthMask);
        }
    }

    public void invalidateDepthState() {
        this._depthMask = null;
        this._depthTestEnabled = null;
        this._depthTestFunc = -1;
        this._states[5] = null;
    }

    public void setFogState(int fogMode, float fogDensity, Color4f fogColor) {
        this._states[6] = null;
        this._wouldEnableFog = fogMode != -1;
        this.updateFogEnabled();
        if (!this._wouldEnableFog) {
            return;
        }
        if (this._fogMode != fogMode) {
            this._fogMode = fogMode;
            GL11.glFogi((int)2917, (int)this._fogMode);
        }
        if (this._fogDensity != fogDensity) {
            this._fogDensity = fogDensity;
            GL11.glFogf((int)2914, (float)this._fogDensity);
        }
        if (!this._fogColor.equals(fogColor)) {
            this._fogColor.set(fogColor).get(this._vbuf).rewind();
            GL11.glFog((int)2918, (FloatBuffer)this._vbuf);
        }
    }

    public void setFogState(int fogMode, float fogStart, float fogEnd, Color4f fogColor) {
        this._states[6] = null;
        this._wouldEnableFog = fogMode != -1;
        this.updateFogEnabled();
        if (!this._wouldEnableFog) {
            return;
        }
        if (this._fogMode != fogMode) {
            this._fogMode = fogMode;
            GL11.glFogi((int)2917, (int)this._fogMode);
        }
        if (this._fogStart != fogStart) {
            this._fogStart = fogStart;
            GL11.glFogf((int)2915, (float)this._fogStart);
        }
        if (this._fogEnd != fogEnd) {
            this._fogEnd = fogEnd;
            GL11.glFogf((int)2916, (float)this._fogEnd);
        }
        if (!this._fogColor.equals(fogColor)) {
            this._fogColor.set(fogColor).get(this._vbuf).rewind();
            GL11.glFog((int)2918, (FloatBuffer)this._vbuf);
        }
    }

    public void invalidateFogState() {
        this._fogEnabled = null;
        this._fogMode = -1;
        this._fogEnd = -1.0f;
        this._fogStart = -1.0f;
        this._fogDensity = -1.0f;
        this._fogColor.a = -1.0f;
        this._states[6] = null;
    }

    public void setLightState(Light[] lights, Color4f globalAmbient) {
        boolean lightingEnabled;
        this._states[7] = null;
        boolean bl = lightingEnabled = lights != null;
        if (this._lightingEnabled != Boolean.valueOf(lightingEnabled)) {
            this._lightingEnabled = lightingEnabled;
            Renderer.setCapability(2896, this._lightingEnabled);
        }
        if (!lightingEnabled) {
            return;
        }
        int numLights = lights == null ? 0 : lights.length;
        boolean cleared = false;
        int nn = Math.max(this._lightEnd, numLights);
        for (int ii = 0; ii < nn; ++ii) {
            boolean lightEnabled;
            LightRecord lrec = this._lights[ii];
            Light light = ii < numLights ? lights[ii] : null;
            boolean bl2 = lightEnabled = light != null;
            if (lrec.light == light && (!lightEnabled || !light.dirty)) continue;
            int lname = 16384 + ii;
            if (lrec.enabled != Boolean.valueOf(lightEnabled)) {
                lrec.enabled = lightEnabled;
                Renderer.setCapability(lname, lrec.enabled);
            }
            lrec.light = light;
            if (!lightEnabled) continue;
            light.dirty = false;
            if (!lrec.ambient.equals(light.ambient)) {
                lrec.ambient.set(light.ambient).get(this._vbuf).rewind();
                GL11.glLight((int)lname, (int)4608, (FloatBuffer)this._vbuf);
            }
            if (!lrec.diffuse.equals(light.diffuse)) {
                lrec.diffuse.set(light.diffuse).get(this._vbuf).rewind();
                GL11.glLight((int)lname, (int)4609, (FloatBuffer)this._vbuf);
            }
            if (!lrec.specular.equals(light.specular)) {
                lrec.specular.set(light.specular).get(this._vbuf).rewind();
                GL11.glLight((int)lname, (int)4610, (FloatBuffer)this._vbuf);
            }
            if (!lrec.position.equals(light.position)) {
                cleared = this.maybeClearModelview(cleared);
                lrec.position.set(light.position).get(this._vbuf).rewind();
                GL11.glLight((int)lname, (int)4611, (FloatBuffer)this._vbuf);
            }
            if (lrec.spotExponent != light.spotExponent) {
                lrec.spotExponent = light.spotExponent;
                GL11.glLightf((int)lname, (int)4613, (float)lrec.spotExponent);
            }
            if (lrec.spotCutoff != light.spotCutoff) {
                lrec.spotCutoff = light.spotCutoff;
                GL11.glLightf((int)lname, (int)4614, (float)lrec.spotCutoff);
            }
            if (light.spotCutoff != 180.0f && !lrec.spotDirection.equals(light.spotDirection)) {
                cleared = this.maybeClearModelview(cleared);
                lrec.spotDirection.set(light.spotDirection).get(this._vbuf).rewind();
                GL11.glLight((int)lname, (int)4612, (FloatBuffer)this._vbuf);
            }
            if (light.position.w == 0.0f) continue;
            if (lrec.constantAttenuation != light.constantAttenuation) {
                lrec.constantAttenuation = light.constantAttenuation;
                GL11.glLightf((int)lname, (int)4615, (float)lrec.constantAttenuation);
            }
            if (lrec.linearAttenuation != light.linearAttenuation) {
                lrec.linearAttenuation = light.linearAttenuation;
                GL11.glLightf((int)lname, (int)4616, (float)lrec.linearAttenuation);
            }
            if (lrec.quadraticAttenuation == light.quadraticAttenuation) continue;
            lrec.quadraticAttenuation = light.quadraticAttenuation;
            GL11.glLightf((int)lname, (int)4617, (float)lrec.quadraticAttenuation);
        }
        this._lightEnd = numLights;
        this.maybeRestoreModelview(cleared);
        if (!this._globalAmbient.equals(globalAmbient)) {
            this._globalAmbient.set(globalAmbient).get(this._vbuf).rewind();
            GL11.glLightModel((int)2899, (FloatBuffer)this._vbuf);
        }
    }

    public void invalidateLightState() {
        this._lightingEnabled = null;
        for (LightRecord lrec : this._lights) {
            lrec.invalidate();
        }
        this._lightEnd = this._lights.length;
        this._globalAmbient.a = -1.0f;
        this._states[7] = null;
    }

    public void setLineState(float lineWidth) {
        if (this._lineWidth != lineWidth) {
            this._lineWidth = lineWidth;
            GL11.glLineWidth((float)this._lineWidth);
            this._states[8] = null;
        }
    }

    public void invalidateLineState() {
        this._lineWidth = -1.0f;
        this._states[8] = null;
    }

    public void setMaterialState(Color4f frontAmbient, Color4f frontDiffuse, Color4f frontSpecular, Color4f frontEmission, float frontShininess, Color4f backAmbient, Color4f backDiffuse, Color4f backSpecular, Color4f backEmission, float backShininess, int colorMaterialMode, int colorMaterialFace, boolean twoSide, boolean localViewer, boolean separateSpecular, boolean flatShading) {
        boolean colorMaterialEnabled;
        this._states[9] = null;
        if (!this._frontAmbient.equals(frontAmbient)) {
            this._frontAmbient.set(frontAmbient).get(this._vbuf).rewind();
            GL11.glMaterial((int)1028, (int)4608, (FloatBuffer)this._vbuf);
        }
        if (!this._frontDiffuse.equals(frontDiffuse)) {
            this._frontDiffuse.set(frontDiffuse).get(this._vbuf).rewind();
            GL11.glMaterial((int)1028, (int)4609, (FloatBuffer)this._vbuf);
        }
        if (!this._frontSpecular.equals(frontSpecular)) {
            this._frontSpecular.set(frontSpecular).get(this._vbuf).rewind();
            GL11.glMaterial((int)1028, (int)4610, (FloatBuffer)this._vbuf);
        }
        if (!this._frontEmission.equals(frontEmission)) {
            this._frontEmission.set(frontEmission).get(this._vbuf).rewind();
            GL11.glMaterial((int)1028, (int)5632, (FloatBuffer)this._vbuf);
        }
        if (this._frontShininess != frontShininess) {
            this._frontShininess = frontShininess;
            GL11.glMaterialf((int)1028, (int)5633, (float)this._frontShininess);
        }
        if (twoSide) {
            if (!this._backAmbient.equals(backAmbient)) {
                this._backAmbient.set(backAmbient).get(this._vbuf).rewind();
                GL11.glMaterial((int)1029, (int)4608, (FloatBuffer)this._vbuf);
            }
            if (!this._backDiffuse.equals(backDiffuse)) {
                this._backDiffuse.set(backDiffuse).get(this._vbuf).rewind();
                GL11.glMaterial((int)1029, (int)4609, (FloatBuffer)this._vbuf);
            }
            if (!this._backSpecular.equals(backSpecular)) {
                this._backSpecular.set(backSpecular).get(this._vbuf).rewind();
                GL11.glMaterial((int)1029, (int)4610, (FloatBuffer)this._vbuf);
            }
            if (!this._backEmission.equals(backEmission)) {
                this._backEmission.set(backEmission).get(this._vbuf).rewind();
                GL11.glMaterial((int)1029, (int)5632, (FloatBuffer)this._vbuf);
            }
            if (this._backShininess != backShininess) {
                this._backShininess = backShininess;
                GL11.glMaterialf((int)1029, (int)5633, (float)this._backShininess);
            }
        }
        boolean bl = colorMaterialEnabled = colorMaterialMode != -1;
        if (this._colorMaterialEnabled != Boolean.valueOf(colorMaterialEnabled)) {
            this._colorMaterialEnabled = colorMaterialEnabled;
            Renderer.setCapability(2903, this._colorMaterialEnabled);
        }
        if (colorMaterialEnabled && (this._colorMaterialFace != colorMaterialFace || this._colorMaterialMode != colorMaterialMode)) {
            this._colorMaterialFace = colorMaterialFace;
            this._colorMaterialMode = colorMaterialMode;
            GL11.glColorMaterial((int)this._colorMaterialFace, (int)this._colorMaterialMode);
        }
        if (this._twoSide != Boolean.valueOf(twoSide)) {
            this._twoSide = twoSide;
            GL11.glLightModeli((int)2898, (int)(this._twoSide != false ? 1 : 0));
        }
        if (this._localViewer != Boolean.valueOf(localViewer)) {
            this._localViewer = localViewer;
            GL11.glLightModeli((int)2897, (int)(this._localViewer != false ? 1 : 0));
        }
        if (this._separateSpecular != Boolean.valueOf(separateSpecular)) {
            this._separateSpecular = separateSpecular;
            GL11.glLightModeli((int)33272, (int)(this._separateSpecular != false ? 33274 : 33273));
        }
        if (this._flatShading != Boolean.valueOf(flatShading)) {
            this._flatShading = flatShading;
            GL11.glShadeModel((int)(this._flatShading != false ? 7424 : 7425));
        }
    }

    public void invalidateMaterialState() {
        this._frontEmission.a = -1.0f;
        this._frontSpecular.a = -1.0f;
        this._frontDiffuse.a = -1.0f;
        this._frontAmbient.a = -1.0f;
        this._backEmission.a = -1.0f;
        this._backSpecular.a = -1.0f;
        this._backDiffuse.a = -1.0f;
        this._backAmbient.a = -1.0f;
        this._backShininess = -1.0f;
        this._frontShininess = -1.0f;
        this._flatShading = null;
        this._separateSpecular = null;
        this._localViewer = null;
        this._twoSide = null;
        this._colorMaterialEnabled = null;
        this._colorMaterialMode = -1;
        this._colorMaterialFace = -1;
        this._states[9] = null;
    }

    public void setPointState(float pointSize) {
        if (this._pointSize != pointSize) {
            this._pointSize = pointSize;
            GL11.glPointSize((float)this._pointSize);
            this._states[10] = null;
        }
    }

    public void invalidatePointState() {
        this._pointSize = -1.0f;
        this._states[10] = null;
    }

    public void setPolygonState(int frontPolygonMode, int backPolygonMode, float polygonOffsetFactor, float polygonOffsetUnits) {
        boolean enablePolygonOffset;
        this._states[11] = null;
        if (this._frontPolygonMode != frontPolygonMode) {
            this._frontPolygonMode = frontPolygonMode;
            GL11.glPolygonMode((int)1028, (int)this._frontPolygonMode);
        }
        if (this._backPolygonMode != backPolygonMode) {
            this._backPolygonMode = backPolygonMode;
            GL11.glPolygonMode((int)1029, (int)this._backPolygonMode);
        }
        boolean bl = enablePolygonOffset = polygonOffsetFactor != 0.0f || polygonOffsetUnits != 0.0f;
        if ((frontPolygonMode == 6914 || backPolygonMode == 6914) && this._polygonOffsetFillEnabled != Boolean.valueOf(enablePolygonOffset)) {
            this._polygonOffsetFillEnabled = enablePolygonOffset;
            Renderer.setCapability(32823, this._polygonOffsetFillEnabled);
        }
        if ((frontPolygonMode == 6913 || backPolygonMode == 6913) && this._polygonOffsetLineEnabled != Boolean.valueOf(enablePolygonOffset)) {
            this._polygonOffsetLineEnabled = enablePolygonOffset;
            Renderer.setCapability(10754, this._polygonOffsetLineEnabled);
        }
        if ((frontPolygonMode == 6912 || backPolygonMode == 6912) && this._polygonOffsetPointEnabled != Boolean.valueOf(enablePolygonOffset)) {
            this._polygonOffsetPointEnabled = enablePolygonOffset;
            Renderer.setCapability(10753, this._polygonOffsetPointEnabled);
        }
        if (enablePolygonOffset && (this._polygonOffsetFactor != polygonOffsetFactor || this._polygonOffsetUnits != polygonOffsetUnits)) {
            this._polygonOffsetFactor = polygonOffsetFactor;
            this._polygonOffsetUnits = polygonOffsetUnits;
            GL11.glPolygonOffset((float)this._polygonOffsetFactor, (float)this._polygonOffsetUnits);
        }
    }

    public void invalidatePolygonState() {
        this._backPolygonMode = -1;
        this._frontPolygonMode = -1;
        this._polygonOffsetUnits = Float.NaN;
        this._polygonOffsetFactor = Float.NaN;
        this._polygonOffsetPointEnabled = null;
        this._polygonOffsetLineEnabled = null;
        this._polygonOffsetFillEnabled = null;
        this._states[11] = null;
    }

    public void setShaderState(Program program, boolean vertexProgramTwoSide) {
        if (this._program != program) {
            int id = program == null ? 0 : program.getId();
            ARBShaderObjects.glUseProgramObjectARB((int)id);
            this._program = program;
            this._states[12] = null;
        }
        if (program != null && program.getVertexShader() != null && this._vertexProgramTwoSide != Boolean.valueOf(vertexProgramTwoSide)) {
            this._vertexProgramTwoSide = vertexProgramTwoSide;
            Renderer.setCapability(34371, this._vertexProgramTwoSide);
        }
        this.updateFogEnabled();
    }

    public void invalidateShaderState() {
        if (GLContext.getCapabilities().GL_ARB_shader_objects) {
            this._program = INVALID_PROGRAM;
            this._vertexProgramTwoSide = null;
        }
        this._states[12] = null;
    }

    public void setStencilState(int stencilTestFunc, int stencilTestRef, int stencilTestMask, int stencilFailOp, int stencilDepthFailOp, int stencilPassOp, int stencilWriteMask) {
        boolean stencilTestEnabled;
        this._states[13] = null;
        boolean bl = stencilTestEnabled = stencilTestFunc != 519 || stencilDepthFailOp != 7680 || stencilPassOp != 7680;
        if (this._stencilTestEnabled != Boolean.valueOf(stencilTestEnabled)) {
            this._stencilTestEnabled = stencilTestEnabled;
            Renderer.setCapability(2960, this._stencilTestEnabled);
        }
        if (!stencilTestEnabled) {
            return;
        }
        if (this._stencilTestFunc != stencilTestFunc || this._stencilTestRef != stencilTestRef || this._stencilTestMask != stencilTestMask) {
            this._stencilTestFunc = stencilTestFunc;
            this._stencilTestRef = stencilTestRef;
            this._stencilTestMask = stencilTestMask;
            GL11.glStencilFunc((int)this._stencilTestFunc, (int)this._stencilTestRef, (int)this._stencilTestMask);
        }
        if (this._stencilFailOp != stencilFailOp || this._stencilDepthFailOp != stencilDepthFailOp || this._stencilPassOp != stencilPassOp) {
            this._stencilFailOp = stencilFailOp;
            this._stencilDepthFailOp = stencilDepthFailOp;
            this._stencilPassOp = stencilPassOp;
            GL11.glStencilOp((int)this._stencilFailOp, (int)this._stencilDepthFailOp, (int)this._stencilPassOp);
        }
        if (this._stencilWriteMask != stencilWriteMask) {
            this._stencilWriteMask = stencilWriteMask;
            GL11.glStencilMask((int)this._stencilWriteMask);
        }
    }

    public void invalidateStencilState() {
        this._stencilTestEnabled = null;
        this._stencilTestMask = -1;
        this._stencilTestRef = -1;
        this._stencilTestFunc = -1;
        this._stencilPassOp = -1;
        this._stencilDepthFailOp = -1;
        this._stencilFailOp = -1;
        this._stencilWriteMask = -1;
        this._states[13] = null;
    }

    public void setTextureState(TextureUnit[] units) {
        this._states[14] = null;
        int numUnits = units == null ? 0 : units.length;
        boolean cleared = false;
        int nn = Math.max(this._unitEnd, numUnits);
        for (int ii = 0; ii < nn; ++ii) {
            boolean genEnabledQ;
            boolean genEnabledR;
            boolean genEnabledT;
            boolean genEnabledS;
            boolean combine;
            boolean enabledCubeMap;
            boolean unitEnabled;
            TextureUnit unit;
            TextureUnitRecord urec = this._units[ii];
            TextureUnit textureUnit = unit = ii < numUnits ? units[ii] : null;
            if (unit != null && unit.texture == null) {
                unit = null;
            }
            boolean bl = unitEnabled = unit != null;
            if (urec.unit == unit && (!unitEnabled || !unit.dirty)) continue;
            int target = unitEnabled ? unit.texture.getTarget() : 0;
            boolean bl2 = enabledCubeMap = target == 34067;
            if (urec.enabledCubeMap != Boolean.valueOf(enabledCubeMap)) {
                this.setActiveUnit(ii);
                urec.enabledCubeMap = enabledCubeMap;
                Renderer.setCapability(34067, urec.enabledCubeMap);
            }
            if (!enabledCubeMap) {
                boolean enabled3D;
                boolean bl3 = enabled3D = target == 32879;
                if (urec.enabled3D != Boolean.valueOf(enabled3D)) {
                    this.setActiveUnit(ii);
                    urec.enabled3D = enabled3D;
                    Renderer.setCapability(32879, urec.enabled3D);
                }
                if (!enabled3D) {
                    boolean enabledRectangle;
                    boolean bl4 = enabledRectangle = target == 34037;
                    if (urec.enabledRectangle != Boolean.valueOf(enabledRectangle)) {
                        this.setActiveUnit(ii);
                        urec.enabledRectangle = enabledRectangle;
                        Renderer.setCapability(34037, urec.enabledRectangle);
                    }
                    if (!enabledRectangle) {
                        boolean enabled2D;
                        boolean bl5 = enabled2D = target == 3553;
                        if (urec.enabled2D != Boolean.valueOf(enabled2D)) {
                            this.setActiveUnit(ii);
                            urec.enabled2D = enabled2D;
                            Renderer.setCapability(3553, urec.enabled2D);
                        }
                        if (!enabled2D) {
                            boolean enabled1D;
                            boolean bl6 = enabled1D = target == 3552;
                            if (urec.enabled1D != Boolean.valueOf(enabled1D)) {
                                this.setActiveUnit(ii);
                                urec.enabled1D = enabled1D;
                                Renderer.setCapability(3552, urec.enabled1D);
                            }
                        }
                    }
                }
            }
            urec.unit = unit;
            if (!unitEnabled) continue;
            unit.dirty = false;
            switch (target) {
                case 3552: {
                    if (urec.texture1D == unit.texture) break;
                    this.setActiveUnit(ii);
                    urec.texture1D = unit.texture;
                    GL11.glBindTexture((int)3552, (int)urec.texture1D.getId());
                    ++this._textureChangeCount;
                    break;
                }
                case 3553: {
                    if (urec.texture2D == unit.texture) break;
                    this.setActiveUnit(ii);
                    urec.texture2D = unit.texture;
                    GL11.glBindTexture((int)3553, (int)urec.texture2D.getId());
                    ++this._textureChangeCount;
                    break;
                }
                case 34037: {
                    if (urec.textureRectangle == unit.texture) break;
                    this.setActiveUnit(ii);
                    urec.textureRectangle = unit.texture;
                    GL11.glBindTexture((int)34037, (int)urec.textureRectangle.getId());
                    ++this._textureChangeCount;
                    break;
                }
                case 32879: {
                    if (urec.texture3D == unit.texture) break;
                    this.setActiveUnit(ii);
                    urec.texture3D = unit.texture;
                    GL11.glBindTexture((int)32879, (int)urec.texture3D.getId());
                    ++this._textureChangeCount;
                    break;
                }
                case 34067: {
                    if (urec.textureCubeMap == unit.texture) break;
                    this.setActiveUnit(ii);
                    urec.textureCubeMap = unit.texture;
                    GL11.glBindTexture((int)34067, (int)urec.textureCubeMap.getId());
                    ++this._textureChangeCount;
                }
            }
            if (urec.envMode != unit.envMode) {
                this.setActiveUnit(ii);
                urec.envMode = unit.envMode;
                GL11.glTexEnvi((int)8960, (int)8704, (int)urec.envMode);
            }
            boolean bl7 = combine = unit.envMode == 34160;
            if ((combine || unit.envMode == 3042) && !urec.envColor.equals(unit.envColor)) {
                this.setActiveUnit(ii);
                urec.envColor.set(unit.envColor).get(this._vbuf).rewind();
                GL11.glTexEnv((int)8960, (int)8705, (FloatBuffer)this._vbuf);
            }
            if (combine) {
                if (urec.rgbCombine != unit.rgbCombine) {
                    this.setActiveUnit(ii);
                    urec.rgbCombine = unit.rgbCombine;
                    GL11.glTexEnvi((int)8960, (int)34161, (int)urec.rgbCombine);
                }
                if (urec.alphaCombine != unit.alphaCombine) {
                    this.setActiveUnit(ii);
                    urec.alphaCombine = unit.alphaCombine;
                    GL11.glTexEnvi((int)8960, (int)34162, (int)urec.alphaCombine);
                }
                if (urec.rgbSource0 != unit.rgbSource0) {
                    this.setActiveUnit(ii);
                    urec.rgbSource0 = unit.rgbSource0;
                    GL11.glTexEnvi((int)8960, (int)34176, (int)urec.rgbSource0);
                }
                if (urec.rgbOperand0 != unit.rgbOperand0) {
                    this.setActiveUnit(ii);
                    urec.rgbOperand0 = unit.rgbOperand0;
                    GL11.glTexEnvi((int)8960, (int)34192, (int)urec.rgbOperand0);
                }
                if (unit.rgbCombine != 7681) {
                    if (urec.rgbSource1 != unit.rgbSource1) {
                        this.setActiveUnit(ii);
                        urec.rgbSource1 = unit.rgbSource1;
                        GL11.glTexEnvi((int)8960, (int)34177, (int)urec.rgbSource1);
                    }
                    if (urec.rgbOperand1 != unit.rgbOperand1) {
                        this.setActiveUnit(ii);
                        urec.rgbOperand1 = unit.rgbOperand1;
                        GL11.glTexEnvi((int)8960, (int)34193, (int)urec.rgbOperand1);
                    }
                    if (unit.rgbCombine == 34165) {
                        if (urec.rgbSource2 != unit.rgbSource2) {
                            this.setActiveUnit(ii);
                            urec.rgbSource2 = unit.rgbSource2;
                            GL11.glTexEnvi((int)8960, (int)34178, (int)urec.rgbSource2);
                        }
                        if (urec.rgbOperand2 != unit.rgbOperand2) {
                            this.setActiveUnit(ii);
                            urec.rgbOperand2 = unit.rgbOperand2;
                            GL11.glTexEnvi((int)8960, (int)34194, (int)urec.rgbOperand2);
                        }
                    }
                }
                if (urec.alphaSource0 != unit.alphaSource0) {
                    this.setActiveUnit(ii);
                    urec.alphaSource0 = unit.alphaSource0;
                    GL11.glTexEnvi((int)8960, (int)34184, (int)urec.alphaSource0);
                }
                if (urec.alphaOperand0 != unit.alphaOperand0) {
                    this.setActiveUnit(ii);
                    urec.alphaOperand0 = unit.alphaOperand0;
                    GL11.glTexEnvi((int)8960, (int)34200, (int)urec.alphaOperand0);
                }
                if (unit.alphaCombine != 7681) {
                    if (urec.alphaSource1 != unit.alphaSource1) {
                        this.setActiveUnit(ii);
                        urec.alphaSource1 = unit.alphaSource1;
                        GL11.glTexEnvi((int)8960, (int)34185, (int)urec.alphaSource1);
                    }
                    if (urec.alphaOperand1 != unit.alphaOperand1) {
                        this.setActiveUnit(ii);
                        urec.alphaOperand1 = unit.alphaOperand1;
                        GL11.glTexEnvi((int)8960, (int)34201, (int)urec.alphaOperand1);
                    }
                    if (unit.alphaCombine == 34165) {
                        if (urec.alphaSource2 != unit.alphaSource2) {
                            this.setActiveUnit(ii);
                            urec.alphaSource2 = unit.alphaSource2;
                            GL11.glTexEnvi((int)8960, (int)34186, (int)urec.alphaSource2);
                        }
                        if (urec.alphaOperand2 != unit.alphaOperand2) {
                            this.setActiveUnit(ii);
                            urec.alphaOperand2 = unit.alphaOperand2;
                            GL11.glTexEnvi((int)8960, (int)34202, (int)urec.alphaOperand2);
                        }
                    }
                }
                if (urec.rgbScale != unit.rgbScale) {
                    this.setActiveUnit(ii);
                    urec.rgbScale = unit.rgbScale;
                    GL11.glTexEnvf((int)8960, (int)34163, (float)urec.rgbScale);
                }
                if (urec.alphaScale != unit.alphaScale) {
                    this.setActiveUnit(ii);
                    urec.alphaScale = unit.alphaScale;
                    GL11.glTexEnvf((int)8960, (int)3356, (float)urec.alphaScale);
                }
            }
            if (urec.lodBias != unit.lodBias) {
                this.setActiveUnit(ii);
                urec.lodBias = unit.lodBias;
                GL11.glTexEnvf((int)34048, (int)34049, (float)urec.lodBias);
            }
            boolean bl8 = genEnabledS = unit.genModeS != -1;
            if (urec.genEnabledS != Boolean.valueOf(genEnabledS)) {
                this.setActiveUnit(ii);
                urec.genEnabledS = genEnabledS;
                Renderer.setCapability(3168, urec.genEnabledS);
            }
            if (genEnabledS) {
                if (urec.genModeS != unit.genModeS) {
                    this.setActiveUnit(ii);
                    urec.genModeS = unit.genModeS;
                    GL11.glTexGeni((int)8192, (int)9472, (int)urec.genModeS);
                }
                if (unit.genModeS == 9217) {
                    if (!urec.genPlaneS.equals(unit.genPlaneS)) {
                        this.setActiveUnit(ii);
                        urec.genPlaneS.set(unit.genPlaneS).get(this._vbuf).rewind();
                        GL11.glTexGen((int)8192, (int)9473, (FloatBuffer)this._vbuf);
                    }
                } else if (unit.genModeS == 9216 && !urec.genEyePlaneS.equals(unit.genPlaneS)) {
                    this.setActiveUnit(ii);
                    cleared = this.clearModelviewOrTransposeTransform(cleared, urec.genEyePlaneS.set(unit.genPlaneS), this._vbuf);
                    GL11.glTexGen((int)8192, (int)9474, (FloatBuffer)this._vbuf);
                }
            }
            boolean bl9 = genEnabledT = unit.genModeT != -1;
            if (urec.genEnabledT != Boolean.valueOf(genEnabledT)) {
                this.setActiveUnit(ii);
                urec.genEnabledT = genEnabledT;
                Renderer.setCapability(3169, urec.genEnabledT);
            }
            if (genEnabledT) {
                if (urec.genModeT != unit.genModeT) {
                    this.setActiveUnit(ii);
                    urec.genModeT = unit.genModeT;
                    GL11.glTexGeni((int)8193, (int)9472, (int)urec.genModeT);
                }
                if (unit.genModeT == 9217) {
                    if (!urec.genPlaneT.equals(unit.genPlaneT)) {
                        this.setActiveUnit(ii);
                        urec.genPlaneT.set(unit.genPlaneT).get(this._vbuf).rewind();
                        GL11.glTexGen((int)8193, (int)9473, (FloatBuffer)this._vbuf);
                    }
                } else if (unit.genModeT == 9216 && !urec.genEyePlaneT.equals(unit.genPlaneT)) {
                    this.setActiveUnit(ii);
                    cleared = this.clearModelviewOrTransposeTransform(cleared, urec.genEyePlaneT.set(unit.genPlaneT), this._vbuf);
                    GL11.glTexGen((int)8193, (int)9474, (FloatBuffer)this._vbuf);
                }
            }
            boolean bl10 = genEnabledR = unit.genModeR != -1;
            if (urec.genEnabledR != Boolean.valueOf(genEnabledR)) {
                this.setActiveUnit(ii);
                urec.genEnabledR = genEnabledR;
                Renderer.setCapability(3170, urec.genEnabledR);
            }
            if (genEnabledR) {
                if (urec.genModeR != unit.genModeR) {
                    this.setActiveUnit(ii);
                    urec.genModeR = unit.genModeR;
                    GL11.glTexGeni((int)8194, (int)9472, (int)urec.genModeR);
                }
                if (unit.genModeR == 9217) {
                    if (!urec.genPlaneR.equals(unit.genPlaneR)) {
                        this.setActiveUnit(ii);
                        urec.genPlaneR.set(unit.genPlaneR).get(this._vbuf).rewind();
                        GL11.glTexGen((int)8194, (int)9473, (FloatBuffer)this._vbuf);
                    }
                } else if (unit.genModeR == 9216 && !urec.genEyePlaneR.equals(unit.genPlaneR)) {
                    this.setActiveUnit(ii);
                    cleared = this.clearModelviewOrTransposeTransform(cleared, urec.genEyePlaneR.set(unit.genPlaneR), this._vbuf);
                    GL11.glTexGen((int)8194, (int)9474, (FloatBuffer)this._vbuf);
                }
            }
            boolean bl11 = genEnabledQ = unit.genModeQ != -1;
            if (urec.genEnabledQ != Boolean.valueOf(genEnabledQ)) {
                this.setActiveUnit(ii);
                urec.genEnabledQ = genEnabledQ;
                Renderer.setCapability(3171, urec.genEnabledQ);
            }
            if (genEnabledQ) {
                if (urec.genModeQ != unit.genModeQ) {
                    this.setActiveUnit(ii);
                    urec.genModeQ = unit.genModeQ;
                    GL11.glTexGeni((int)8195, (int)9472, (int)urec.genModeQ);
                }
                if (unit.genModeQ == 9217) {
                    if (!urec.genPlaneQ.equals(unit.genPlaneQ)) {
                        this.setActiveUnit(ii);
                        urec.genPlaneQ.set(unit.genPlaneQ).get(this._vbuf).rewind();
                        GL11.glTexGen((int)8195, (int)9473, (FloatBuffer)this._vbuf);
                    }
                } else if (unit.genModeQ == 9216 && !urec.genEyePlaneQ.equals(unit.genPlaneQ)) {
                    this.setActiveUnit(ii);
                    cleared = this.clearModelviewOrTransposeTransform(cleared, urec.genEyePlaneQ.set(unit.genPlaneQ), this._vbuf);
                    GL11.glTexGen((int)8195, (int)9474, (FloatBuffer)this._vbuf);
                }
            }
            if (urec.transform.equals(unit.transform)) continue;
            this.setActiveUnit(ii);
            this.setMatrixMode(5890);
            this.loadTransformMatrix(urec.transform.set(unit.transform));
        }
        this._unitEnd = numUnits;
        this.maybeRestoreModelview(cleared);
    }

    public void invalidateTextureState() {
        for (TextureUnitRecord urec : this._units) {
            urec.invalidate();
        }
        this._unitEnd = this._units.length;
        this._states[14] = null;
    }

    public void setTransformState(Transform3D modelview) {
        if (!this._modelview.equals(modelview)) {
            this.setMatrixMode(5888);
            this.loadTransformMatrix(this._modelview.set(modelview));
            int type = modelview.getType();
            if (type == 0 || type == 1) {
                this.setNormalize(false, false);
            } else if (type == 2 && GLContext.getCapabilities().GL_EXT_rescale_normal && !RunAnywhere.isMacOS()) {
                this.setNormalize(false, true);
            } else {
                this.setNormalize(true, false);
            }
            this._states[15] = null;
            this._modelviewMatrixValid = false;
        }
    }

    public void invalidateTransformState() {
        this._modelview.setType(-1);
        this._states[15] = null;
        this._modelviewMatrixValid = false;
    }

    public void setMatrixMode(int matrixMode) {
        if (this._matrixMode != matrixMode) {
            this._matrixMode = matrixMode;
            GL11.glMatrixMode((int)this._matrixMode);
        }
    }

    public void render(List<Batch> batches) {
        int size = batches.size();
        for (int ii = 0; ii < size; ++ii) {
            Batch batch = batches.get(ii);
            if (batch.draw(this) || this._colorArray.enabled != Boolean.FALSE) {
                this.invalidateColorState();
            }
            this._primitiveCount += batch.getPrimitiveCount();
        }
        this._batchCount += size;
    }

    protected void setVertexAttribArray(int idx, ClientArray array) {
        if (array.arrayBuffer != null) {
            this.setArrayBuffer(array.arrayBuffer);
            ARBVertexShader.glVertexAttribPointerARB((int)idx, (int)array.size, (int)array.type, (boolean)array.normalized, (int)array.stride, (long)array.offset);
        } else {
            this.setArrayBuffer(null);
            array.floatArray.position((int)array.offset / 4);
            ARBVertexShader.glVertexAttribPointerARB((int)idx, (int)array.size, (boolean)array.normalized, (int)array.stride, (FloatBuffer)array.floatArray);
            array.floatArray.rewind();
        }
    }

    protected void setTexCoordArray(ClientArray array) {
        if (array.arrayBuffer != null) {
            this.setArrayBuffer(array.arrayBuffer);
            GL11.glTexCoordPointer((int)array.size, (int)array.type, (int)array.stride, (long)array.offset);
        } else {
            this.setArrayBuffer(null);
            array.floatArray.position((int)array.offset / 4);
            GL11.glTexCoordPointer((int)array.size, (int)array.stride, (FloatBuffer)array.floatArray);
            array.floatArray.rewind();
        }
    }

    protected void setColorArray(ClientArray array) {
        if (array.arrayBuffer != null) {
            this.setArrayBuffer(array.arrayBuffer);
            GL11.glColorPointer((int)array.size, (int)array.type, (int)array.stride, (long)array.offset);
        } else {
            this.setArrayBuffer(null);
            array.floatArray.position((int)array.offset / 4);
            GL11.glColorPointer((int)array.size, (int)array.stride, (FloatBuffer)array.floatArray);
            array.floatArray.rewind();
        }
    }

    protected void setNormalArray(ClientArray array) {
        if (array.arrayBuffer != null) {
            this.setArrayBuffer(array.arrayBuffer);
            GL11.glNormalPointer((int)array.type, (int)array.stride, (long)array.offset);
        } else {
            this.setArrayBuffer(null);
            array.floatArray.position((int)array.offset / 4);
            GL11.glNormalPointer((int)array.stride, (FloatBuffer)array.floatArray);
            array.floatArray.rewind();
        }
    }

    protected void setVertexArray(ClientArray array) {
        if (array.arrayBuffer != null) {
            this.setArrayBuffer(array.arrayBuffer);
            GL11.glVertexPointer((int)array.size, (int)array.type, (int)array.stride, (long)array.offset);
        } else {
            this.setArrayBuffer(null);
            array.floatArray.position((int)array.offset / 4);
            GL11.glVertexPointer((int)array.size, (int)array.stride, (FloatBuffer)array.floatArray);
            array.floatArray.rewind();
        }
    }

    protected void setArrayBuffer(BufferObject arrayBuffer) {
        if (this._arrayBuffer != arrayBuffer) {
            int id = arrayBuffer == null ? 0 : arrayBuffer.getId();
            ARBBufferObject.glBindBufferARB((int)34962, (int)id);
            this._arrayBuffer = arrayBuffer;
        }
    }

    protected void updateFogEnabled() {
        boolean fogEnabled;
        boolean bl = fogEnabled = this._wouldEnableFog && this._program == null;
        if (this._fogEnabled != Boolean.valueOf(fogEnabled)) {
            this._fogEnabled = fogEnabled;
            Renderer.setCapability(2912, this._fogEnabled);
        }
    }

    protected void loadTransformMatrix(Transform3D transform) {
        float scale;
        Quaternion rotation;
        int type = transform.getType();
        if (type >= 3) {
            transform.getMatrix().get(this._vbuf).rewind();
            GL11.glLoadMatrix((FloatBuffer)this._vbuf);
            return;
        }
        GL11.glLoadIdentity();
        if (type == 0) {
            return;
        }
        Vector3f translation = transform.getTranslation();
        if (!translation.equals(Vector3f.ZERO)) {
            GL11.glTranslatef((float)translation.x, (float)translation.y, (float)translation.z);
        }
        if (!(rotation = transform.getRotation()).equals(Quaternion.IDENTITY)) {
            float w = FloatMath.clamp(rotation.w, -1.0f, 1.0f);
            float angle = 2.0f * FloatMath.acos(w);
            float rsina = 1.0f / FloatMath.sqrt(1.0f - w * w);
            GL11.glRotatef((float)FloatMath.toDegrees(angle), (float)(rotation.x * rsina), (float)(rotation.y * rsina), (float)(rotation.z * rsina));
        }
        if (type == 2 && (scale = transform.getScale()) != 1.0f) {
            GL11.glScalef((float)scale, (float)scale, (float)scale);
        }
    }

    protected boolean clearModelviewOrTransposeTransform(boolean cleared, Vector4f vector, FloatBuffer result) {
        if (this._intel) {
            this.maybeClearModelview(cleared);
            vector.get(result).rewind();
            return true;
        }
        this.transposeTransform(vector, result);
        return false;
    }

    protected boolean maybeClearModelview(boolean cleared) {
        if (!cleared) {
            this.setMatrixMode(5888);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
        }
        return true;
    }

    protected void maybeRestoreModelview(boolean cleared) {
        if (cleared) {
            this.setMatrixMode(5888);
            GL11.glPopMatrix();
        }
    }

    protected void transposeTransform(Vector4f vector, FloatBuffer result) {
        Matrix4f mat = this.getModelviewMatrix();
        result.put(vector.x * mat.m00 + vector.y * mat.m01 + vector.z * mat.m02);
        result.put(vector.x * mat.m10 + vector.y * mat.m11 + vector.z * mat.m12);
        result.put(vector.x * mat.m20 + vector.y * mat.m21 + vector.z * mat.m22);
        result.put(vector.x * mat.m30 + vector.y * mat.m31 + vector.z * mat.m32 + vector.w);
        result.rewind();
    }

    protected Matrix4f getModelviewMatrix() {
        if (!this._modelviewMatrixValid) {
            this._modelview.update(3);
            this._modelviewMatrixValid = true;
        }
        return this._modelview.getMatrix();
    }

    protected void setClientActiveUnit(int unit) {
        if (this._clientActiveUnit != unit) {
            this._clientActiveUnit = unit;
            ARBMultitexture.glClientActiveTextureARB((int)(33984 + this._clientActiveUnit));
        }
    }

    protected void setActiveUnit(int unit) {
        if (this._activeUnit != unit) {
            this._activeUnit = unit;
            ARBMultitexture.glActiveTextureARB((int)(33984 + this._activeUnit));
        }
    }

    protected void setTexture(Texture texture) {
        TextureUnitRecord unit = this._units[this._activeUnit];
        switch (texture.getTarget()) {
            case 3552: {
                if (unit.texture1D == texture) break;
                unit.texture1D = texture;
                GL11.glBindTexture((int)3552, (int)unit.texture1D.getId());
                unit.unit = unit;
                break;
            }
            case 3553: {
                if (unit.texture2D == texture) break;
                unit.texture2D = texture;
                GL11.glBindTexture((int)3553, (int)unit.texture2D.getId());
                unit.unit = unit;
                break;
            }
            case 34037: {
                if (unit.textureRectangle == texture) break;
                unit.textureRectangle = texture;
                GL11.glBindTexture((int)34037, (int)unit.textureRectangle.getId());
                unit.unit = unit;
                break;
            }
            case 32879: {
                if (unit.texture3D == texture) break;
                unit.texture3D = texture;
                GL11.glBindTexture((int)32879, (int)unit.texture3D.getId());
                unit.unit = unit;
                break;
            }
            case 34067: {
                if (unit.textureCubeMap == texture) break;
                unit.textureCubeMap = texture;
                GL11.glBindTexture((int)34067, (int)unit.textureCubeMap.getId());
                unit.unit = unit;
            }
        }
    }

    protected void setBuffers(int drawBuffer, int readBuffer) {
        if (this._drawBuffer != drawBuffer) {
            this._drawBuffer = drawBuffer;
            GL11.glDrawBuffer((int)this._drawBuffer);
        }
        if (this._readBuffer != readBuffer) {
            this._readBuffer = readBuffer;
            GL11.glReadBuffer((int)this._readBuffer);
        }
    }

    protected int getDrawBuffer() {
        return this._drawBuffer;
    }

    protected int getReadBuffer() {
        return this._readBuffer;
    }

    protected void setFramebuffer(Framebuffer framebuffer) {
        if (this._framebuffer != framebuffer) {
            int id = framebuffer == null ? 0 : framebuffer.getId();
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)id);
            this._framebuffer = framebuffer;
        }
    }

    protected Framebuffer getFramebuffer() {
        return this._framebuffer;
    }

    protected void setRenderbuffer(Renderbuffer renderbuffer) {
        if (this._renderbuffer != renderbuffer) {
            int id = renderbuffer == null ? 0 : renderbuffer.getId();
            EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)id);
            this._renderbuffer = renderbuffer;
        }
    }

    protected void bufferObjectCreated() {
        ++this._bufferObjectCount;
    }

    protected void bufferObjectResized(int delta) {
        this._bufferObjectBytes += delta;
    }

    protected void bufferObjectDeleted(int bytes) {
        --this._bufferObjectCount;
        this._bufferObjectBytes -= bytes;
    }

    protected void displayListCreated() {
        ++this._displayListCount;
    }

    protected void displayListDeleted() {
        --this._displayListCount;
    }

    protected void shaderObjectCreated() {
        ++this._shaderObjectCount;
    }

    protected void shaderObjectDeleted() {
        --this._shaderObjectCount;
    }

    protected void textureCreated() {
        ++this._textureCount;
    }

    protected void textureResized(int delta) {
        this._textureBytes += delta;
    }

    protected void textureDeleted(int bytes) {
        --this._textureCount;
        this._textureBytes -= bytes;
    }

    protected synchronized void bufferObjectFinalized(int id, int bytes) {
        this._finalizedBufferObjects = IntListUtil.add((int[])this._finalizedBufferObjects, (int)id);
        this._finalizedBufferObjectBytes += bytes;
    }

    protected synchronized void displayListFinalized(int id) {
        this._finalizedDisplayLists = IntListUtil.add((int[])this._finalizedDisplayLists, (int)id);
    }

    protected synchronized void framebufferFinalized(int id) {
        this._finalizedFramebuffers = IntListUtil.add((int[])this._finalizedFramebuffers, (int)id);
    }

    protected synchronized void pbufferFinalized(Pbuffer pbuffer) {
        this._finalizedPbuffers = ListUtil.add((Object[])this._finalizedPbuffers, (Object)pbuffer);
    }

    protected synchronized void queryFinalized(int id) {
        this._finalizedQueries = IntListUtil.add((int[])this._finalizedQueries, (int)id);
    }

    protected synchronized void renderbufferFinalized(int id) {
        this._finalizedRenderbuffers = IntListUtil.add((int[])this._finalizedRenderbuffers, (int)id);
    }

    protected synchronized void shaderObjectFinalized(int id) {
        this._finalizedShaderObjects = IntListUtil.add((int[])this._finalizedShaderObjects, (int)id);
    }

    protected synchronized void textureFinalized(int id, int bytes) {
        this._finalizedTextures = IntListUtil.add((int[])this._finalizedTextures, (int)id);
        this._finalizedTextureBytes += bytes;
    }

    protected synchronized void deleteFinalizedObjects() {
        int n;
        if (this._finalizedBufferObjects != null) {
            int[] nArray = IntListUtil.compact((int[])this._finalizedBufferObjects);
            IntBuffer idbuf22 = BufferUtils.createIntBuffer((int)nArray.length);
            idbuf22.put(nArray).rewind();
            ARBBufferObject.glDeleteBuffersARB((IntBuffer)idbuf22);
            this._bufferObjectCount -= nArray.length;
            this._bufferObjectBytes -= this._finalizedBufferObjectBytes;
            this._finalizedBufferObjects = null;
            this._finalizedBufferObjectBytes = 0;
        }
        if (this._finalizedDisplayLists != null) {
            int[] nArray = this._finalizedDisplayLists;
            int idbuf22 = nArray.length;
            for (n = 0; n < idbuf22; ++n) {
                int id = nArray[n];
                if (id == 0) continue;
                GL11.glDeleteLists((int)id, (int)1);
                --this._displayListCount;
            }
            this._finalizedDisplayLists = null;
        }
        if (this._finalizedFramebuffers != null) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this._finalizedFramebuffers.length);
            intBuffer.put(this._finalizedFramebuffers).rewind();
            EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)intBuffer);
            this._finalizedFramebuffers = null;
        }
        if (this._finalizedPbuffers != null) {
            Object[] objectArray = this._finalizedPbuffers;
            int idbuf22 = objectArray.length;
            for (n = 0; n < idbuf22; ++n) {
                Object buf = objectArray[n];
                if (buf == null) continue;
                ((Pbuffer)buf).destroy();
            }
            this._finalizedPbuffers = null;
        }
        if (this._finalizedQueries != null) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this._finalizedQueries.length);
            intBuffer.put(this._finalizedQueries).rewind();
            ARBOcclusionQuery.glDeleteQueriesARB((IntBuffer)intBuffer);
            this._finalizedQueries = null;
        }
        if (this._finalizedRenderbuffers != null) {
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)this._finalizedRenderbuffers.length);
            intBuffer.put(this._finalizedRenderbuffers).rewind();
            EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)intBuffer);
            this._finalizedRenderbuffers = null;
        }
        if (this._finalizedShaderObjects != null) {
            for (int id : this._finalizedShaderObjects) {
                if (id == 0) continue;
                ARBShaderObjects.glDeleteObjectARB((int)id);
                --this._shaderObjectCount;
            }
            this._finalizedShaderObjects = null;
        }
        if (this._finalizedTextures != null) {
            int[] nArray = IntListUtil.compact((int[])this._finalizedTextures);
            IntBuffer idbuf = BufferUtils.createIntBuffer((int)nArray.length);
            idbuf.put(nArray).rewind();
            GL11.glDeleteTextures((IntBuffer)idbuf);
            this._textureCount -= nArray.length;
            this._textureBytes -= this._finalizedTextureBytes;
            this._finalizedTextures = null;
            this._finalizedTextureBytes = 0;
        }
    }

    protected static void setCapability(int capability, boolean enable) {
        if (enable) {
            GL11.glEnable((int)capability);
        } else {
            GL11.glDisable((int)capability);
        }
    }

    protected static void setClientCapability(int capability, boolean enable) {
        if (enable) {
            GL11.glEnableClientState((int)capability);
        } else {
            GL11.glDisableClientState((int)capability);
        }
    }

    protected static class TextureUnitRecord
    extends TextureUnit {
        public Boolean enabled1D = false;
        public Texture texture1D;
        public Boolean enabled2D = false;
        public Texture texture2D;
        public Boolean enabledRectangle = false;
        public Texture textureRectangle;
        public Boolean enabled3D = false;
        public Texture texture3D;
        public Boolean enabledCubeMap = false;
        public Texture textureCubeMap;
        public Boolean genEnabledS = false;
        public Vector4f genEyePlaneS = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f);
        public Boolean genEnabledT = false;
        public Vector4f genEyePlaneT = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f);
        public Boolean genEnabledR = false;
        public Vector4f genEyePlaneR = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        public Boolean genEnabledQ = false;
        public Vector4f genEyePlaneQ = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
        public TextureUnit unit;

        public TextureUnitRecord() {
            this.genModeQ = 9216;
            this.genModeR = 9216;
            this.genModeT = 9216;
            this.genModeS = 9216;
            this.transform.setType(-1);
        }

        public void invalidate() {
            this.enabled2D = null;
            this.enabled1D = null;
            this.texture1D = this.texture2D = INVALID_TEXTURE;
            if (GLContext.getCapabilities().GL_ARB_texture_rectangle) {
                this.enabledRectangle = null;
                this.textureRectangle = INVALID_TEXTURE;
            }
            if (GLContext.getCapabilities().OpenGL12) {
                this.enabled3D = null;
                this.texture3D = INVALID_TEXTURE;
            }
            if (GLContext.getCapabilities().GL_ARB_texture_cube_map) {
                this.enabledCubeMap = null;
                this.textureCubeMap = INVALID_TEXTURE;
            }
            if (GLContext.getCapabilities().GL_EXT_texture_lod_bias) {
                this.lodBias = Float.NaN;
            }
            this.genEnabledQ = null;
            this.genEnabledR = null;
            this.genEnabledT = null;
            this.genEnabledS = null;
            this.genEyePlaneQ.x = Float.NaN;
            this.genEyePlaneR.x = Float.NaN;
            this.genEyePlaneT.y = Float.NaN;
            this.genEyePlaneS.x = Float.NaN;
            this.genPlaneQ.x = Float.NaN;
            this.genPlaneR.x = Float.NaN;
            this.genPlaneT.x = Float.NaN;
            this.genPlaneS.x = Float.NaN;
            this.unit = this;
            this.genModeQ = -1;
            this.genModeR = -1;
            this.genModeT = -1;
            this.genModeS = -1;
            this.envMode = -1;
            this.envColor.r = -1.0f;
            this.alphaCombine = -1;
            this.rgbCombine = -1;
            this.rgbSource2 = -1;
            this.rgbSource1 = -1;
            this.rgbSource0 = -1;
            this.alphaSource2 = -1;
            this.alphaSource1 = -1;
            this.alphaSource0 = -1;
            this.rgbOperand2 = -1;
            this.rgbOperand1 = -1;
            this.rgbOperand0 = -1;
            this.alphaOperand2 = -1;
            this.alphaOperand1 = -1;
            this.alphaOperand0 = -1;
            this.alphaScale = Float.NaN;
            this.rgbScale = Float.NaN;
            this.transform.setType(-1);
        }
    }

    protected static class LightRecord
    extends Light {
        public Boolean enabled = false;
        public Light light;

        public LightRecord(int idx) {
            if (idx > 0) {
                this.diffuse.set(0.0f, 0.0f, 0.0f, 0.0f);
                this.specular.set(0.0f, 0.0f, 0.0f, 0.0f);
            }
        }

        public void invalidate() {
            this.enabled = null;
            this.light = this;
            this.specular.r = -1.0f;
            this.diffuse.r = -1.0f;
            this.ambient.r = -1.0f;
            this.position.w = Float.NaN;
            this.spotDirection.x = Float.NaN;
            this.spotCutoff = -1.0f;
            this.spotExponent = -1.0f;
            this.quadraticAttenuation = Float.NaN;
            this.linearAttenuation = Float.NaN;
            this.constantAttenuation = Float.NaN;
        }
    }

    protected static class ClientArrayRecord
    extends ClientArray {
        public Boolean enabled = false;
        public ClientArray array;

        protected ClientArrayRecord() {
        }

        public void invalidate() {
            this.enabled = null;
            this.array = this;
            this.size = -1;
        }
    }

    protected static class ClipPlaneRecord
    extends Plane {
        public Boolean enabled = false;

        protected ClipPlaneRecord() {
        }

        public void invalidate() {
            this.enabled = null;
            this.constant = Float.NaN;
        }
    }

    public static interface Observer {
        public void sizeChanged(int var1, int var2);
    }
}

