/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model.config;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.util.ComparableTuple;
import com.samskivert.util.StringUtil;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.editor.FileConstraints;
import com.threerings.editor.util.EditorContext;
import com.threerings.editor.util.Validator;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Box;
import com.threerings.opengl.Log;
import com.threerings.opengl.effect.config.MetaParticleSystemConfig;
import com.threerings.opengl.effect.config.ParticleSystemConfig;
import com.threerings.opengl.geometry.config.GeometryConfig;
import com.threerings.opengl.gui.config.ComponentBillboardConfig;
import com.threerings.opengl.material.config.GeometryMaterial;
import com.threerings.opengl.material.config.MaterialConfig;
import com.threerings.opengl.model.CollisionMesh;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ArticulatedConfig;
import com.threerings.opengl.model.config.CompoundConfig;
import com.threerings.opengl.model.config.ConditionalConfig;
import com.threerings.opengl.model.config.GeneratedStaticConfig;
import com.threerings.opengl.model.config.InfluenceFlagConfig;
import com.threerings.opengl.model.config.MergedStaticConfig;
import com.threerings.opengl.model.config.ScriptedConfig;
import com.threerings.opengl.model.config.StaticConfig;
import com.threerings.opengl.model.config.StaticSetConfig;
import com.threerings.opengl.model.tools.ModelDef;
import com.threerings.opengl.model.tools.xml.ModelParser;
import com.threerings.opengl.scene.config.SceneInfluencerConfig;
import com.threerings.opengl.scene.config.ViewerAffecterConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.GlContextWrapper;
import com.threerings.opengl.util.Preloadable;
import com.threerings.tudey.config.ActorModelConfig;
import com.threerings.tudey.shape.config.ShapeModelConfig;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.TreeSet;
import proguard.annotation.Keep;

public class ModelConfig
extends ParameterizedConfig {
    public static final String DEFAULT_TAG = "default";
    public static final String SKINNED_TAG = "skinned";
    @Editable
    public Implementation implementation;
    protected ConfigManager _configs = new ConfigManager();
    protected static ModelParser _parser;
    protected static final String DEFAULT_MATERIAL = "Model/Opaque";
    protected static final String DEFAULT_TEXTURE = "2D/File/Default";
    protected static final HashMap<String, String> DEFAULT_MATERIALS;

    public ModelConfig() {
        this.implementation = new StaticConfig();
    }

    public ModelConfig(Implementation impl) {
        this.implementation = impl;
    }

    public Implementation getOriginal() {
        return this.implementation.getOriginal(this._configs);
    }

    public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
        return this.implementation.getModelImplementation(ctx, scope, impl);
    }

    public GeometryConfig getParticleGeometry(GlContext ctx) {
        return this.implementation.getParticleGeometry(ctx);
    }

    public ConfigReference<MaterialConfig> getParticleMaterial(GlContext ctx) {
        return this.implementation.getParticleMaterial(ctx);
    }

    public void preload(GlContext ctx) {
        this.implementation.preload(ctx);
    }

    @Override
    public void init(ConfigManager cfgmgr) {
        this._configs.init("model", cfgmgr);
        super.init(this._configs);
    }

    @Override
    public ConfigManager getConfigManager() {
        return this.implementation.getConfigManager(this._configs);
    }

    @Override
    public void updateFromSource(EditorContext ctx, boolean force) {
        this.implementation.updateFromSource(ctx, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validateReferences(Validator validator) {
        boolean valid = super.validateReferences(validator);
        validator.pushWhere("model.cfgmgr");
        try {
            boolean bl = this._configs.validateReferences(validator) & valid;
            return bl;
        }
        finally {
            validator.popWhere();
        }
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    protected static GlContext createContextWrapper(GlContext ctx, final ModelConfig config) {
        return new GlContextWrapper(ctx){

            @Override
            public ConfigManager getConfigManager() {
                return config.getConfigManager();
            }
        };
    }

    static {
        DEFAULT_MATERIALS = Maps.newHashMap();
        DEFAULT_MATERIALS.put(DEFAULT_TAG, DEFAULT_MATERIAL);
        DEFAULT_MATERIALS.put(SKINNED_TAG, "Model/Skinned/Opaque");
    }

    public static class VisibleMesh
    extends DeepObject
    implements Exportable {
        public String texture = "";
        public String tag = "default";
        public GeometryConfig geometry;

        public VisibleMesh(String texture, String tag, GeometryConfig geometry) {
            this.texture = texture;
            this.tag = tag;
            this.geometry = geometry;
        }

        public VisibleMesh() {
        }
    }

    public static class MeshSet
    extends DeepObject
    implements Exportable {
        public Box bounds;
        public VisibleMesh[] visible;
        public CollisionMesh collision;

        public MeshSet(VisibleMesh[] visible, CollisionMesh collision) {
            this.bounds = new Box();
            this.visible = visible;
            for (VisibleMesh mesh : visible) {
                this.bounds.addLocal(mesh.geometry.getBounds());
            }
            this.collision = collision;
            if (this.collision != null) {
                this.bounds.addLocal(collision.getBounds());
            }
        }

        public MeshSet() {
        }

        public void getTextures(TreeSet<String> textures) {
            for (VisibleMesh mesh : this.visible) {
                textures.add(mesh.texture);
            }
        }

        public void getTextureTagPairs(TreeSet<ComparableTuple<String, String>> pairs) {
            for (VisibleMesh mesh : this.visible) {
                pairs.add((ComparableTuple<String, String>)new ComparableTuple((Comparable)((Object)mesh.texture), (Comparable)((Object)mesh.tag)));
            }
        }
    }

    public static abstract class BaseWrapper
    extends Implementation {
        @Override
        public ConfigManager getConfigManager(ConfigManager cfgmgr) {
            ModelConfig config = this.getModelConfig(cfgmgr);
            return config == null ? cfgmgr : config.getConfigManager();
        }

        @Override
        public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
            ModelConfig config = this.getModelConfig(ctx.getConfigManager());
            return config == null ? null : config.getModelImplementation(ModelConfig.createContextWrapper(ctx, config), scope, impl);
        }

        @Override
        public GeometryConfig getParticleGeometry(GlContext ctx) {
            ModelConfig config = this.getModelConfig(ctx.getConfigManager());
            return config == null ? null : config.getParticleGeometry(ctx);
        }

        @Override
        public ConfigReference<MaterialConfig> getParticleMaterial(GlContext ctx) {
            ModelConfig config = this.getModelConfig(ctx.getConfigManager());
            return config == null ? null : config.getParticleMaterial(ctx);
        }

        protected abstract ModelConfig getModelConfig(ConfigManager var1);
    }

    public static class SchemedModel
    extends DeepObject
    implements Exportable {
        @Editable(editor="config", mode="render_scheme", nullable=true)
        public String scheme;
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;
    }

    public static class Schemed
    extends Implementation {
        @Editable
        public SchemedModel[] models = new SchemedModel[0];

        @Override
        public void preload(GlContext ctx) {
            for (SchemedModel model : this.models) {
                new Preloadable.Model(model.model).preload(ctx);
            }
        }

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            for (SchemedModel smodel : this.models) {
                refs.add(ModelConfig.class, smodel.model);
            }
        }

        @Override
        public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
            ConfigReference<ModelConfig> model = this.getModel(scope);
            ModelConfig config = ctx.getConfigManager().getConfig(ModelConfig.class, model);
            return config == null ? null : config.getModelImplementation(ModelConfig.createContextWrapper(ctx, config), scope, impl);
        }

        protected ConfigReference<ModelConfig> getModel(Scope scope) {
            String scheme = ScopeUtil.resolve(scope, "renderScheme", (String)null);
            for (SchemedModel smodel : this.models) {
                if (!Objects.equal((Object)smodel.scheme, (Object)scheme)) continue;
                return smodel.model;
            }
            return this.models.length > 0 ? this.models[0].model : null;
        }
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<ModelConfig> model;

        @Override
        public Implementation getOriginal(ConfigManager cfgmgr) {
            ModelConfig config = cfgmgr.getConfig(ModelConfig.class, this.model);
            return config == null ? null : config.getOriginal();
        }

        @Override
        public void preload(GlContext ctx) {
            new Preloadable.Model(this.model).preload(ctx);
        }

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(ModelConfig.class, this.model);
        }

        @Override
        public ConfigManager getConfigManager(ConfigManager cfgmgr) {
            ModelConfig config = cfgmgr.getConfig(ModelConfig.class, this.model);
            return config == null ? cfgmgr : config.getConfigManager();
        }

        @Override
        public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
            ModelConfig config = ctx.getConfigManager().getConfig(ModelConfig.class, this.model);
            return config == null ? null : config.getModelImplementation(ModelConfig.createContextWrapper(ctx, config), scope, impl);
        }

        @Override
        public GeometryConfig getParticleGeometry(GlContext ctx) {
            ModelConfig config = ctx.getConfigManager().getConfig(ModelConfig.class, this.model);
            return config == null ? null : config.getParticleGeometry(ctx);
        }

        @Override
        public ConfigReference<MaterialConfig> getParticleMaterial(GlContext ctx) {
            ModelConfig config = ctx.getConfigManager().getConfig(ModelConfig.class, this.model);
            return config == null ? null : config.getParticleMaterial(ctx);
        }
    }

    public static class Imported
    extends Implementation {
        @Editable(min=0.0, step=0.009999999776482582, hgroup="s")
        public float scale = 1.0f;
        @Editable(min=0.0, step=0.01, hgroup="s")
        public float boundsExpansion;
        @Editable(hgroup="i")
        public boolean ignoreRootTransforms;
        @Editable(hgroup="i")
        public boolean generateTangents;
        @Editable
        public InfluenceFlagConfig influences = new InfluenceFlagConfig();
        @Editable(depends={"source"})
        public MaterialMapping[] materialMappings = new MaterialMapping[0];
        protected String _source;
        @DeepOmit
        protected transient boolean _reload;

        @Editable(editor="resource", nullable=true)
        @FileConstraints(description="m.exported_models", extensions={".mxml"}, directory="exported_model_dir")
        public void setSource(String source) {
            this._source = source;
            this._reload = true;
        }

        @Editable
        public String getSource() {
            return this._source;
        }

        @Override
        public void updateFromSource(EditorContext ctx, boolean force) {
            if (!this._reload && !force) {
                return;
            }
            this._reload = false;
            if (this._source == null) {
                this.updateFromSource(null);
                return;
            }
            if (_parser == null) {
                _parser = new ModelParser();
            }
            try {
                this.updateFromSource(_parser.parseModel(ctx.getResourceManager().getResource(this._source)));
                this.createDefaultMaterialMappings();
            }
            catch (Exception e) {
                Log.log.warning((Object)("Error parsing model [source=" + this._source + "]."), new Object[]{e});
            }
        }

        @Override
        public Model.Implementation getModelImplementation(GlContext ctx, Scope scope, Model.Implementation impl) {
            return null;
        }

        @Override
        public GeometryConfig getParticleGeometry(GlContext ctx) {
            VisibleMesh mesh = this.getParticleMesh();
            return mesh == null ? null : mesh.geometry;
        }

        @Override
        public ConfigReference<MaterialConfig> getParticleMaterial(GlContext ctx) {
            VisibleMesh mesh = this.getParticleMesh();
            if (mesh == null) {
                return null;
            }
            MaterialMapping mapping = this.getMaterialMapping(mesh.texture, mesh.tag);
            return mapping == null ? null : mapping.material;
        }

        @Override
        public void preload(GlContext ctx) {
            for (MaterialMapping mapping : this.materialMappings) {
                new Preloadable.Config(MaterialConfig.class, mapping.material).preload(ctx);
            }
        }

        protected VisibleMesh getParticleMesh() {
            return null;
        }

        protected void updateFromSource(ModelDef def) {
        }

        protected void createDefaultMaterialMappings() {
            TreeSet pairs = Sets.newTreeSet();
            this.getTextureTagPairs(pairs);
            ArrayList<MaterialMapping> mappings = new ArrayList<MaterialMapping>();
            Collections.addAll(mappings, this.materialMappings);
            String pref = this._source.substring(0, this._source.lastIndexOf(47) + 1);
            for (ComparableTuple pair : pairs) {
                String texture = (String)pair.left;
                String tag = (String)pair.right;
                if (this.getMaterialMapping(texture, tag) != null) continue;
                mappings.add(new MaterialMapping(texture, tag, StringUtil.isBlank((String)texture) ? null : pref + texture));
            }
            this.materialMappings = mappings.toArray(new MaterialMapping[mappings.size()]);
        }

        protected MaterialMapping getMaterialMapping(String texture, String tag) {
            for (MaterialMapping mapping : this.materialMappings) {
                if (!Objects.equal((Object)texture, (Object)mapping.texture) || !tag.equals(mapping.tag)) continue;
                return mapping;
            }
            return null;
        }

        protected void getTextures(TreeSet<String> textures) {
        }

        protected void getTextureTagPairs(TreeSet<ComparableTuple<String, String>> pairs) {
        }

        protected static GeometryMaterial[] getGeometryMaterials(GlContext ctx, VisibleMesh[] meshes, MaterialMapping[] materialMappings) {
            GeometryMaterial[] gmats = new GeometryMaterial[meshes.length];
            HashMap mmap = Maps.newHashMap();
            for (int ii = 0; ii < gmats.length; ++ii) {
                VisibleMesh mesh = meshes[ii];
                gmats[ii] = new GeometryMaterial(mesh.geometry, Model.getMaterialConfig(ctx, mesh.texture, mesh.tag, materialMappings, mmap));
            }
            return gmats;
        }

        public class MaterialMapping
        extends DeepObject
        implements Exportable {
            @Editable(editor="choice", hgroup="t")
            public String texture = "";
            @Editable(hgroup="t")
            public String tag = "default";
            @Editable(nullable=true)
            public ConfigReference<MaterialConfig> material;

            public MaterialMapping(String texture, String tag, String path) {
                this.texture = texture;
                this.tag = tag;
                String material = DEFAULT_MATERIALS.get(tag);
                this.material = new ConfigReference(material == null ? ModelConfig.DEFAULT_MATERIAL : material, "Texture", new ConfigReference(ModelConfig.DEFAULT_TEXTURE, "File", path, new Object[0]), new Object[0]);
            }

            public MaterialMapping() {
            }

            @Keep
            public String[] getTextureOptions() {
                TreeSet<String> textures = new TreeSet<String>();
                Imported.this.getTextures(textures);
                return textures.toArray(new String[textures.size()]);
            }
        }
    }

    @EditorTypes(value={StaticConfig.class, StaticSetConfig.class, MergedStaticConfig.class, GeneratedStaticConfig.class, ArticulatedConfig.class, ParticleSystemConfig.class, MetaParticleSystemConfig.class, SceneInfluencerConfig.class, ViewerAffecterConfig.class, ComponentBillboardConfig.class, ConditionalConfig.class, CompoundConfig.class, ScriptedConfig.class, ActorModelConfig.Wrapper.class, ShapeModelConfig.class, Derived.class, Schemed.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable,
    Preloadable.LoadableConfig {
        public Implementation getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        public void updateFromSource(EditorContext ctx, boolean force) {
        }

        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public ConfigManager getConfigManager(ConfigManager cfgmgr) {
            return cfgmgr;
        }

        public abstract Model.Implementation getModelImplementation(GlContext var1, Scope var2, Model.Implementation var3);

        public GeometryConfig getParticleGeometry(GlContext ctx) {
            return null;
        }

        public ConfigReference<MaterialConfig> getParticleMaterial(GlContext ctx) {
            return null;
        }

        public void invalidate() {
        }
    }

    public static enum TransientPolicy {
        DEFAULT,
        NEVER,
        FRUSTUM,
        BOUNDS,
        ALWAYS;

    }
}

