/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.google.common.collect.Maps;
import com.samskivert.util.ObserverList;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigUpdateListener;
import com.threerings.expr.Bound;
import com.threerings.expr.Executor;
import com.threerings.expr.Function;
import com.threerings.expr.MutableLong;
import com.threerings.expr.ObjectExpression;
import com.threerings.expr.Scope;
import com.threerings.expr.ScopeEvent;
import com.threerings.expr.Scoped;
import com.threerings.expr.SimpleScope;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Transform3D;
import com.threerings.opengl.model.AnimationObserver;
import com.threerings.opengl.model.Articulated;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.AnimationConfig;
import com.threerings.opengl.util.GlContext;
import java.util.ArrayList;
import java.util.Map;

public class Animation
extends SimpleScope
implements ConfigUpdateListener<AnimationConfig> {
    public static final Animation[] EMPTY_ARRAY = new Animation[0];
    protected GlContext _ctx;
    protected String _name;
    protected AnimationConfig _config;
    protected float _speed = 1.0f;
    protected float _speedModifier = 1.0f;
    protected Implementation _impl = NULL_IMPLEMENTATION;
    protected ObserverList<AnimationObserver> _observers;
    protected long _lastTickTimestamp;
    protected float _lastElapsed;
    @Scoped
    protected MutableLong _epoch = new MutableLong(System.currentTimeMillis());
    protected static StartedOp _startedOp = new StartedOp();
    protected static StoppedOp _stoppedOp = new StoppedOp();
    protected static final Implementation NULL_IMPLEMENTATION = new Implementation(null, null){};

    public Animation(GlContext ctx, Scope parentScope) {
        super(parentScope);
        this._ctx = ctx;
    }

    public void setConfig(String name, String config) {
        this.setConfig(name, this._ctx.getConfigManager().getConfig(AnimationConfig.class, config));
    }

    public void setConfig(String name, ConfigReference<AnimationConfig> ref) {
        this.setConfig(name, this._ctx.getConfigManager().getConfig(AnimationConfig.class, ref));
    }

    public void setConfig(String name, String config, String firstKey, Object firstValue, Object ... otherArgs) {
        this.setConfig(name, this._ctx.getConfigManager().getConfig(AnimationConfig.class, config, firstKey, firstValue, otherArgs));
    }

    public void setConfig(String name, AnimationConfig config) {
        this._name = name;
        if (this._config != null) {
            this._config.removeListener(this);
        }
        if ((this._config = config) != null) {
            this._config.addListener(this);
        }
        this.updateFromConfig();
    }

    public String getName() {
        return this._name;
    }

    public void setSpeed(float speed) {
        this._speed = speed;
    }

    public float getSpeed() {
        return this._speed * this._speedModifier;
    }

    public void setSpeedModifier(float speedModifier) {
        this._speedModifier = speedModifier;
        this._impl.setSpeedModifier(speedModifier);
    }

    @Scoped
    public float getSpeedModifier() {
        return this._speedModifier;
    }

    public void start() {
        this.resetEpoch();
        this._lastTickTimestamp = ScopeUtil.resolveTimestamp((Scope)this, (String)"now").value;
        this._impl.start();
    }

    public void stop() {
        this._impl.stop();
    }

    public void stop(float blendOut) {
        this._impl.stop(blendOut);
    }

    public boolean isPlaying() {
        return this._impl.isPlaying();
    }

    public void addObserver(AnimationObserver observer) {
        if (this._observers == null) {
            this._observers = ObserverList.newFastUnsafe();
        }
        this._observers.add((Object)observer);
    }

    public void removeObserver(AnimationObserver observer) {
        if (this._observers == null) {
            return;
        }
        this._observers.remove((Object)observer);
        if (this._observers.isEmpty()) {
            this._observers = null;
        }
    }

    public int getPriority() {
        return this._impl.getPriority();
    }

    public boolean tick(float elapsed) {
        long nnow = ScopeUtil.resolveTimestamp((Scope)this, (String)"now").value;
        float telapsed = (float)(nnow - this._lastTickTimestamp) / 1000.0f;
        this._lastTickTimestamp = nnow;
        elapsed = this._lastElapsed;
        this._lastElapsed = telapsed;
        return this._impl.tick(elapsed);
    }

    public boolean hasCompleted() {
        return this._impl.hasCompleted();
    }

    public void updateTransforms() {
        this._impl.updateTransforms();
    }

    public void blendTransforms(int update) {
        this._impl.blendTransforms(update);
    }

    public void dumpInfo(String prefix) {
        System.out.println(prefix + (this._config == null ? null : this._config.getReference()));
        this._impl.dumpInfo(prefix);
    }

    @Override
    public void configUpdated(ConfigEvent<AnimationConfig> event) {
        this.updateFromConfig();
    }

    @Override
    public String getScopeName() {
        return "animation";
    }

    @Override
    public void scopeUpdated(ScopeEvent event) {
        super.scopeUpdated(event);
        this.resetEpoch();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._config != null) {
            this._config.removeListener(this);
        }
    }

    public String toString() {
        return this._name;
    }

    protected void updateFromConfig() {
        Implementation nimpl = this._config == null ? null : this._config.getAnimationImplementation(this._ctx, this, this._impl);
        Implementation implementation = nimpl = nimpl == null ? NULL_IMPLEMENTATION : nimpl;
        if (this._impl != nimpl) {
            this._impl.dispose();
            this._impl = nimpl;
        }
    }

    protected void started(float overrideBlendOut) {
        if (this._parentScope instanceof Articulated) {
            ((Articulated)this._parentScope).animationStarted(this, overrideBlendOut);
        }
        Animation.applyStartedOp(this._observers, this);
    }

    protected void stopped(boolean completed) {
        if (this._parentScope instanceof Articulated) {
            ((Articulated)this._parentScope).animationStopped(this, completed);
        }
        Animation.applyStoppedOp(this._observers, this, completed);
    }

    protected void resetEpoch() {
        this._epoch.value = ScopeUtil.resolveTimestamp((Scope)this, (String)"now").value;
    }

    protected static void applyStartedOp(ObserverList<? extends AnimationObserver> observers, Animation animation) {
        if (observers != null) {
            _startedOp.init(animation);
            ObserverList<? extends AnimationObserver> obs = observers;
            obs.apply((ObserverList.ObserverOp)_startedOp);
            _startedOp.clear();
        }
    }

    protected static void applyStoppedOp(ObserverList<? extends AnimationObserver> observers, Animation animation, boolean completed) {
        if (observers != null) {
            _stoppedOp.init(animation, completed);
            ObserverList<? extends AnimationObserver> obs = observers;
            obs.apply((ObserverList.ObserverOp)_stoppedOp);
            _stoppedOp.clear();
        }
    }

    protected static class StoppedOp
    extends AnimationOp {
        protected boolean _completed;

        protected StoppedOp() {
        }

        public void init(Animation animation, boolean completed) {
            this._animation = animation;
            this._completed = completed;
        }

        public boolean apply(AnimationObserver observer) {
            return observer.animationStopped(this._animation, this._completed);
        }
    }

    protected static class StartedOp
    extends AnimationOp {
        protected StartedOp() {
        }

        public void init(Animation animation) {
            this._animation = animation;
        }

        public boolean apply(AnimationObserver observer) {
            return observer.animationStarted(this._animation);
        }
    }

    protected static abstract class AnimationOp
    implements ObserverList.ObserverOp<AnimationObserver> {
        protected Animation _animation;

        protected AnimationOp() {
        }

        public void clear() {
            this._animation = null;
        }
    }

    protected static class FrameExecutor {
        public float frame;
        public Executor executor;

        public FrameExecutor(float frame, Executor executor) {
            this.frame = frame;
            this.executor = executor;
        }
    }

    public static class Sequential
    extends Implementation {
        protected AnimationConfig.Sequential _config;
        protected Animation[] _animations;
        protected int _aidx;

        public Sequential(GlContext ctx, Scope parentScope, AnimationConfig.Sequential config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(AnimationConfig.Sequential config) {
            int ii;
            this._config = config;
            super.setConfig(this._config);
            Animation[] oanims = this._animations;
            this._animations = new Animation[config.animations.length];
            for (ii = 0; ii < this._animations.length; ++ii) {
                Animation anim;
                this._animations[ii] = anim = oanims == null || oanims.length <= ii ? new Animation(this._ctx, this) : oanims[ii];
                AnimationConfig.ComponentAnimation comp = config.animations[ii];
                anim.setConfig(null, comp.animation);
                anim.setSpeed(comp.speed);
                anim.setSpeedModifier(((Animation)this._parentScope).getSpeedModifier());
            }
            if (oanims != null) {
                if (this._aidx >= this._animations.length) {
                    this._aidx = 0;
                }
                for (ii = this._animations.length; ii < oanims.length; ++ii) {
                    oanims[ii].dispose();
                }
            }
        }

        @Override
        public void setSpeedModifier(float speedModifier) {
            for (Animation anim : this._animations) {
                anim.setSpeedModifier(speedModifier);
            }
        }

        @Override
        public void start() {
            this._aidx = 0;
            this._animations[0].start();
            super.start();
        }

        @Override
        public boolean isPlaying() {
            return super.isPlaying() && !this.hasCompleted();
        }

        @Override
        public boolean tick(float elapsed) {
            super.tick(elapsed);
            if (!this.isPlaying()) {
                return false;
            }
            Animation anim = this._animations[this._aidx];
            anim.tick(elapsed);
            if (anim.isPlaying()) {
                return false;
            }
            ++this._aidx;
            int acount = this._animations.length;
            if (this._aidx >= acount) {
                if (this._config.loop) {
                    this._aidx %= acount;
                } else {
                    this._aidx = acount - 1;
                    ((Animation)this._parentScope).stopped(true);
                    return true;
                }
            }
            this._animations[this._aidx].start();
            return false;
        }

        @Override
        public boolean hasCompleted() {
            return this._animations[this._aidx].hasCompleted();
        }

        @Override
        public void updateTransforms() {
            this._animations[this._aidx].updateTransforms();
        }

        @Override
        public void blendTransforms(int update) {
            this._animations[this._aidx].blendTransforms(update);
        }
    }

    public static class Procedural
    extends Implementation {
        protected Map<Articulated.Node, Transform3D> _nodeTrans = Maps.newHashMap();
        protected AnimationConfig.Procedural _config;
        protected TargetTransform[] _transforms;
        protected boolean _counting;
        protected float _countdown;
        protected float _accum;
        protected boolean _completed;
        @Bound(value="epoch")
        protected MutableLong _parentEpoch;
        @Scoped
        protected MutableLong _epoch = new MutableLong(System.currentTimeMillis());

        public Procedural(GlContext ctx, Scope parentScope, AnimationConfig.Procedural config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(AnimationConfig.Procedural config) {
            this._config = config;
            super.setConfig(this._config);
            this.updateFromConfig();
            if (this._config.reset) {
                for (TargetTransform transform : this._transforms) {
                    for (Articulated.Node node : transform.targets) {
                        if (node == null) continue;
                        this._nodeTrans.put(node, new Transform3D(node.getLocalTransform()));
                    }
                }
            }
        }

        @Override
        public void start() {
            this._accum = this._config.offset.getValue();
            this._completed = false;
            if (this._config.duration > 0.0f) {
                float f;
                this._accum %= this._config.duration;
                if (f < 0.0f) {
                    this._accum += this._config.duration;
                }
            }
            if (this._counting = this._config.duration > 0.0f && this._config.blendOut > 0.0f) {
                this._countdown = this._config.duration - this._accum - this._config.blendOut;
            }
            this.resetEpoch();
            super.start();
        }

        @Override
        public void stop(float blendOut) {
            if (this._config.reset) {
                this.restNodeTransform();
            }
            super.stop(blendOut);
        }

        protected void restNodeTransform() {
            for (Map.Entry<Articulated.Node, Transform3D> entry : this._nodeTrans.entrySet()) {
                entry.getKey().getLocalTransform().set(entry.getValue());
            }
        }

        @Override
        public boolean isPlaying() {
            return super.isPlaying() && !this.hasCompleted();
        }

        @Override
        public boolean tick(float elapsed) {
            if (this._counting) {
                float f;
                this._countdown -= elapsed;
                if (f <= 0.0f) {
                    this.blendToWeight(0.0f, this._config.blendOut);
                }
            }
            super.tick(elapsed);
            if (!this.isPlaying()) {
                return false;
            }
            this._accum += elapsed;
            if (this._config.duration > 0.0f && this._accum >= this._config.duration) {
                this._completed = true;
                ((Animation)this._parentScope).stopped(true);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCompleted() {
            return this._completed;
        }

        @Override
        public void updateTransforms() {
            for (TargetTransform transform : this._transforms) {
                transform.update();
            }
        }

        @Override
        public void blendTransforms(int update) {
            for (TargetTransform transform : this._transforms) {
                transform.blend(update, this._weight);
            }
        }

        @Override
        protected void blendToWeight(float weight, float interval) {
            super.blendToWeight(weight, interval);
            if (weight == 0.0f) {
                this._counting = false;
            }
        }

        @Override
        public void scopeUpdated(ScopeEvent event) {
            super.scopeUpdated(event);
            this.resetEpoch();
            this.updateFromConfig();
        }

        protected void updateFromConfig() {
            Function getNode = ScopeUtil.resolve(this._parentScope, "getNode", Function.NULL);
            this._transforms = new TargetTransform[this._config.transforms.length];
            for (int ii = 0; ii < this._transforms.length; ++ii) {
                AnimationConfig.TargetTransform transform = this._config.transforms[ii];
                ArrayList<Articulated.Node> targets = new ArrayList<Articulated.Node>(transform.targets.length);
                for (String target : transform.targets) {
                    Articulated.Node node = (Articulated.Node)getNode.call(target);
                    if (node == null) continue;
                    targets.add(node);
                }
                this._transforms[ii] = new TargetTransform(targets.toArray(new Articulated.Node[targets.size()]), transform.expression.createEvaluator(this));
            }
        }

        protected void resetEpoch() {
            this._epoch.value = this._parentEpoch.value - (long)(this._accum * 1000.0f);
        }

        protected static class TargetTransform {
            public Articulated.Node[] targets;
            public ObjectExpression.Evaluator<Transform3D> evaluator;

            public TargetTransform(Articulated.Node[] targets, ObjectExpression.Evaluator<Transform3D> evaluator) {
                this.targets = targets;
                this.evaluator = evaluator;
            }

            public void update() {
                Transform3D transform = this.evaluator.evaluate();
                for (Articulated.Node target : this.targets) {
                    target.getLocalTransform().set(transform);
                }
            }

            public void blend(int update, float weight) {
                Transform3D transform = this.evaluator.evaluate();
                for (Articulated.Node target : this.targets) {
                    if (target.lastUpdate != update) {
                        target.getLocalTransform().set(transform);
                        target.lastUpdate = update;
                        target.totalWeight = weight;
                        continue;
                    }
                    if (target.totalWeight >= 1.0f) continue;
                    float mweight = Math.min(weight, 1.0f - target.totalWeight);
                    target.getLocalTransform().lerpLocal(transform, mweight / (target.totalWeight += mweight));
                }
            }
        }
    }

    public static class Imported
    extends Implementation {
        protected AnimationConfig.Imported _config;
        protected Articulated.Node[] _targets;
        protected Transform3D[][] _transforms;
        protected Transform3D[] _snapshot;
        protected FrameExecutor[] _executors;
        protected boolean _transitioning;
        protected boolean _counting;
        protected float _countdown;
        protected int _fidx;
        protected float _accum;
        protected int _eidx;
        protected boolean _completed;
        protected Transform3D _xform = new Transform3D();

        public Imported(GlContext ctx, Scope parentScope, AnimationConfig.Imported config) {
            super(ctx, parentScope);
            this.setConfig(config);
        }

        public void setConfig(AnimationConfig.Imported config) {
            int ii;
            this._config = config;
            super.setConfig(this._config);
            this._targets = new Articulated.Node[config.targets.length];
            if (this._snapshot == null || this._snapshot.length != this._targets.length) {
                this._snapshot = new Transform3D[this._targets.length];
            }
            Function getNode = ScopeUtil.resolve(this._parentScope, "getNode", Function.NULL);
            for (ii = 0; ii < this._targets.length; ++ii) {
                this._targets[ii] = (Articulated.Node)getNode.call(config.targets[ii]);
                if (this._targets[ii] == null) {
                    this._snapshot[ii] = null;
                    continue;
                }
                if (this._snapshot[ii] != null) continue;
                this._snapshot[ii] = new Transform3D();
            }
            if (config.modifiers.length == 0) {
                this._transforms = config.transforms;
            } else {
                Transform3D[] nodeDefaults = new Transform3D[this._targets.length];
                for (int ii2 = 0; ii2 < this._targets.length; ++ii2) {
                    nodeDefaults[ii2] = (this._targets[ii2] == null ? new Transform3D() : this._targets[ii2].getConfig().transform).promote(2);
                }
                this._transforms = config.getModifiedTransforms(nodeDefaults);
            }
            this._executors = new FrameExecutor[config.actions.length];
            for (ii = 0; ii < this._executors.length; ++ii) {
                AnimationConfig.FrameAction action = config.actions[ii];
                this._executors[ii] = new FrameExecutor(action.frame, action.action.createExecutor(this._ctx, this));
            }
            if (this._fidx > this._transforms.length) {
                this._fidx = 0;
                this._eidx = 0;
            }
        }

        @Override
        public void start() {
            int offset = Math.round(this._config.offset.getValue() * this.getFrameRate());
            this._fidx = this._eidx = Math.max(0, offset) % this._transforms.length;
            this._accum = 0.0f;
            this._completed = false;
            this._transitioning = this._config.transition > 0.0f;
            if (this._transitioning) {
                for (int ii = 0; ii < this._targets.length; ++ii) {
                    Articulated.Node target = this._targets[ii];
                    if (target == null) continue;
                    this._snapshot[ii].set(target.getLocalTransform());
                }
            }
            if (this._counting = !this._config.loop && this._config.blendOut > 0.0f) {
                float foff = this._fidx == 0 ? 0.0f : (float)this._fidx / this.getFrameRate();
                this._countdown = this._config.getDuration() - foff - this._config.blendOut;
            }
            super.start();
        }

        @Override
        public boolean isPlaying() {
            return super.isPlaying() && !this.hasCompleted();
        }

        @Override
        public boolean tick(float elapsed) {
            if (this._counting) {
                float f;
                this._countdown -= elapsed;
                if (f <= 0.0f) {
                    this.blendToWeight(0.0f, this._config.blendOut);
                }
            }
            super.tick(elapsed);
            if (!this.isPlaying()) {
                return false;
            }
            if (this._transitioning) {
                this._accum += elapsed / this._config.transition;
                if (this._accum < 1.0f) {
                    return false;
                }
                this._accum = (this._accum - 1.0f) * this._config.transition * this.getFrameRate();
                this._transitioning = false;
            } else {
                this._accum += elapsed * this.getFrameRate();
            }
            int frames = (int)this._accum;
            this._accum -= (float)frames;
            this._fidx += frames;
            if (this._fidx < 0) {
                this._fidx = 0;
            }
            this.executeActions();
            int fcount = this._transforms.length;
            if (this._config.loop) {
                if (this._fidx >= fcount) {
                    this._fidx %= fcount;
                    this._eidx = 0;
                    this.executeActions();
                }
            } else if (this._fidx >= fcount - 1) {
                this._fidx = fcount - 1;
                this._accum = 0.0f;
                this._completed = true;
                ((Animation)this._parentScope).stopped(true);
                return true;
            }
            return false;
        }

        @Override
        public boolean hasCompleted() {
            return this._completed;
        }

        @Override
        public void updateTransforms() {
            Transform3D[] t2;
            Transform3D[] t1;
            if (this._transitioning) {
                t1 = this._snapshot;
                t2 = this._transforms[this._fidx];
            } else {
                t1 = this._transforms[this._fidx];
                t2 = this._transforms[(this._fidx + 1) % this._transforms.length];
            }
            for (int ii = 0; ii < this._targets.length; ++ii) {
                Articulated.Node target = this._targets[ii];
                if (target == null) continue;
                t1[ii].lerp(t2[ii], this._accum, target.getLocalTransform());
            }
        }

        @Override
        public void blendTransforms(int update) {
            Transform3D[] t2;
            Transform3D[] t1;
            if (this._transitioning) {
                t1 = this._snapshot;
                t2 = this._transforms[this._fidx];
            } else {
                t1 = this._transforms[this._fidx];
                t2 = this._transforms[(this._fidx + 1) % this._transforms.length];
            }
            for (int ii = 0; ii < this._targets.length; ++ii) {
                Articulated.Node target = this._targets[ii];
                if (target == null) continue;
                if (target.lastUpdate != update) {
                    t1[ii].lerp(t2[ii], this._accum, target.getLocalTransform());
                    target.lastUpdate = update;
                    target.totalWeight = this._weight;
                    continue;
                }
                if (this._weight <= 0.0f || target.totalWeight >= 1.0f) continue;
                float mweight = Math.min(this._weight, 1.0f - target.totalWeight);
                t1[ii].lerp(t2[ii], this._accum, this._xform);
                target.getLocalTransform().lerpLocal(this._xform, mweight / (target.totalWeight += mweight));
            }
        }

        @Override
        protected void blendToWeight(float weight, float interval) {
            super.blendToWeight(weight, interval);
            if (weight == 0.0f) {
                this._counting = false;
            }
        }

        protected float getFrameRate() {
            return this._config.getScaledRate() * ((Animation)this._parentScope).getSpeed();
        }

        protected void executeActions() {
            boolean execute = this.actionsVisible();
            float frame = (float)this._fidx + this._accum;
            while (this._eidx < this._executors.length && this._executors[this._eidx].frame < frame) {
                if (execute) {
                    this._executors[this._eidx].executor.execute();
                }
                ++this._eidx;
            }
        }

        protected boolean actionsVisible() {
            for (Scope scope = this.getParentScope(); scope != null; scope = scope.getParentScope()) {
                if (!(scope instanceof Model) || ((Model)scope).isVisible()) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class Implementation
    extends SimpleScope {
        protected GlContext _ctx;
        protected AnimationConfig.Original _config;
        protected float _weight;
        protected float _targetWeight;
        protected float _weightRate;

        public Implementation(GlContext ctx, Scope parentScope) {
            super(parentScope);
            this._ctx = ctx;
        }

        public void start() {
            this.blendToWeight(this._config.weight, this._config.blendIn);
            ((Animation)this._parentScope).started(this._config.override && this._config.weight == 1.0f ? this._config.blendIn : -1.0f);
        }

        public void stop() {
            this.stop(this._config.blendOut);
        }

        public void stop(float blendOut) {
            this.blendToWeight(0.0f, blendOut);
        }

        public boolean isPlaying() {
            return this._weight > 0.0f || this._targetWeight > 0.0f;
        }

        public int getPriority() {
            return this._config.priority;
        }

        public void setSpeedModifier(float speedModifier) {
        }

        public boolean tick(float elapsed) {
            if (this._weight < this._targetWeight) {
                this._weight = Math.min(this._weight + elapsed * this._weightRate, this._targetWeight);
            } else if (this._weight > this._targetWeight) {
                this._weight = Math.max(this._weight + elapsed * this._weightRate, this._targetWeight);
            }
            if (this._weight == 0.0f && this._targetWeight == 0.0f) {
                ((Animation)this._parentScope).stopped(false);
            }
            return false;
        }

        public boolean hasCompleted() {
            return false;
        }

        public void updateTransforms() {
        }

        public void blendTransforms(int update) {
        }

        public void dumpInfo(String prefix) {
        }

        @Override
        public String getScopeName() {
            return "impl";
        }

        protected void setConfig(AnimationConfig.Original config) {
            this._config = config;
        }

        protected void blendToWeight(float weight, float interval) {
            this._targetWeight = weight;
            if (interval > 0.0f) {
                this._weightRate = (this._targetWeight - this._weight) / interval;
            } else {
                this._weight = this._targetWeight;
            }
        }
    }
}

