/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.material.config;

import com.google.common.collect.Lists;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.Reference;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.ExpressionBinding;
import com.threerings.expr.MutableInteger;
import com.threerings.expr.Scope;
import com.threerings.expr.Updater;
import com.threerings.expr.util.ScopeUtil;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.compositor.config.RenderEffectConfig;
import com.threerings.opengl.compositor.config.RenderQueueConfig;
import com.threerings.opengl.compositor.config.RenderSchemeConfig;
import com.threerings.opengl.geometry.Geometry;
import com.threerings.opengl.geometry.config.DeformerConfig;
import com.threerings.opengl.geometry.config.PassDescriptor;
import com.threerings.opengl.material.config.MaterialRewriter;
import com.threerings.opengl.material.config.PassConfig;
import com.threerings.opengl.renderer.Batch;
import com.threerings.opengl.renderer.CompoundBatch;
import com.threerings.opengl.renderer.SimpleBatch;
import com.threerings.opengl.renderer.config.CoordSpace;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.renderer.state.TransformState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.util.DeepObject;
import com.threerings.util.DeepOmit;
import java.util.ArrayList;
import java.util.List;

public class TechniqueConfig
extends DeepObject
implements Exportable,
Preloadable.LoadableConfig {
    @Editable(nullable=true, hgroup="s")
    @Reference(value=RenderSchemeConfig.class)
    public String scheme;
    @Editable(hgroup="s")
    public boolean receivesProjections;
    @Editable
    public TechniqueDependency[] dependencies = new TechniqueDependency[0];
    @Editable(nullable=true)
    public DeformerConfig deformer;
    @Editable
    public Enqueuer enqueuer = new NormalEnqueuer();
    @DeepOmit
    protected transient RenderSchemeConfig _schemeConfig = RenderSchemeConfig.INVALID;
    @DeepOmit
    protected transient PassDescriptor[] _descriptors;

    @Override
    public void preload(GlContext ctx) {
        for (TechniqueDependency dependency : this.dependencies) {
            dependency.preload(ctx);
        }
        this.enqueuer.preload(ctx);
    }

    @Deprecated
    public void getUpdateReferences(ConfigReferenceSet refs) {
    }

    public TechniqueConfig process(GlContext ctx, boolean fallback) {
        return this.isSupported(ctx, fallback) ? this : null;
    }

    public boolean isSupported(GlContext ctx, boolean fallback) {
        for (TechniqueDependency dependency : this.dependencies) {
            if (dependency.isSupported(ctx, fallback)) continue;
            return false;
        }
        return this.enqueuer.isSupported(ctx, fallback);
    }

    public RenderSchemeConfig getSchemeConfig(GlContext ctx) {
        if (this._schemeConfig == RenderSchemeConfig.INVALID) {
            return this.scheme == null ? null : ctx.getConfigManager().getConfig(RenderSchemeConfig.class, this.scheme);
        }
        return this._schemeConfig;
    }

    public PassDescriptor[] getDescriptors(GlContext ctx) {
        if (this._descriptors == null) {
            ArrayList list = Lists.newArrayList();
            this.enqueuer.getDescriptors(ctx, list);
            this._descriptors = list.toArray(new PassDescriptor[list.size()]);
        }
        return this._descriptors;
    }

    public Compositable createCompositable(GlContext ctx, Scope scope, Geometry geometry) {
        return this.createCompositable(ctx, scope, geometry, ctx.getCompositor().getGroup());
    }

    public Compositable createCompositable(final GlContext ctx, Scope scope, Geometry geometry, RenderQueue.Group group) {
        ArrayList adders = Lists.newArrayList();
        for (TechniqueDependency dependency : this.dependencies) {
            adders.add(dependency.createAdder(ctx, scope));
        }
        final Enqueueable enqueueable = this.enqueuer.createEnqueueable(ctx, scope, geometry, geometry.requiresUpdate(), group, adders, new MutableInteger(0));
        if (adders.isEmpty()) {
            return new Compositable(){

                @Override
                public void composite() {
                    ctx.getCompositor().addEnqueueable(enqueueable);
                }
            };
        }
        final Dependency.Adder[] aarray = adders.toArray(new Dependency.Adder[adders.size()]);
        return new Compositable(){

            @Override
            public void composite() {
                for (Dependency.Adder adder : aarray) {
                    if (adder.add()) continue;
                    return;
                }
                ctx.getCompositor().addEnqueueable(enqueueable);
            }
        };
    }

    public void invalidate() {
        this.enqueuer.invalidate();
        this._schemeConfig = RenderSchemeConfig.INVALID;
        this._descriptors = null;
    }

    public static class StateContainer {
        public RenderState[] states;

        public StateContainer(RenderState[] states) {
            this.states = states;
        }
    }

    public static class EnqueuerWrapper
    extends Enqueuer {
        protected Enqueuer _wrapped;

        public EnqueuerWrapper(Enqueuer wrapped) {
            this._wrapped = wrapped;
        }

        @Override
        public void preload(GlContext ctx) {
            this._wrapped.preload(ctx);
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return this._wrapped.isSupported(ctx, fallback);
        }

        @Override
        public Enqueuer rewrite(MaterialRewriter rewriter) {
            return this._wrapped.rewrite(rewriter);
        }

        @Override
        public void getDescriptors(GlContext ctx, List<PassDescriptor> list) {
            this._wrapped.getDescriptors(ctx, list);
        }

        @Override
        public Enqueueable createEnqueueable(GlContext ctx, Scope scope, Geometry geometry, boolean update, RenderQueue.Group group, List<Dependency.Adder> adders, MutableInteger pidx) {
            return this._wrapped.createEnqueueable(ctx, scope, geometry, update, group, adders, pidx);
        }

        @Override
        public void invalidate() {
            this._wrapped.invalidate();
        }
    }

    public static class GroupedEnqueuer
    extends CompoundEnqueuer {
        @Editable(nullable=true, weight=-1.0, hgroup="q")
        @Reference(value=RenderQueueConfig.class)
        public String queue = "Opaque";
        @Editable(weight=-1.0, hgroup="q")
        public int group;

        @Override
        public Enqueuer rewrite(MaterialRewriter rewriter) {
            return rewriter.rewrite(this);
        }

        @Override
        public Enqueueable createEnqueueable(GlContext ctx, Scope scope, Geometry geometry, boolean update, RenderQueue.Group group, List<Dependency.Adder> adders, MutableInteger pidx) {
            return super.createEnqueueable(ctx, scope, geometry, update, group.getQueue(this.queue).getGroup(this.group), adders, pidx);
        }
    }

    public static class CompoundEnqueuer
    extends Enqueuer {
        @Editable
        public Enqueuer[] enqueuers = new Enqueuer[0];

        @Override
        public void preload(GlContext ctx) {
            for (Enqueuer enqueuer : this.enqueuers) {
                enqueuer.preload(ctx);
            }
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            for (Enqueuer enqueuer : this.enqueuers) {
                if (enqueuer.isSupported(ctx, fallback)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Enqueuer rewrite(MaterialRewriter rewriter) {
            return rewriter.rewrite(this);
        }

        @Override
        public void getDescriptors(GlContext ctx, List<PassDescriptor> list) {
            for (Enqueuer enqueuer : this.enqueuers) {
                enqueuer.getDescriptors(ctx, list);
            }
        }

        @Override
        public Enqueueable createEnqueueable(GlContext ctx, Scope scope, final Geometry geometry, boolean update, RenderQueue.Group group, List<Dependency.Adder> adders, MutableInteger pidx) {
            final Enqueueable[] enqueueables = new Enqueueable[this.enqueuers.length];
            for (int ii = 0; ii < enqueueables.length; ++ii) {
                enqueueables[ii] = this.enqueuers[ii].createEnqueueable(ctx, scope, geometry, false, group, adders, pidx);
            }
            if (update) {
                return new Enqueueable(){

                    @Override
                    public void enqueue() {
                        geometry.update();
                        for (Enqueueable enqueueable : enqueueables) {
                            enqueueable.enqueue();
                        }
                    }
                };
            }
            return new Enqueueable(){

                @Override
                public void enqueue() {
                    for (Enqueueable enqueueable : enqueueables) {
                        enqueueable.enqueue();
                    }
                }
            };
        }

        @Override
        public void invalidate() {
            for (Enqueuer enqueuer : this.enqueuers) {
                enqueuer.invalidate();
            }
        }
    }

    public static class NormalEnqueuer
    extends Enqueuer {
        @Editable(nullable=true, hgroup="q")
        @Reference(value=RenderQueueConfig.class)
        public String queue = "Opaque";
        @Editable(hgroup="q")
        public int priority;
        @Editable
        public PassConfig[] passes = new PassConfig[0];

        @Override
        public void preload(GlContext ctx) {
            for (PassConfig pass : this.passes) {
                pass.preload(ctx);
            }
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            for (PassConfig pass : this.passes) {
                if (pass.isSupported(ctx, fallback)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Enqueuer rewrite(MaterialRewriter rewriter) {
            return rewriter.rewrite(this);
        }

        @Override
        public void getDescriptors(GlContext ctx, List<PassDescriptor> list) {
            for (PassConfig pass : this.passes) {
                list.add(pass.createDescriptor(ctx));
            }
        }

        @Override
        public Enqueueable createEnqueueable(GlContext ctx, Scope scope, final Geometry geometry, boolean update, RenderQueue.Group group, List<Dependency.Adder> adders, MutableInteger pidx) {
            final RenderQueue queue = group.getQueue(this.queue);
            ArrayList updaters = Lists.newArrayList();
            final CompoundBatch batch = this.passes.length == 1 ? this.createBatch(ctx, scope, geometry, this.passes[0], adders, updaters, pidx) : this.createBatch(ctx, scope, geometry, adders, updaters, pidx);
            TransformState transformState = ScopeUtil.resolve(scope, "transformState", TransformState.IDENTITY, TransformState.class);
            final Transform3D modelview = transformState.getModelview();
            final Vector3f center = geometry.getCenter();
            if (update) {
                if (updaters.isEmpty()) {
                    return new Enqueueable(){

                        @Override
                        public void enqueue() {
                            geometry.update();
                            batch.depth = modelview.transformPointZ(center);
                            queue.add(batch, NormalEnqueuer.this.priority);
                        }
                    };
                }
                final Updater[] updaterArray = updaters.toArray(new Updater[updaters.size()]);
                return new Enqueueable(){

                    @Override
                    public void enqueue() {
                        geometry.update();
                        for (Updater updater : updaterArray) {
                            updater.update();
                        }
                        batch.depth = modelview.transformPointZ(center);
                        queue.add(batch, NormalEnqueuer.this.priority);
                    }
                };
            }
            if (updaters.isEmpty()) {
                return new Enqueueable(){

                    @Override
                    public void enqueue() {
                        batch.depth = modelview.transformPointZ(center);
                        queue.add(batch, NormalEnqueuer.this.priority);
                    }
                };
            }
            final Updater[] updaterArray = updaters.toArray(new Updater[updaters.size()]);
            return new Enqueueable(){

                @Override
                public void enqueue() {
                    for (Updater updater : updaterArray) {
                        updater.update();
                    }
                    batch.depth = modelview.transformPointZ(center);
                    queue.add(batch, NormalEnqueuer.this.priority);
                }
            };
        }

        @Override
        public void invalidate() {
            for (PassConfig pass : this.passes) {
                pass.invalidate();
            }
        }

        protected TransformState getTransformState(Batch batch) {
            ArrayList<Batch> batches;
            if (batch instanceof SimpleBatch) {
                TransformState state = (TransformState)((SimpleBatch)batch).getStates()[15];
                if (state != null) {
                    return state;
                }
            } else if (batch instanceof CompoundBatch && !(batches = ((CompoundBatch)batch).getBatches()).isEmpty()) {
                return this.getTransformState((Batch)batches.get(0));
            }
            return TransformState.IDENTITY;
        }

        protected CompoundBatch createBatch(GlContext ctx, Scope scope, Geometry geometry, List<Dependency.Adder> adders, List<Updater> updaters, MutableInteger pidx) {
            CompoundBatch batch = new CompoundBatch();
            for (PassConfig pass : this.passes) {
                SimpleBatch simple = this.createBatch(ctx, scope, geometry, pass, adders, updaters, pidx);
                batch.getBatches().add(simple);
                if (batch.key != null) continue;
                batch.key = simple.key;
            }
            return batch;
        }

        protected SimpleBatch createBatch(GlContext ctx, Scope scope, Geometry geometry, PassConfig pass, List<Dependency.Adder> adders, List<Updater> updaters, MutableInteger pidx) {
            RenderState[] states = pass.createStates(ctx, scope, adders, updaters);
            states[1] = geometry.getArrayState(pidx.value);
            CoordSpace space = geometry.getCoordSpace(pidx.value);
            if (space == CoordSpace.EYE) {
                states[15] = TransformState.IDENTITY;
            } else {
                String name = space == CoordSpace.OBJECT ? "transformState" : "viewTransformState";
                states[15] = ScopeUtil.resolve(scope, name, TransformState.IDENTITY, TransformState.class);
            }
            SimpleBatch.DrawCommand command = geometry.getDrawCommand(pidx.value);
            ++pidx.value;
            StateContainer container = new StateContainer(states);
            for (ExpressionBinding binding : pass.staticBindings) {
                binding.createUpdater(ctx.getConfigManager(), scope, container).update();
            }
            for (ExpressionBinding binding : pass.dynamicBindings) {
                updaters.add(binding.createUpdater(ctx.getConfigManager(), scope, container));
            }
            return new SimpleBatch(states, command);
        }
    }

    @EditorTypes(value={NormalEnqueuer.class, CompoundEnqueuer.class, GroupedEnqueuer.class})
    public static abstract class Enqueuer
    extends DeepObject
    implements Exportable,
    Preloadable.LoadableConfig {
        @Override
        public void preload(GlContext ctx) {
        }

        @Deprecated
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract boolean isSupported(GlContext var1, boolean var2);

        public abstract Enqueuer rewrite(MaterialRewriter var1);

        public abstract void getDescriptors(GlContext var1, List<PassDescriptor> var2);

        public abstract Enqueueable createEnqueueable(GlContext var1, Scope var2, Geometry var3, boolean var4, RenderQueue.Group var5, List<Dependency.Adder> var6, MutableInteger var7);

        public abstract void invalidate();
    }

    public static class SkipColorClearDependency
    extends TechniqueDependency {
        @Override
        public Dependency.Adder createAdder(final GlContext ctx, Scope scope) {
            return new Dependency.Adder(){

                @Override
                public boolean add() {
                    ctx.getCompositor().setSkipColorClear();
                    return true;
                }
            };
        }
    }

    public static class RenderEffectDependency
    extends TechniqueDependency
    implements Preloadable.LoadableConfig {
        @Editable(nullable=true)
        public ConfigReference<RenderEffectConfig> renderEffect;

        @Override
        public void preload(GlContext ctx) {
            new Preloadable.Config(RenderEffectConfig.class, this.renderEffect).preload(ctx);
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            RenderEffectConfig config = ctx.getConfigManager().getConfig(RenderEffectConfig.class, this.renderEffect);
            return config != null && config.getTechnique(ctx, null) != null;
        }

        @Override
        public Dependency.Adder createAdder(final GlContext ctx, Scope scope) {
            final Dependency.RenderEffect dependency = new Dependency.RenderEffect(ctx);
            dependency.config = ctx.getConfigManager().getConfig(RenderEffectConfig.class, this.renderEffect);
            return new Dependency.Adder(){

                @Override
                public boolean add() {
                    ctx.getCompositor().addDependency(dependency);
                    return true;
                }
            };
        }
    }

    public static class StencilRefractionDependency
    extends TechniqueDependency {
        @Editable(step=0.01)
        public float ratio = 1.0f;

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return ctx.getRenderer().getStencilBits() > 0;
        }

        @Override
        public Dependency.Adder createAdder(final GlContext ctx, Scope scope) {
            final Dependency.StencilRefraction dependency = new Dependency.StencilRefraction(ctx);
            dependency.ratio = this.ratio;
            return new Dependency.Adder(){

                @Override
                public boolean add() {
                    ctx.getCompositor().addDependency(dependency);
                    return true;
                }
            };
        }
    }

    public static class StencilReflectionDependency
    extends TechniqueDependency {
        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return ctx.getRenderer().getStencilBits() > 0;
        }

        @Override
        public Dependency.Adder createAdder(final GlContext ctx, Scope scope) {
            final Dependency.StencilReflection dependency = new Dependency.StencilReflection(ctx);
            return new Dependency.Adder(){

                @Override
                public boolean add() {
                    ctx.getCompositor().addDependency(dependency);
                    return true;
                }
            };
        }
    }

    @EditorTypes(value={StencilReflectionDependency.class, StencilRefractionDependency.class, RenderEffectDependency.class, SkipColorClearDependency.class})
    public static abstract class TechniqueDependency
    extends DeepObject
    implements Exportable,
    Preloadable.LoadableConfig {
        public boolean isSupported(GlContext ctx, boolean fallback) {
            return true;
        }

        @Override
        public void preload(GlContext ctx) {
        }

        public abstract Dependency.Adder createAdder(GlContext var1, Scope var2);
    }
}

