/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.effect.tools;

import com.samskivert.swing.GroupLayout;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.threerings.config.ConfigManager;
import com.threerings.config.tools.ConfigEditor;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.export.BinaryExporter;
import com.threerings.export.BinaryImporter;
import com.threerings.export.XMLExporter;
import com.threerings.export.XMLImporter;
import com.threerings.opengl.GlCanvasTool;
import com.threerings.opengl.Log;
import com.threerings.opengl.effect.config.ParticleSystemConfig;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ModelConfig;
import com.threerings.opengl.model.tools.ModelTool;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.state.ColorState;
import com.threerings.opengl.renderer.state.RenderState;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.SimpleTransformable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import org.lwjgl.opengl.GL11;

public class ParticleEditor
extends ModelTool
implements ListSelectionListener,
ChangeListener {
    protected File _initParticles;
    protected JMenuItem _revert;
    protected JCheckBoxMenuItem _autoReset;
    protected JCheckBoxMenuItem _showGround;
    protected JFileChooser _chooser;
    protected JFileChooser _exportChooser;
    protected JPanel _epanel;
    protected JTable _ltable;
    protected JButton _cloneLayer;
    protected JButton _deleteLayer;
    protected EditorPanel _editor;
    protected SimpleTransformable _ground;
    protected File _file;
    protected static Preferences _prefs = Preferences.userNodeForPackage(ParticleEditor.class);

    public static void main(String[] args) {
        new ParticleEditor(args.length > 0 ? args[0] : null).startup();
    }

    public ParticleEditor(String particles) {
        super("particle");
        this._initParticles = particles == null ? null : new File(particles);
        this.updateTitle();
        JMenuBar menubar = new JMenuBar();
        this._frame.setJMenuBar(menubar);
        JMenu file = this.createMenu("file", 70);
        menubar.add(file);
        this.createFileMenuItems(file);
        JMenu edit = this.createMenu("edit", 69);
        menubar.add(edit);
        edit.add(this.createMenuItem("configs", 67, 71));
        edit.add(this.createMenuItem("resources", 82, 85));
        edit.add(this.createMenuItem("preferences", 80, 80));
        JMenu view = this.createMenu("view", 86);
        menubar.add(view);
        this._autoReset = this.createCheckBoxMenuItem("auto_reset", 65, 69);
        view.add(this._autoReset);
        view.addSeparator();
        this._showEnvironment = this.createCheckBoxMenuItem("environment", 69, 86);
        view.add(this._showEnvironment);
        this._showEnvironment.setSelected(true);
        this._showGround = this.createCheckBoxMenuItem("ground", 71, 68);
        view.add(this._showGround);
        this._showGrid = this.createCheckBoxMenuItem("grid", 82, 73);
        view.add(this._showGrid);
        this._showGrid.setSelected(true);
        this._showBounds = this.createCheckBoxMenuItem("bounds", 66, 66);
        view.add(this._showBounds);
        this._showCompass = this.createCheckBoxMenuItem("compass", 79, 77);
        view.add(this._showCompass);
        this._showStats = this.createCheckBoxMenuItem("stats", 83, 84);
        view.add(this._showStats);
        view.addSeparator();
        view.add(this.createMenuItem("refresh", 70, 70));
        view.addSeparator();
        view.add(this.createMenuItem("recenter", 67, 67));
        view.add(this.createMenuItem("reset", 82, 82, 0));
        this._chooser = new JFileChooser(_prefs.get("particle_dir", null));
        this._chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".dat");
            }

            @Override
            public String getDescription() {
                return ParticleEditor.this._msgs.get("m.particle_files");
            }
        });
        this._exportChooser = new JFileChooser(_prefs.get("particle_export_dir", null));
        this._exportChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file != null && (file.isDirectory() || file.toString().toLowerCase().endsWith(".xml"));
            }

            @Override
            public String getDescription() {
                return ParticleEditor.this._msgs.get("m.xml_files");
            }
        });
        this._epanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._epanel.setPreferredSize(new Dimension(350, 1));
        JPanel lpanel = GroupLayout.makeVStretchBox((int)5);
        this._epanel.add((Component)lpanel, GroupLayout.FIXED);
        this._ltable = new JTable(){

            @Override
            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (columnIndex != 1) {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            }
        };
        lpanel.add(new JScrollPane(this._ltable, 20, 31));
        this._ltable.setPreferredScrollableViewportSize(new Dimension(1, 85));
        this._ltable.setSelectionMode(0);
        this._ltable.getColumnModel().getSelectionModel().setSelectionMode(0);
        this._ltable.getSelectionModel().addListSelectionListener(this);
        this._ltable.setDragEnabled(true);
        this._ltable.setCellSelectionEnabled(true);
        this._ltable.getTableHeader().setReorderingAllowed(false);
        this._ltable.getTableHeader().setResizingAllowed(false);
        Component comp = ((DefaultCellEditor)this._ltable.getDefaultEditor(Boolean.class)).getComponent();
        comp.setBackground(Color.white);
        comp.setFocusable(false);
        final DataFlavor lflavor = new DataFlavor(ParticleSystemConfig.Layer.class, null);
        this._ltable.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent comp) {
                return 2;
            }

            @Override
            public boolean canImport(JComponent comp, DataFlavor[] flavors) {
                return ListUtil.containsRef((Object[])flavors, (Object)lflavor);
            }

            @Override
            public boolean importData(JComponent comp, Transferable t) {
                try {
                    int row = (Integer)t.getTransferData(lflavor);
                    ((LayerTableModel)ParticleEditor.this._ltable.getModel()).moveLayer(row);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                final int row = ParticleEditor.this._ltable.getSelectedRow();
                return new Transferable(){

                    @Override
                    public Object getTransferData(DataFlavor flavor) {
                        return row;
                    }

                    @Override
                    public DataFlavor[] getTransferDataFlavors() {
                        return new DataFlavor[]{lflavor};
                    }

                    @Override
                    public boolean isDataFlavorSupported(DataFlavor flavor) {
                        return flavor == lflavor;
                    }
                };
            }
        });
        JPanel bpanel = new JPanel();
        lpanel.add((Component)bpanel, GroupLayout.FIXED);
        bpanel.add(this.createButton("new_layer", "m.new"));
        this._cloneLayer = this.createButton("clone_layer", "m.copy");
        bpanel.add(this._cloneLayer);
        this._cloneLayer.setEnabled(false);
        this._deleteLayer = this.createButton("delete_layer", "m.delete");
        bpanel.add(this._deleteLayer);
        this._deleteLayer.setEnabled(false);
        JPanel ipanel = GroupLayout.makeVStretchBox((int)5);
        this._epanel.add(ipanel);
        this._editor = new EditorPanel(this, EditorPanel.CategoryMode.CHOOSER, null, true);
        ipanel.add((Component)((Object)this._editor));
        this._editor.addChangeListener(this);
        this._editor.setVisible(false);
        bpanel = new JPanel();
        this._epanel.add((Component)bpanel, GroupLayout.FIXED);
        bpanel.add(this.createButton("reset"));
    }

    @Override
    public ConfigManager getConfigManager() {
        return this._model != null ? this._model.getConfig().getConfigManager() : super.getConfigManager();
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        int idx = this._ltable.getSelectedRow();
        boolean enabled = idx != -1;
        this._cloneLayer.setEnabled(enabled);
        this._deleteLayer.setEnabled(enabled);
        this._editor.setVisible(enabled);
        if (enabled) {
            this._editor.setObject(this.getLayers()[idx]);
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this._model.getConfig().wasUpdated();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        if (action.equals("new")) {
            this.newParticles();
        } else if (action.equals("open")) {
            this.open();
        } else if (action.equals("save")) {
            if (this._file != null) {
                this.save(this._file);
            } else {
                this.save();
            }
        } else if (action.equals("save_as")) {
            this.save();
        } else if (action.equals("revert")) {
            if (this.showCantUndo()) {
                this.open(this._file);
            }
        } else if (action.equals("import")) {
            this.importParticles();
        } else if (action.equals("export")) {
            this.exportParticles();
        } else if (action.equals("import_layers")) {
            this.importLayers();
        } else if (action.equals("configs")) {
            new ConfigEditor(this._msgmgr, this._model.getConfig().getConfigManager(), this._colorpos).setVisible(true);
        } else if (action.equals("new_layer")) {
            ((LayerTableModel)this._ltable.getModel()).newLayer();
        } else if (action.equals("clone_layer")) {
            ((LayerTableModel)this._ltable.getModel()).cloneLayer();
        } else if (action.equals("delete_layer")) {
            ((LayerTableModel)this._ltable.getModel()).deleteLayer();
        } else {
            super.actionPerformed(event);
        }
    }

    protected void createFileMenuItems(JMenu file) {
        file.add(this.createMenuItem("new", 78, 78));
        file.add(this.createMenuItem("open", 79, 79));
        file.addSeparator();
        file.add(this.createMenuItem("save", 83, 83));
        file.add(this.createMenuItem("save_as", 65, 65));
        this._revert = this.createMenuItem("revert", 82, 82);
        file.add(this._revert);
        this._revert.setEnabled(false);
        file.addSeparator();
        file.add(this.createMenuItem("import", 73, -1));
        file.add(this.createMenuItem("export", 69, -1));
        file.addSeparator();
        file.add(this.createMenuItem("import_layers", 76, 76));
        file.addSeparator();
        file.add(this.createMenuItem("quit", 81, 81));
    }

    @Override
    protected JComponent createCanvasContainer() {
        this._epanel = GroupLayout.makeVStretchBox((int)5);
        JSplitPane pane = new JSplitPane(1, true, this._canvas, this._epanel);
        this._canvas.setMinimumSize(new Dimension(1, 1));
        pane.setResizeWeight(1.0);
        pane.setOneTouchExpandable(true);
        return pane;
    }

    @Override
    protected GlCanvasTool.CanvasToolPrefs createEditablePrefs() {
        return new ModelTool.ModelToolPrefs(this, _prefs);
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._ground = new SimpleTransformable(this){

            @Override
            protected RenderState[] createStates() {
                RenderState[] states = super.createStates();
                states[2] = new ColorState(new Color4f(0.4f, 0.4f, 0.4f, 1.0f));
                return states;
            }

            @Override
            protected void draw() {
                GL11.glBegin((int)7);
                GL11.glVertex3f((float)-32.0f, (float)-32.0f, (float)-0.01f);
                GL11.glVertex3f((float)32.0f, (float)-32.0f, (float)-0.01f);
                GL11.glVertex3f((float)32.0f, (float)32.0f, (float)-0.01f);
                GL11.glVertex3f((float)-32.0f, (float)32.0f, (float)-0.01f);
                GL11.glEnd();
            }
        };
        ModelConfig config = new ModelConfig();
        config.implementation = new ParticleSystemConfig();
        config.init(this._cfgmgr);
        this._model = new Model((GlContext)this, config);
        this._scene.add(this._model);
        this._ltable.setModel(new LayerTableModel());
        this._ltable.getColumnModel().getColumn(1).setMaxWidth(60);
        if (this._initParticles != null) {
            this.open(this._initParticles);
        }
    }

    @Override
    protected void updateView(float elapsed) {
        super.updateView(elapsed);
        if (this._autoReset.isSelected() && this._model.hasCompleted()) {
            this._model.reset();
        }
    }

    @Override
    protected void compositeView() {
        super.compositeView();
        if (this._showGround.isSelected()) {
            this._ground.composite();
        }
    }

    protected void newParticles() {
        ModelConfig config = new ModelConfig();
        config.implementation = new ParticleSystemConfig();
        this.setConfig(config, null);
    }

    protected void open() {
        if (this._chooser.showOpenDialog(this._frame) == 0) {
            this.open(this._chooser.getSelectedFile());
        }
        _prefs.put("particle_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void open(File file) {
        try {
            BinaryImporter in = new BinaryImporter(new FileInputStream(file));
            this.setConfig((ModelConfig)in.readObject(), file);
            in.close();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to open particles.", new Object[]{"file", file, e});
        }
    }

    protected void save() {
        if (this._chooser.showSaveDialog(this._frame) == 0) {
            this.save(this._chooser.getSelectedFile());
        }
        _prefs.put("particle_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void save(File file) {
        try {
            BinaryExporter out = new BinaryExporter(new FileOutputStream(file));
            out.writeObject(this._model.getConfig());
            out.close();
            this.setFile(file);
        }
        catch (IOException e) {
            Log.log.warning((Object)"Failed to save particles.", new Object[]{"file", file, e});
        }
    }

    protected void importParticles() {
        if (this._exportChooser.showOpenDialog(this._frame) == 0) {
            File file = this._exportChooser.getSelectedFile();
            try {
                XMLImporter in = new XMLImporter(new FileInputStream(file));
                this.setConfig((ModelConfig)in.readObject(), null);
                in.close();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to import particles.", new Object[]{"file", file, e});
            }
        }
        _prefs.put("particle_export_dir", this._exportChooser.getCurrentDirectory().toString());
    }

    protected void exportParticles() {
        if (this._exportChooser.showSaveDialog(this._frame) == 0) {
            File file = this._exportChooser.getSelectedFile();
            try {
                XMLExporter out = new XMLExporter(new FileOutputStream(file));
                out.writeObject(this._model.getConfig());
                out.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)"Failed to export particles.", new Object[]{"file", file, e});
            }
        }
        _prefs.put("particle_export_dir", this._exportChooser.getCurrentDirectory().toString());
    }

    protected void importLayers() {
        if (this._chooser.showOpenDialog(this._frame) == 0) {
            File file = this._chooser.getSelectedFile();
            try {
                BinaryImporter in = new BinaryImporter(new FileInputStream(file));
                ModelConfig config = (ModelConfig)in.readObject();
                ((LayerTableModel)this._ltable.getModel()).insertLayers(((ParticleSystemConfig)config.implementation).layers);
                in.close();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to import layers.", new Object[]{"file", file, e});
            }
        }
        _prefs.put("particle_dir", this._chooser.getCurrentDirectory().toString());
    }

    protected void setConfig(ModelConfig config, File file) {
        if (!(config.implementation instanceof ParticleSystemConfig)) {
            throw new ClassCastException(config.getClass().getName());
        }
        config.init(this._cfgmgr);
        this._model.setConfig(config);
        ((LayerTableModel)this._ltable.getModel()).fireTableDataChanged();
        this.setFile(file);
    }

    protected void setFile(File file) {
        this._file = file;
        this._revert.setEnabled(file != null);
        this.updateTitle();
    }

    protected void updateTitle() {
        String title = this._msgs.get("m.title");
        if (this._file != null) {
            title = title + ": " + this._file;
        }
        this._frame.setTitle(title);
    }

    protected void setLayers(ParticleSystemConfig.Layer[] layers) {
        this.getParticleSystemConfig().layers = layers;
        this._model.getConfig().wasUpdated();
    }

    protected ParticleSystemConfig.Layer[] getLayers() {
        return this.getParticleSystemConfig().layers;
    }

    public ParticleSystemConfig getParticleSystemConfig() {
        return (ParticleSystemConfig)this._model.getConfig().implementation;
    }

    protected boolean showCantUndo() {
        return JOptionPane.showConfirmDialog(this._frame, this._msgs.get("m.cant_undo"), this._msgs.get("t.cant_undo"), 2, 2) == 0;
    }

    @Override
    public Root getRoot() {
        return null;
    }

    protected class LayerTableModel
    extends AbstractTableModel {
        protected LayerTableModel() {
        }

        public void newLayer() {
            Object[] olayers = ParticleEditor.this.getLayers();
            int max = 0;
            String prefix = ParticleEditor.this._msgs.get("m.layer");
            for (ParticleSystemConfig.Layer layer : olayers) {
                String name = layer.name;
                if (!name.startsWith(prefix)) continue;
                try {
                    max = Math.max(max, Integer.parseInt(name.substring(prefix.length()).trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ParticleSystemConfig.Layer nlayer = new ParticleSystemConfig.Layer();
            nlayer.name = prefix + " " + (max + 1);
            ParticleEditor.this.setLayers((ParticleSystemConfig.Layer[])ArrayUtil.append((Object[])olayers, (Object)nlayer));
            this.fireTableRowsInserted(olayers.length, olayers.length);
            ParticleEditor.this._ltable.changeSelection(olayers.length, 0, false, false);
        }

        public void insertLayers(ParticleSystemConfig.Layer[] nlayers) {
            if (nlayers.length == 0) {
                return;
            }
            Object[] olayers = ParticleEditor.this.getLayers();
            ParticleEditor.this.setLayers((ParticleSystemConfig.Layer[])ArrayUtil.concatenate((Object[])olayers, (Object[])nlayers));
            this.fireTableRowsInserted(olayers.length, olayers.length + nlayers.length - 1);
            ParticleEditor.this._ltable.changeSelection(olayers.length, 0, false, false);
        }

        public void cloneLayer() {
            int idx = ParticleEditor.this._ltable.getSelectedRow();
            Object[] olayers = ParticleEditor.this.getLayers();
            ParticleSystemConfig.Layer nlayer = (ParticleSystemConfig.Layer)olayers[idx].clone();
            nlayer.name = nlayer.name + " " + ParticleEditor.this._msgs.get("m.clone");
            ParticleEditor.this.setLayers((ParticleSystemConfig.Layer[])ArrayUtil.insert((Object[])olayers, (Object)nlayer, (int)(++idx)));
            this.fireTableRowsInserted(idx, idx);
            ParticleEditor.this._ltable.changeSelection(idx, 0, false, false);
        }

        public void deleteLayer() {
            int idx = ParticleEditor.this._ltable.getSelectedRow();
            ParticleSystemConfig.Layer[] layers = (ParticleSystemConfig.Layer[])ArrayUtil.splice((Object[])ParticleEditor.this.getLayers(), (int)idx, (int)1);
            ParticleEditor.this.setLayers(layers);
            this.fireTableRowsDeleted(idx, idx);
            if (idx < layers.length) {
                ParticleEditor.this._ltable.changeSelection(idx, 0, false, false);
            } else if (layers.length > 0) {
                ParticleEditor.this._ltable.changeSelection(layers.length - 1, 0, false, false);
            }
        }

        public void moveLayer(int fromIdx) {
            int toIdx = ParticleEditor.this._ltable.getSelectedRow();
            if (fromIdx == toIdx) {
                return;
            }
            ParticleSystemConfig.Layer[] layers = ParticleEditor.this.getLayers();
            ParticleSystemConfig.Layer layer = layers[fromIdx];
            if (toIdx < fromIdx) {
                System.arraycopy(layers, toIdx, layers, toIdx + 1, fromIdx - toIdx);
            } else {
                System.arraycopy(layers, fromIdx + 1, layers, fromIdx, toIdx - fromIdx);
            }
            layers[toIdx] = layer;
            ParticleEditor.this._model.getConfig().wasUpdated();
            this.fireTableRowsUpdated(Math.min(fromIdx, toIdx), Math.max(fromIdx, toIdx));
            ParticleEditor.this._editor.setObject(layer);
        }

        @Override
        public int getRowCount() {
            return ParticleEditor.this.getLayers().length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int row, int column) {
            ParticleSystemConfig.Layer layer = ParticleEditor.this.getLayers()[row];
            return column == 0 ? layer.name : Boolean.valueOf(layer.visible);
        }

        @Override
        public String getColumnName(int column) {
            return ParticleEditor.this._msgs.get(column == 0 ? "m.layer" : "m.visible");
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return column == 0 ? String.class : Boolean.class;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            ParticleSystemConfig.Layer layer = ParticleEditor.this.getLayers()[row];
            if (column == 0) {
                layer.name = (String)value;
            } else {
                layer.visible = (Boolean)value;
            }
            ParticleEditor.this._model.getConfig().wasUpdated();
        }
    }
}

