/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.math;

import com.samskivert.util.StringUtil;
import com.threerings.export.Encodable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.math.Plane;
import com.threerings.math.Quaternion;
import com.threerings.math.SingularMatrixException;
import com.threerings.math.Vector3f;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.FloatBuffer;

public final class Matrix4f
implements Encodable,
Streamable {
    public static final Matrix4f IDENTITY = new Matrix4f();
    public static final Matrix4f[] EMPTY_ARRAY = new Matrix4f[0];
    public float m00;
    public float m10;
    public float m20;
    public float m30;
    public float m01;
    public float m11;
    public float m21;
    public float m31;
    public float m02;
    public float m12;
    public float m22;
    public float m32;
    public float m03;
    public float m13;
    public float m23;
    public float m33;

    public Matrix4f(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32, float m03, float m13, float m23, float m33) {
        this.set(m00, m10, m20, m30, m01, m11, m21, m31, m02, m12, m22, m32, m03, m13, m23, m33);
    }

    public Matrix4f(float[] values) {
        this.set(values);
    }

    public Matrix4f(FloatBuffer buf) {
        this.set(buf);
    }

    public Matrix4f(Matrix4f other) {
        this.set(other);
    }

    public Matrix4f() {
        this.setToIdentity();
    }

    public Matrix4f setToIdentity() {
        return this.set(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToTransform(Vector3f translation, Quaternion rotation) {
        return this.setToRotation(rotation).setTranslation(translation);
    }

    public Matrix4f setToTransform(Vector3f translation, Quaternion rotation, float scale) {
        return this.setToRotation(rotation).set(this.m00 * scale, this.m10 * scale, this.m20 * scale, translation.x, this.m01 * scale, this.m11 * scale, this.m21 * scale, translation.y, this.m02 * scale, this.m12 * scale, this.m22 * scale, translation.z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToTransform(Vector3f translation, Quaternion rotation, Vector3f scale) {
        return this.setToRotation(rotation).set(this.m00 * scale.x, this.m10 * scale.y, this.m20 * scale.z, translation.x, this.m01 * scale.x, this.m11 * scale.y, this.m21 * scale.z, translation.y, this.m02 * scale.x, this.m12 * scale.y, this.m22 * scale.z, translation.z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToTranslation(Vector3f translation) {
        return this.setToTranslation(translation.x, translation.y, translation.z);
    }

    public Matrix4f setToTranslation(float x, float y, float z) {
        return this.set(1.0f, 0.0f, 0.0f, x, 0.0f, 1.0f, 0.0f, y, 0.0f, 0.0f, 1.0f, z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setTranslation(Vector3f translation) {
        return this.setTranslation(translation.x, translation.y, translation.z);
    }

    public Matrix4f setTranslation(float x, float y, float z) {
        this.m30 = x;
        this.m31 = y;
        this.m32 = z;
        return this;
    }

    public Matrix4f setToRotation(Vector3f from, Vector3f to) {
        float angle = from.angle(to);
        if (angle < 1.0E-6f) {
            return this.setToIdentity();
        }
        if (angle <= 3.1415918f) {
            return this.setToRotation(angle, from.cross(to).normalizeLocal());
        }
        Vector3f axis = new Vector3f(0.0f, from.z, -from.y);
        float length = axis.length();
        return this.setToRotation((float)Math.PI, length < 1.0E-6f ? axis.set(-from.z, 0.0f, from.x).normalizeLocal() : axis.multLocal(1.0f / length));
    }

    public Matrix4f setToRotation(float angle, Vector3f axis) {
        return this.setToRotation(angle, axis.x, axis.y, axis.z);
    }

    public Matrix4f setToRotation(float angle, float x, float y, float z) {
        float c = FloatMath.cos(angle);
        float s = FloatMath.sin(angle);
        float omc = 1.0f - c;
        float xs = x * s;
        float ys = y * s;
        float zs = z * s;
        float xy = x * y;
        float xz = x * z;
        float yz = y * z;
        return this.set(x * x * omc + c, xy * omc - zs, xz * omc + ys, 0.0f, xy * omc + zs, y * y * omc + c, yz * omc - xs, 0.0f, xz * omc - ys, yz * omc + xs, z * z * omc + c, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToRotation(Quaternion quat) {
        float xx = quat.x * quat.x;
        float yy = quat.y * quat.y;
        float zz = quat.z * quat.z;
        float xy = quat.x * quat.y;
        float xz = quat.x * quat.z;
        float xw = quat.x * quat.w;
        float yz = quat.y * quat.z;
        float yw = quat.y * quat.w;
        float zw = quat.z * quat.w;
        return this.set(1.0f - 2.0f * (yy + zz), 2.0f * (xy - zw), 2.0f * (xz + yw), 0.0f, 2.0f * (xy + zw), 1.0f - 2.0f * (xx + zz), 2.0f * (yz - xw), 0.0f, 2.0f * (xz - yw), 2.0f * (yz + xw), 1.0f - 2.0f * (xx + yy), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToScale(Vector3f scale) {
        return this.setToScale(scale.x, scale.y, scale.z);
    }

    public Matrix4f setToScale(float s) {
        return this.setToScale(s, s, s);
    }

    public Matrix4f setToScale(float x, float y, float z) {
        return this.set(x, 0.0f, 0.0f, 0.0f, 0.0f, y, 0.0f, 0.0f, 0.0f, 0.0f, z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToReflection(Vector3f normal) {
        return this.setToReflection(normal.x, normal.y, normal.z);
    }

    public Matrix4f setToReflection(float x, float y, float z) {
        float x2 = -2.0f * x;
        float y2 = -2.0f * y;
        float z2 = -2.0f * z;
        float xy2 = x2 * y;
        float xz2 = x2 * z;
        float yz2 = y2 * z;
        return this.set(1.0f + x2 * x, xy2, xz2, 0.0f, xy2, 1.0f + y2 * y, yz2, 0.0f, xz2, yz2, 1.0f + z2 * z, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToReflection(Plane plane) {
        return this.setToReflection(plane.getNormal(), plane.constant);
    }

    public Matrix4f setToReflection(Vector3f normal, float constant) {
        return this.setToReflection(normal.x, normal.y, normal.z, constant);
    }

    public Matrix4f setToReflection(float x, float y, float z, float w) {
        float x2 = -2.0f * x;
        float y2 = -2.0f * y;
        float z2 = -2.0f * z;
        float xy2 = x2 * y;
        float xz2 = x2 * z;
        float yz2 = y2 * z;
        float x2y2z2 = x * x + y * y + z * z;
        return this.set(1.0f + x2 * x, xy2, xz2, x2 * w * x2y2z2, xy2, 1.0f + y2 * y, yz2, y2 * w * x2y2z2, xz2, yz2, 1.0f + z2 * z, z2 * w * x2y2z2, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToSkew(Plane plane, Vector3f amount) {
        return this.setToSkew(plane.getNormal(), plane.constant, amount);
    }

    public Matrix4f setToSkew(Vector3f normal, float constant, Vector3f amount) {
        return this.setToSkew(normal.x, normal.y, normal.z, constant, amount.x, amount.y, amount.z);
    }

    public Matrix4f setToSkew(float a, float b, float c, float d, float x, float y, float z) {
        return this.set(1.0f + a * x, b * x, c * x, d * x, a * y, 1.0f + b * y, c * y, d * y, a * z, b * z, 1.0f + c * z, d * z, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f setToPerspective(float fovy, float aspect, float near, float far) {
        float f = 1.0f / FloatMath.tan(fovy / 2.0f);
        float dscale = 1.0f / (near - far);
        return this.set(f / aspect, 0.0f, 0.0f, 0.0f, 0.0f, f, 0.0f, 0.0f, 0.0f, 0.0f, (far + near) * dscale, 2.0f * far * near * dscale, 0.0f, 0.0f, -1.0f, 0.0f);
    }

    public Matrix4f setToFrustum(float left, float right, float bottom, float top, float near, float far) {
        return this.setToFrustum(left, right, bottom, top, near, far, Vector3f.UNIT_Z);
    }

    public Matrix4f setToFrustum(float left, float right, float bottom, float top, float near, float far, Vector3f nearFarNormal) {
        float rrl = 1.0f / (right - left);
        float rtb = 1.0f / (top - bottom);
        float rnf = 1.0f / (near - far);
        float n2 = 2.0f * near;
        float s = (far + near) / (near * nearFarNormal.z - far * nearFarNormal.z);
        return this.set(n2 * rrl, 0.0f, (right + left) * rrl, 0.0f, 0.0f, n2 * rtb, (top + bottom) * rtb, 0.0f, s * nearFarNormal.x, s * nearFarNormal.y, (far + near) * rnf, n2 * far * rnf, 0.0f, 0.0f, -1.0f, 0.0f);
    }

    public Matrix4f setToOrtho(float left, float right, float bottom, float top, float near, float far) {
        return this.setToOrtho(left, right, bottom, top, near, far, Vector3f.UNIT_Z);
    }

    public Matrix4f setToOrtho(float left, float right, float bottom, float top, float near, float far, Vector3f nearFarNormal) {
        float rlr = 1.0f / (left - right);
        float rbt = 1.0f / (bottom - top);
        float rnf = 1.0f / (near - far);
        float s = 2.0f / (near * nearFarNormal.z - far * nearFarNormal.z);
        return this.set(-2.0f * rlr, 0.0f, 0.0f, (right + left) * rlr, 0.0f, -2.0f * rbt, 0.0f, (top + bottom) * rbt, s * nearFarNormal.x, s * nearFarNormal.y, 2.0f * rnf, (far + near) * rnf, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f transposeLocal() {
        return this.transpose(this);
    }

    public Matrix4f transpose() {
        return this.transpose(new Matrix4f());
    }

    public Matrix4f transpose(Matrix4f result) {
        return result.set(this.m00, this.m01, this.m02, this.m03, this.m10, this.m11, this.m12, this.m13, this.m20, this.m21, this.m22, this.m23, this.m30, this.m31, this.m32, this.m33);
    }

    public Matrix4f multLocal(Matrix4f other) {
        return this.mult(other, this);
    }

    public Matrix4f mult(Matrix4f other) {
        return this.mult(other, new Matrix4f());
    }

    public Matrix4f mult(Matrix4f other, Matrix4f result) {
        return result.set(this.m00 * other.m00 + this.m10 * other.m01 + this.m20 * other.m02 + this.m30 * other.m03, this.m00 * other.m10 + this.m10 * other.m11 + this.m20 * other.m12 + this.m30 * other.m13, this.m00 * other.m20 + this.m10 * other.m21 + this.m20 * other.m22 + this.m30 * other.m23, this.m00 * other.m30 + this.m10 * other.m31 + this.m20 * other.m32 + this.m30 * other.m33, this.m01 * other.m00 + this.m11 * other.m01 + this.m21 * other.m02 + this.m31 * other.m03, this.m01 * other.m10 + this.m11 * other.m11 + this.m21 * other.m12 + this.m31 * other.m13, this.m01 * other.m20 + this.m11 * other.m21 + this.m21 * other.m22 + this.m31 * other.m23, this.m01 * other.m30 + this.m11 * other.m31 + this.m21 * other.m32 + this.m31 * other.m33, this.m02 * other.m00 + this.m12 * other.m01 + this.m22 * other.m02 + this.m32 * other.m03, this.m02 * other.m10 + this.m12 * other.m11 + this.m22 * other.m12 + this.m32 * other.m13, this.m02 * other.m20 + this.m12 * other.m21 + this.m22 * other.m22 + this.m32 * other.m23, this.m02 * other.m30 + this.m12 * other.m31 + this.m22 * other.m32 + this.m32 * other.m33, this.m03 * other.m00 + this.m13 * other.m01 + this.m23 * other.m02 + this.m33 * other.m03, this.m03 * other.m10 + this.m13 * other.m11 + this.m23 * other.m12 + this.m33 * other.m13, this.m03 * other.m20 + this.m13 * other.m21 + this.m23 * other.m22 + this.m33 * other.m23, this.m03 * other.m30 + this.m13 * other.m31 + this.m23 * other.m32 + this.m33 * other.m33);
    }

    public boolean isAffine() {
        return this.m03 == 0.0f && this.m13 == 0.0f && this.m23 == 0.0f && this.m33 == 1.0f;
    }

    public boolean isMirrored() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20) < 0.0f;
    }

    public Matrix4f multAffineLocal(Matrix4f other) {
        return this.multAffine(other, this);
    }

    public Matrix4f multAffine(Matrix4f other) {
        return this.multAffine(other, new Matrix4f());
    }

    public Matrix4f multAffine(Matrix4f other, Matrix4f result) {
        return result.set(this.m00 * other.m00 + this.m10 * other.m01 + this.m20 * other.m02, this.m00 * other.m10 + this.m10 * other.m11 + this.m20 * other.m12, this.m00 * other.m20 + this.m10 * other.m21 + this.m20 * other.m22, this.m00 * other.m30 + this.m10 * other.m31 + this.m20 * other.m32 + this.m30, this.m01 * other.m00 + this.m11 * other.m01 + this.m21 * other.m02, this.m01 * other.m10 + this.m11 * other.m11 + this.m21 * other.m12, this.m01 * other.m20 + this.m11 * other.m21 + this.m21 * other.m22, this.m01 * other.m30 + this.m11 * other.m31 + this.m21 * other.m32 + this.m31, this.m02 * other.m00 + this.m12 * other.m01 + this.m22 * other.m02, this.m02 * other.m10 + this.m12 * other.m11 + this.m22 * other.m12, this.m02 * other.m20 + this.m12 * other.m21 + this.m22 * other.m22, this.m02 * other.m30 + this.m12 * other.m31 + this.m22 * other.m32 + this.m32, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f invertLocal() {
        return this.invert(this);
    }

    public Matrix4f invert() {
        return this.invert(new Matrix4f());
    }

    public Matrix4f invert(Matrix4f result) throws SingularMatrixException {
        float sd00 = this.m11 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m21 * (this.m13 * this.m32 - this.m12 * this.m33) + this.m31 * (this.m12 * this.m23 - this.m13 * this.m22);
        float sd20 = this.m01 * (this.m12 * this.m33 - this.m13 * this.m32) + this.m11 * (this.m03 * this.m32 - this.m02 * this.m33) + this.m31 * (this.m02 * this.m13 - this.m03 * this.m12);
        float sd10 = this.m01 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m21 * (this.m03 * this.m32 - this.m02 * this.m33) + this.m31 * (this.m02 * this.m23 - this.m03 * this.m22);
        float sd30 = this.m01 * (this.m12 * this.m23 - this.m13 * this.m22) + this.m11 * (this.m03 * this.m22 - this.m02 * this.m23) + this.m21 * (this.m02 * this.m13 - this.m03 * this.m12);
        float det = this.m00 * sd00 + this.m20 * sd20 - this.m10 * sd10 - this.m30 * sd30;
        if (Math.abs(det) == 0.0f) {
            throw new SingularMatrixException(this.toString());
        }
        float rdet = 1.0f / det;
        return result.set(sd00 * rdet, -(this.m10 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m20 * (this.m13 * this.m32 - this.m12 * this.m33) + this.m30 * (this.m12 * this.m23 - this.m13 * this.m22)) * rdet, (this.m10 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m20 * (this.m13 * this.m31 - this.m11 * this.m33) + this.m30 * (this.m11 * this.m23 - this.m13 * this.m21)) * rdet, -(this.m10 * (this.m21 * this.m32 - this.m22 * this.m31) + this.m20 * (this.m12 * this.m31 - this.m11 * this.m32) + this.m30 * (this.m11 * this.m22 - this.m12 * this.m21)) * rdet, -sd10 * rdet, (this.m00 * (this.m22 * this.m33 - this.m23 * this.m32) + this.m20 * (this.m03 * this.m32 - this.m02 * this.m33) + this.m30 * (this.m02 * this.m23 - this.m03 * this.m22)) * rdet, -(this.m00 * (this.m21 * this.m33 - this.m23 * this.m31) + this.m20 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m30 * (this.m01 * this.m23 - this.m03 * this.m21)) * rdet, (this.m00 * (this.m21 * this.m32 - this.m22 * this.m31) + this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m30 * (this.m01 * this.m22 - this.m02 * this.m21)) * rdet, sd20 * rdet, -(this.m00 * (this.m12 * this.m33 - this.m13 * this.m32) + this.m10 * (this.m03 * this.m32 - this.m02 * this.m33) + this.m30 * (this.m02 * this.m13 - this.m03 * this.m12)) * rdet, (this.m00 * (this.m11 * this.m33 - this.m13 * this.m31) + this.m10 * (this.m03 * this.m31 - this.m01 * this.m33) + this.m30 * (this.m01 * this.m13 - this.m03 * this.m11)) * rdet, -(this.m00 * (this.m11 * this.m32 - this.m12 * this.m31) + this.m10 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m30 * (this.m01 * this.m12 - this.m02 * this.m11)) * rdet, -sd30 * rdet, (this.m00 * (this.m12 * this.m23 - this.m13 * this.m22) + this.m10 * (this.m03 * this.m22 - this.m02 * this.m23) + this.m20 * (this.m02 * this.m13 - this.m03 * this.m12)) * rdet, -(this.m00 * (this.m11 * this.m23 - this.m13 * this.m21) + this.m10 * (this.m03 * this.m21 - this.m01 * this.m23) + this.m20 * (this.m01 * this.m13 - this.m03 * this.m11)) * rdet, (this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m10 * (this.m02 * this.m21 - this.m01 * this.m22) + this.m20 * (this.m01 * this.m12 - this.m02 * this.m11)) * rdet);
    }

    public Matrix4f invertAffineLocal() {
        return this.invertAffine(this);
    }

    public Matrix4f invertAffine() {
        return this.invertAffine(new Matrix4f());
    }

    public Matrix4f invertAffine(Matrix4f result) throws SingularMatrixException {
        float sd00 = this.m11 * this.m22 - this.m21 * this.m12;
        float sd20 = this.m01 * this.m12 - this.m11 * this.m02;
        float sd10 = this.m01 * this.m22 - this.m21 * this.m02;
        float det = this.m00 * sd00 + this.m20 * sd20 - this.m10 * sd10;
        if (Math.abs(det) == 0.0f) {
            throw new SingularMatrixException(this.toString());
        }
        float rdet = 1.0f / det;
        return result.set(sd00 * rdet, -(this.m10 * this.m22 - this.m20 * this.m12) * rdet, (this.m10 * this.m21 - this.m20 * this.m11) * rdet, -(this.m10 * (this.m21 * this.m32 - this.m22 * this.m31) + this.m20 * (this.m12 * this.m31 - this.m11 * this.m32) + this.m30 * sd00) * rdet, -sd10 * rdet, (this.m00 * this.m22 - this.m20 * this.m02) * rdet, -(this.m00 * this.m21 - this.m20 * this.m01) * rdet, (this.m00 * (this.m21 * this.m32 - this.m22 * this.m31) + this.m20 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m30 * sd10) * rdet, sd20 * rdet, -(this.m00 * this.m12 - this.m10 * this.m02) * rdet, (this.m00 * this.m11 - this.m10 * this.m01) * rdet, -(this.m00 * (this.m11 * this.m32 - this.m12 * this.m31) + this.m10 * (this.m02 * this.m31 - this.m01 * this.m32) + this.m30 * sd20) * rdet, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f lerpLocal(Matrix4f other, float t) {
        return this.lerp(other, t, this);
    }

    public Matrix4f lerp(Matrix4f other, float t) {
        return this.lerp(other, t, new Matrix4f());
    }

    public Matrix4f lerp(Matrix4f other, float t, Matrix4f result) {
        return result.set(this.m00 + t * (other.m00 - this.m00), this.m10 + t * (other.m10 - this.m10), this.m20 + t * (other.m20 - this.m20), this.m30 + t * (other.m30 - this.m30), this.m01 + t * (other.m01 - this.m01), this.m11 + t * (other.m11 - this.m11), this.m21 + t * (other.m21 - this.m21), this.m31 + t * (other.m31 - this.m31), this.m02 + t * (other.m02 - this.m02), this.m12 + t * (other.m12 - this.m12), this.m22 + t * (other.m22 - this.m22), this.m32 + t * (other.m32 - this.m32), this.m03 + t * (other.m03 - this.m03), this.m13 + t * (other.m13 - this.m13), this.m23 + t * (other.m23 - this.m23), this.m33 + t * (other.m33 - this.m33));
    }

    public Matrix4f lerpAffineLocal(Matrix4f other, float t) {
        return this.lerpAffine(other, t, this);
    }

    public Matrix4f lerpAffine(Matrix4f other, float t) {
        return this.lerpAffine(other, t, new Matrix4f());
    }

    public Matrix4f lerpAffine(Matrix4f other, float t, Matrix4f result) {
        return result.set(this.m00 + t * (other.m00 - this.m00), this.m10 + t * (other.m10 - this.m10), this.m20 + t * (other.m20 - this.m20), this.m30 + t * (other.m30 - this.m30), this.m01 + t * (other.m01 - this.m01), this.m11 + t * (other.m11 - this.m11), this.m21 + t * (other.m21 - this.m21), this.m31 + t * (other.m31 - this.m31), this.m02 + t * (other.m02 - this.m02), this.m12 + t * (other.m12 - this.m12), this.m22 + t * (other.m22 - this.m22), this.m32 + t * (other.m32 - this.m32), 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public Matrix4f set(Matrix4f other) {
        return this.set(other.m00, other.m10, other.m20, other.m30, other.m01, other.m11, other.m21, other.m31, other.m02, other.m12, other.m22, other.m32, other.m03, other.m13, other.m23, other.m33);
    }

    public Matrix4f set(float[] values) {
        return this.set(values[0], values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8], values[9], values[10], values[11], values[12], values[13], values[14], values[15]);
    }

    public Matrix4f set(FloatBuffer buf) {
        this.m00 = buf.get();
        this.m01 = buf.get();
        this.m02 = buf.get();
        this.m03 = buf.get();
        this.m10 = buf.get();
        this.m11 = buf.get();
        this.m12 = buf.get();
        this.m13 = buf.get();
        this.m20 = buf.get();
        this.m21 = buf.get();
        this.m22 = buf.get();
        this.m23 = buf.get();
        this.m30 = buf.get();
        this.m31 = buf.get();
        this.m32 = buf.get();
        this.m33 = buf.get();
        return this;
    }

    public Matrix4f set(float m00, float m10, float m20, float m30, float m01, float m11, float m21, float m31, float m02, float m12, float m22, float m32, float m03, float m13, float m23, float m33) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.m30 = m30;
        this.m31 = m31;
        this.m32 = m32;
        this.m33 = m33;
        return this;
    }

    public FloatBuffer get(FloatBuffer buf) {
        buf.put(this.m00).put(this.m01).put(this.m02).put(this.m03);
        buf.put(this.m10).put(this.m11).put(this.m12).put(this.m13);
        buf.put(this.m20).put(this.m21).put(this.m22).put(this.m23);
        buf.put(this.m30).put(this.m31).put(this.m32).put(this.m33);
        return buf;
    }

    public Vector3f projectPointLocal(Vector3f point) {
        return this.projectPoint(point, point);
    }

    public Vector3f projectPoint(Vector3f point) {
        return this.projectPoint(point, new Vector3f());
    }

    public Vector3f projectPoint(Vector3f point, Vector3f result) {
        float rw = 1.0f / (this.m03 * point.x + this.m13 * point.y + this.m23 * point.z + this.m33);
        return result.set((this.m00 * point.x + this.m10 * point.y + this.m20 * point.z + this.m30) * rw, (this.m01 * point.x + this.m11 * point.y + this.m21 * point.z + this.m31) * rw, (this.m02 * point.x + this.m12 * point.y + this.m22 * point.z + this.m32) * rw);
    }

    public Vector3f transformPointLocal(Vector3f point) {
        return this.transformPoint(point, point);
    }

    public Vector3f transformPoint(Vector3f point) {
        return this.transformPoint(point, new Vector3f());
    }

    public Vector3f transformPoint(Vector3f point, Vector3f result) {
        return result.set(this.m00 * point.x + this.m10 * point.y + this.m20 * point.z + this.m30, this.m01 * point.x + this.m11 * point.y + this.m21 * point.z + this.m31, this.m02 * point.x + this.m12 * point.y + this.m22 * point.z + this.m32);
    }

    public float transformPointZ(Vector3f point) {
        return this.m02 * point.x + this.m12 * point.y + this.m22 * point.z + this.m32;
    }

    public Vector3f transformVectorLocal(Vector3f vector) {
        return this.transformVector(vector, vector);
    }

    public Vector3f transformVector(Vector3f vector) {
        return this.transformVector(vector, new Vector3f());
    }

    public Vector3f transformVector(Vector3f vector, Vector3f result) {
        return result.set(this.m00 * vector.x + this.m10 * vector.y + this.m20 * vector.z, this.m01 * vector.x + this.m11 * vector.y + this.m21 * vector.z, this.m02 * vector.x + this.m12 * vector.y + this.m22 * vector.z);
    }

    public Quaternion extractRotation() {
        return this.extractRotation(new Quaternion());
    }

    public Quaternion extractRotation(Quaternion result) {
        float n00 = this.m00;
        float n10 = this.m10;
        float n20 = this.m20;
        float n01 = this.m01;
        float n11 = this.m11;
        float n21 = this.m21;
        float n02 = this.m02;
        float n12 = this.m12;
        float n22 = this.m22;
        for (int ii = 0; ii < 10; ++ii) {
            float o00 = n00;
            float o11 = n11;
            float o22 = n22;
            float o21 = n21;
            float o12 = n12;
            float sd00 = o11 * o22 - o21 * o12;
            float o20 = n20;
            float o01 = n01;
            float o02 = n02;
            float sd20 = o01 * o12 - o11 * o02;
            float o10 = n10;
            float sd10 = o01 * o22 - o21 * o02;
            float det = o00 * sd00 + o20 * sd20 - o10 * sd10;
            if (Math.abs(det) == 0.0f) {
                throw new SingularMatrixException(this.toString());
            }
            float hrdet = 0.5f / det;
            n00 = sd00 * hrdet + o00 * 0.5f;
            float d00 = n00 - o00;
            n10 = -sd10 * hrdet + o10 * 0.5f;
            float d10 = n10 - o10;
            n20 = sd20 * hrdet + o20 * 0.5f;
            float d20 = n20 - o20;
            n01 = -(o10 * o22 - o20 * o12) * hrdet + o01 * 0.5f;
            float d01 = n01 - o01;
            n11 = (o00 * o22 - o20 * o02) * hrdet + o11 * 0.5f;
            float d11 = n11 - o11;
            n21 = -(o00 * o12 - o10 * o02) * hrdet + o21 * 0.5f;
            float d21 = n21 - o21;
            n02 = (o10 * o21 - o20 * o11) * hrdet + o02 * 0.5f;
            float d02 = n02 - o02;
            n12 = -(o00 * o21 - o20 * o01) * hrdet + o12 * 0.5f;
            float d12 = n12 - o12;
            n22 = (o00 * o11 - o10 * o01) * hrdet + o22 * 0.5f;
            float d22 = n22 - o22;
            if (d00 * d00 + d10 * d10 + d20 * d20 + d01 * d01 + d11 * d11 + d21 * d21 + d02 * d02 + d12 * d12 + d22 * d22 < 1.0E-6f) break;
        }
        float x2 = Math.abs(1.0f + n00 - n11 - n22);
        float y2 = Math.abs(1.0f - n00 + n11 - n22);
        float z2 = Math.abs(1.0f - n00 - n11 + n22);
        float w2 = Math.abs(1.0f + n00 + n11 + n22);
        result.set(0.5f * FloatMath.sqrt(x2) * (n12 >= n21 ? 1.0f : -1.0f), 0.5f * FloatMath.sqrt(y2) * (n20 >= n02 ? 1.0f : -1.0f), 0.5f * FloatMath.sqrt(z2) * (n01 >= n10 ? 1.0f : -1.0f), 0.5f * FloatMath.sqrt(w2));
        return result;
    }

    public Vector3f extractScale() {
        return this.extractScale(new Vector3f());
    }

    public Vector3f extractScale(Vector3f result) {
        return result.set(FloatMath.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02), FloatMath.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12), FloatMath.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22));
    }

    public float approximateUniformScale() {
        return FloatMath.cbrt(this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) + this.m01 * (this.m12 * this.m20 - this.m10 * this.m22) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20));
    }

    public boolean epsilonEquals(Matrix4f other, float epsilon) {
        return Math.abs(this.m00 - other.m00) < epsilon && Math.abs(this.m10 - other.m10) < epsilon && Math.abs(this.m20 - other.m20) < epsilon && Math.abs(this.m30 - other.m30) < epsilon && Math.abs(this.m01 - other.m01) < epsilon && Math.abs(this.m11 - other.m11) < epsilon && Math.abs(this.m21 - other.m21) < epsilon && Math.abs(this.m31 - other.m31) < epsilon && Math.abs(this.m02 - other.m02) < epsilon && Math.abs(this.m12 - other.m12) < epsilon && Math.abs(this.m22 - other.m22) < epsilon && Math.abs(this.m32 - other.m32) < epsilon && Math.abs(this.m03 - other.m03) < epsilon && Math.abs(this.m13 - other.m13) < epsilon && Math.abs(this.m23 - other.m23) < epsilon && Math.abs(this.m33 - other.m33) < epsilon;
    }

    @Override
    public String encodeToString() {
        return this.m00 + ", " + this.m10 + ", " + this.m20 + ", " + this.m30 + ", " + this.m01 + ", " + this.m11 + ", " + this.m21 + ", " + this.m31 + ", " + this.m02 + ", " + this.m12 + ", " + this.m22 + ", " + this.m32 + ", " + this.m03 + ", " + this.m13 + ", " + this.m23 + ", " + this.m33;
    }

    @Override
    public void decodeFromString(String string) throws Exception {
        this.set(StringUtil.parseFloatArray((String)string));
    }

    @Override
    public void encodeToStream(DataOutputStream out) throws IOException {
        out.writeFloat(this.m00);
        out.writeFloat(this.m10);
        out.writeFloat(this.m20);
        out.writeFloat(this.m30);
        out.writeFloat(this.m01);
        out.writeFloat(this.m11);
        out.writeFloat(this.m21);
        out.writeFloat(this.m31);
        out.writeFloat(this.m02);
        out.writeFloat(this.m12);
        out.writeFloat(this.m22);
        out.writeFloat(this.m32);
        out.writeFloat(this.m03);
        out.writeFloat(this.m13);
        out.writeFloat(this.m23);
        out.writeFloat(this.m33);
    }

    @Override
    public void decodeFromStream(DataInputStream in) throws IOException {
        this.set(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
    }

    public String toString() {
        return "[[" + this.m00 + ", " + this.m10 + ", " + this.m20 + ", " + this.m30 + "], [" + this.m01 + ", " + this.m11 + ", " + this.m21 + ", " + this.m31 + "], [" + this.m02 + ", " + this.m12 + ", " + this.m22 + ", " + this.m32 + "], [" + this.m03 + ", " + this.m13 + ", " + this.m23 + ", " + this.m33 + "]]";
    }

    public int hashCode() {
        return Float.floatToIntBits(this.m00) ^ Float.floatToIntBits(this.m10) ^ Float.floatToIntBits(this.m20) ^ Float.floatToIntBits(this.m30) ^ Float.floatToIntBits(this.m01) ^ Float.floatToIntBits(this.m11) ^ Float.floatToIntBits(this.m21) ^ Float.floatToIntBits(this.m31) ^ Float.floatToIntBits(this.m02) ^ Float.floatToIntBits(this.m12) ^ Float.floatToIntBits(this.m22) ^ Float.floatToIntBits(this.m32) ^ Float.floatToIntBits(this.m03) ^ Float.floatToIntBits(this.m13) ^ Float.floatToIntBits(this.m23) ^ Float.floatToIntBits(this.m33);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Matrix4f)) {
            return false;
        }
        Matrix4f omat = (Matrix4f)other;
        return this.m00 == omat.m00 && this.m10 == omat.m10 && this.m20 == omat.m20 && this.m30 == omat.m30 && this.m01 == omat.m01 && this.m11 == omat.m11 && this.m21 == omat.m21 && this.m31 == omat.m31 && this.m02 == omat.m02 && this.m12 == omat.m12 && this.m22 == omat.m22 && this.m32 == omat.m32 && this.m03 == omat.m03 && this.m13 == omat.m13 && this.m23 == omat.m23 && this.m33 == omat.m33;
    }
}

