/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export;

import com.google.common.base.Supplier;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.samskivert.util.HashIntMap;
import com.threerings.export.BinaryExporter;
import com.threerings.export.Exportable;
import com.threerings.export.Importer;
import com.threerings.export.Log;
import com.threerings.export.Streamer;
import com.threerings.export.Streams;
import com.threerings.util.ReflectionUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.InflaterInputStream;

public class BinaryImporter
extends Importer {
    protected InputStream _base;
    protected DataInputStream _in;
    protected HashIntMap<Object> _objects;
    protected Supplier<IdReader> _idReaderSupplier;
    protected IdReader _objectIdReader;
    protected Map<String, Object> _fields;
    protected Map<String, ClassWrapper> _wrappersByName = Maps.newHashMap();
    protected Map<Class<?>, ClassWrapper> _wrappersByClass = Maps.newHashMap();
    protected HashIntMap<ClassWrapper> _classes = new HashIntMap();
    protected ClassWrapper _objectClass;
    protected ClassWrapper _stringClass;
    protected IdReader _classIdReader;
    protected Map<ClassWrapper, ClassData> _classData = Maps.newHashMap();
    protected static final Object NULL = new Object();

    public BinaryImporter(InputStream in) {
        this._base = in;
        this._in = new DataInputStream(this._base);
        for (int ii = 0; ii < BinaryExporter.BOOTSTRAP_CLASSES.length; ++ii) {
            this._classes.put(ii + 1, (Object)this.getClassWrapper(BinaryExporter.BOOTSTRAP_CLASSES[ii]));
        }
        this._objectClass = this.getClassWrapper(Object.class);
        this._stringClass = this.getClassWrapper(String.class);
    }

    @Override
    public Object readObject() throws IOException {
        if (this._objects == null) {
            boolean compressed;
            int magic = this._in.readInt();
            if (magic != -87118066) {
                throw new IOException(String.format("Invalid magic number [magic=%#x].", magic));
            }
            short version = this._in.readShort();
            switch (version) {
                default: {
                    throw new IOException(String.format("Invalid version [version=%#x].", version));
                }
                case 4098: {
                    this._idReaderSupplier = new Supplier<IdReader>(){

                        public IdReader get() {
                            return new VarIntReader();
                        }
                    };
                    break;
                }
                case 4097: {
                    this._idReaderSupplier = new Supplier<IdReader>(){

                        public IdReader get() {
                            return new IntermediateIdReader();
                        }
                    };
                    break;
                }
                case 4096: {
                    this._idReaderSupplier = new Supplier<IdReader>(){

                        public IdReader get() {
                            return new ClassicIdReader();
                        }
                    };
                }
            }
            short flags = this._in.readShort();
            boolean bl = compressed = (flags & 0x1000) != 0;
            if (compressed) {
                this._in = new DataInputStream(new InflaterInputStream(this._base));
            }
            this._objectIdReader = (IdReader)this._idReaderSupplier.get();
            this._classIdReader = (IdReader)this._idReaderSupplier.get();
            this._objects = new HashIntMap();
            this._objects.put(0, NULL);
        }
        return this.read(this._objectClass);
    }

    @Override
    public boolean read(String name, boolean defvalue) throws IOException {
        try {
            Boolean value = (Boolean)this._fields.get(name);
            return value == null ? defvalue : value;
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to boolean.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public byte read(String name, byte defvalue) throws IOException {
        try {
            Number value = (Number)this._fields.get(name);
            return value == null ? defvalue : value.byteValue();
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to byte.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public char read(String name, char defvalue) throws IOException {
        try {
            Character value = (Character)this._fields.get(name);
            return value == null ? defvalue : value.charValue();
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to char.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public double read(String name, double defvalue) throws IOException {
        try {
            Number value = (Number)this._fields.get(name);
            return value == null ? defvalue : value.doubleValue();
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to double.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public float read(String name, float defvalue) throws IOException {
        try {
            Number value = (Number)this._fields.get(name);
            return value == null ? defvalue : value.floatValue();
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to float.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public int read(String name, int defvalue) throws IOException {
        try {
            Number value = (Number)this._fields.get(name);
            return value == null ? defvalue : value.intValue();
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to int.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public long read(String name, long defvalue) throws IOException {
        try {
            Number value = (Number)this._fields.get(name);
            return value == null ? defvalue : value.longValue();
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to long.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public short read(String name, short defvalue) throws IOException {
        try {
            Number value = (Number)this._fields.get(name);
            return value == null ? defvalue : value.shortValue();
        }
        catch (ClassCastException e) {
            Log.log.warning((Object)"Can't cast to short.", new Object[]{"name", name, "value", this._fields.get(name), e});
            return defvalue;
        }
    }

    @Override
    public <T> T read(String name, T defvalue, Class<T> clazz) throws IOException {
        Object value = this._fields.get(name);
        if (value == null) {
            if (this._fields.containsKey(name)) {
                return null;
            }
        } else {
            if (clazz.isInstance(value)) {
                Object tvalue = value;
                return (T)tvalue;
            }
            Log.log.warning((Object)"Read value is not the correct type.", new Object[]{"name", name, "expectedType", clazz.getName(), "actualType", value.getClass().getName()});
        }
        return defvalue;
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }

    protected Object read(Class<?> clazz) throws IOException {
        return this.read(this.getClassWrapper(clazz));
    }

    protected Object read(ClassWrapper clazz) throws IOException {
        if (clazz.isPrimitive()) {
            return this.readValue(clazz, -1);
        }
        int objectId = this._objectIdReader.read();
        Object value = this._objects.get(objectId);
        if (value != null) {
            return value == NULL ? null : value;
        }
        return this.readValue(clazz, objectId);
    }

    protected Object readValue(ClassWrapper clazz, int objectId) throws IOException {
        Streamer<?> streamer;
        Class<?> wclazz;
        ClassWrapper cclazz = clazz;
        if (!clazz.isFinal()) {
            cclazz = this.readClass();
        }
        if ((wclazz = cclazz.getWrappedClass()) != null && (streamer = Streamer.getStreamer(wclazz)) != null) {
            Object value = null;
            try {
                value = streamer.read(this._in);
            }
            catch (ClassNotFoundException e) {
                Log.log.warning((Object)"Class not found.", new Object[]{e});
            }
            if (value != null && objectId != -1) {
                this._objects.put(objectId, value);
            }
            return value;
        }
        EnumSet<?> value = null;
        int length = 0;
        boolean wasRead = false;
        if (cclazz.isArray()) {
            length = this._objectIdReader.readLength();
            if (wclazz != null) {
                value = Array.newInstance(wclazz.getComponentType(), length);
            }
        } else {
            Object outer;
            Object object = outer = cclazz.isInner() ? this.read(this._objectClass) : null;
            if (wclazz != null) {
                if (wclazz == ImmutableList.class) {
                    value = ImmutableList.copyOf(this.readEntries(Lists.newArrayList()));
                    wasRead = true;
                } else if (wclazz == ImmutableSet.class) {
                    value = ImmutableSet.copyOf(this.readEntries(Lists.newArrayList()));
                    wasRead = true;
                } else if (wclazz == ImmutableMap.class) {
                    value = ImmutableMap.copyOf(this.readEntries(Maps.newHashMap()));
                    wasRead = true;
                } else if (wclazz == ImmutableMultiset.class) {
                    value = ImmutableMultiset.copyOf(this.readEntries((Multiset<Object>)HashMultiset.create()));
                    wasRead = true;
                } else if (EnumSet.class.isAssignableFrom(wclazz)) {
                    Class<?> eclazz = this.readClass().getWrappedClass();
                    value = EnumSet.noneOf(eclazz);
                } else {
                    value = ReflectionUtil.newInstance(wclazz, outer);
                }
            }
        }
        this._objects.put(objectId, value == null ? NULL : value);
        if (wasRead) {
            return value;
        }
        if (cclazz.isArray()) {
            this.readEntries(value == null ? new Object[length] : (Object[])value, cclazz.getComponentType());
        } else if (cclazz.isCollection()) {
            if (cclazz.isMultiset()) {
                HashMultiset multiset = value == null ? HashMultiset.create() : (Multiset)value;
                this.readEntries((Multiset<Object>)multiset);
            } else {
                ArrayList<Object> collection = value == null ? new ArrayList() : (Collection)value;
                this.readEntries(collection);
            }
        } else if (cclazz.isMap()) {
            HashMap<Object, Object> map = value == null ? new HashMap() : (Map)((Object)value);
            this.readEntries(map);
        } else {
            ClassData cdata = this._classData.get(cclazz);
            if (cdata == null) {
                cdata = new ClassData();
                this._classData.put(cclazz, cdata);
            }
            this._fields = cdata.readFields();
            if (value instanceof Exportable) {
                this.readFields((Exportable)((Object)value));
            }
            this._fields = null;
        }
        return value;
    }

    protected ClassWrapper readClass() throws IOException {
        int classId = this._classIdReader.read();
        ClassWrapper clazz = (ClassWrapper)this._classes.get(classId);
        if (clazz != null) {
            return clazz;
        }
        clazz = this.getClassWrapper(this._in.readUTF(), this._in.readByte());
        this._classes.put(classId, (Object)clazz);
        return clazz;
    }

    protected void readEntries(Object[] array, ClassWrapper cclazz) throws IOException {
        for (int ii = 0; ii < array.length; ++ii) {
            array[ii] = this.read(cclazz);
        }
    }

    protected Collection<Object> readEntries(Collection<Object> collection) throws IOException {
        int nn = this._objectIdReader.readLength();
        for (int ii = 0; ii < nn; ++ii) {
            collection.add(this.read(this._objectClass));
        }
        return collection;
    }

    protected Multiset<Object> readEntries(Multiset<Object> multiset) throws IOException {
        int nn = this._objectIdReader.readLength();
        for (int ii = 0; ii < nn; ++ii) {
            multiset.add(this.read(this._objectClass), this._objectIdReader.readLength());
        }
        return multiset;
    }

    protected Map<Object, Object> readEntries(Map<Object, Object> map) throws IOException {
        int nn = this._objectIdReader.readLength();
        for (int ii = 0; ii < nn; ++ii) {
            map.put(this.read(this._objectClass), this.read(this._objectClass));
        }
        return map;
    }

    protected ClassWrapper getClassWrapper(String name, byte flags) {
        ClassWrapper wrapper = this._wrappersByName.get(name);
        if (wrapper == null) {
            wrapper = new ClassWrapper(this, name, flags);
            this._wrappersByName.put(name, wrapper);
            Class<?> clazz = wrapper.getWrappedClass();
            if (clazz != null) {
                this._wrappersByClass.put(clazz, wrapper);
            }
        }
        return wrapper;
    }

    protected ClassWrapper getClassWrapper(Class<?> clazz) {
        ClassWrapper wrapper = this._wrappersByClass.get(clazz);
        if (wrapper == null) {
            wrapper = new ClassWrapper(this, clazz);
            this._wrappersByClass.put(clazz, wrapper);
            this._wrappersByName.put(clazz.getName(), wrapper);
        }
        return wrapper;
    }

    protected class ClassicIdReader
    implements IdReader {
        public static final int VERSION = 4096;
        protected int _highest;

        protected ClassicIdReader() {
        }

        @Override
        public int read() throws IOException {
            int id = this._highest < 255 ? BinaryImporter.this._in.readUnsignedByte() : (this._highest < 65535 ? BinaryImporter.this._in.readUnsignedShort() : BinaryImporter.this._in.readInt());
            this._highest = Math.max(this._highest, id);
            return id;
        }

        @Override
        public int readLength() throws IOException {
            return BinaryImporter.this._in.readInt();
        }
    }

    protected class IntermediateIdReader
    extends VarIntReader {
        public static final int VERSION = 4097;

        protected IntermediateIdReader() {
        }

        @Override
        public int readLength() throws IOException {
            return BinaryImporter.this._in.readInt();
        }
    }

    protected class VarIntReader
    implements IdReader {
        protected VarIntReader() {
        }

        @Override
        public int read() throws IOException {
            return Streams.readVarInt(BinaryImporter.this._in);
        }

        @Override
        public int readLength() throws IOException {
            return Streams.readVarInt(BinaryImporter.this._in);
        }
    }

    static interface IdReader {
        public int read() throws IOException;

        public int readLength() throws IOException;
    }

    protected static class FieldData {
        public final String name;
        public final ClassWrapper clazz;

        public FieldData(String name, ClassWrapper clazz) {
            this.name = name;
            this.clazz = clazz;
        }
    }

    protected class ClassData {
        protected HashIntMap<FieldData> _fieldData = new HashIntMap();
        protected IdReader _fieldIdReader;

        protected ClassData() {
            this._fieldIdReader = (IdReader)BinaryImporter.this._idReaderSupplier.get();
        }

        public Map<String, Object> readFields() throws IOException {
            int size = this._fieldIdReader.readLength();
            HashMap<String, Object> fields = new HashMap<String, Object>(size);
            for (int ii = 0; ii < size; ++ii) {
                this.readField(fields);
            }
            return fields;
        }

        protected void readField(Map<String, Object> fields) throws IOException {
            int fieldId = this._fieldIdReader.read();
            FieldData fieldData = (FieldData)this._fieldData.get(fieldId);
            if (fieldData == null) {
                String name = (String)BinaryImporter.this.read(BinaryImporter.this._stringClass);
                ClassWrapper clazz = BinaryImporter.this.readClass();
                fieldData = new FieldData(name, clazz);
                this._fieldData.put(fieldId, (Object)fieldData);
            }
            fields.put(fieldData.name, BinaryImporter.this.read(fieldData.clazz));
        }
    }

    protected static class ClassWrapper {
        protected String _name;
        protected byte _flags;
        protected ClassWrapper _componentType;
        protected Class<?> _clazz;

        public ClassWrapper(BinaryImporter importer, String name, byte flags) {
            this._name = name;
            if (name.charAt(0) == '[') {
                this._flags = 1;
                String cname = name.substring(1);
                char type = cname.charAt(0);
                if (type == '[') {
                    this._componentType = importer.getClassWrapper(cname, flags);
                } else if (type == 'L') {
                    this._componentType = importer.getClassWrapper(cname.substring(1, cname.length() - 1), flags);
                } else {
                    try {
                        this._clazz = Class.forName(name);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    this._componentType = importer.getClassWrapper(this._clazz.getComponentType());
                    return;
                }
                if (this._componentType.getWrappedClass() == null) {
                    return;
                }
            } else {
                this._flags = flags;
            }
            try {
                this._clazz = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                Log.log.warning((Object)("Couldn't find class to import [name=" + name + "]."), new Object[0]);
            }
        }

        public ClassWrapper(BinaryImporter importer, Class<?> clazz) {
            this._name = clazz.getName();
            this._flags = BinaryExporter.getFlags(clazz);
            if (clazz.isArray()) {
                this._componentType = importer.getClassWrapper(clazz.getComponentType());
            }
            this._clazz = clazz;
        }

        public String getName() {
            return this._name;
        }

        public boolean isFinal() {
            return this.hasFlags((byte)1);
        }

        public boolean isInner() {
            return this.hasFlags((byte)2);
        }

        public boolean isCollection() {
            return this.hasFlags((byte)4);
        }

        public boolean isMultiset() {
            return this.hasFlags((byte)20);
        }

        public boolean isMap() {
            return this.hasFlags((byte)24, (byte)8);
        }

        public boolean isArray() {
            return this._componentType != null;
        }

        public boolean isPrimitive() {
            return this._clazz != null && this._clazz.isPrimitive();
        }

        public ClassWrapper getComponentType() {
            return this._componentType;
        }

        public Class<?> getWrappedClass() {
            return this._clazz;
        }

        public int hashCode() {
            return this._name.hashCode();
        }

        public boolean equals(Object other) {
            return ((ClassWrapper)other)._name.equals(this._name);
        }

        protected boolean hasFlags(byte flags) {
            return this.hasFlags(flags, flags);
        }

        protected boolean hasFlags(byte mask, byte flags) {
            return (this._flags & mask) == flags;
        }
    }
}

