/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.util;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.DerivedConfig;
import com.threerings.config.ManagedConfig;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.config.Reference;
import com.threerings.config.ReferenceConstraints;
import com.threerings.config.util.ConfigId;
import com.threerings.editor.Editable;
import com.threerings.editor.FileConstraints;
import com.threerings.editor.Introspector;
import com.threerings.editor.Property;
import com.threerings.editor.util.PropertyUtil;
import java.io.PrintStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Validator {
    protected final PrintStream _out;
    protected Deque<String> _wheres = new ArrayDeque<String>();
    protected Set<Resource> _resources = Sets.newHashSet();
    protected Set<ConfigId> _configs = Sets.newHashSet();
    protected boolean _hasNulls;
    protected ListMultimap<ReferenceConstraints, ConfigId> _configsByConstraints;

    public Validator(PrintStream out) {
        this._out = out;
    }

    public Validator(String where, PrintStream out) {
        this(out);
        this.pushWhere(where);
    }

    public String getWhere() {
        return Joiner.on((String)" : ").join(this._wheres);
    }

    public PrintStream getPrintStream() {
        return this._out;
    }

    public void output(String message) {
        this._out.println(this.getWhere() + " " + message);
    }

    public void pushWhere(String where) {
        this._wheres.addLast(where);
    }

    public void popWhere() {
        this._wheres.removeLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(ConfigManager cfgmgr, Object object) {
        Preconditions.checkNotNull((Object)cfgmgr);
        this.preValidate();
        try {
            this.getReferences(cfgmgr, object);
            boolean bl = this.validate(cfgmgr);
            return bl;
        }
        finally {
            this.postValidate();
        }
    }

    protected void preValidate() {
        Preconditions.checkState((boolean)this._configs.isEmpty());
        Preconditions.checkState((boolean)this._resources.isEmpty());
        Preconditions.checkState((this._configsByConstraints == null ? 1 : 0) != 0);
    }

    protected void postValidate() {
        this._configs.clear();
        this._resources.clear();
        this._hasNulls = false;
        this._configsByConstraints = null;
    }

    protected void getReferences(ConfigManager cfgmgr, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof Object[]) {
            for (Object element : (Object[])object) {
                this.getReferences(cfgmgr, element);
            }
            return;
        }
        if (object instanceof Iterable) {
            for (Object element : (Iterable)object) {
                this.getReferences(cfgmgr, element);
            }
            return;
        }
        for (Property property : Introspector.getProperties(object)) {
            this.getReferences(cfgmgr, object, property);
        }
    }

    protected void getReferences(ConfigManager cfgmgr, Object object, Property property) {
        Editable annotation = property.getAnnotation();
        Object value = property.get(object);
        if (value == null) {
            if (this.isNullValidated() && !annotation.nullable()) {
                this.output("Non-nullable property is null: " + property.getName());
            }
            return;
        }
        String editor = annotation.editor();
        if (editor.equals("resource")) {
            this.addResource((String)value, property, this._resources);
            return;
        }
        Reference refAnno = property.getAnnotation(Reference.class);
        if (refAnno != null) {
            this.noteReference(cfgmgr, refAnno.value(), (String)value, property);
            return;
        }
        if (editor.equals("config")) {
            ConfigGroup<?> group = cfgmgr.getGroup(annotation.mode());
            if (group != null) {
                this.noteReference(cfgmgr, group.getConfigClass(), (String)value, property);
            }
            return;
        }
        Class<?> type = property.getType();
        if (ConfigReference.class.equals(type)) {
            Class<Object> clazz = property.getArgumentType(ConfigReference.class);
            if (clazz == null && object instanceof DerivedConfig) {
                clazz = ((DerivedConfig)object).cclass;
            }
            Class<?> cclass = clazz;
            ConfigReference ref = (ConfigReference)value;
            this.noteReference(cfgmgr, cclass, ref, property);
            return;
        }
        if ((type.isArray() || List.class.isAssignableFrom(type)) && ConfigReference.class.equals(property.getComponentType())) {
            List<ConfigReference> list = type.isArray() ? Arrays.asList((ConfigReference[])value) : (List<ConfigReference>)value;
            Type ctype = property.getGenericComponentType();
            if (!(ctype instanceof ParameterizedType)) {
                this.output("can't determine type of refs");
                return;
            }
            Class cclass = (Class)((ParameterizedType)ctype).getActualTypeArguments()[0];
            for (ConfigReference ref : list) {
                if (ref == null) {
                    this._hasNulls = true;
                    continue;
                }
                this.noteReference(cfgmgr, (Class<? extends ManagedConfig>)cclass, ref, property);
            }
            return;
        }
        this.getReferences(cfgmgr, value);
    }

    protected void noteReference(ConfigManager cfgmgr, Class<? extends ManagedConfig> clazz, String name, Property property) {
        ConfigId configId = new ConfigId(clazz, name);
        ReferenceConstraints constraints = property.getAnnotation(ReferenceConstraints.class);
        if (constraints == null) {
            this._configs.add(configId);
        } else {
            if (this._configsByConstraints == null) {
                this._configsByConstraints = ArrayListMultimap.create();
            }
            this._configsByConstraints.put((Object)constraints, (Object)configId);
        }
    }

    protected void noteReference(ConfigManager cfgmgr, Class<? extends ManagedConfig> clazz, ConfigReference<?> ref, Property property) {
        this.noteReference(cfgmgr, clazz, ref.getName(), property);
        ArgumentMap args = ref.getArguments();
        if (args.isEmpty()) {
            return;
        }
        ManagedConfig config = cfgmgr.getRawConfig(clazz, ref.getName());
        if (!(config instanceof ParameterizedConfig)) {
            args.clear();
            return;
        }
        ParameterizedConfig pconfig = (ParameterizedConfig)config;
        Iterator<Map.Entry<String, Object>> it = args.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            Parameter param = pconfig.getParameter(entry.getKey());
            if (param == null) {
                it.remove();
                continue;
            }
            Property prop = param.getArgumentProperty(pconfig);
            if (prop == null) continue;
            this.getReferences(cfgmgr, args, prop);
        }
    }

    protected boolean validate(ConfigManager cfgmgr) {
        boolean result = true;
        if (this._hasNulls) {
            this.output("has null config references");
            result = false;
        }
        for (ConfigId configId : this._configs) {
            if (cfgmgr.getConfig(configId.clazz, configId.name) != null) continue;
            this.noteMissing(configId);
            result = false;
        }
        if (this._configsByConstraints != null) {
            for (Map.Entry entry : Multimaps.asMap(this._configsByConstraints).entrySet()) {
                Predicate<ManagedConfig> pred = PropertyUtil.getRawConfigPredicate((ReferenceConstraints)entry.getKey());
                for (ConfigId configId : (List)entry.getValue()) {
                    ManagedConfig cfg = cfgmgr.getRawConfig(configId.clazz, configId.name);
                    if (cfg == null) {
                        this.noteMissing(configId);
                        result = false;
                        continue;
                    }
                    if (pred.apply((Object)cfg)) continue;
                    this.output("references invalid config: " + configId.name);
                    result = false;
                }
            }
        }
        for (Resource resource : this._resources) {
            if (resource.validate(cfgmgr)) continue;
            result = false;
            this.output("references missing resource: " + resource);
        }
        return result;
    }

    protected void noteMissing(ConfigId configId) {
        this.output("references missing config of type " + ConfigGroup.getName(configId.clazz) + ": " + configId.name);
    }

    protected void addResource(String value, Property property, Set<Resource> resources) {
        FileConstraints constraints = property.getAnnotation(FileConstraints.class);
        if (constraints != null && constraints.stripExtension()) {
            String[] exts = constraints.extensions();
            resources.add(this.createResource(value, exts));
            return;
        }
        resources.add(this.createResource(value, null));
    }

    protected Resource createResource(String path, String[] extensions) {
        return new Resource(path, extensions);
    }

    protected boolean isNullValidated() {
        return false;
    }

    protected class Resource {
        public String path;
        public String[] extensions;

        public Resource(String path, String[] extensions) {
            this.path = path;
            this.extensions = extensions;
            if (this.extensions != null) {
                Arrays.sort(this.extensions);
            }
        }

        public boolean validate(ConfigManager cfgmgr) {
            if (this.extensions == null) {
                return this.validateFullPath(cfgmgr, this.path);
            }
            boolean result = false;
            for (String extension : this.extensions) {
                result |= this.validateFullPath(cfgmgr, this.path + extension);
            }
            return result;
        }

        protected boolean validateFullPath(ConfigManager cfgmgr, String path) {
            return cfgmgr.getResourceManager().getResourceFile(path).exists();
        }

        public boolean equals(Object o) {
            return o instanceof Resource && ((Resource)o).path.equals(this.path) && Arrays.equals(((Resource)o).extensions, this.extensions);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.path, this.extensions});
        }

        public String toString() {
            return this.path + ", " + Arrays.toString(this.extensions);
        }
    }
}

