/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors.util;

import com.threerings.editor.swing.editors.util.AbstractRecentList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JLabel;

public class RecentDirectoryList
extends AbstractRecentList {
    protected JFileChooser _chooser;
    protected ActionListener _actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            File file = RecentDirectoryList.this._chooser.getSelectedFile();
            if (file != null) {
                RecentDirectoryList.this.addRecent(file);
            }
        }
    };
    protected static final int BORDER = 8;

    public RecentDirectoryList(String prefsKey) {
        super(prefsKey, Preferences.userNodeForPackage(RecentDirectoryList.class).node("RecentDirectoryList"));
        this.add((Component)new JLabel("Recent Dirs"), "North");
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.setPreferredSize(new Dimension(200, 200));
    }

    @Override
    protected void valueSelected(String value) {
        if (value != null) {
            this._chooser.setCurrentDirectory(new File(value));
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Container c = this;
        while ((c = c.getParent()) != null) {
            if (!(c instanceof JFileChooser)) continue;
            this.configureChooser((JFileChooser)c);
            break;
        }
    }

    @Override
    public void removeNotify() {
        this.unconfigureChooser();
        super.removeNotify();
    }

    @Override
    protected int getMaximumChop(String value) {
        return value.lastIndexOf(File.separatorChar) + 1;
    }

    protected void addRecent(File file) {
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        this.addRecent(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureChooser(JFileChooser chooser) {
        this._chooser = chooser;
        this._chooser.setPreferredSize(null);
        Dimension dialogSize = this._chooser.getPreferredSize();
        Dimension accessorySize = this.getPreferredSize();
        dialogSize.width += accessorySize.width;
        dialogSize.height = Math.max(dialogSize.height, accessorySize.height);
        this._chooser.setPreferredSize(dialogSize);
        this._chooser.addActionListener(this._actionListener);
        this.readPrefs();
        String theKey = this._prefKey;
        this._prefKey = null;
        try {
            this.addRecent(this._chooser.getCurrentDirectory());
        }
        finally {
            this._prefKey = theKey;
        }
    }

    protected void unconfigureChooser() {
        if (this._chooser != null) {
            this._chooser.removeActionListener(this._actionListener);
            this._chooser = null;
        }
    }
}

