/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.Objects;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.StringUtil;
import com.threerings.editor.swing.PropertyEditor;
import java.awt.Container;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class StringEditor
extends PropertyEditor
implements DocumentListener {
    protected JTextComponent _field;

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        String text = StringUtil.trim((String)this._field.getText());
        if (!Objects.equal((Object)this._property.get(this._object), (Object)text)) {
            this._property.set(this._object, text);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        this._field.getDocument().removeDocumentListener(this);
        String text = StringUtil.trim((String)((String)this._property.get(this._object)));
        text = StringUtil.truncate((String)text, (int)this._property.getAnnotation().maxsize());
        this._field.setText(text);
        this._field.getDocument().addDocumentListener(this);
    }

    @Override
    protected void didInit() {
        Object panel = this;
        if (this._property.getAnnotation().collapsible()) {
            this.makeCollapsible(this._ctx, this.getPropertyLabel(), false);
            panel = this._content;
        } else {
            this.add(new JLabel(this.getPropertyLabel() + ":"));
        }
        int height = this._property.getHeight(1);
        int width = this._property.getWidth(10);
        if (height > 1) {
            JTextArea area = new JTextArea(height, width);
            area.setLineWrap(true);
            ((Container)panel).add(new JScrollPane(area));
            this._field = area;
        } else {
            this._field = new JTextField(width);
            ((Container)panel).add(this._field);
        }
        final int maxSize = this._property.getMaxSize();
        if (maxSize < Integer.MAX_VALUE) {
            SwingUtil.setDocumentHelpers((JTextComponent)this._field, (SwingUtil.DocumentValidator)new SwingUtil.DocumentValidator(){

                public boolean isValid(String text) {
                    return text.length() <= maxSize;
                }
            }, null);
        }
        this._field.setEnabled(!this._property.getAnnotation().constant());
        this._field.getDocument().addDocumentListener(this);
        this.addUnits((JPanel)panel);
    }
}

