/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.collect.ImmutableMap;
import com.samskivert.swing.CollapsiblePanel;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.util.ListUtil;
import com.samskivert.util.ObjectUtil;
import com.threerings.config.Parameter;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Log;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.editors.ArrayListEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public abstract class PanelArrayListEditor
extends ArrayListEditor {
    protected JPanel _panels;
    protected static Icon _raiseIcon;
    protected static Icon _lowerIcon;
    protected static Icon _deleteIcon;
    protected static Icon _insertIcon;

    @Override
    public void update() {
        int pcount = this._panels.getComponentCount();
        int length = this.getLength();
        for (int ii = 0; ii < length; ++ii) {
            Object value = this.getValue(ii);
            if (ii < pcount) {
                this.updatePanel((EntryPanel)((Object)this._panels.getComponent(ii)), value);
                continue;
            }
            this.addPanel(value);
        }
        while (pcount > length) {
            this._panels.remove(--pcount);
        }
        this.updatePanels();
        if (this._add != null) {
            this._add.setEnabled(this.getLength() < this._max);
        }
    }

    @Override
    public void makeVisible(int idx) {
        EntryPanel panel = (EntryPanel)((Object)this._panels.getComponent(idx));
        panel.setCollapsed(false);
        this._panels.scrollRectToVisible(panel.getBounds());
    }

    @Override
    public String getComponentPath(Component comp, boolean mouse) {
        EntryPanel entry = this.getNextChildComponent(EntryPanel.class, comp);
        return entry == null ? "" : "[" + entry.getIndex() + "]" + entry.getComponentPath(comp, mouse);
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._panels = GroupLayout.makeVBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.TOP, (GroupLayout.Policy)GroupLayout.STRETCH);
        this._content.add(this._panels);
        this._panels.setBackground(null);
        if (!this._property.getAnnotation().constant()) {
            JPanel bpanel = new JPanel();
            bpanel.setBackground(null);
            this._content.add(bpanel);
            this._add = new JButton(this.getActionLabel("new"));
            bpanel.add(this._add);
            this._add.addActionListener(this);
        }
    }

    @Override
    protected void addValue(Object value) {
        super.addValue(value);
        this.addPanel(value);
        this.updatePanels();
    }

    @Override
    protected void removeValue(int idx) {
        super.removeValue(idx);
        this._panels.remove(idx);
        this.updatePanels();
        this.updatePaths(idx, -1);
    }

    protected void insertValue(int idx, int newIdx) {
        int dir = Integer.signum(newIdx - idx);
        Object tmp = this.getValue(idx);
        for (int ii = idx; ii != newIdx; ii += dir) {
            Object val = this.getValue(ii + dir);
            this.setValue(ii, val);
            this.updatePanel((EntryPanel)((Object)this._panels.getComponent(ii)), val);
        }
        this.setValue(newIdx, tmp);
        this.updatePanel((EntryPanel)((Object)this._panels.getComponent(newIdx)), tmp);
        this.fireStateChanged(true);
        this.updatePanels();
        this.updatePaths(idx, newIdx);
    }

    protected void updatePaths(int idx, int newIdx) {
        String path = this.getPropertyPath();
        ParameterizedConfig pc = (ParameterizedConfig)ObjectUtil.as((Object)this.getRootObject(), ParameterizedConfig.class);
        if (pc == null) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (newIdx == -1) {
            builder.put((Object)this.pathIndex(path, idx), (Object)"");
            newIdx = this._panels.getComponentCount();
        } else {
            builder.put((Object)this.pathIndex(path, idx), (Object)this.pathIndex(path, newIdx));
        }
        int dir = Integer.signum(idx - newIdx);
        for (int ii = newIdx; ii != idx; ii += dir) {
            builder.put((Object)this.pathIndex(path, ii), (Object)this.pathIndex(path, ii + dir));
        }
        ImmutableMap replace = builder.build();
        boolean updated = false;
        for (Parameter param : pc.parameters) {
            if (param instanceof Parameter.Direct) {
                updated |= this.updateDirect((Parameter.Direct)param, (Map<String, String>)replace);
                continue;
            }
            if (!(param instanceof Parameter.Choice)) continue;
            for (Parameter.Direct direct : ((Parameter.Choice)param).directs) {
                updated |= this.updateDirect(direct, (Map<String, String>)replace);
            }
        }
        if (updated) {
            pc.wasUpdated();
        }
    }

    protected String pathIndex(String path, int idx) {
        return path + "[" + idx + "]";
    }

    protected boolean updateDirect(Parameter.Direct direct, Map<String, String> replace) {
        boolean updated = false;
        int nn = direct.paths.length;
        block0: for (int ii = 0; ii < nn; ++ii) {
            String path = direct.paths[ii];
            for (Map.Entry<String, String> entry : replace.entrySet()) {
                String match = entry.getKey();
                if (!path.startsWith(match)) continue;
                String repl = entry.getValue();
                direct.paths[ii] = repl.isEmpty() ? "" : repl + path.substring(match.length());
                Log.log.info((Object)"Updating direct path", new Object[]{"old", path, "new", direct.paths[ii]});
                updated = true;
                continue block0;
            }
        }
        return updated;
    }

    protected String getPropertyPath() {
        BaseEditorPanel editor = this.findBaseEditor();
        if (editor == null) {
            return "";
        }
        String path = editor.getComponentPath((Component)((Object)this), false);
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        return path;
    }

    protected abstract void addPanel(Object var1);

    protected void updatePanels() {
        int nn = this._panels.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            ((EntryPanel)((Object)this._panels.getComponent(ii))).updateButtons();
        }
        this._panels.revalidate();
    }

    protected abstract void updatePanel(EntryPanel var1, Object var2);

    protected abstract class EntryPanel
    extends CollapsiblePanel
    implements ActionListener {
        protected JButton _raise;
        protected JButton _lower;
        protected JButton _delete;
        protected JButton _highlight;
        protected JButton _insert;
        protected boolean _highlighted;
        protected TitledBorder _title;

        public EntryPanel(Object value) {
            JPanel panel = this.createPanel(value);
            if (_expandIcon == null) {
                _expandIcon = PanelArrayListEditor.this.loadIcon("expand", PanelArrayListEditor.this._ctx);
                _collapseIcon = PanelArrayListEditor.this.loadIcon("collapse", PanelArrayListEditor.this._ctx);
                _highlightIcon = PanelArrayListEditor.this.loadIcon("highlight", PanelArrayListEditor.this._ctx);
            }
            if (_raiseIcon == null) {
                _raiseIcon = PanelArrayListEditor.this.loadIcon("raise", PanelArrayListEditor.this._ctx);
                _lowerIcon = PanelArrayListEditor.this.loadIcon("lower", PanelArrayListEditor.this._ctx);
                _deleteIcon = PanelArrayListEditor.this.loadIcon("delete", PanelArrayListEditor.this._ctx);
                _insertIcon = PanelArrayListEditor.this.loadIcon("insert", PanelArrayListEditor.this._ctx);
            }
            JPanel tcont = GroupLayout.makeHBox((GroupLayout.Policy)GroupLayout.NONE, (GroupLayout.Justification)GroupLayout.RIGHT, (GroupLayout.Policy)GroupLayout.NONE);
            tcont.setOpaque(false);
            JButton expand = PanelArrayListEditor.this.createButton(_expandIcon);
            tcont.add(expand);
            this._highlight = PanelArrayListEditor.this.createButton(_highlightIcon);
            tcont.add(this._highlight);
            this._highlight.addActionListener(this);
            if (!PanelArrayListEditor.this._property.getAnnotation().constant()) {
                this._insert = PanelArrayListEditor.this.createButton(_insertIcon);
                tcont.add(this._insert);
                this._insert.addActionListener(this);
                this._raise = PanelArrayListEditor.this.createButton(_raiseIcon);
                tcont.add(this._raise);
                this._raise.addActionListener(this);
                this._lower = PanelArrayListEditor.this.createButton(_lowerIcon);
                tcont.add(this._lower);
                this._lower.addActionListener(this);
                this._delete = PanelArrayListEditor.this.createButton(_deleteIcon);
                tcont.add(this._delete);
                this._delete.addActionListener(this);
            }
            this._title = BorderFactory.createTitledBorder("");
            this.updateBorder();
            this.setBackground(null);
            this.setTrigger(expand, _expandIcon, _collapseIcon);
            expand.setHorizontalAlignment(0);
            this.add((Component)new Spacer(1, -25));
            this.setTriggerContainer(tcont, panel);
            this.setGap(5);
            this.setCollapsed(false);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2) {
                        EntryPanel.this._highlighted = !EntryPanel.this._highlighted;
                        EntryPanel.this.updateBorder();
                    }
                }
            });
        }

        public abstract String getComponentPath(Component var1, boolean var2);

        public void updateButtons() {
            int idx = this.getIndex();
            int count = PanelArrayListEditor.this._panels.getComponentCount();
            if (this._raise != null) {
                this._raise.setEnabled(idx > 0);
                this._lower.setEnabled(idx < count - 1);
                this._delete.setEnabled(!PanelArrayListEditor.this._fixed && count > PanelArrayListEditor.this._min);
                this._insert.setEnabled(!PanelArrayListEditor.this._fixed && PanelArrayListEditor.this.getLength() < PanelArrayListEditor.this._max);
            }
            this.updateBorder();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object source = event.getSource();
            if (source == this._raise) {
                int idx = this.getIndex();
                PanelArrayListEditor.this.insertValue(idx, idx - 1);
            } else if (source == this._lower) {
                int idx = this.getIndex();
                PanelArrayListEditor.this.insertValue(idx, idx + 1);
            } else if (source == this._delete) {
                PanelArrayListEditor.this.removeValue(this.getIndex());
            } else if (source == this._highlight) {
                this._highlighted = !this._highlighted;
                this.updateBorder();
            } else if (source == this._insert) {
                int idx = this.getIndex();
                PanelArrayListEditor.this.addValue();
                PanelArrayListEditor.this.insertValue(PanelArrayListEditor.this.getLength() - 1, idx);
            } else {
                super.actionPerformed(event);
            }
        }

        public void scrollRectToVisible(Rectangle rect) {
        }

        public int getIndex() {
            return ListUtil.indexOfRef((Object[])PanelArrayListEditor.this._panels.getComponents(), (Object)this);
        }

        protected void updateBorder() {
            String title = PanelArrayListEditor.this.getPropertyLabel() + " (" + this.getIndex() + ")";
            this._title = this._highlighted ? BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 2), title) : BorderFactory.createTitledBorder(title);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0), this._title));
        }

        protected abstract JPanel createPanel(Object var1);
    }
}

