/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.collect.Maps;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Config;
import com.samskivert.util.ListUtil;
import com.samskivert.util.StringUtil;
import com.threerings.editor.Log;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.util.MessageBundle;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MaskEditor
extends PropertyEditor
implements DocumentListener,
ActionListener {
    protected JFormattedTextField _field;
    protected JButton _button;
    protected JPopupMenu _popup;
    protected String[] _flags;
    protected static Map<String, String[]> _modes = Maps.newHashMap();

    public static int getFlag(String mode, String flag) {
        Object[] flags = _modes.get(mode);
        int idx = flags == null ? -1 : ListUtil.indexOf((Object[])flags, (Object)flag);
        return idx == -1 ? 0 : 1 << idx;
    }

    public static String toString(String mode, int bits) {
        if (bits == 0) {
            return "<none>";
        }
        String[] flags = _modes.get(mode);
        StringBuilder buf = new StringBuilder();
        int nn = flags.length;
        for (int ii = 0; bits != 0 && ii < nn; bits >>>= 1, ++ii) {
            if ((bits & 1) != 1) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(flags[ii]);
        }
        if (bits != 0) {
            buf.append(" _leftover-bits-").append(bits << flags.length);
        }
        return buf.toString();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.changedUpdate(null);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        long value;
        try {
            value = Long.parseLong(this._field.getText());
        }
        catch (NumberFormatException e) {
            return;
        }
        Number nvalue = this.fromLong(value);
        if (!this._property.get(this._object).equals(nvalue)) {
            this._property.set(this._object, nvalue);
            this.fireStateChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JCheckBoxMenuItem item;
        if (event.getSource() != this._button) {
            long value = 0L;
            int nn = this._popup.getComponentCount();
            for (int ii = 0; ii < nn; ++ii) {
                JCheckBoxMenuItem item2 = (JCheckBoxMenuItem)this._popup.getComponent(ii);
                int idx = ListUtil.indexOf((Object[])this._flags, (Object)item2.getText());
                if (!item2.isSelected()) continue;
                value |= 1L << idx;
            }
            Number nvalue = this.fromLong(value);
            if (!this._property.get(this._object).equals(nvalue)) {
                this._property.set(this._object, nvalue);
                this.fireStateChanged();
            }
            this.update();
            return;
        }
        if (this._popup == null) {
            this._popup = new JPopupMenu();
            for (String flag : this._flags) {
                if (StringUtil.isBlank((String)flag)) continue;
                item = new JCheckBoxMenuItem(flag);
                this._popup.add(item);
                item.addActionListener(this);
            }
        }
        long value = ((Number)this._property.get(this._object)).longValue();
        int nn = this._popup.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            int idx = ListUtil.indexOf((Object[])this._flags, (Object)(item = (JCheckBoxMenuItem)this._popup.getComponent(ii)).getText());
            item.setSelected((value & 1L << idx) != 0L);
        }
        this._popup.show(this._button, 0, this._button.getHeight());
    }

    @Override
    public void update() {
        this._field.getDocument().removeDocumentListener(this);
        this._field.setValue(this._property.get(this._object));
        this._field.getDocument().addDocumentListener(this);
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        NumberFormat fmt = NumberFormat.getIntegerInstance();
        fmt.setGroupingUsed(false);
        this._field = new JFormattedTextField(fmt);
        this.add(this._field);
        this._field.setColumns(4);
        this._field.setHorizontalAlignment(4);
        this._field.getDocument().addDocumentListener(this);
        this._button = new JButton("...");
        this.add(this._button);
        this._button.setPreferredSize(new Dimension(20, 20));
        this._button.addActionListener(this);
        String mode = this.getMode();
        String[] names = _modes.get(mode);
        if (names == null) {
            if (!StringUtil.isBlank((String)mode)) {
                Log.log.warning((Object)"Unknown mask mode.", new Object[]{"mode", mode});
            }
            this._flags = new String[8];
            for (int ii = 0; ii < this._flags.length; ++ii) {
                this._flags[ii] = String.valueOf(ii);
            }
        } else {
            MessageBundle msgs = this._ctx.getMessageManager().getBundle("editor.mask");
            this._flags = new String[names.length];
            for (int ii = 0; ii < names.length; ++ii) {
                String name = names[ii];
                this._flags[ii] = StringUtil.isBlank((String)name) ? name : this.getLabel(name, msgs);
            }
        }
    }

    protected Number fromLong(long value) {
        Class<?> type = this._property.getType();
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (int)value;
        }
        if (type == Long.TYPE || type == Long.class) {
            return value;
        }
        return (short)value;
    }

    static {
        Config config = new Config("/rsrc/config/editor/mask");
        Iterator it = config.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            _modes.put(key, config.getValue(key, ArrayUtil.EMPTY_STRING));
        }
    }
}

