/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing.editors;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.threerings.editor.Introspector;
import com.threerings.editor.swing.PropertyEditor;
import com.threerings.util.MessageBundle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class EnumEditor
extends PropertyEditor
implements ActionListener {
    protected JComboBox _box;

    @Override
    public void actionPerformed(ActionEvent event) {
        Enum<?> value = this.getValues().get(this._box.getSelectedIndex());
        if (!Objects.equal((Object)this._property.get(this._object), value)) {
            this._property.set(this._object, value);
            this.fireStateChanged();
        }
    }

    @Override
    public void update() {
        this._box.setSelectedIndex(this.getValues().indexOf(this._property.get(this._object)));
    }

    @Override
    protected void didInit() {
        this.add(new JLabel(this.getPropertyLabel() + ":"));
        final MessageBundle msgs = this._msgmgr.getBundle(Introspector.getMessageBundle(this._property.getType()));
        Object[] labels = Lists.transform(this.getValues(), (Function)new Function<Enum<?>, String>(){

            public String apply(Enum<?> value) {
                return EnumEditor.this.getLabel(value, msgs);
            }
        }).toArray();
        this._box = new JComboBox<Object>(labels);
        this.add(this._box);
        this._box.addActionListener(this);
    }

    protected List<Enum<?>> getValues() {
        Object[] constants = (Enum[])this._property.getType().getEnumConstants();
        return this._property.nullable() ? Lists.asList(null, (Object[])constants) : Arrays.asList(constants);
    }
}

