/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor.swing;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.StringUtil;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.util.EditorContext;
import com.threerings.util.MessageBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class FindDialog
extends JDialog
implements ActionListener {
    protected MessageBundle _msgs;
    protected JTextField _field;
    protected JButton _find;
    protected JLabel _status;
    protected BaseEditorPanel _epanel;
    protected String _term;
    protected JComponent _last;
    protected JComponent _first;
    protected JViewport _viewport;

    public static FindDialog createDialog(Component parent, EditorContext ctx) {
        Component root = SwingUtilities.getRoot(parent);
        MessageBundle msgs = ctx.getMessageManager().getBundle("editor.default");
        String title = msgs.get("m.find");
        FindDialog dialog = root instanceof Dialog ? new FindDialog((Dialog)root, ctx, title) : new FindDialog((Frame)(root instanceof Frame ? root : null), ctx, title);
        SwingUtil.centerWindow((Window)dialog);
        dialog.setAlwaysOnTop(true);
        return dialog;
    }

    public FindDialog(Dialog parent, EditorContext ctx, String title) {
        super(parent, title);
        this.init(ctx);
    }

    public FindDialog(Frame parent, EditorContext ctx, String title) {
        super(parent, title);
        this.init(ctx);
    }

    public void show(BaseEditorPanel epanel) {
        this.setEditorPanel(epanel);
        this.setVisible(true);
        this._field.requestFocus();
        this._field.selectAll();
        this._status.setText("");
    }

    public void setEditorPanel(BaseEditorPanel epanel) {
        if (this._epanel != epanel) {
            this._epanel = epanel;
            this._first = null;
            this._last = null;
        }
    }

    public void find(BaseEditorPanel epanel) {
        this.setEditorPanel(epanel);
        this.find();
    }

    public void find() {
        if (this._epanel == null) {
            return;
        }
        String term = StringUtil.trim((String)this._field.getText()).toLowerCase();
        if (StringUtil.isBlank((String)term)) {
            return;
        }
        if (!term.equals(this._term)) {
            this._last = null;
            this._first = null;
            this._term = term;
        }
        this._viewport = null;
        this._first = this.testTerm(this._first);
        this._last = this.testTerm(this._last);
        this.goFind((Component)((Object)this._epanel));
        this._status.setText("");
        if (this._last == null) {
            this._last = this._first;
            if (this._last != null) {
                this._status.setText(this._msgs.get("m.looped_to_top"));
            }
        }
        if (this._last != null && this._viewport != null) {
            this._viewport.scrollRectToVisible(this.getViewportBounds(this._last));
            this._last.requestFocusInWindow();
        } else {
            this._status.setText(this._msgs.get("m.not_found"));
        }
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this._find || source == this._field) {
            this.find();
        }
    }

    protected void init(EditorContext ctx) {
        this._msgs = ctx.getMessageManager().getBundle("editor.default");
        JPanel cont = GroupLayout.makeVBox();
        JPanel box = GroupLayout.makeHBox();
        this._field = new JTextField(20);
        box.add(this._field);
        this._field.addActionListener(this);
        this._find = new JButton(this._msgs.get("m.find"));
        box.add(this._find);
        this._find.addActionListener(this);
        cont.add(box);
        this._status = new JLabel();
        cont.add(this._status);
        this.add(cont);
        this.pack();
    }

    protected boolean goFind(Component comp) {
        if (this._viewport == null) {
            if (comp instanceof JScrollPane) {
                this._viewport = ((JScrollPane)comp).getViewport();
                this._first = this.testViewport(this._first);
                this._last = this.testViewport(this._last);
            }
        } else {
            JComponent found = this.testTerm(comp);
            if (found != null && this.found(found)) {
                return true;
            }
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            int nn = cont.getComponentCount();
            for (int ii = 0; ii < nn; ++ii) {
                if (!this.goFind(cont.getComponent(ii))) continue;
                return true;
            }
        }
        return false;
    }

    protected JComponent testViewport(JComponent comp) {
        if (comp != null) {
            for (Container p = comp.getParent(); p != null; p = p.getParent()) {
                if (p != this._viewport) continue;
                return comp;
            }
        }
        return null;
    }

    protected JComponent testTerm(Component comp) {
        JComponent found = null;
        if (comp instanceof JTextComponent) {
            String text = ((JTextComponent)comp).getText().toLowerCase();
            if (text.contains(this._term)) {
                found = (JComponent)comp;
            }
        } else if (comp instanceof AbstractButton) {
            String text = ((AbstractButton)comp).getText().toLowerCase();
            if (text.contains(this._term)) {
                found = (JComponent)comp;
            }
        } else if (comp instanceof JTable) {
            JTable table = (JTable)comp;
            int nn = table.getRowCount();
            block0: for (int ii = 0; ii < nn; ++ii) {
                int mm = table.getColumnCount();
                for (int jj = 0; jj < mm; ++jj) {
                    Object obj = table.getValueAt(ii, jj);
                    if (obj == null || !obj.toString().toLowerCase().contains(this._term)) continue;
                    found = table;
                    break block0;
                }
            }
        }
        return found;
    }

    protected boolean found(JComponent comp) {
        if (this._first == null) {
            this._first = comp;
        }
        if (this._last == null) {
            this._last = comp;
            return true;
        }
        if (this._last == comp) {
            this._last = null;
        }
        return false;
    }

    protected Rectangle getViewportBounds(Component comp) {
        if (comp == this._viewport) {
            return new Rectangle();
        }
        Rectangle bounds = comp.getBounds();
        Rectangle parent = this.getViewportBounds(comp.getParent());
        bounds.x += parent.x;
        bounds.y += parent.y;
        return bounds;
    }

    @Override
    protected JRootPane createRootPane() {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        JRootPane rootPane = new JRootPane();
        rootPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FindDialog.this.setVisible(false);
            }
        }, stroke, 2);
        return rootPane;
    }
}

