/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.editor;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ListUtil;
import com.threerings.editor.DynamicallyEditable;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorMessageBundle;
import com.threerings.editor.FieldProperty;
import com.threerings.editor.Log;
import com.threerings.editor.MethodProperty;
import com.threerings.editor.Property;
import com.threerings.editor.PropertyOrder;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class Introspector {
    protected static HashMap<Class<?>, String[]> _categories = new HashMap();
    protected static HashMap<Class<?>, Property[]> _properties = new HashMap();
    protected static HashMap<Class<?>, String> _bundles = new HashMap();
    protected static final Comparator<Property> WEIGHT_COMP = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            return Double.compare(p1.getAnnotation().weight(), p2.getAnnotation().weight());
        }
    };

    public static String[] getCategories(Class<?> clazz) {
        Object[] categories = _categories.get(clazz);
        if (categories == null) {
            categories = ArrayUtil.EMPTY_STRING;
            for (Property prop : Introspector.getProperties(clazz)) {
                String category = prop.getAnnotation().category();
                if (ListUtil.contains((Object[])categories, (Object)category)) continue;
                categories = (String[])ArrayUtil.append((Object[])categories, (Object)category);
            }
            if (DynamicallyEditable.class.isAssignableFrom(clazz) && !ListUtil.contains((Object[])categories, (Object)"")) {
                categories = (String[])ArrayUtil.append((Object[])categories, (Object)"");
            }
            _categories.put(clazz, (String[])categories);
        }
        return categories;
    }

    public static Property[] getProperties(Object object) {
        Object[] sprops = Introspector.getProperties(object.getClass());
        if (!(object instanceof DynamicallyEditable)) {
            return sprops;
        }
        Object[] dprops = ((DynamicallyEditable)object).getDynamicProperties();
        if (sprops.length == 0) {
            return dprops;
        }
        if (dprops.length == 0) {
            return sprops;
        }
        return (Property[])ArrayUtil.concatenate((Object[])sprops, (Object[])dprops);
    }

    public static Property[] getProperties(Class<?> clazz) {
        Property[] properties = _properties.get(clazz);
        if (properties == null) {
            properties = Introspector.createProperties(clazz);
            _properties.put(clazz, properties);
        }
        return properties;
    }

    public static String getMessageBundle(Class<?> clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            return "editor.default";
        }
        String bundle = _bundles.get(clazz);
        if (bundle == null) {
            bundle = Introspector.findMessageBundle(clazz);
            _bundles.put(clazz, bundle);
        }
        return bundle;
    }

    protected static String findMessageBundle(Class<?> clazz) {
        int idx;
        EditorMessageBundle annotation = clazz.getAnnotation(EditorMessageBundle.class);
        if (annotation != null) {
            return annotation.value();
        }
        Class<?> eclazz = clazz.getEnclosingClass();
        if (eclazz != null) {
            return Introspector.getMessageBundle(eclazz);
        }
        String name = clazz.getName();
        while ((idx = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, idx);
            try {
                Class<?> c = Class.forName(name + ".package-info");
                annotation = c.getAnnotation(EditorMessageBundle.class);
                if (annotation == null) continue;
                return annotation.value();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return "editor.default";
    }

    protected static Property[] createProperties(Class<?> clazz) {
        ArrayList<Property> properties = new ArrayList<Property>();
        Introspector.createProperties(clazz, properties);
        Collections.sort(properties, WEIGHT_COMP);
        PropertyOrder order = clazz.getAnnotation(PropertyOrder.class);
        if (order != null) {
            int index = 0;
            for (String name : order.value()) {
                int oindex = index;
                int nn = properties.size();
                for (int ii = index; ii < nn; ++ii) {
                    Property property = properties.get(ii);
                    if (!property.getName().equals(name)) continue;
                    properties.remove(ii);
                    properties.add(index++, property);
                    break;
                }
                if (index != oindex) continue;
                Log.log.warning((Object)("Missing property in order annotation [class=" + clazz.getName() + ", property=" + name + "]."), new Object[0]);
            }
        }
        return properties.toArray(new Property[properties.size()]);
    }

    protected static void createProperties(Class<?> clazz, ArrayList<Property> properties) {
        Class<?> sclazz = clazz.getSuperclass();
        if (sclazz != null) {
            Collections.addAll(properties, Introspector.getProperties(sclazz));
        }
        HashMap<String, Method> unpaired = new HashMap<String, Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            boolean getter;
            if (method.isSynthetic() || !method.isAnnotationPresent(Editable.class)) continue;
            String name = method.getName();
            if (name.startsWith("set")) {
                name = name.substring(3);
                getter = false;
            } else {
                if (name.startsWith("get")) {
                    name = name.substring(3);
                } else if (name.startsWith("is")) {
                    name = name.substring(2);
                } else {
                    Log.log.warning((Object)("Invalid method name for editable property [class=" + clazz + ", name=" + name + "]."), new Object[0]);
                    continue;
                }
                getter = true;
            }
            Method omethod = (Method)unpaired.remove(name);
            if (omethod != null) {
                Method gmethod = getter ? method : omethod;
                Method smethod = getter ? omethod : method;
                Class<?> rtype = gmethod.getReturnType();
                Class<?>[] ptypes = smethod.getParameterTypes();
                if (ptypes.length != 1 || ptypes[0] != rtype) {
                    Log.log.warning((Object)("Mismatched types on getter/setter [class=" + clazz + ", getter=" + gmethod + ", setter=" + smethod + "]."), new Object[0]);
                    continue;
                }
                properties.add(new MethodProperty(gmethod, smethod));
                continue;
            }
            unpaired.put(name, method);
        }
        if (!unpaired.isEmpty()) {
            Log.log.warning((Object)("Found unmatched getters/setters [class=" + clazz + ", methods=" + unpaired.values() + "]."), new Object[0]);
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            if (!accessibleObject.isAnnotationPresent(Editable.class)) continue;
            properties.add(new FieldProperty((Field)accessibleObject));
        }
    }
}

