/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.tools;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.ObserverList;
import com.samskivert.util.QuickSort;
import com.threerings.ClydeLog;
import com.threerings.config.ArgumentMap;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigGroupListener;
import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.DerivedConfig;
import com.threerings.config.ManagedConfig;
import com.threerings.config.swing.ConfigTree;
import com.threerings.config.swing.ConfigTreeFilterPanel;
import com.threerings.config.swing.ConfigTreeNode;
import com.threerings.config.tools.BaseConfigEditor;
import com.threerings.config.tools.ConfigSearcher;
import com.threerings.config.tools.ResourceEditor;
import com.threerings.config.util.PasteHelper;
import com.threerings.editor.Editable;
import com.threerings.editor.Introspector;
import com.threerings.editor.Property;
import com.threerings.editor.swing.BaseEditorPanel;
import com.threerings.editor.swing.EditorPanel;
import com.threerings.editor.swing.TreeEditorPanel;
import com.threerings.editor.swing.editors.ConfigReferenceEditor;
import com.threerings.editor.util.EditorContext;
import com.threerings.editor.util.Validator;
import com.threerings.media.image.ColorPository;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.resource.ResourceManager;
import com.threerings.resource.file.FileResourceManager;
import com.threerings.swing.PrintStreamDialog;
import com.threerings.util.DeepUtil;
import com.threerings.util.MessageManager;
import com.threerings.util.ResourceUtil;
import com.threerings.util.ToolUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class ConfigEditor
extends BaseConfigEditor
implements ClipboardOwner {
    protected final boolean _readOnly = ToolUtil.isReadOnly();
    protected JPopupMenu _popup;
    protected JMenuItem _save;
    protected JMenuItem _revert;
    protected JMenuItem _saveAll;
    protected JMenuItem _revertAll;
    protected JMenuItem _sync;
    protected JMenuItem _exportConfigs;
    protected Action _undo;
    protected Action _redo;
    protected Action _cut;
    protected Action _copy;
    protected Action _deepCopy;
    protected Action _paste;
    protected Action _delete;
    protected Action _findUses;
    protected Action _copyName;
    protected JCheckBoxMenuItem _treeMode;
    protected JFileChooser _chooser;
    protected JSplitPane _split;
    protected JTabbedPane _tabs;
    protected Class<?> _clipclass;
    protected ConfigGroupListener _editListener = new ConfigGroupListener(){

        @Override
        public void configAdded(ConfigEvent<ManagedConfig> event) {
            ConfigEditor.this.maybePostUndo(new ConfigEdit(ConfigEdit.Type.ADD, (ConfigGroup)event.getSource(), event.getConfig(), null));
        }

        @Override
        public void configRemoved(ConfigEvent<ManagedConfig> event) {
            ConfigEditor.this.maybePostUndo(new ConfigEdit(ConfigEdit.Type.REMOVE, (ConfigGroup)event.getSource(), null, event.getConfig()));
        }
    };
    protected UndoManager _undomgr;
    protected UndoableEditSupport _undoSupport = new UndoableEditSupport();
    protected boolean _undoing;
    protected static Function<? super EditorContext, ? extends ConfigEditor> _editorCreator;

    public static ConfigEditor create(EditorContext ctx) {
        return ConfigEditor.create(ctx, null, null);
    }

    public static ConfigEditor create(EditorContext ctx, Class<?> clazz, String name) {
        ConfigEditor editor;
        ConfigEditor configEditor = editor = _editorCreator != null ? (ConfigEditor)_editorCreator.apply((Object)ctx) : new ConfigEditor(ctx.getMessageManager(), ctx.getConfigManager(), ctx.getColorPository());
        if (clazz != null) {
            editor.select(ctx.getConfigManager(), clazz, name);
        }
        return editor;
    }

    public static void main(String[] args) {
        FileResourceManager rsrcmgr = new FileResourceManager("rsrc/");
        MessageManager msgmgr = new MessageManager("i18n", (ResourceManager)rsrcmgr);
        ConfigManager cfgmgr = new ConfigManager((ResourceManager)rsrcmgr, msgmgr, "config/");
        ColorPository colorpos = ColorPository.loadColorPository((ResourceManager)rsrcmgr);
        new ConfigEditor(msgmgr, cfgmgr, colorpos).setVisible(true);
    }

    public ConfigEditor(MessageManager msgmgr, ConfigManager cfgmgr, ColorPository colorpos) {
        this(msgmgr, cfgmgr, colorpos, null, null);
    }

    public ConfigEditor(MessageManager msgmgr, ConfigManager cfgmgr, ColorPository colorpos, Class<?> clazz, String name) {
        super(msgmgr, cfgmgr, colorpos, "editor.config");
        this._undomgr = new UndoManager();
        this._undoSupport.addUndoableEditListener(this._undomgr);
        this._undomgr.setLimit(10000);
        this._undoSupport.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent event) {
                ConfigEditor.this.updateUndoActions();
            }
        });
        JMenuBar menubar = new JMenuBar();
        this.setJMenuBar(menubar);
        JMenu file = this.createMenu("file", 70);
        menubar.add(file);
        JMenu nmenu = this.createMenu("new", 78);
        file.add(nmenu);
        nmenu.add(this.createMenuItem("window", 87, 78));
        nmenu.addSeparator();
        Action nconfig = this.createAction("config", 67, 79);
        nmenu.add(new JMenuItem(nconfig));
        Action nfolder = this.createAction("folder", 70, 68);
        nmenu.add(new JMenuItem(nfolder));
        file.addSeparator();
        this._save = this.createMenuItem("save_group", 83, 83);
        file.add(this._save);
        this._revert = this.createMenuItem("revert_group", 82, 82);
        file.add(this._revert);
        file.addSeparator();
        JMenuItem importGroup = this.createMenuItem("import_group", 73, 73);
        file.add(importGroup);
        file.add(this.createMenuItem("export_group", 69, 69));
        file.addSeparator();
        JMenuItem importConfigs = this.createMenuItem("import_configs", 77, -1);
        file.add(importConfigs);
        this._exportConfigs = this.createMenuItem("export_configs", 88, -1);
        file.add(this._exportConfigs);
        file.addSeparator();
        file.add(this.createMenuItem("close", 67, 87));
        file.add(this.createMenuItem("quit", 81, 81));
        if (this._readOnly) {
            nconfig.setEnabled(false);
            nfolder.setEnabled(false);
            importGroup.setEnabled(false);
            importConfigs.setEnabled(false);
        }
        final JMenu edit = this.createMenu("edit", 69);
        menubar.add(edit);
        this._undo = this.createAction("undo", 85, 90);
        edit.add(this._undo);
        this._undo.setEnabled(false);
        this._redo = this.createAction("redo", 82, 89);
        edit.add(this._redo);
        this._redo.setEnabled(false);
        edit.addSeparator();
        final int CUT_INDEX = edit.getItemCount();
        this._cut = this.createAction("cut", 84, 88);
        edit.add(new JMenuItem(this._cut));
        this._copy = this.createAction("copy", 67, 67);
        edit.add(new JMenuItem(this._copy));
        this._deepCopy = this.createAction("deep_copy", 66, 66);
        edit.add(new JMenuItem(this._deepCopy));
        this._paste = this.createAction("paste", 80, 86);
        edit.add(new JMenuItem(this._paste));
        this._delete = this.createAction("delete", 68, 127, 0);
        edit.add(new JMenuItem(this._delete));
        this.addFindMenu(edit);
        edit.addSeparator();
        this._findUses = this.createAction("find_uses", 0, -1);
        edit.add(new JMenuItem(this._findUses));
        edit.addSeparator();
        edit.add(this.createMenuItem("validate_refs", 86, -1));
        this.addEditMenuItems(edit);
        edit.addSeparator();
        edit.add(this.createMenuItem("resources", 82, 85));
        edit.add(this.createMenuItem("preferences", 70, -1));
        edit.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent event) {
                TreeEditorPanel panel = (TreeEditorPanel)((Object)SwingUtilities.getAncestorOfClass(TreeEditorPanel.class, ConfigEditor.this.getFocusOwner()));
                if (panel != null) {
                    edit.getItem(CUT_INDEX).setAction(panel.getCutAction());
                    edit.getItem(CUT_INDEX + 1).setAction(panel.getCopyAction());
                    edit.getItem(CUT_INDEX + 2).setAction(panel.getPasteAction());
                    edit.getItem(CUT_INDEX + 3).setAction(panel.getDeleteAction());
                } else {
                    this.restoreActions();
                }
            }

            @Override
            public void menuDeselected(MenuEvent event) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.restoreActions();
                    }
                });
            }

            @Override
            public void menuCanceled(MenuEvent event) {
            }

            protected void restoreActions() {
                edit.getItem(CUT_INDEX).setAction(ConfigEditor.this._cut);
                edit.getItem(CUT_INDEX + 1).setAction(ConfigEditor.this._copy);
                edit.getItem(CUT_INDEX + 2).setAction(ConfigEditor.this._paste);
                edit.getItem(CUT_INDEX + 3).setAction(ConfigEditor.this._delete);
                edit.getItem(CUT_INDEX + 4).setAction(ConfigEditor.this._deepCopy);
            }
        });
        JMenu view = this.createMenu("view", 86);
        menubar.add(view);
        this._treeMode = ToolUtil.createCheckBoxMenuItem(this, this._msgs, "tree_mode", 84, -1);
        view.add(this._treeMode);
        JMenu gmenu = this.createMenu("groups", 71);
        menubar.add(gmenu);
        this._saveAll = this.createMenuItem("save_all", 83, 65);
        gmenu.add(this._saveAll);
        this._revertAll = this.createMenuItem("revert_all", 82, 84);
        gmenu.add(this._revertAll);
        this._popup = new JPopupMenu();
        nmenu = this.createMenu("new", 78);
        this._popup.add(nmenu);
        nmenu.add(new JMenuItem(nconfig));
        nmenu.add(new JMenuItem(nfolder));
        this._popup.addSeparator();
        this._popup.add(new JMenuItem(this._findUses));
        this._popup.addSeparator();
        this._popup.add(new JMenuItem(this._cut));
        this._popup.add(new JMenuItem(this._copy));
        this._popup.add(new JMenuItem(this._deepCopy));
        this._popup.add(new JMenuItem(this._paste));
        this._popup.add(new JMenuItem(this._delete));
        this._popup.addSeparator();
        this._popup.add(new JMenuItem(this.createAction("copy_name", 75, 77)));
        this._sync = new JMenuItem(this.createAction("sync", 75, 75));
        this._chooser = new JFileChooser(_prefs.get("config_dir", null));
        this._chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.toString() != null && file.toString().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return ConfigEditor.this._msgs.get("m.xml_files");
            }
        });
        this._split = new JSplitPane(1, true);
        this.add((Component)this._split, "Center");
        if (this._readOnly) {
            this._split.setBorder(new LineBorder(Color.RED));
        }
        this._tabs = new JTabbedPane();
        this._split.setLeftComponent(this._tabs);
        this._tabs.setPreferredSize(new Dimension(250, 1));
        this._tabs.setMaximumSize(new Dimension(250, Integer.MAX_VALUE));
        final ConfigManager cfg = cfgmgr;
        ConfigReferenceEditor.initOuter(new EditorContext(){

            @Override
            public ResourceManager getResourceManager() {
                return ConfigEditor.this._rsrcmgr;
            }

            @Override
            public MessageManager getMessageManager() {
                return ConfigEditor.this._msgmgr;
            }

            @Override
            public ConfigManager getConfigManager() {
                return cfg;
            }

            @Override
            public ColorPository getColorPository() {
                return ConfigEditor.this._colorpos;
            }
        });
        ConfigManager outer = ConfigReferenceEditor.getOuterManager();
        if (outer != null) {
            this._tabs.add(new ManagerPanel(outer), "OUTER", 0);
        }
        while (cfgmgr != null) {
            this._tabs.add(new ManagerPanel(cfgmgr), this.getLabel(cfgmgr.getType()), 0);
            cfgmgr = cfgmgr.getParent();
        }
        ManagerPanel panel = (ManagerPanel)this._tabs.getComponentAt(0);
        this._tabs.setSelectedComponent(panel);
        panel.activate();
        this._tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                ((ManagerPanel)ConfigEditor.this._tabs.getSelectedComponent()).activate();
            }
        });
        this.setSize(850, 600);
        SwingUtil.centerWindow((Window)this);
        this.restorePrefs();
        if (clazz != null) {
            this.select(cfgmgr, clazz, name);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        String action = event.getActionCommand();
        ManagerPanel panel = (ManagerPanel)this._tabs.getSelectedComponent();
        ManagerPanel.GroupItem item = (ManagerPanel.GroupItem)panel.gbox.getSelectedItem();
        if (action.equals("window")) {
            this.showFrame(ConfigEditor.create(this));
        } else if (action.equals("config")) {
            item.newConfig();
        } else if (action.equals("folder")) {
            item.newFolder();
        } else if (action.equals("save_group")) {
            item.group.save();
            DirtyGroupManager.setDirty(item.group, false);
        } else if (action.equals("revert_group")) {
            if (!DirtyGroupManager.isDirty(item.group) || this.showCantUndo()) {
                item.group.revert();
                DirtyGroupManager.setDirty(item.group, false);
            }
        } else if (action.equals("import_group")) {
            item.importGroup();
        } else if (action.equals("export_group")) {
            item.exportGroup();
        } else if (action.equals("import_configs")) {
            item.importConfigs();
        } else if (action.equals("export_configs")) {
            item.exportConfigs();
        } else if (action.equals("undo")) {
            this._undoing = true;
            try {
                this._undomgr.undo();
            }
            finally {
                this._undoing = false;
            }
            this.updateUndoActions();
        } else if (action.equals("redo")) {
            this._undoing = true;
            try {
                this._undomgr.redo();
            }
            finally {
                this._undoing = false;
            }
            this.updateUndoActions();
        } else if (action.equals("cut")) {
            item.cutNode();
        } else if (action.equals("copy")) {
            item.copyNode();
        } else if (action.equals("deep_copy")) {
            item.deepCopyNode();
        } else if (action.equals("paste")) {
            item.pasteNode();
        } else if (action.equals("delete")) {
            item.deleteNode();
        } else if (action.equals("find_uses")) {
            this.findUses(panel.getSelected(), item.group.getConfigClass(), null != panel.getEditorPanel().getObject());
        } else if (action.equals("validate_refs")) {
            this.validateReferences();
        } else if (action.equals("resources")) {
            this.showFrame(new ResourceEditor(this._msgmgr, this._cfgmgr, this._colorpos));
        } else if (action.equals("tree_mode")) {
            boolean enabled = this._treeMode.isSelected();
            for (int ii = this._tabs.getComponentCount() - 1; ii >= 0; --ii) {
                ((ManagerPanel)this._tabs.getComponentAt(ii)).setTreeModeEnabled(enabled);
            }
        } else if (action.equals("save_all")) {
            panel.cfgmgr.saveAll();
            DirtyGroupManager.setDirty(panel.cfgmgr, false);
        } else if (action.equals("revert_all")) {
            if (!DirtyGroupManager.isDirty(panel.cfgmgr) || this.showCantUndo()) {
                panel.cfgmgr.revertAll();
                DirtyGroupManager.setDirty(panel.cfgmgr, false);
            }
        } else if (action.equals("copy_name")) {
            item.copyName();
        } else if (action.equals("quit")) {
            if (!DirtyGroupManager.anyDirty() || this.showUnsavedChanges()) {
                super.actionPerformed(event);
            }
        } else if (action.equalsIgnoreCase("sync")) {
            Class<ManagedConfig> type = item.group.getConfigClass();
            ConfigManager manager = this._cfgmgr;
            while (manager.getParent() != null) {
                manager = manager.getParent();
            }
            ConfigGroup<ManagedConfig> group = manager.getGroup(type);
            ManagedConfig config = ConfigReferenceEditor.getOuterManager().getConfig(type, item.getName());
            if (config != null) {
                try {
                    group.addConfig(config);
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)"sync error", new Object[]{e});
                    group.removeConfig(config);
                }
            } else {
                int result = JOptionPane.showConfirmDialog(this, "Sync All configs under the folder=" + item.getName(), "Sync Folder", 0);
                if (result == 0) {
                    ConfigGroup<ManagedConfig> outer = ConfigReferenceEditor.getOuterManager().getGroup(type);
                    Iterable<ManagedConfig> array = outer.getConfigs();
                    for (ManagedConfig old : array) {
                        if (!old.getName().startsWith(item.getName()) || group.getConfig(old.getName()) != null) continue;
                        try {
                            group.addConfig(old);
                        }
                        catch (Exception e) {
                            ClydeLog.log.warning((Object)"sync error", new Object[]{e});
                            group.removeConfig(config);
                        }
                    }
                }
            }
        } else {
            super.actionPerformed(event);
        }
    }

    @Override
    public void dispose() {
        if (DirtyGroupManager.getRegisteredEditorCount() == 1) {
            boolean dirty = false;
            int nn = this._tabs.getComponentCount();
            for (int ii = 0; ii < nn; ++ii) {
                dirty |= DirtyGroupManager.isDirty(((ManagerPanel)this._tabs.getComponentAt((int)ii)).cfgmgr);
            }
            if (dirty && !this.showUnsavedChanges()) {
                return;
            }
        }
        super.dispose();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (!this._readOnly) {
            DirtyGroupManager.registerEditor(this);
        }
    }

    @Override
    public void removeNotify() {
        DirtyGroupManager.unregisterEditor(this);
        super.removeNotify();
        int nn = this._tabs.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            ((ManagerPanel)this._tabs.getComponentAt(ii)).dispose();
        }
    }

    protected void recheckDirty() {
        int nn = this._tabs.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            SwingUtil.refresh((JComponent)((ManagerPanel)this._tabs.getComponentAt((int)ii)).gbox);
        }
    }

    protected void updateUndoActions() {
        boolean canUndo = this._undomgr.canUndo();
        this._undo.setEnabled(canUndo);
        this._undo.putValue("ShortDescription", canUndo ? this._undomgr.getUndoPresentationName() : "");
        boolean canRedo = this._undomgr.canRedo();
        this._redo.setEnabled(canRedo);
        this._redo.putValue("ShortDescription", canRedo ? this._undomgr.getRedoPresentationName() : "");
    }

    protected void select(ConfigManager cfgmgr, Class<?> clazz, String name) {
        ConfigManager local = cfgmgr;
        do {
            for (int ii = this._tabs.getComponentCount() - 1; ii >= 0; --ii) {
                ManagerPanel panel = (ManagerPanel)this._tabs.getComponentAt(ii);
                if (panel.getConfigManager() != local || !panel.select(clazz, name)) continue;
                return;
            }
        } while ((local = local.getParent()) != null);
    }

    protected boolean showCantUndo() {
        return this.showConfirm("m.cant_undo", "t.cant_undo");
    }

    protected boolean showUnsavedChanges() {
        return this.showConfirm("m.unsaved_changes", "t.unsaved_changes");
    }

    protected boolean showConfirm(String msg, String title) {
        Object[] options = new String[]{UIManager.getString("OptionPane.okButtonText"), UIManager.getString("OptionPane.cancelButtonText")};
        return 0 == JOptionPane.showOptionDialog(this, this._msgs.get(msg), this._msgs.get(title), 2, 2, null, options, options[1]);
    }

    protected void findUses(final String cfgNameOrPrefix, Class<? extends ManagedConfig> clazz, final boolean exact) {
        if (cfgNameOrPrefix == null) {
            return;
        }
        new ConfigSearcher(this, cfgNameOrPrefix, ConfigSearcher.Presence.getReporter(clazz, new Predicate<ConfigReference<?>>(){

            public boolean apply(ConfigReference<?> ref) {
                return exact ? ref.getName().equals(cfgNameOrPrefix) : ref.getName().startsWith(cfgNameOrPrefix);
            }
        }), this.getSearcherDomains());
    }

    protected Iterable<ConfigSearcher.Domain> getSearcherDomains() {
        return ImmutableList.of((Object)new ConfigSearcher.ConfigDomain(this));
    }

    protected void validateReferences() {
        PrintStreamDialog dialog = new PrintStreamDialog((Frame)this, this._msgs.get("m.validate_refs"), this._msgs.get("b.ok"));
        PrintStream stream = dialog.getPrintStream();
        try {
            this.validateReferences(this.createValidator(stream));
        }
        catch (Exception e) {
            stream.println("Exception while validating!!");
            e.printStackTrace(stream);
        }
        dialog.maybeShow();
    }

    protected void validateReferences(Validator validator) {
        this._cfgmgr.validateReferences(validator);
    }

    protected Validator createValidator(PrintStream out) {
        return new Validator(out);
    }

    protected PasteHelper createPasteHelper(ConfigGroup<?> group) {
        return new PasteHelper();
    }

    protected void addEditMenuItems(JMenu edit) {
    }

    @Override
    protected BaseEditorPanel getFindEditorPanel() {
        return ((ManagerPanel)this._tabs.getSelectedComponent()).getEditorPanel();
    }

    @Override
    protected ConfigEditorPrefs createEditablePrefs(Preferences prefs) {
        return new ConfigEditorPrefs(_prefs);
    }

    protected void restorePrefs() {
        final String p = this.getConfigKey();
        this._eprefs.bindWindowBounds(p, this);
        this._eprefs.bindDividerLocation(p + "div", this._split);
        String cat = _prefs.get(p + "group", null);
        for (int tab = this._tabs.getComponentCount() - 1; tab >= 0; --tab) {
            final JComboBox gbox = ((ManagerPanel)this._tabs.getComponentAt((int)tab)).gbox;
            if (cat != null) {
                int nn = gbox.getItemCount();
                for (int ii = 0; ii < nn; ++ii) {
                    if (!cat.equals(String.valueOf(gbox.getItemAt(ii)))) continue;
                    gbox.setSelectedIndex(ii);
                    break;
                }
            }
            gbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    BaseConfigEditor._prefs.put(p + "group", String.valueOf(gbox.getSelectedItem()));
                }
            });
        }
        this.setBackground(((ConfigEditorPrefs)this._eprefs).getBackgroundColor());
    }

    protected void setBackground(Color4f color) {
        Color c = color.getColor();
        this.setBackground(c);
        this.getContentPane().setBackground(c);
        int nn = this._tabs.getComponentCount();
        for (int ii = 0; ii < nn; ++ii) {
            ((ManagerPanel)this._tabs.getComponentAt(ii)).setBackground(c);
        }
    }

    protected String getConfigKey() {
        return "ConfigEditor." + ResourceUtil.getPrefsPrefix() + (this._readOnly ? ".readonly" : "");
    }

    protected void maybePostUndo(ConfigEdit edit) {
        if (!this._undoing) {
            this._undoSupport.postEdit(edit);
        }
    }

    protected static class ConfigEdit
    extends AbstractUndoableEdit {
        protected Type _type;
        protected ConfigGroup<?> _group;
        protected ManagedConfig _new;
        protected ManagedConfig _old;
        protected String _diffKey;

        public ConfigEdit(Type type, ConfigGroup<?> group, ManagedConfig newValue, ManagedConfig oldValue) {
            this._type = type;
            this._group = group;
            this._new = newValue;
            this._old = oldValue;
            if (this._type == Type.CHANGE) {
                this._diffKey = this.findFirstDiffLineage(newValue, oldValue);
            }
        }

        @Override
        public boolean addEdit(UndoableEdit edit) {
            if (!(edit instanceof ConfigEdit)) {
                return false;
            }
            ConfigEdit that = (ConfigEdit)edit;
            if (this._type != Type.CHANGE || that._type != Type.CHANGE || this._group != that._group || !this._new.getName().equals(that._new.getName()) || that._diffKey != null && !that._diffKey.equals(this._diffKey)) {
                return false;
            }
            this._new = that._new;
            that.die();
            return true;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            switch (this._type) {
                case CHANGE: 
                case REMOVE: {
                    this._group.addConfig(this._old);
                    break;
                }
                case ADD: {
                    this._group.removeConfig(this._new);
                    break;
                }
                default: {
                    this.unknownType();
                }
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            switch (this._type) {
                case CHANGE: 
                case ADD: {
                    this._group.addConfig(this._new);
                    break;
                }
                case REMOVE: {
                    this._group.removeConfig(this._old);
                    break;
                }
                default: {
                    this.unknownType();
                }
            }
        }

        @Override
        public String getPresentationName() {
            StringBuilder buf = new StringBuilder(this._type.toString()).append(':').append(this._group.getName()).append(" \"").append(this.getConfigName()).append('\"');
            if (this._diffKey != null) {
                buf.append(' ').append(this._diffKey);
            }
            return buf.toString();
        }

        protected String getConfigName() {
            switch (this._type) {
                case CHANGE: 
                case ADD: {
                    return this._new.getName();
                }
                case REMOVE: {
                    return this._old.getName();
                }
            }
            return (String)this.unknownType();
        }

        protected <T> T unknownType() throws RuntimeException {
            throw new RuntimeException("Unhandled type: " + (Object)((Object)this._type));
        }

        protected String findFirstDiffLineage(Object one, Object two) {
            Property[] p2;
            Class<?> c2;
            if (one == two) {
                return null;
            }
            Class<?> c1 = one == null ? null : one.getClass();
            Class<?> clazz = c2 = two == null ? null : two.getClass();
            if (c1 != c2) {
                return "";
            }
            if (c1 == ConfigReference.class) {
                ConfigReference r1 = (ConfigReference)one;
                ConfigReference r2 = (ConfigReference)two;
                if (!r1.getName().equals(r2.getName())) {
                    return "._name";
                }
                ArgumentMap am1 = r1.getArguments();
                ArgumentMap am2 = r2.getArguments();
                if (am1.size() != am2.size()) {
                    return "._args";
                }
                for (Map.Entry<String, Object> entry : am1.entrySet()) {
                    String s = this.findFirstDiffLineage(entry.getValue(), am2.get(entry.getKey()));
                    if (s == null) continue;
                    return "." + entry.getKey() + s;
                }
                return null;
            }
            if (c1.isArray()) {
                int arrayLength = Array.getLength(one);
                if (arrayLength != Array.getLength(two)) {
                    return "._length";
                }
                for (int ii = 0; ii < arrayLength; ++ii) {
                    String s = this.findFirstDiffLineage(Array.get(one, ii), Array.get(two, ii));
                    if (s == null) continue;
                    return ".[" + ii + "]" + s;
                }
                return null;
            }
            Property[] p1 = Introspector.getProperties(one);
            if (p1.length != (p2 = Introspector.getProperties(two)).length) {
                return "";
            }
            if (p1.length == 0) {
                return DeepUtil.equals(one, two) ? null : "";
            }
            for (int ii = 0; ii < p1.length; ++ii) {
                Object po2;
                if (p1[ii] != p2[ii]) {
                    return "";
                }
                Object po1 = p1[ii].get(one);
                String path = this.findFirstDiffLineage(po1, po2 = p2[ii].get(two));
                if (path == null) continue;
                return "." + p1[ii].getName() + path;
            }
            return null;
        }

        public static enum Type {
            CHANGE,
            ADD,
            REMOVE;

        }
    }

    protected static class DirtyGroupManager {
        protected static Map<ConfigGroup<?>, Boolean> _dirty = CacheBuilder.newBuilder().concurrencyLevel(1).weakKeys().build().asMap();
        protected static ObserverList<ConfigEditor> _editors = ObserverList.newFastUnsafe();

        protected DirtyGroupManager() {
        }

        public static void registerEditor(ConfigEditor editor) {
            _editors.add((Object)editor);
        }

        public static void unregisterEditor(ConfigEditor editor) {
            _editors.remove((Object)editor);
        }

        public static int getRegisteredEditorCount() {
            return _editors.size();
        }

        public static void setDirty(ConfigManager cfgmgr, boolean dirty) {
            for (ConfigGroup<?> group : cfgmgr.getGroups()) {
                DirtyGroupManager.setDirty(group, dirty);
            }
        }

        public static void setDirty(ConfigGroup<?> group, boolean dirty) {
            Boolean oldVal = _dirty.put(group, dirty);
            boolean oldDirty = Boolean.TRUE.equals(oldVal);
            if (dirty != oldDirty) {
                _editors.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ConfigEditor>(){

                    public boolean apply(ConfigEditor editor) {
                        editor.recheckDirty();
                        return true;
                    }
                });
            }
        }

        public static boolean isDirty(ConfigManager cfgmgr) {
            for (ConfigGroup<?> group : cfgmgr.getGroups()) {
                if (!DirtyGroupManager.isDirty(group)) continue;
                return true;
            }
            return false;
        }

        public static boolean isDirty(ConfigGroup<?> group) {
            return Boolean.TRUE.equals(_dirty.get(group));
        }

        public static boolean anyDirty() {
            for (Boolean b : _dirty.values()) {
                if (!Boolean.TRUE.equals(b)) continue;
                return true;
            }
            return false;
        }
    }

    protected class ConfigEditorPrefs
    extends ToolUtil.EditablePrefs {
        public ConfigEditorPrefs(Preferences prefs) {
            super(prefs);
        }

        @Editable(weight=3.0)
        public void setBackgroundColor(Color4f color) {
            this.putPref(ConfigEditor.this.getConfigKey() + "background_color", color);
            ConfigEditor.this.setBackground(color);
        }

        @Editable
        public Color4f getBackgroundColor() {
            return this.getPref(ConfigEditor.this.getConfigKey() + "background_color", ConfigEditor.this._readOnly ? Color4f.RED : Color4f.GRAY);
        }
    }

    protected class ManagerPanel
    extends JPanel
    implements EditorContext,
    ItemListener,
    ChangeListener {
        public ConfigManager cfgmgr;
        public JComboBox gbox;
        protected ConfigTreeFilterPanel _filterPanel;
        protected JScrollPane _pane;
        protected BaseEditorPanel _epanel;

        public ManagerPanel(ConfigManager cfgmgr) {
            super((LayoutManager)new VGroupLayout(GroupLayout.STRETCH, GroupLayout.STRETCH, 5, GroupLayout.TOP));
            this.cfgmgr = cfgmgr;
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel gpanel = GroupLayout.makeHStretchBox((int)5);
            this.add((Component)gpanel, GroupLayout.FIXED);
            gpanel.add((Component)new JLabel(ConfigEditor.this._msgs.get("m.group")), GroupLayout.FIXED);
            Collection<ConfigGroup<?>> groups = cfgmgr.getGroups();
            Object[] items = new GroupItem[groups.size()];
            int idx = 0;
            for (ConfigGroup<?> group : groups) {
                group.addListener(ConfigEditor.this._editListener);
                items[idx++] = new GroupItem(group);
            }
            QuickSort.sort((Object[])items, (Comparator)new Comparator<GroupItem>(){

                @Override
                public int compare(GroupItem g1, GroupItem g2) {
                    return String.CASE_INSENSITIVE_ORDER.compare(g1.toString(), g2.toString());
                }
            });
            this.gbox = new JComboBox<Object>(items);
            gpanel.add(this.gbox);
            this.gbox.addItemListener(this);
            this._filterPanel = new ConfigTreeFilterPanel(ConfigEditor.this._msgmgr);
            this.add((Component)this._filterPanel, VGroupLayout.FIXED);
            this._pane = new JScrollPane();
            this.add(this._pane);
            this._epanel = new EditorPanel((EditorContext)this, EditorPanel.CategoryMode.TABS, null);
            this._epanel.addChangeListener(this);
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            if (this._pane != null) {
                this._pane.setBackground(c);
                this._epanel.setBackground(c);
            }
        }

        public void activate() {
            ConfigEditor.this._split.setRightComponent((Component)((Object)this._epanel));
            SwingUtil.refresh((JComponent)((Object)this._epanel));
            GroupItem group = (GroupItem)this.gbox.getSelectedItem();
            if (group != null) {
                group.activate();
            }
            boolean writeable = !ConfigEditor.this._readOnly;
            boolean enable = writeable && this.cfgmgr.getConfigPath() != null;
            ConfigEditor.this._save.setEnabled(enable);
            ConfigEditor.this._revert.setEnabled(enable);
            ConfigEditor.this._saveAll.setEnabled(enable);
            ConfigEditor.this._revertAll.setEnabled(enable);
        }

        public boolean select(Class<?> clazz, String name) {
            int nn = this.gbox.getItemCount();
            for (int ii = 0; ii < nn; ++ii) {
                GroupItem item = (GroupItem)this.gbox.getItemAt(ii);
                if (item.group.getConfigClass() != clazz) continue;
                return item.select(name);
            }
            return false;
        }

        public String getSelected() {
            return ((GroupItem)this.gbox.getSelectedItem()).getSelected();
        }

        public void setTreeModeEnabled(boolean enabled) {
            BaseEditorPanel opanel = this._epanel;
            this._epanel = enabled ? new TreeEditorPanel(this) : new EditorPanel(this, EditorPanel.CategoryMode.TABS);
            this._epanel.addChangeListener(this);
            this._epanel.setObject(opanel.getObject());
            if (ConfigEditor.this._split.getRightComponent() == opanel) {
                ConfigEditor.this._split.setRightComponent((Component)((Object)this._epanel));
                SwingUtil.refresh((JComponent)((Object)this._epanel));
            }
        }

        public void dispose() {
            int nn = this.gbox.getItemCount();
            for (int ii = 0; ii < nn; ++ii) {
                ((GroupItem)this.gbox.getItemAt(ii)).dispose();
            }
        }

        public BaseEditorPanel getEditorPanel() {
            return this._epanel;
        }

        @Override
        public ResourceManager getResourceManager() {
            return ConfigEditor.this._rsrcmgr;
        }

        @Override
        public MessageManager getMessageManager() {
            return ConfigEditor.this._msgmgr;
        }

        @Override
        public ConfigManager getConfigManager() {
            return this.cfgmgr;
        }

        @Override
        public ColorPository getColorPository() {
            return ConfigEditor.this._colorpos;
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            ((GroupItem)this.gbox.getSelectedItem()).activate();
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            ((GroupItem)this.gbox.getSelectedItem()).configChanged();
        }

        public class GroupItem
        implements TreeSelectionListener {
            public ConfigGroup<ManagedConfig> group;
            protected String _label;
            protected ConfigTree _tree;
            protected ManagedConfig _lastValue;

            public GroupItem(ConfigGroup<?> group) {
                ConfigGroup<?> mgroup = group;
                this.group = mgroup;
                this.group.addListener(new ConfigGroupListener(){

                    @Override
                    public void configAdded(ConfigEvent<ManagedConfig> evt) {
                        DirtyGroupManager.setDirty(GroupItem.this.group, true);
                    }

                    @Override
                    public void configRemoved(ConfigEvent<ManagedConfig> evt) {
                        DirtyGroupManager.setDirty(GroupItem.this.group, true);
                    }
                });
                this._label = ConfigEditor.this.getLabel(group.getConfigClass(), group.getName());
            }

            public String getItemName() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                return node.getConfig().getName();
            }

            public String getName() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                return node.getName();
            }

            public void copyName() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                StringSelection stringSelection = new StringSelection(node.getConfig() == null ? node.getName() : node.getConfig().getName());
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }

            public void activate() {
                if (this._tree == null) {
                    this._tree = new ConfigTree(this.group, true){

                        @Override
                        public void selectedConfigUpdated() {
                            super.selectedConfigUpdated();
                            ManagerPanel.this._epanel.update();
                        }

                        @Override
                        protected PasteHelper createPasteHelper(ConfigGroup<?> group) {
                            return ConfigEditor.this.createPasteHelper(group);
                        }
                    };
                    this._tree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                    this._tree.addTreeSelectionListener(this);
                    this._tree.setComponentPopupMenu(ConfigEditor.this._popup);
                    InputMap imap = this._tree.getInputMap();
                    imap.put(KeyStroke.getKeyStroke(88, 2), "noop");
                    imap.put(KeyStroke.getKeyStroke(67, 2), "noop");
                    imap.put(KeyStroke.getKeyStroke(86, 2), "noop");
                }
                if (this.group.getConfigManager() == ConfigReferenceEditor.getOuterManager()) {
                    ConfigEditor.this._popup.add(ConfigEditor.this._sync);
                } else {
                    ConfigEditor.this._popup.remove(ConfigEditor.this._sync);
                }
                ManagerPanel.this._pane.setViewportView(this._tree);
                ManagerPanel.this._filterPanel.setTree(this._tree);
                ConfigEditor.this._paste.setEnabled(ConfigEditor.this._clipclass == this.group.getConfigClass() && !ConfigEditor.this._readOnly);
                this.updateSelection();
            }

            public void newConfig() {
                Class<?> clazz = this.group.getRawConfigClasses().get(0);
                try {
                    ManagedConfig cfg = (ManagedConfig)clazz.newInstance();
                    if (cfg instanceof DerivedConfig) {
                        ((DerivedConfig)cfg).cclass = this.group.getConfigClass();
                    }
                    this.newNode(cfg);
                }
                catch (Exception e) {
                    ClydeLog.log.warning((Object)("Failed to instantiate config [class=" + clazz + "]."), new Object[]{e});
                }
            }

            public void newFolder() {
                this.newNode(null);
            }

            public void importGroup() {
                if (ConfigEditor.this._chooser.showOpenDialog(ConfigEditor.this) == 0) {
                    this.group.load(ConfigEditor.this._chooser.getSelectedFile());
                }
                BaseConfigEditor._prefs.put("config_dir", ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void exportGroup() {
                if (ConfigEditor.this._chooser.showSaveDialog(ConfigEditor.this) == 0) {
                    this.group.save(ConfigEditor.this._chooser.getSelectedFile());
                }
                BaseConfigEditor._prefs.put("config_dir", ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void importConfigs() {
                if (ConfigEditor.this._chooser.showOpenDialog(ConfigEditor.this) == 0) {
                    this.group.load(ConfigEditor.this._chooser.getSelectedFile(), true);
                }
                BaseConfigEditor._prefs.put("config_dir", ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void exportConfigs() {
                if (ConfigEditor.this._chooser.showOpenDialog(ConfigEditor.this) == 0) {
                    ArrayList<ManagedConfig> configs = new ArrayList<ManagedConfig>();
                    this._tree.getSelectedNode().getConfigs(configs);
                    this.group.save(configs, ConfigEditor.this._chooser.getSelectedFile());
                }
                BaseConfigEditor._prefs.put("config_dir", ConfigEditor.this._chooser.getCurrentDirectory().toString());
            }

            public void cutNode() {
                this.copyNode();
                this.deleteNode();
            }

            public void copyNode() {
                Clipboard clipboard = this._tree.getToolkit().getSystemClipboard();
                clipboard.setContents(this._tree.createClipboardTransferable(false), ConfigEditor.this);
                ConfigEditor.this._clipclass = this.group.getConfigClass();
                ConfigEditor.this._paste.setEnabled(!ConfigEditor.this._readOnly);
            }

            public void deepCopyNode() {
                Clipboard clipboard = this._tree.getToolkit().getSystemClipboard();
                clipboard.setContents(this._tree.createClipboardTransferable(true), ConfigEditor.this);
                ConfigEditor.this._clipclass = this.group.getConfigClass();
                ConfigEditor.this._paste.setEnabled(!ConfigEditor.this._readOnly);
            }

            public void pasteNode() {
                PasteHelper paster = ConfigEditor.this.createPasteHelper(this.group);
                Clipboard clipboard = this._tree.getToolkit().getSystemClipboard();
                if (this._tree.getTransferHandler().importData(this._tree, clipboard.getContents(this))) {
                    paster.didPaste();
                }
            }

            public void deleteNode() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                ConfigTreeNode parent = (ConfigTreeNode)node.getParent();
                int index = parent.getIndex(node);
                ((DefaultTreeModel)this._tree.getModel()).removeNodeFromParent(node);
                int ccount = parent.getChildCount();
                ConfigTreeNode configTreeNode = node = ccount > 0 ? (ConfigTreeNode)parent.getChildAt(Math.min(index, ccount - 1)) : parent;
                if (node != this._tree.getModel().getRoot()) {
                    this._tree.setSelectionPath(new TreePath(node.getPath()));
                }
                DirtyGroupManager.setDirty(this.group, true);
            }

            public void configChanged() {
                ManagedConfig oldLastValue = this._lastValue;
                this._lastValue = (ManagedConfig)this._tree.getSelectedNode().getConfig().clone();
                ConfigEditor.this.maybePostUndo(new ConfigEdit(ConfigEdit.Type.CHANGE, this.group, this._lastValue, oldLastValue));
                DirtyGroupManager.setDirty(this.group, true);
                this._tree.selectedConfigChanged();
            }

            public boolean select(String name) {
                if (this.group.getRawConfig(name) == null) {
                    return false;
                }
                ConfigEditor.this._tabs.setSelectedComponent(ManagerPanel.this);
                ManagerPanel.this.gbox.setSelectedItem(this);
                this._tree.setSelectedNode(name);
                return true;
            }

            public String getSelected() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                return node == null ? null : node.getName();
            }

            public void dispose() {
                if (this._tree != null) {
                    this._tree.dispose();
                    this._tree = null;
                }
            }

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                this.updateSelection();
            }

            public String toString() {
                return this._label + (DirtyGroupManager.isDirty(this.group) ? " *" : "");
            }

            protected void updateSelection() {
                ConfigTreeNode node = this._tree.getSelectedNode();
                ManagerPanel.this._epanel.removeChangeListener(ManagerPanel.this);
                try {
                    ManagedConfig cfg = node == null ? null : node.getConfig();
                    ManagerPanel.this._epanel.setObject(cfg);
                    this._lastValue = cfg == null ? null : (ManagedConfig)cfg.clone();
                }
                finally {
                    ManagerPanel.this._epanel.addChangeListener(ManagerPanel.this);
                }
                boolean enable = node != null;
                boolean writeable = !ConfigEditor.this._readOnly;
                ConfigEditor.this._exportConfigs.setEnabled(enable);
                ConfigEditor.this._cut.setEnabled(enable && writeable);
                ConfigEditor.this._copy.setEnabled(enable);
                ConfigEditor.this._deepCopy.setEnabled(enable);
                ConfigEditor.this._delete.setEnabled(enable && writeable);
                ConfigEditor.this._findUses.setEnabled(enable);
            }

            protected void newNode(ManagedConfig config) {
                ManagerPanel.this._filterPanel.clearFilter();
                ConfigTreeNode snode = this._tree.getSelectedNode();
                ConfigTreeNode parent = (ConfigTreeNode)(snode == null ? this._tree.getModel().getRoot() : snode.getParent());
                String name = parent.findNameForChild(ConfigEditor.this._msgs.get(config == null ? "m.new_folder" : "m.new_config"));
                ConfigTreeNode child = new ConfigTreeNode(name, config);
                ((DefaultTreeModel)this._tree.getModel()).insertNodeInto(child, parent, parent.getInsertionIndex(child));
                this._tree.startEditingAtPath(new TreePath(child.getPath()));
                DirtyGroupManager.setDirty(this.group, true);
            }
        }
    }
}

