/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.samskivert.util.ObserverList;
import com.threerings.config.ConfigReference;
import com.threerings.editor.swing.editors.util.AbstractRecentList;
import java.util.prefs.Preferences;

public class RecentConfigList
extends AbstractRecentList {
    protected ObserverList<Observer> _observers = ObserverList.newFastUnsafe();

    public RecentConfigList(String prefKey) {
        super(prefKey, prefKey == null ? null : Preferences.userNodeForPackage(RecentConfigList.class).node("RecentConfigList"));
    }

    public void addObserver(Observer obs) {
        this._observers.add((Object)obs);
    }

    public void removeObserver(Observer obs) {
        this._observers.remove((Object)obs);
    }

    public void addRecent(ConfigReference<?> ref) {
        this.addRecent(ref.getName());
    }

    @Override
    protected int getMaximumChop(String value) {
        return value.lastIndexOf(47) + 1;
    }

    @Override
    protected void valueSelected(String value) {
        final ConfigReference ref = new ConfigReference(value);
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<Observer>(){

            public boolean apply(Observer obs) {
                obs.configSelected(ref);
                return true;
            }
        });
    }

    public static abstract class Observer {
        public void configSelected(ConfigReference<?> ref) {
        }
    }
}

