/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.swing;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.samskivert.util.QuickSort;
import com.threerings.config.ConfigEvent;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigGroupListener;
import com.threerings.config.ManagedConfig;
import com.threerings.config.ReferenceConstraints;
import com.threerings.editor.util.PropertyUtil;
import com.threerings.util.MessageBundle;
import java.util.HashSet;
import javax.annotation.Nullable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ConfigBox
extends JComboBox
implements ConfigGroupListener {
    protected MessageBundle _msgs;
    protected boolean _nullable;
    protected ConfigGroup<ManagedConfig>[] _groups;
    protected Predicate<ManagedConfig> _filter;
    protected Supplier<Predicate<? super ManagedConfig>> _additionalFilter;

    public ConfigBox(MessageBundle msgs, ConfigGroup<?>[] groups, boolean nullable, ReferenceConstraints constraints, @Nullable Supplier<Predicate<? super ManagedConfig>> additionalFilterSupplier) {
        this._msgs = msgs;
        ConfigGroup<?>[] mgroups = groups;
        this._groups = mgroups;
        this._nullable = nullable;
        this._filter = PropertyUtil.getRawConfigPredicate(constraints);
        this._additionalFilter = additionalFilterSupplier;
        this.updateModel();
    }

    public void setSelectedConfig(String config) {
        this.setSelectedItem(new ConfigItem(config));
    }

    public String getSelectedConfig() {
        ConfigItem item = (ConfigItem)this.getSelectedItem();
        return item == null ? null : item.name;
    }

    @Override
    public void configAdded(ConfigEvent<ManagedConfig> event) {
        this.updateModel();
    }

    @Override
    public void configRemoved(ConfigEvent<ManagedConfig> event) {
        this.updateModel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateModel();
        for (ConfigGroup<ManagedConfig> group : this._groups) {
            group.addListener(this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        for (ConfigGroup<ManagedConfig> group : this._groups) {
            group.removeListener(this);
        }
    }

    protected void updateModel() {
        HashSet<String> names = new HashSet<String>();
        Predicate curFilter = this._additionalFilter == null ? this._filter : Predicates.and(this._filter, (Predicate)((Predicate)this._additionalFilter.get()));
        for (ConfigGroup<ManagedConfig> group : this._groups) {
            for (ManagedConfig config : Iterables.filter(group.getRawConfigs(), (Predicate)curFilter)) {
                names.add(config.getName());
            }
        }
        int offset = this._nullable ? 1 : 0;
        Comparable[] items = new ConfigItem[offset + names.size()];
        int idx = 0;
        if (this._nullable) {
            items[idx++] = new ConfigItem(null);
        }
        for (String name : names) {
            items[idx++] = new ConfigItem(name);
        }
        QuickSort.sort((Comparable[])items, (int)offset, (int)(items.length - 1));
        String config = this.getSelectedConfig();
        this.setModel(new DefaultComboBoxModel<Comparable>(items));
        this.setSelectedConfig(config);
    }

    protected class ConfigItem
    implements Comparable<ConfigItem> {
        public String name;

        public ConfigItem(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(ConfigItem other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name == null ? ConfigBox.this._msgs.get("m.null_value") : this.name;
        }

        public boolean equals(Object other) {
            return Objects.equal((Object)this.name, (Object)((ConfigItem)other).name);
        }

        public int hashCode() {
            return this.name != null ? this.name.hashCode() : 0;
        }
    }
}

