/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.dist.util;

import com.threerings.ClydeLog;
import com.threerings.config.ConfigGroup;
import com.threerings.config.ConfigManager;
import com.threerings.config.ManagedConfig;
import com.threerings.config.dist.data.ConfigEntry;
import com.threerings.config.dist.data.ConfigKey;
import com.threerings.config.dist.data.DConfigObject;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.SetListener;

public class ConfigUpdater
implements SetListener<DSet.Entry> {
    protected ConfigManager _cfgmgr;

    public ConfigUpdater(ConfigManager cfgmgr) {
        this._cfgmgr = cfgmgr;
    }

    public void init(DConfigObject cfgobj) {
        for (ConfigEntry entry : cfgobj.added) {
            this.addConfig(entry.getConfig());
        }
        for (ConfigEntry entry : cfgobj.updated) {
            this.updateConfig(entry.getConfig());
        }
        for (ConfigKey key : cfgobj.removed) {
            this.removeConfig(key);
        }
        cfgobj.addListener((ChangeListener)this);
    }

    public void entryAdded(EntryAddedEvent<DSet.Entry> event) {
        String name = event.getName();
        if (name.equals("added")) {
            ConfigEntry entry = (ConfigEntry)event.getEntry();
            this.addConfig(entry.getConfig());
        } else if (name.equals("updated")) {
            ConfigEntry entry = (ConfigEntry)event.getEntry();
            this.updateConfig(entry.getConfig());
        } else if (name.equals("removed")) {
            this.removeConfig((ConfigKey)event.getEntry());
        }
    }

    public void entryRemoved(EntryRemovedEvent<DSet.Entry> event) {
        if (event.getName().equals("added")) {
            this.removeConfig((ConfigKey)event.getKey());
        }
    }

    public void entryUpdated(EntryUpdatedEvent<DSet.Entry> event) {
        String name = event.getName();
        if (name.equals("added") || name.equals("updated")) {
            ConfigEntry entry = (ConfigEntry)event.getEntry();
            this.updateConfig(entry.getConfig());
        }
    }

    protected void addConfig(ManagedConfig config) {
        ConfigGroup<?> group = this._cfgmgr.getGroup(config.getClass());
        group.addConfig(config);
    }

    protected void removeConfig(ConfigKey key) {
        Class<? extends ManagedConfig> mclass = key.getConfigClass();
        ConfigGroup<? extends ManagedConfig> group = this._cfgmgr.getGroup(mclass);
        ManagedConfig config = group.getRawConfig(key.getName());
        if (config != null) {
            group.removeConfig(config);
        } else {
            ClydeLog.log.warning((Object)"Missing config to remove.", new Object[]{"key", key});
        }
    }

    protected void updateConfig(ManagedConfig nconfig) {
        Object oconfig = this._cfgmgr.getConfig(nconfig.getClass(), nconfig.getName());
        if (oconfig != null) {
            nconfig.copy(oconfig);
            ((ManagedConfig)oconfig).wasUpdated();
        } else if (!this._cfgmgr.isResourceClass(nconfig.getClass())) {
            this.addConfig(nconfig);
        } else {
            ClydeLog.log.warning((Object)"Attempted to update unknown resource.", new Object[]{"name", nconfig.getName()});
        }
    }
}

