/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config.dist.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.ClydeLog;
import com.threerings.config.ConfigManager;
import com.threerings.config.dist.data.ConfigEntry;
import com.threerings.config.dist.data.ConfigKey;
import com.threerings.config.dist.data.DConfigMarshaller;
import com.threerings.config.dist.data.DConfigObject;
import com.threerings.config.dist.server.DConfigProvider;
import com.threerings.config.dist.util.ConfigUpdater;
import com.threerings.crowd.data.BodyObject;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.presents.server.PresentsDObjectMgr;
import java.util.Arrays;

@Singleton
public class DConfigManager
implements DConfigProvider {
    protected DConfigObject _cfgobj = new DConfigObject();

    @Inject
    public DConfigManager(ConfigManager cfgmgr, PresentsDObjectMgr omgr, InvocationManager invmgr) {
        omgr.registerObject((DObject)this._cfgobj);
        this._cfgobj.dconfigService = (DConfigMarshaller)invmgr.registerProvider((InvocationProvider)this, DConfigMarshaller.class);
        new ConfigUpdater(cfgmgr).init(this._cfgobj);
    }

    public DConfigObject getConfigObject() {
        return this._cfgobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfigs(int cloid, Iterable<ConfigEntry> add, Iterable<ConfigEntry> update, Iterable<ConfigKey> remove) {
        this._cfgobj.startTransaction();
        try {
            ConfigEntry oentry;
            ConfigKey key;
            for (ConfigEntry entry : add) {
                key = (ConfigKey)entry.getKey();
                if (this._cfgobj.removed.containsKey((Comparable)key)) {
                    this._cfgobj.requestEntryRemove("removed", this._cfgobj.removed, key, cloid);
                    this._cfgobj.requestEntryAdd("updated", this._cfgobj.updated, entry, cloid);
                    continue;
                }
                oentry = (ConfigEntry)this._cfgobj.added.get((Comparable)key);
                if (oentry != null) {
                    if (entry.equals((Object)oentry)) continue;
                    this._cfgobj.requestEntryUpdate("added", this._cfgobj.added, entry, cloid);
                    continue;
                }
                this._cfgobj.requestEntryAdd("added", this._cfgobj.added, entry, cloid);
            }
            for (ConfigEntry entry : update) {
                key = (ConfigKey)entry.getKey();
                oentry = (ConfigEntry)this._cfgobj.added.get((Comparable)key);
                if (oentry != null) {
                    if (entry.equals((Object)oentry)) continue;
                    this._cfgobj.requestEntryUpdate("added", this._cfgobj.added, entry, cloid);
                    continue;
                }
                oentry = (ConfigEntry)this._cfgobj.updated.get((Comparable)key);
                if (oentry != null) {
                    if (entry.equals((Object)oentry)) continue;
                    this._cfgobj.requestEntryUpdate("updated", this._cfgobj.updated, entry, cloid);
                    continue;
                }
                this._cfgobj.requestEntryAdd("updated", this._cfgobj.updated, entry, cloid);
            }
            for (ConfigKey key2 : remove) {
                if (this._cfgobj.added.containsKey((Comparable)key2)) {
                    this._cfgobj.requestEntryRemove("added", this._cfgobj.added, key2, cloid);
                    continue;
                }
                if (this._cfgobj.updated.containsKey((Comparable)key2)) {
                    this._cfgobj.requestEntryRemove("updated", this._cfgobj.updated, key2, cloid);
                }
                if (this._cfgobj.removed.containsKey((Comparable)key2)) continue;
                this._cfgobj.requestEntryAdd("removed", this._cfgobj.removed, key2, cloid);
            }
        }
        finally {
            this._cfgobj.commitTransaction();
        }
    }

    @Override
    public void updateConfigs(ClientObject caller, ConfigEntry[] add, ConfigEntry[] update, ConfigKey[] remove) {
        if (((BodyObject)caller).getTokens().isAdmin()) {
            this.updateConfigs(caller.getOid(), Arrays.asList(add), Arrays.asList(update), Arrays.asList(remove));
        } else {
            ClydeLog.log.warning((Object)"Non-admin tried to update configs.", new Object[]{"who", caller});
        }
    }
}

