/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.config;

import com.google.common.base.Objects;
import com.samskivert.util.ObjectUtil;
import com.samskivert.util.SortableArrayList;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.util.Copyable;
import com.threerings.util.DeepUtil;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ArgumentMap
extends AbstractMap<String, Object>
implements Copyable,
Streamable {
    protected transient SortableArrayList<Map.Entry<String, Object>> _entries = new SortableArrayList();
    protected transient Key _key = new Key();
    protected transient Object[] _a1 = new Object[1];
    protected transient Object[] _a2 = new Object[1];

    public ArgumentMap(String firstKey, Object firstValue, Object ... otherArgs) {
        this.put(firstKey, firstValue);
        for (int ii = 0; ii < otherArgs.length; ii += 2) {
            this.put((String)otherArgs[ii], otherArgs[ii + 1]);
        }
    }

    public ArgumentMap() {
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        int size = this._entries.size();
        out.writeInt(size);
        for (int ii = 0; ii < size; ++ii) {
            Map.Entry entry = (Map.Entry)this._entries.get(ii);
            out.writeIntern((String)entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int nn = in.readInt();
        for (int ii = 0; ii < nn; ++ii) {
            this._entries.add(ArgumentMap.newEntry(in.readIntern(), in.readObject()));
        }
    }

    @Override
    public Object copy(Object dest) {
        return this.copy(dest, null);
    }

    @Override
    public Object copy(Object dest, Object outer) {
        ArgumentMap cmap;
        if (dest instanceof ArgumentMap) {
            cmap = (ArgumentMap)dest;
            cmap.clear();
        } else {
            cmap = new ArgumentMap();
        }
        int nn = this._entries.size();
        for (int ii = 0; ii < nn; ++ii) {
            Map.Entry entry = (Map.Entry)this._entries.get(ii);
            cmap._entries.add(ArgumentMap.newEntry((String)entry.getKey(), DeepUtil.copy(entry.getValue())));
        }
        return cmap;
    }

    @Override
    public int size() {
        return this._entries.size();
    }

    @Override
    public boolean containsValue(Object value) {
        int nn = this._entries.size();
        for (int ii = 0; ii < nn; ++ii) {
            if (!Objects.equal((Object)value, ((Map.Entry)this._entries.get(ii)).getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.findKeyIndex(key) >= 0;
    }

    @Override
    public Object get(Object key) {
        int idx = this.findKeyIndex(key);
        return idx >= 0 ? ((Map.Entry)this._entries.get(idx)).getValue() : null;
    }

    public <T> T get(String key, Class<T> type) {
        int idx = this._entries.binarySearch((Comparable)this._key.as(key));
        return (T)(idx >= 0 ? ObjectUtil.as(((Map.Entry)this._entries.get(idx)).getValue(), type) : null);
    }

    @Override
    public Object put(String key, Object value) {
        int idx = this._entries.binarySearch((Comparable)this._key.as(key));
        if (idx >= 0) {
            return ((Map.Entry)this._entries.get(idx)).setValue(value);
        }
        this._entries.add(-idx - 1, ArgumentMap.newEntry(key, value));
        return null;
    }

    @Override
    public Object remove(Object key) {
        int idx = this.findKeyIndex(key);
        return idx >= 0 ? ((Map.Entry)this._entries.remove(idx)).getValue() : null;
    }

    @Override
    public void clear() {
        this._entries.clear();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public int size() {
                return ArgumentMap.this._entries.size();
            }

            @Override
            public boolean contains(Object o) {
                return this.findEntryIndex(o) >= 0;
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return ArgumentMap.this._entries.iterator();
            }

            @Override
            public boolean remove(Object o) {
                int idx = this.findEntryIndex(o);
                if (idx < 0) {
                    return false;
                }
                ArgumentMap.this._entries.remove(idx);
                return true;
            }

            @Override
            public void clear() {
                ArgumentMap.this._entries.clear();
            }

            protected int findEntryIndex(Object value) {
                if (value instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)value;
                    int idx = ArgumentMap.this.findKeyIndex(entry.getKey());
                    return idx >= 0 && Objects.equal(entry.getValue(), ((Map.Entry)ArgumentMap.this._entries.get(idx)).getValue()) ? idx : -1;
                }
                if (value != null) {
                    int nn = ArgumentMap.this._entries.size();
                    for (int ii = 0; ii < nn; ++ii) {
                        if (!value.equals(ArgumentMap.this._entries.get(ii))) continue;
                        return ii;
                    }
                }
                return -1;
            }
        };
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ArgumentMap)) {
            return false;
        }
        ArgumentMap omap = (ArgumentMap)other;
        int size = this.size();
        if (size != omap.size()) {
            return false;
        }
        for (int ii = 0; ii < size; ++ii) {
            Map.Entry entry = (Map.Entry)this._entries.get(ii);
            Map.Entry oentry = (Map.Entry)omap._entries.get(ii);
            if (!((String)entry.getKey()).equals(oentry.getKey())) {
                return false;
            }
            this._a1[0] = entry.getValue();
            this._a2[0] = oentry.getValue();
            if (Arrays.deepEquals(this._a1, this._a2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        int nn = this._entries.size();
        for (int ii = 0; ii < nn; ++ii) {
            Map.Entry entry = (Map.Entry)this._entries.get(ii);
            this._a1[0] = entry.getValue();
            hash += ((String)entry.getKey()).hashCode() ^ Arrays.deepHashCode(this._a1);
        }
        return hash;
    }

    @Override
    public ArgumentMap clone() {
        return (ArgumentMap)this.copy(null);
    }

    protected int findKeyIndex(Object key) {
        if (key instanceof String) {
            return this._entries.binarySearch((Comparable)this._key.as((String)key));
        }
        if (key != null) {
            int nn = this._entries.size();
            for (int ii = 0; ii < nn; ++ii) {
                if (!key.equals(((Map.Entry)this._entries.get(ii)).getKey())) continue;
                return ii;
            }
        }
        return -1;
    }

    protected static Map.Entry<String, Object> newEntry(String k, Object v) {
        return new AbstractMap.SimpleEntry<String, Object>(k, v);
    }

    protected static class Key
    implements Comparable<Map.Entry<String, Object>> {
        protected String _key;

        protected Key() {
        }

        public Key as(String key) {
            this._key = key;
            return this;
        }

        @Override
        public int compareTo(Map.Entry<String, Object> entry) {
            return this._key.compareTo(entry.getKey());
        }
    }
}

