package com.threerings.tudey.server.logic;

import com.samskivert.util.ArrayUtil;
import com.threerings.math.FloatMath;
import com.threerings.math.Vector2f;

/**
 * A candidate path under consideration for branching.
 */
public class PathCandidate {
	/**
	 * Creates a new path candidate.
	 */
	public PathCandidate(Logic target, Vector2f[] path, int cidx,boolean unidirection) {
		_target = target;
		_path = path;
		_cidx = cidx;
		_unidirection = unidirection;
	}

	/**
	 * Returns a reference to the logic associated with the path.
	 */
	public Logic getTarget() {
		return _target;
	}

	/**
	 * Returns the portion of the path from the closest node to the end, using the
	 * supplied angle to determine which direction to travel along the path in cases
	 * of ambiguity. This clobbers the contained path.
	 */
	public Vector2f[] getRemainingPath(float angle) {
		if (_cidx == _path.length - 1) { // last node; use reverse direction
			if(!_unidirection){
				ArrayUtil.reverse(_path);
			}else{
				return new Vector2f[]{_path[_path.length-1]};
			}
		} else if (_cidx != 0) { // internal node; alignment determines direction
			if(!_unidirection){
				Vector2f prev = _path[_cidx - 1], node = _path[_cidx], next = _path[_cidx + 1];
				float df = FloatMath.atan2(next.y - node.y, next.x - node.x);
				float dr = FloatMath.atan2(prev.y - node.y, prev.x - node.x);
				if (FloatMath.getAngularDistance(angle, dr) < FloatMath.getAngularDistance(angle, df)) {
					ArrayUtil.reverse(_path = ArrayUtil.splice(_path, _cidx + 1));
				} else {
					_path = ArrayUtil.splice(_path, 0, _cidx+1);
				}
			}else{
				
				_path = ArrayUtil.splice(_path, 0, _cidx+1);
			}
		}else{
			_path = ArrayUtil.splice(_path, 0, 1);
		}
		return _path;
	}
	
	
	private boolean inRange(Vector2f trans,Vector2f start,Vector2f end) {
		if(trans.x > start.x && trans.x < end.y) {
			return true;
		}
		
		return false;
	}
	
	/**
	 * one-way
	 */
	protected boolean _unidirection = false; 
	
	/** The logic with which the path is associated. */
	protected Logic _target;

	/** The base path. */
	protected Vector2f[] _path;

	/** The index of the closest node on the path. */
	protected int _cidx;
}
