/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.util;

import com.google.common.collect.Lists;
import com.samskivert.util.Interval;
import com.samskivert.util.LoopingThread;
import com.samskivert.util.RunQueue;
import com.threerings.tudey.Log;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.util.TruncatedAverage;
import java.util.Arrays;
import java.util.List;

public abstract class SceneTicker {
    protected RunQueue _runQueue;
    protected volatile int _targetInterval;
    protected volatile int _actualInterval;
    protected List<TudeySceneManager> _scenemgrs = Lists.newArrayList();
    protected TudeySceneManager[] _sarray = new TudeySceneManager[0];
    protected long _lastTick;
    protected boolean _lastLong;
    protected TruncatedAverage _intervalAverage = new TruncatedAverage();

    public SceneTicker(RunQueue runQueue, int targetInterval) {
        this._runQueue = runQueue;
        this._targetInterval = this._actualInterval = targetInterval;
    }

    public void setTargetInterval(int interval) {
        this._targetInterval = interval;
    }

    public int getActualInterval() {
        return this._actualInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TudeySceneManager scenemgr) {
        List<TudeySceneManager> list = this._scenemgrs;
        synchronized (list) {
            this._scenemgrs.add(scenemgr);
            if (this._scenemgrs.size() == 1) {
                this._lastTick = System.currentTimeMillis();
                this.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TudeySceneManager scenemgr) {
        List<TudeySceneManager> list = this._scenemgrs;
        synchronized (list) {
            if (this._scenemgrs.remove(scenemgr) && this._scenemgrs.isEmpty()) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(TudeySceneManager scenemgr) {
        List<TudeySceneManager> list = this._scenemgrs;
        synchronized (list) {
            return this._scenemgrs.contains(scenemgr);
        }
    }

    protected abstract void start();

    protected abstract void stop();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long tick() {
        long now = System.currentTimeMillis();
        int elapsed = (int)(now - this._lastTick);
        if (elapsed >= this._targetInterval * 5 && !this._lastLong) {
            Log.log.debug((Object)"Overlong ticking started.", new Object[]{"elapsed", elapsed, "target", this._targetInterval});
            this._lastLong = true;
        } else if (elapsed <= this._targetInterval * 2 && this._lastLong) {
            Log.log.debug((Object)"Overlong ticking stopped.", new Object[]{"elapsed", elapsed, "target", this._targetInterval});
            this._lastLong = false;
        }
        this._lastTick = now;
        this._intervalAverage.record(elapsed);
        this._actualInterval = this._intervalAverage.value();
        List<TudeySceneManager> list = this._scenemgrs;
        synchronized (list) {
            this._sarray = this._scenemgrs.toArray(this._sarray);
        }
        for (TudeySceneManager scenemgr : this._sarray) {
            if (scenemgr == null) break;
            try {
                scenemgr.tick();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Exception thrown in scene tick.", new Object[]{"where", scenemgr.where(), e});
            }
        }
        long duration = System.currentTimeMillis() - this._lastTick;
        if (duration >= 100L) {
            StringBuilder buf = new StringBuilder();
            for (TudeySceneManager scenemgr : this._sarray) {
                if (scenemgr == null) break;
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(scenemgr.where()).append(": ").append(scenemgr.getTickDuration());
            }
            Log.log.warning((Object)"Long tick detected.", new Object[]{"durations", buf});
        }
        Arrays.fill(this._sarray, null);
        return (long)this._targetInterval - duration;
    }

    public static class DedicatedThread
    extends SceneTicker {
        protected LoopingThread _thread;

        public DedicatedThread(RunQueue runQueue, int targetInterval) {
            super(runQueue, targetInterval);
        }

        @Override
        protected void start() {
            this._thread = new LoopingThread("sceneTicker"){
                protected long _remaining;
                {
                    this._remaining = DedicatedThread.this._targetInterval;
                }

                protected void iterate() {
                    try {
                        Thread.sleep(this._remaining);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    this._remaining = DedicatedThread.this.tick();
                }

                protected void kick() {
                    this.interrupt();
                }
            };
            this._thread.start();
        }

        @Override
        protected void stop() {
            if (this._thread != null) {
                this._thread.shutdown();
                this._thread = null;
            }
        }
    }

    public static class EventThread
    extends SceneTicker {
        protected Interval _interval;

        public EventThread(RunQueue runQueue, int targetInterval) {
            super(runQueue, targetInterval);
        }

        @Override
        protected void start() {
            this._interval = new Interval(this._runQueue){

                public void expired() {
                    long remaining = EventThread.this.tick();
                    if (EventThread.this._interval != null) {
                        EventThread.this._interval.schedule(Math.max(remaining, 1L));
                    }
                }
            };
            this._interval.schedule((long)this._targetInterval);
        }

        @Override
        protected void stop() {
            if (this._interval != null) {
                this._interval.cancel();
                this._interval = null;
            }
        }
    }
}

