/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.threerings.math.Vector2f;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActiveLogic;
import com.threerings.tudey.server.logic.Logic;
import java.util.Map;

public abstract class ActivityLogic
extends Logic {
    protected ActiveLogic _source;
    protected int _started;

    public void init(TudeySceneManager scenemgr, ActiveLogic source) {
        super.init(scenemgr);
        this._source = source;
    }

    public void start(int timestamp) {
        this._started = timestamp - (this.shouldAdvance() ? this._source.getActivityAdvance() : 0);
    }

    public void stop(int timestamp) {
    }

    public void tick(int timestamp) {
    }

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    @Override
    public void transfer(Logic source, Map<Object, Object> refs) {
        super.transfer(source, refs);
        this._started = ((ActivityLogic)source)._started;
    }

    protected void didInit() {
    }

    public ActiveLogic getSource() {
        return this._source;
    }

    protected boolean shouldAdvance() {
        return true;
    }
}

