/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.server.CrowdSession;
import com.threerings.delta.Delta;
import com.threerings.delta.ReflectiveDelta;
import com.threerings.math.Rect;
import com.threerings.math.Vector2f;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.net.Transport;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.CameraConfig;
import com.threerings.tudey.data.InputFrame;
import com.threerings.tudey.data.TudeySceneConfig;
import com.threerings.tudey.data.TudeySceneObject;
import com.threerings.tudey.data.actor.Actor;
import com.threerings.tudey.data.actor.Pawn;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.dobj.ActorDelta;
import com.threerings.tudey.dobj.SceneDeltaEvent;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.ActorLogic;
import com.threerings.tudey.server.logic.PawnLogic;
import com.threerings.tudey.util.Pool;
import com.threerings.tudey.util.TruncatedAverage;
import com.threerings.tudey.util.TudeySceneMetrics;
import java.util.List;
import java.util.Set;

public class ClientLiaison {
    protected static Rect constantRect = new Rect(new Vector2f(-25.0f, -25.0f), new Vector2f(25.0f, 35.0f));
    protected TudeySceneManager _scenemgr;
    protected TudeySceneObject _tsobj;
    protected BodyObject _bodyobj;
    protected CrowdSession _session;
    protected PawnLogic _target;
    protected PawnLogic _controlled;
    protected Rect _localInterest;
    protected Rect _worldInterest = new Rect();
    protected List<TickRecord> _records = Lists.newArrayList();
    protected boolean _receiving;
    protected int _ping;
    protected TruncatedAverage _pingAverage = new TruncatedAverage();
    protected int _lastInput;
    protected Set<ActorLogic> _previousVisibleActors = Sets.newHashSet();
    protected Set<ActorLogic> _visibleActors = Sets.newHashSet();
    protected List<Actor> _actorsAdded = Lists.newArrayList();
    protected List<ActorDelta> _actorsUpdated = Lists.newArrayList();
    protected List<Actor> _actorsRemoved = Lists.newArrayList();
    protected IntMap<Actor> _added = IntMaps.newHashIntMap();
    protected IntMap<ActorDelta> _updated = IntMaps.newHashIntMap();
    protected IntMap<Actor> _removed = IntMaps.newHashIntMap();
    protected List<Effect> _fired = Lists.newArrayList();

    public ClientLiaison(TudeySceneManager scenemgr, BodyObject bodyobj, CrowdSession session) {
        this._scenemgr = scenemgr;
        this._tsobj = (TudeySceneObject)scenemgr.getPlaceObject();
        this._bodyobj = bodyobj;
        this._session = session;
        int targetId = this._tsobj.getPawnId(this._bodyobj.getOid());
        if (targetId > 0) {
            this._controlled = (PawnLogic)this._scenemgr.getActorLogic(targetId);
        } else {
            targetId = this._tsobj.getFirstPawnId();
        }
        this._target = (PawnLogic)this._scenemgr.getActorLogic(targetId);
        if (this._controlled != null) {
            this._controlled.bodyEntered(this);
        }
        this._localInterest = this._scenemgr.getDefaultLocalInterest();
        this._records.add(new TickRecord());
    }

    public BodyObject getClientObject() {
        return this._bodyobj;
    }

    public int getOid() {
        return this._bodyobj.getOid();
    }

    public void resetControlled() {
        int targetId = this._tsobj.getPawnId(this._bodyobj.getOid());
        if (targetId > 0) {
            this._controlled = (PawnLogic)this._scenemgr.getActorLogic(targetId);
        } else {
            targetId = this._tsobj.getFirstPawnId();
        }
        this._target = (PawnLogic)this._scenemgr.getActorLogic(targetId);
        if (this._controlled != null) {
            this._controlled.bodyEntered(this);
        }
    }

    public void bodyUpdated(OccupantInfo info) {
        if (info.status == 2) {
            this._records.clear();
            this._records.add(new TickRecord());
            this._previousVisibleActors.clear();
            this._visibleActors.clear();
            this._receiving = false;
            if (this._controlled != null) {
                ((Pawn)this._controlled.getActor()).setActivity(Integer.MAX_VALUE, this._scenemgr._timestamp);
                ((Pawn)this._controlled.getActor()).stopMoving();
            }
        }
    }

    public void setTarget(PawnLogic target) {
        this._target = target;
    }

    public PawnLogic getTarget() {
        return this._target;
    }

    public void setCameraParams(CameraConfig config, float aspect) {
        this._localInterest = TudeySceneMetrics.getLocalInterest(config, aspect);
    }

    public int getControlDelta() {
        TudeySceneConfig config = (TudeySceneConfig)this._scenemgr.getConfig();
        return this._scenemgr.getBufferDelay() + config.getInputAdvance(this._pingAverage.value());
    }

    public int getLastInput() {
        return this._lastInput;
    }

    public void enteredPlace() {
        this._receiving = true;
    }

    public void enqueueInput(int acknowledge, int ping, InputFrame[] frames) {
        if (!this._receiving) {
            return;
        }
        while (acknowledge > this._records.get(0).getTimestamp()) {
            if (this._records.size() > 1) {
                this._records.remove(0);
                continue;
            }
            Log.log.warning((Object)"Received invalid acknowledgement.", new Object[]{"who", this._bodyobj.who(), "acknowledge", acknowledge, "last", this._records.get(0).getTimestamp()});
            break;
        }
        this._ping = ping;
        this._pingAverage.record(this._ping);
        if (this._controlled == null) {
            if (frames.length > 0) {
                Log.log.warning((Object)"Got input frames for non-controlled pawn.", new Object[]{"who", this._bodyobj.who(), "actor", this._target == null ? null : this._target.getActor()});
            }
            return;
        }
        int timestamp = this._scenemgr.getTimestamp();
        for (int ii = 0; ii < frames.length; ++ii) {
            InputFrame frame = frames[ii];
            int input = frame.getTimestamp();
            if (input <= this._lastInput) continue;
            this._lastInput = input;
            if (input > timestamp || ii == frames.length - 1) {
                this._controlled.enqueueInput(frame);
                continue;
            }
            Log.log.debug((Object)"Discarding out-of-date frame.", new Object[]{"frame", frame});
        }
    }

    public void postDelta() {
        if (!this._receiving) {
            return;
        }
        for (int ii = this._records.size() - 1; ii > 0; --ii) {
            if (this._records.get((int)ii).event.getActualTransport() != Transport.RELIABLE_ORDERED) continue;
            this._records.subList(0, ii).clear();
            break;
        }
        Vector2f translation = this._target == null ? Vector2f.ZERO : this._target.getActor().getTranslation();
        constantRect.getMinimumExtent().add(translation, this._worldInterest.getMinimumExtent());
        constantRect.getMaximumExtent().add(translation, this._worldInterest.getMaximumExtent());
        this.populateVisibleActors();
        for (ActorLogic actor : this._visibleActors) {
            if (this._previousVisibleActors.remove(actor)) {
                ActorDelta delta = actor.getSnapshotDelta();
                if (delta == null) continue;
                this._actorsUpdated.add(delta);
                continue;
            }
            this._actorsAdded.add(actor.getSnapshot());
        }
        for (ActorLogic actor : this._previousVisibleActors) {
            this._actorsRemoved.add(actor.getPreviousSnapshot());
        }
        this._previousVisibleActors.clear();
        Set<ActorLogic> visibleActors = this._visibleActors;
        this._visibleActors = this._previousVisibleActors;
        this._previousVisibleActors = visibleActors;
        if (this._records.get(this._records.size() - 1).getTimestamp() == 0) {
            for (ActorLogic actor : this._scenemgr.getStaticActors()) {
                this._actorsAdded.add(actor.getSnapshot());
            }
        } else {
            for (ActorLogic actor : this._scenemgr.getStaticActorsAdded()) {
                this._actorsAdded.add(actor.getSnapshot());
            }
            for (ActorLogic actor : this._scenemgr.getStaticActorsUpdated()) {
                ActorDelta delta = actor.getSnapshotDelta();
                if (delta == null) continue;
                this._actorsUpdated.add(delta);
            }
            for (ActorLogic actor : this._scenemgr.getStaticActorsRemoved()) {
                this._actorsRemoved.add(actor.getPreviousSnapshot());
            }
        }
        int timestamp = this._scenemgr.getTimestamp();
        TickRecord record = new TickRecord(timestamp, this._actorsAdded.toArray(new Actor[this._actorsAdded.size()]), this._actorsUpdated.toArray(new ActorDelta[this._actorsUpdated.size()]), this._actorsRemoved.toArray(new Actor[this._actorsRemoved.size()]), this._scenemgr.getEffectsFired(this._target, this._worldInterest));
        this._records.add(record);
        this._actorsAdded.clear();
        this._actorsUpdated.clear();
        this._actorsRemoved.clear();
        TickRecord reference = this._records.get(0);
        int nn = this._records.size();
        for (int ii = 1; ii < nn; ++ii) {
            int id;
            TickRecord orecord = this._records.get(ii);
            for (Actor actor : orecord.getActorsAdded()) {
                id = actor.getId();
                Actor removed = (Actor)this._removed.remove(id);
                if (removed == null) {
                    this._added.put(id, (Object)actor);
                    continue;
                }
                ActorDelta delta = new ActorDelta(removed, actor);
                if (delta.isEmpty()) continue;
                this._updated.put(id, (Object)delta);
            }
            for (Pool.Poolable poolable : orecord.getActorsUpdated()) {
                id = ((ActorDelta)poolable).getId();
                Actor added = (Actor)this._added.get(id);
                if (added != null) {
                    this._added.put(id, (Object)((Actor)((ReflectiveDelta)poolable).apply(added)));
                    continue;
                }
                ActorDelta odelta = (ActorDelta)this._updated.put(id, (Object)poolable);
                if (odelta == null) continue;
                this._updated.put(id, (Object)((ActorDelta)odelta.merge((Delta)((Object)poolable))));
            }
            for (Pool.Poolable poolable : orecord.getActorsRemoved()) {
                id = ((Actor)poolable).getId();
                if (this._added.remove(id) != null) continue;
                this._updated.remove(id);
                this._removed.put(id, (Object)poolable);
            }
            for (Effect effect : orecord.getEffectsFired()) {
                if (timestamp >= effect.getExpiry()) continue;
                this._fired.add(effect);
            }
        }
        Transport transport = Transport.UNRELIABLE_UNORDERED;
        if (this._session == null || !this._session.getTransmitDatagrams()) {
            transport = Transport.RELIABLE_ORDERED;
            this._records.subList(0, this._records.size() - 1).clear();
        }
        int nadded = this._added.size();
        int nupdated = this._updated.size();
        int nfired = this._fired.size();
        record.event = new SceneDeltaEvent(this._bodyobj.getOid(), this._tsobj.getOid(), this._lastInput, (short)this._ping, reference.getTimestamp(), timestamp, (short)(timestamp - this._scenemgr.getPreviousTimestamp()), nadded == 0 ? null : this._added.values().toArray(new Actor[nadded]), nupdated == 0 ? null : this._updated.values().toArray(new ActorDelta[nupdated]), this._removed.isEmpty() ? null : this._removed.intKeySet().toIntArray(), nfired == 0 ? null : this._fired.toArray(new Effect[nfired]));
        record.event.setTransport(transport);
        this._bodyobj.postEvent((DEvent)record.event);
        this._added.clear();
        this._updated.clear();
        this._removed.clear();
        this._fired.clear();
    }

    protected void populateVisibleActors() {
        this._scenemgr.getVisibleActors(this._target, this._worldInterest, this._visibleActors);
    }

    protected static class TickRecord {
        public SceneDeltaEvent event;
        protected int _timestamp;
        protected Actor[] _actorsAdded;
        protected ActorDelta[] _actorsUpdated;
        protected Actor[] _actorsRemoved;
        protected Effect[] _effectsFired;

        public TickRecord() {
            this(0, new Actor[0], new ActorDelta[0], new Actor[0], new Effect[0]);
        }

        public TickRecord(int timestamp, Actor[] actorsAdded, ActorDelta[] actorsUpdated, Actor[] actorsRemoved, Effect[] effectsFired) {
            this._timestamp = timestamp;
            this._actorsAdded = actorsAdded;
            this._actorsUpdated = actorsUpdated;
            this._actorsRemoved = actorsRemoved;
            this._effectsFired = effectsFired;
        }

        public int getTimestamp() {
            return this._timestamp;
        }

        public Actor[] getActorsAdded() {
            return this._actorsAdded;
        }

        public ActorDelta[] getActorsUpdated() {
            return this._actorsUpdated;
        }

        public Actor[] getActorsRemoved() {
            return this._actorsRemoved;
        }

        public Effect[] getEffectsFired() {
            return this._effectsFired;
        }
    }
}

