/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.config.ConfigManager;
import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.config.ParameterizedConfig;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.math.Vector2f;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.Preloadable;
import com.threerings.opengl.util.PreloadableSet;
import com.threerings.tudey.client.sprite.EffectSprite;
import com.threerings.tudey.config.ActionConfig;
import com.threerings.tudey.config.EffectSpriteConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.data.effect.Effect;
import com.threerings.tudey.shape.config.ShapeConfig;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.util.DeepObject;

public class EffectConfig
extends ParameterizedConfig
implements Preloadable.LoadableConfig {
    @Editable
    public Implementation implementation = new Original();

    public Original getOriginal(ConfigManager cfgmgr) {
        return this.implementation.getOriginal(cfgmgr);
    }

    public EffectSprite.Implementation createSpriteImplementation(TudeyContext ctx, Scope scope, Effect effect) {
        return this.implementation.createSpriteImplementation(ctx, scope, effect);
    }

    @Override
    protected void fireConfigUpdated() {
        this.implementation.invalidate();
        super.fireConfigUpdated();
    }

    @Override
    protected void getUpdateReferences(ConfigReferenceSet refs) {
        this.implementation.getUpdateReferences(refs);
    }

    @Override
    public void preload(GlContext ctx) {
        this.implementation.preload(ctx);
    }

    public static class Derived
    extends Implementation {
        @Editable(nullable=true)
        public ConfigReference<EffectConfig> effect;

        @Override
        public void getUpdateReferences(ConfigReferenceSet refs) {
            refs.add(EffectConfig.class, this.effect);
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            EffectConfig config = cfgmgr.getConfig(EffectConfig.class, this.effect);
            return config == null ? null : config.getOriginal(cfgmgr);
        }

        @Override
        public EffectSprite.Implementation createSpriteImplementation(TudeyContext ctx, Scope scope, Effect effect) {
            EffectConfig config = ctx.getConfigManager().getConfig(EffectConfig.class, this.effect);
            return config == null ? null : config.createSpriteImplementation(ctx, scope, effect);
        }

        @Override
        public void preload(GlContext ctx) {
            if (this.effect != null) {
                EffectConfig config = this.effect.getConfig(ctx.getConfigManager(), EffectConfig.class);
                config.preload(ctx);
            }
        }
    }

    public static class Original
    extends Implementation {
        @Editable
        public EffectSpriteConfig sprite = new EffectSpriteConfig.Default();
        @Editable
        public ShapeConfig shape = new ShapeConfig.Point();
        @Editable(nullable=true)
        public ActionConfig action;
        @Editable(min=0.0, hgroup="l")
        public int lifespan = 1000;
        @Editable(hgroup="l")
        public boolean targetOnly;

        public String getLogicClassName() {
            return "com.threerings.tudey.server.logic.EffectLogic";
        }

        public Effect createEffect(ConfigReference<EffectConfig> config, int timestamp, EntityKey target, Vector2f translation, float rotation) {
            return new Effect(config, timestamp, target, translation, rotation);
        }

        public void getPreloads(ConfigManager cfgmgr, PreloadableSet preloads) {
            this.sprite.getPreloads(cfgmgr, preloads);
            if (this.action != null) {
                this.action.getPreloads(cfgmgr, preloads);
            }
        }

        @Override
        public Original getOriginal(ConfigManager cfgmgr) {
            return this;
        }

        @Override
        public EffectSprite.Implementation createSpriteImplementation(TudeyContext ctx, Scope scope, Effect effect) {
            return this.sprite.createImplementation(ctx, scope, effect);
        }

        @Override
        public void invalidate() {
            this.shape.invalidate();
            if (this.action != null) {
                this.action.invalidate();
            }
        }

        @Override
        public void preload(GlContext ctx) {
            if (this.sprite != null) {
                this.sprite.preload(ctx);
            }
        }
    }

    @EditorTypes(value={Original.class, Derived.class})
    public static abstract class Implementation
    extends DeepObject
    implements Exportable {
        public void getUpdateReferences(ConfigReferenceSet refs) {
        }

        public abstract Original getOriginal(ConfigManager var1);

        public abstract EffectSprite.Implementation createSpriteImplementation(TudeyContext var1, Scope var2, Effect var3);

        public void invalidate() {
        }

        public void preload(GlContext ctx) {
        }
    }
}

