/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.config;

import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.math.FloatMath;
import com.threerings.math.SphereCoords;
import com.threerings.math.Vector3f;
import com.threerings.opengl.camera.OrbitCameraHandler;
import com.threerings.util.DeepObject;

public class CameraConfig
extends DeepObject
implements Exportable,
Streamable {
    @Editable(hgroup="p")
    public int priority;
    @Editable(hgroup="p")
    public int zoom;
    @Editable(min=0.0, max=180.0, scale=0.017453292519943295, hgroup="f")
    public float fov = 1.134464f;
    @Editable(min=0.0, step=0.01, hgroup="f")
    public float near = 1.0f;
    @Editable(min=0.0, step=0.01, hgroup="f")
    public float far = 100.0f;
    @Editable
    public SphereCoords coords = new SphereCoords(0.0f, 1.134464f, 10.0f);
    @Editable
    public Vector3f offset = new Vector3f(0.0f, 0.0f, 1.0f);

    public CameraConfig(int priority, int zoom, float fov, float near, float far, SphereCoords coords, Vector3f offset) {
        this.set(priority, zoom, fov, near, far, coords, offset);
    }

    public CameraConfig(CameraConfig other) {
        this.set(other);
    }

    public CameraConfig() {
    }

    public void apply(OrbitCameraHandler camhand) {
        camhand.setPerspective(this.fov, this.near, this.far);
        camhand.getCoords().set(this.coords);
    }

    public CameraConfig lerpLocal(CameraConfig other, float t) {
        return this.lerp(other, t, this);
    }

    public CameraConfig lerp(CameraConfig other, float t) {
        return this.lerp(other, t, new CameraConfig());
    }

    public CameraConfig lerp(CameraConfig other, float t, CameraConfig result) {
        result.priority = this.priority;
        result.zoom = this.zoom;
        result.fov = FloatMath.lerp(this.fov, other.fov, t);
        result.near = FloatMath.lerp(this.near, other.near, t);
        result.far = FloatMath.lerp(this.far, other.far, t);
        this.coords.lerp(other.coords, t, result.coords);
        this.offset.lerp(other.offset, t, result.offset);
        return result;
    }

    public CameraConfig set(CameraConfig other) {
        return this.set(other.priority, other.zoom, other.fov, other.near, other.far, other.coords, other.offset);
    }

    public CameraConfig set(int priority, int zoom, float fov, float near, float far, SphereCoords coords, Vector3f offset) {
        this.priority = priority;
        this.zoom = zoom;
        this.fov = fov;
        this.near = near;
        this.far = far;
        this.coords.set(coords);
        this.offset.set(offset);
        return this;
    }
}

