/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.swing.filetree;

import java.io.File;
import java.io.FileFilter;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FileTreeNode
extends DefaultMutableTreeNode {
    protected File file;
    protected boolean _expanded;
    protected boolean isFileSystemRoot;
    private FileFilter filter;
    private String nodeName;

    public FileTreeNode(File file, boolean isFileSystemRoot, MutableTreeNode parent, FileFilter filter) {
        super(file, file.isDirectory());
        this.file = file;
        this.setUserObject(file);
        this.isFileSystemRoot = isFileSystemRoot;
        this.filter = filter;
        if (file.isDirectory()) {
            File[] children = this.file.listFiles(filter);
            int j = 0;
            for (int i = 0; i < children.length; ++i) {
                FileTreeNode node = new FileTreeNode(children[i], false, this, filter);
                if (!node.hasChildren()) continue;
                this.insert(node, j++);
            }
        }
    }

    public boolean hasChildren() {
        return this.file.isFile() || this.getChildCount() > 0;
    }

    public void refresh() {
        this.removeAllChildren();
        if (this.file.isDirectory()) {
            File[] children = this.file.listFiles(this.filter);
            int j = 0;
            for (int i = 0; i < children.length; ++i) {
                FileTreeNode node = new FileTreeNode(children[i], false, this, this.filter);
                if (!node.hasChildren()) continue;
                this.insert(node, j++);
            }
        }
    }

    public String getRelativePath() {
        String path = this.file.getName();
        for (TreeNode parent = this.parent; parent != null && parent instanceof FileTreeNode; parent = parent.getParent()) {
            if (((FileTreeNode)parent).file == null) continue;
            path = ((FileTreeNode)parent).file.getName() + "/" + path;
        }
        return path;
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public FileTreeNode(File[] children, FileFilter filter) {
        this.file = null;
        this.parent = null;
        this.filter = filter;
        int j = 0;
        for (int i = 0; i < children.length; ++i) {
            FileTreeNode node = new FileTreeNode(children[i], false, this, filter);
            if (!node.hasChildren()) continue;
            this.insert(node, j++);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.file != null && this.file.isFile();
    }

    public void setExpanded(boolean expanded) {
        this._expanded = expanded;
    }

    public void expandPaths(JTree tree) {
        if (this._expanded) {
            tree.expandPath(new TreePath(this.getPath()));
            if (this.children != null) {
                for (Object child : this.children) {
                    ((FileTreeNode)child).expandPaths(tree);
                }
            }
        }
    }

    public void expandPaths(JTree tree, int depth) {
        if (!this.getAllowsChildren()) {
            return;
        }
        tree.expandPath(new TreePath(this.getPath()));
        if (depth-- > 0 && this.children != null) {
            for (Object child : this.children) {
                ((FileTreeNode)child).expandPaths(tree, depth);
            }
        }
    }

    public FileTreeNode getNode(String name) {
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            FileTreeNode node = (FileTreeNode)e.nextElement();
            if (node.getName().equals(name)) {
                return node;
            }
            int index = name.indexOf(node.getName());
            if (index != 0) continue;
            return node.getNode(name);
        }
        return null;
    }

    public String getName() {
        if (this.nodeName == null) {
            StringBuilder buff = new StringBuilder(this.file.getName());
            for (FileTreeNode parent = (FileTreeNode)this.getParent(); parent != null && parent.file != null; parent = (FileTreeNode)parent.getParent()) {
                if (parent.file == null) continue;
                buff.insert(0, parent.file.getName() + "/");
            }
            if (this.file.isDirectory()) {
                buff.append("/");
            }
            this.nodeName = buff.toString();
            return this.nodeName;
        }
        return this.nodeName;
    }

    public int getInsertionIndex(FileTreeNode child) {
        if (this.children == null) {
            return 0;
        }
        File file = (File)child.getUserObject();
        boolean folder = child.getAllowsChildren();
        int nn = this.children.size();
        for (int ii = 0; ii < nn; ++ii) {
            FileTreeNode ochild = (FileTreeNode)this.children.get(ii);
            File oname = (File)ochild.getUserObject();
            boolean ofolder = ochild.getAllowsChildren();
            if (!(folder == ofolder ? file.compareTo(oname) <= 0 : !folder)) continue;
            return ii;
        }
        return this.children.size();
    }

    @Override
    public String toString() {
        if (this.file == null) {
            return super.toString();
        }
        return this.getName();
    }
}

