package com.threerings.swing.filetree;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;

import com.google.common.collect.Sets;

public class ChainFileFilter implements FileFilter{
	private Set<FileFilter> filters = Sets.newHashSet();
	public ChainFileFilter(FileFilter ...filters) {
		
		for(FileFilter filter : filters) {
			if(filter != null) {
				this.filters.add(filter);
			}
		}
	}
	
	@Override
	public boolean accept(File pathname) {
		if(filters != null) {
			for(FileFilter filter : filters) {
				if(filter != null && !filter.accept(pathname)) {
					return false;
				}
			}
		}
		return true;
	}
	
	public void add(FileFilter filter) {
		this.filters.add(filter);
	}
}
