/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.samskivert.util.Config;
import com.threerings.crowd.chat.client.ChatDirector;
import com.threerings.crowd.client.LocationDirector;
import com.threerings.crowd.client.OccupantDirector;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.opengl.GlCanvasTool;
import com.threerings.opengl.GlView;
import com.threerings.opengl.gui.Root;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.presents.client.Client;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.tudey.tools.ToolServer;
import com.threerings.tudey.util.TudeyContext;
import com.threerings.tudey.util.TudeySceneFactory;
import com.threerings.util.MessageManager;
import com.threerings.util.Name;
import com.threerings.whirled.client.SceneDirector;
import com.threerings.whirled.client.persist.SceneRepository;
import com.threerings.whirled.data.SceneModel;
import com.threerings.whirled.util.NoSuchSceneException;
import com.threerings.whirled.util.SceneFactory;
import com.threerings.whirled.util.WhirledContext;

public abstract class TudeyTool
extends GlCanvasTool
implements TudeyContext {
    protected Config _config = new Config("tool");
    protected Client _client;
    protected ToolServer _server;
    protected LocationDirector _locdir = new LocationDirector((CrowdContext)this);
    protected OccupantDirector _occdir = new OccupantDirector((CrowdContext)this);
    protected ChatDirector _chatdir = new ChatDirector((CrowdContext)this, "chat");
    protected SceneDirector _scenedir;
    protected Root _root;
    protected GlView _view;

    public TudeyTool(String msgs) {
        super(msgs);
        SceneRepository screp = this.createSceneRepository();
        this._scenedir = this.createSceneDirector(this._locdir, screp);
        this._root = this.createRoot();
        this._root.setModalShade(new Color4f(0.0f, 0.0f, 0.0f, 0.5f));
    }

    protected SceneRepository createSceneRepository() {
        return new SceneRepository(){

            public SceneModel loadSceneModel(int sceneId) throws NoSuchSceneException {
                throw new NoSuchSceneException(sceneId);
            }

            public void storeSceneModel(SceneModel model) {
            }

            public void deleteSceneModel(int sceneId) {
            }
        };
    }

    protected SceneDirector createSceneDirector(LocationDirector locationDirector, SceneRepository screp) {
        return new SceneDirector((WhirledContext)this, locationDirector, screp, (SceneFactory)new TudeySceneFactory());
    }

    public Config getConfig() {
        return this._config;
    }

    public Client getClient() {
        return this._client;
    }

    public DObjectManager getDObjectManager() {
        return this._client.getDObjectManager();
    }

    public LocationDirector getLocationDirector() {
        return this._locdir;
    }

    public OccupantDirector getOccupantDirector() {
        return this._occdir;
    }

    public ChatDirector getChatDirector() {
        return this._chatdir;
    }

    public void setPlaceView(PlaceView view) {
        this.setView((GlView)view);
    }

    public void clearPlaceView(PlaceView view) {
        this.setView(null);
    }

    public SceneDirector getSceneDirector() {
        return this._scenedir;
    }

    @Override
    public Root getRoot() {
        return this._root;
    }

    @Override
    protected void initSharedManagers() {
        this._client = new Client(null, this.getRunQueue());
        Injector injector = Guice.createInjector((Module[])new Module[]{new ToolServer.ToolModule(this._client)});
        this._server = (ToolServer)((Object)injector.getInstance(ToolServer.class));
        try {
            this._server.init(injector);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize server.", e);
        }
        this._rsrcmgr = this._server.getResourceManager();
        this._msgmgr = new MessageManager("i18n", this._rsrcmgr);
        this._cfgmgr = this._server.getConfigManager();
        this._colorpos = this._server.getColorPository();
    }

    @Override
    protected void didInit() {
        super.didInit();
        this._server.startStandaloneClient(new Name("editor"));
    }

    @Override
    protected void willShutdown() {
        super.willShutdown();
        this._server.stopStandaloneClient();
    }

    @Override
    protected void updateView(float elapsed) {
        if (this._view != null) {
            this._view.tick(elapsed);
        }
        this._root.tick(elapsed);
        super.updateView(elapsed);
    }

    @Override
    protected void compositeView() {
        super.compositeView();
        if (this._view != null) {
            this._view.composite();
        }
        this._root.composite();
    }

    protected void setView(GlView view) {
        if (this._view != null) {
            this._view.wasRemoved();
        }
        if ((this._view = view) != null) {
            this._view.wasAdded();
        }
    }

    public GlView getGlView() {
        return this._view;
    }
}

