/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.tools;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.threerings.tudey.client.sprite.EntrySprite;
import com.threerings.tudey.data.TudeySceneModel;
import com.threerings.tudey.tools.SceneEditor;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class LayerTableModel
extends AbstractTableModel
implements TudeySceneModel.LayerObserver {
    protected SceneEditor _editor;
    protected List<Boolean> _vis;
    protected TudeySceneModel _scene;

    public LayerTableModel(SceneEditor editor) {
        this._editor = editor;
    }

    public JTable getTable() {
        JTable table = new JTable(this);
        JCheckBox box = new JCheckBox();
        box.setHorizontalAlignment(0);
        table.setDefaultEditor(Boolean.class, new DefaultCellEditor(box){

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }
        });
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn numCol = columnModel.getColumn(0);
        numCol.setResizable(false);
        numCol.setMaxWidth(20);
        TableColumn visCol = columnModel.getColumn(2);
        visCol.setResizable(false);
        visCol.setMaxWidth(10);
        return table;
    }

    public void setScene(TudeySceneModel scene) {
        this._scene = scene;
        this._scene.addObserver(this);
        this._vis = Lists.newArrayList(Collections.nCopies(this.getRowCount(), Boolean.TRUE));
        this.fireTableDataChanged();
    }

    public int addLayer(String name, int position) {
        int newLayer = this._scene.addLayer(name, position);
        this._vis.add(newLayer, Boolean.TRUE);
        this.fireTableRowsInserted(newLayer, newLayer);
        return newLayer;
    }

    public void removeLayer(int layer) {
        this._scene.removeLayer(layer);
        this._vis.remove(layer);
        this.fireTableRowsDeleted(layer, layer);
    }

    public List<Boolean> getLayerVisibility() {
        return Collections.unmodifiableList(this._vis);
    }

    @Override
    public int getRowCount() {
        return this._scene == null ? 0 : this._scene.getLayers().size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return row;
            }
            default: {
                return this._scene.getLayers().get(row);
            }
            case 2: 
        }
        return this._vis.get(row);
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            default: {
                return String.class;
            }
            case 2: 
        }
        return Boolean.class;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "#";
            }
            default: {
                return "Layer";
            }
            case 2: 
        }
        return "\u0298";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return false;
            }
            default: {
                return row > 7;
            }
            case 2: 
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        Preconditions.checkArgument((boolean)this.isCellEditable(row, column));
        switch (column) {
            default: {
                this._scene.renameLayer(row, String.valueOf(value));
                break;
            }
            case 2: {
                Boolean visible = (Boolean)value;
                this._vis.set(row, visible);
                this.updateVisibility(row, visible);
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public void setVisibilities(int ... visibleLayers) {
        List viz = Ints.asList((int[])visibleLayers);
        int nn = this._vis.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._vis.set(ii, viz.contains(ii));
        }
        this.fireTableDataChanged();
        for (TudeySceneModel.Entry entry : this._scene.getEntries()) {
            Object key = entry.getKey();
            this.setVisibility(key, this._vis.get(this._scene.getLayer(key)));
        }
    }

    protected void updateVisibility(int layer, boolean visible) {
        for (TudeySceneModel.Entry entry : this._scene.getEntries()) {
            Object key = entry.getKey();
            if (layer != this._scene.getLayer(key)) continue;
            this.setVisibility(key, visible);
        }
    }

    @Override
    public void entryAdded(TudeySceneModel.Entry entry) {
    }

    @Override
    public void entryUpdated(TudeySceneModel.Entry oentry, TudeySceneModel.Entry nentry) {
    }

    @Override
    public void entryRemoved(TudeySceneModel.Entry oentry) {
    }

    @Override
    public void entryLayerWasSet(Object key, int layer) {
        this.setVisibility(key, this._vis.get(layer));
    }

    protected void setVisibility(Object key, boolean visible) {
        EntrySprite sprite = this._editor.getView().getEntrySprite(key);
        if (sprite != null) {
            sprite.setVisible(visible);
        }
    }
}

