/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.model;

import com.threerings.expr.BooleanExpression;
import com.threerings.expr.Bound;
import com.threerings.expr.MutableFloat;
import com.threerings.expr.Scope;
import com.threerings.expr.Scoped;
import com.threerings.math.Box;
import com.threerings.math.Ray3D;
import com.threerings.math.Transform3D;
import com.threerings.math.Vector3f;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.model.Model;
import com.threerings.opengl.model.config.ConditionalConfig;
import com.threerings.opengl.scene.Scene;
import com.threerings.opengl.scene.SceneElement;
import com.threerings.opengl.util.GlContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Conditional
extends Model.Implementation
implements Enqueueable {
    protected GlContext _ctx;
    protected ConditionalConfig _config;
    protected BooleanExpression.Evaluator[] _evaluators;
    protected Model[] _models;
    protected Model _active;
    @Bound(value="worldTransform")
    protected Transform3D _parentWorldTransform;
    @Bound(value="viewTransform")
    protected Transform3D _parentViewTransform;
    @Bound
    protected Transform3D _localTransform;
    @Scoped
    protected Transform3D _worldTransform = new Transform3D();
    @Scoped
    protected Transform3D _viewTransform = new Transform3D();
    @Scoped
    protected MutableFloat _distance = new MutableFloat();
    protected SceneElement.TickPolicy _tickPolicy;
    protected int _influenceFlags;
    @Scoped
    protected Box _bounds = new Box();
    protected boolean _completed;
    protected transient Vector3f _scratch = new Vector3f();

    public Conditional(GlContext ctx, Scope parentScope, ConditionalConfig config) {
        super(parentScope);
        this.setConfig(ctx, config);
    }

    public void setConfig(GlContext ctx, ConditionalConfig config) {
        this._ctx = ctx;
        this._config = config;
        this.updateFromConfig();
    }

    @Override
    public void enqueue() {
        this._parentViewTransform.compose(this._localTransform, this._viewTransform);
    }

    @Override
    public List<Model> getChildren() {
        return Collections.unmodifiableList(Arrays.asList(this._models));
    }

    @Override
    public boolean hasCompleted() {
        return this._completed;
    }

    @Override
    public void reset() {
        for (Model model : this._models) {
            model.reset();
        }
        this._completed = false;
    }

    @Override
    public int getInfluenceFlags() {
        return this._influenceFlags;
    }

    @Override
    public Box getBounds() {
        return this._bounds;
    }

    @Override
    public void updateBounds() {
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this.updateActive();
        this._active.updateBounds();
        Box nbounds = this._active.getBounds();
        if (!this._bounds.equals(nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
    }

    @Override
    public void drawBounds() {
        this._active.drawBounds();
    }

    @Override
    public void dumpInfo(String prefix) {
        System.out.println(prefix + "Conditional: " + this._worldTransform + " " + this._bounds);
        this._active.dumpInfo(prefix + "  ");
    }

    @Override
    public SceneElement.TickPolicy getTickPolicy() {
        return this._tickPolicy;
    }

    @Override
    public void wasAdded() {
        Scene scene = ((Model)this._parentScope).getScene(this);
        this._active.wasAdded(scene);
    }

    @Override
    public void willBeRemoved() {
        this._active.willBeRemoved();
    }

    @Override
    public void tick(float elapsed) {
        if (this._completed) {
            return;
        }
        if (this._parentWorldTransform == null) {
            this._worldTransform.set(this._localTransform);
        } else {
            this._parentWorldTransform.compose(this._localTransform, this._worldTransform);
        }
        this.updateActive();
        this._active.tick(elapsed);
        Box nbounds = this._active.getBounds();
        if (!this._bounds.equals(nbounds)) {
            ((Model)this._parentScope).boundsWillChange(this);
            this._bounds.set(nbounds);
            ((Model)this._parentScope).boundsDidChange(this);
        }
        if (this._completed = this._active.hasCompleted()) {
            ((Model)this._parentScope).completed(this);
        }
    }

    @Override
    public boolean getIntersection(Ray3D ray, Vector3f result) {
        return this._active.getIntersection(ray, result);
    }

    @Override
    public void composite() {
        this._ctx.getCompositor().addEnqueueable(this);
        this._active.composite();
    }

    protected void updateFromConfig() {
        int ii;
        this._evaluators = new BooleanExpression.Evaluator[this._config.cases.length];
        for (int ii2 = 0; ii2 < this._evaluators.length; ++ii2) {
            this._evaluators[ii2] = this._config.cases[ii2].condition.createEvaluator(this);
        }
        Model[] omodels = this._models;
        this._models = new Model[this._config.cases.length + 1];
        for (ii = 0; ii < this._models.length; ++ii) {
            Model model;
            this._models[ii] = model = omodels == null || omodels.length <= ii ? new Model(this._ctx) : omodels[ii];
            model.setParentScope(this);
            if (ii == this._config.cases.length) {
                model.setConfig(this._config.defaultModel);
                model.getLocalTransform().set(this._config.defaultTransform);
                continue;
            }
            ConditionalConfig.Case caze = this._config.cases[ii];
            model.setConfig(caze.model);
            model.getLocalTransform().set(caze.transform);
        }
        if (omodels != null) {
            for (ii = this._models.length; ii < omodels.length; ++ii) {
                omodels[ii].dispose();
            }
        }
        this._influenceFlags = this._config.influences.getFlags();
        this.updateBounds();
    }

    protected void updateActive() {
        SceneElement.TickPolicy npolicy;
        int idx;
        Transform3D cameraTransform = this._ctx.getCompositor().getCamera().getWorldTransform();
        this._distance.value = cameraTransform.getTranslation().distance(this._worldTransform.transformPoint(Vector3f.ZERO, this._scratch));
        for (idx = 0; idx < this._evaluators.length && !this._evaluators[idx].evaluate(); ++idx) {
        }
        Model nactive = this._models[idx];
        if (this._active == nactive) {
            return;
        }
        Scene scene = ((Model)this._parentScope).getScene(this);
        if (scene != null && this._active != null) {
            this._active.willBeRemoved();
        }
        this._active = nactive;
        if (scene != null) {
            this._active.wasAdded(scene);
        }
        if ((npolicy = this._config.tickPolicy) == SceneElement.TickPolicy.DEFAULT) {
            npolicy = this._active.getTickPolicy();
        }
        if (this._tickPolicy != npolicy) {
            ((Model)this._parentScope).tickPolicyWillChange(this);
            this._tickPolicy = npolicy;
            ((Model)this._parentScope).tickPolicyDidChange(this);
        }
    }
}

