/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.threerings.config.ConfigReference;
import com.threerings.opengl.gui.BoundedRangeModel;
import com.threerings.opengl.gui.Button;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Container;
import com.threerings.opengl.gui.UIConstants;
import com.threerings.opengl.gui.config.StyleConfig;
import com.threerings.opengl.gui.event.ActionEvent;
import com.threerings.opengl.gui.event.ActionListener;
import com.threerings.opengl.gui.event.ChangeEvent;
import com.threerings.opengl.gui.event.ChangeListener;
import com.threerings.opengl.gui.event.MouseAdapter;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.event.MouseListener;
import com.threerings.opengl.gui.event.MouseWheelListener;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.gui.util.Insets;
import com.threerings.opengl.util.GlContext;

public class ScrollBar
extends Container
implements UIConstants {
    protected ChangeListener _updater = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent event) {
            ScrollBar.this.update();
        }
    };
    protected MouseListener _wellListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent event) {
            int mx = event.getX() - ScrollBar.this.getAbsoluteX();
            int my = event.getY() - ScrollBar.this.getAbsoluteY();
            int dv = 0;
            if (ScrollBar.this._horz) {
                if (mx < ScrollBar.this._thumb.getX()) {
                    dv = -1;
                } else if (mx > ScrollBar.this._thumb.getX() + ScrollBar.this._thumb.getWidth()) {
                    dv = 1;
                }
            } else if (my < ScrollBar.this._thumb.getY()) {
                dv = 1;
            } else if (my > ScrollBar.this._thumb.getY() + ScrollBar.this._thumb.getHeight()) {
                dv = -1;
            }
            if (dv != 0) {
                ScrollBar.this._model.setValue(ScrollBar.this._model.getValue() + (dv *= Math.max(1, ScrollBar.this._model.getExtent())));
            }
            event.consume();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            event.consume();
        }
    };
    protected MouseAdapter _thumbListener = new MouseAdapter(){
        protected int _sx;
        protected int _sy;
        protected int _sv;

        @Override
        public void mousePressed(MouseEvent event) {
            this._sv = ScrollBar.this._model.getValue();
            this._sx = event.getX() - ScrollBar.this.getAbsoluteX();
            this._sy = event.getY() - ScrollBar.this.getAbsoluteY();
            event.consume();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            int dv = 0;
            if (ScrollBar.this._horz) {
                int mx = event.getX() - ScrollBar.this.getAbsoluteX();
                dv = (mx - this._sx) * ScrollBar.this._model.getRange() / (ScrollBar.this._well.getWidth() - ScrollBar.this._well.getInsets().getHorizontal());
            } else {
                int my = event.getY() - ScrollBar.this.getAbsoluteY();
                dv = (this._sy - my) * ScrollBar.this._model.getRange() / (ScrollBar.this._well.getHeight() - ScrollBar.this._well.getInsets().getVertical());
            }
            if (dv != 0) {
                ScrollBar.this._model.setValue(this._sv + dv);
            }
            event.consume();
        }
    };
    protected ActionListener _buttoner = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            int delta = (ScrollBar.this._less == event.getSource() ? -1 : 1) * ScrollBar.this._model.getScrollIncrement();
            ScrollBar.this._model.setValue(ScrollBar.this._model.getValue() + delta);
        }
    };
    protected BoundedRangeModel _model;
    protected boolean _horz;
    protected Button _less;
    protected Button _more;
    protected Component _well;
    protected Component _thumb;
    protected MouseWheelListener _wheelListener;
    private String _stylePrefix;
    protected static final int THUMB_RATIO = 2;

    public ScrollBar(GlContext ctx) {
        this(ctx, 1);
    }

    public ScrollBar(GlContext ctx, int orientation) {
        this(ctx, orientation, 0, 100, 0, 10);
    }

    public ScrollBar(GlContext ctx, int orientation, int min, int value, int extent, int max) {
        this(ctx, orientation, new BoundedRangeModel(min, value, extent, max));
    }

    public ScrollBar(GlContext ctx, int orientation, BoundedRangeModel model, String scrollBarPrefix) {
        this(ctx, orientation, model);
        this._stylePrefix = scrollBarPrefix;
    }

    public ScrollBar(GlContext ctx, int orientation, BoundedRangeModel model) {
        super(ctx, new BorderLayout());
        this._horz = orientation == 0;
        this._model = model;
        this._model.addChangeListener(this._updater);
        this._wheelListener = this._model.createWheelListener();
        this._well = new Component(this._ctx);
        this._well.addListener(this._wellListener);
        this._thumb = new Component(this._ctx);
        this._thumb.addListener(this._thumbListener);
        this._less = new Button(this._ctx, "");
        this._less.addListener(this._buttoner);
        this._more = new Button(this._ctx, "");
        this._more.addListener(this._buttoner);
        this.add(this._well, BorderLayout.CENTER);
        this.add(this._thumb, BorderLayout.IGNORE);
        this.add(this._less, this._horz ? BorderLayout.WEST : BorderLayout.NORTH);
        this.add(this._more, this._horz ? BorderLayout.EAST : BorderLayout.SOUTH);
    }

    public BoundedRangeModel getModel() {
        return this._model;
    }

    @Override
    public void setStyleConfig(ConfigReference<StyleConfig> ref) {
        String prefix = ref == null ? this.getDefaultStyleConfig() : ref.getName();
        this._well.setStyleConfig(prefix + "Well");
        this._thumb.setStyleConfig(prefix + "Thumb");
        this._less.setStyleConfig(prefix + "Less");
        this._more.setStyleConfig(prefix + "More");
        super.setStyleConfig(ref);
    }

    @Override
    protected void wasAdded() {
        super.wasAdded();
        this.addListener(this._wheelListener);
    }

    @Override
    protected void wasRemoved() {
        super.wasRemoved();
        this.removeListener(this._wheelListener);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.update();
    }

    @Override
    public Component getHitComponent(int mx, int my) {
        if (this._thumb.getHitComponent(mx - this._x, my - this._y) != null) {
            return this._thumb;
        }
        return super.getHitComponent(mx, my);
    }

    protected void update() {
        if (!this.isAdded()) {
            return;
        }
        int value = this._model.getValue();
        int extent = this._model.getExtent();
        int range = this._model.getRange();
        boolean enabled = this.isEnabled();
        this._less.setEnabled(enabled && value > this._model.getMinimum());
        this._more.setEnabled(enabled && value + extent < this._model.getMaximum());
        this._thumb.setEnabled(enabled && range > extent);
        Insets winsets = this._well.getInsets();
        int tx = 0;
        int ty = 0;
        int twidth = this._well.getWidth() - winsets.getHorizontal();
        int theight = this._well.getHeight() - winsets.getVertical();
        range = Math.max(1, range);
        if (this._horz) {
            int wellSize = twidth;
            if ((twidth = extent * wellSize / range) < 2 * theight) {
                wellSize -= 2 * theight - twidth;
                twidth = 2 * theight;
            }
            tx = value * wellSize / range;
        } else {
            int wellSize = theight;
            if ((theight = extent * wellSize / range) < 2 * twidth) {
                wellSize -= 2 * twidth - theight;
                theight = 2 * twidth;
            }
            ty = (range - extent - value) * wellSize / range;
        }
        this._thumb.setBounds(this._well.getX() + winsets.left + tx, this._well.getY() + winsets.bottom + ty, twidth, theight);
    }

    @Override
    protected String getDefaultStyleConfig() {
        if (this._stylePrefix == null) {
            return "Default/ScrollBar" + (this._horz ? "H" : "V");
        }
        return this._stylePrefix + (this._horz ? "H" : "V");
    }

    @Override
    protected void layout() {
        super.layout();
        this.update();
    }
}

