/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor.config;

import com.threerings.config.ConfigReference;
import com.threerings.config.ConfigReferenceSet;
import com.threerings.editor.Editable;
import com.threerings.editor.EditorTypes;
import com.threerings.export.Exportable;
import com.threerings.expr.Scope;
import com.threerings.opengl.compositor.RenderEffect;
import com.threerings.opengl.compositor.config.StepConfig;
import com.threerings.opengl.renderer.TextureRenderer;
import com.threerings.opengl.renderer.config.TextureConfig;
import com.threerings.opengl.util.GlContext;
import com.threerings.util.DeepObject;
import org.lwjgl.opengl.PixelFormat;

@EditorTypes(value={Texture.class})
public abstract class TargetConfig
extends DeepObject
implements Exportable {
    @Editable
    public Input input = Input.PREVIOUS;
    @Editable
    public StepConfig[] steps = new StepConfig[0];

    @Deprecated
    public void getUpdateReferences(ConfigReferenceSet refs) {
    }

    public boolean isSupported(GlContext ctx, boolean fallback) {
        for (StepConfig step : this.steps) {
            if (step.isSupported(ctx, fallback)) continue;
            return false;
        }
        return true;
    }

    public abstract RenderEffect.Target createEffectTarget(GlContext var1, Scope var2);

    public static class Output
    extends TargetConfig {
        @Override
        public RenderEffect.Target createEffectTarget(GlContext ctx, Scope scope) {
            return new RenderEffect.OutputTarget(ctx, scope, this);
        }
    }

    public static class Texture
    extends TargetConfig {
        @Editable(weight=-1.0, nullable=true)
        public ConfigReference<TextureConfig> color;
        @Editable(weight=-1.0, nullable=true)
        public ConfigReference<TextureConfig> depth;
        @Editable(min=0.0, weight=-1.0, hgroup="b")
        public int depthBits;
        @Editable(min=0.0, weight=-1.0, hgroup="b")
        public int stencilBits;

        public TextureRenderer getTextureRenderer(GlContext ctx) {
            TextureConfig cconfig = ctx.getConfigManager().getConfig(TextureConfig.class, this.color);
            com.threerings.opengl.renderer.Texture ctex = cconfig == null ? null : cconfig.getTexture(ctx);
            TextureConfig dconfig = ctx.getConfigManager().getConfig(TextureConfig.class, this.depth);
            com.threerings.opengl.renderer.Texture dtex = dconfig == null ? null : dconfig.getTexture(ctx);
            int alphaBits = ctex != null && ctex.hasAlpha() ? 1 : 0;
            return TextureRenderer.getInstance(ctx, ctex, dtex, new PixelFormat(alphaBits, this.depthBits, this.stencilBits));
        }

        @Override
        public boolean isSupported(GlContext ctx, boolean fallback) {
            TextureConfig cconfig = ctx.getConfigManager().getConfig(TextureConfig.class, this.color);
            TextureConfig dconfig = ctx.getConfigManager().getConfig(TextureConfig.class, this.depth);
            return !(cconfig == null && dconfig == null || cconfig != null && !cconfig.isSupported(ctx, fallback) || dconfig != null && !dconfig.isSupported(ctx, fallback));
        }

        @Override
        public RenderEffect.Target createEffectTarget(GlContext ctx, Scope scope) {
            return new RenderEffect.TextureTarget(ctx, scope, this);
        }
    }

    public static enum Input {
        NONE,
        PREVIOUS;

    }
}

