/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.compositor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.QuickSort;
import com.threerings.expr.Scope;
import com.threerings.opengl.camera.Camera;
import com.threerings.opengl.compositor.Compositable;
import com.threerings.opengl.compositor.Dependency;
import com.threerings.opengl.compositor.Enqueueable;
import com.threerings.opengl.compositor.RenderEffect;
import com.threerings.opengl.compositor.RenderQueue;
import com.threerings.opengl.compositor.config.RenderEffectConfig;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.renderer.state.ColorMaskState;
import com.threerings.opengl.renderer.state.DepthState;
import com.threerings.opengl.renderer.state.StencilState;
import com.threerings.opengl.util.GlContext;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import org.lwjgl.opengl.GL11;

public class Compositor {
    protected GlContext _ctx;
    protected Camera _camera = new Camera();
    protected Color4f _defaultBackgroundColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    protected Color4f _backgroundColor;
    protected List<Compositable> _roots = Lists.newArrayList();
    protected List<RenderEffect> _effects = Lists.newArrayList();
    protected Map<Dependency, Dependency> _dependencies = Maps.newHashMap();
    protected List<Enqueueable> _enqueueables = Lists.newArrayList();
    protected List<RenderEffect> _combinedEffects = Lists.newArrayList();
    protected boolean _skipColorClear;
    protected RenderQueue.Group _group;
    protected int _subrenderDepth;
    protected Object _subrenderSource;
    protected Map<RenderEffectConfig, SoftReference<RenderEffect>> _cachedEffects = Maps.newIdentityHashMap();
    protected List<SoftReference<State>> _statePool = Lists.newArrayList();

    public Compositor(GlContext ctx) {
        this._ctx = ctx;
        this._group = new RenderQueue.Group(ctx);
    }

    public void setCamera(Camera camera) {
        this._camera = camera;
    }

    public Camera getCamera() {
        return this._camera;
    }

    public Color4f getDefaultBackgroundColor() {
        return this._defaultBackgroundColor;
    }

    public void setBackgroundColor(Color4f color) {
        this._backgroundColor = color;
    }

    public Color4f getBackgroundColor() {
        return this._backgroundColor;
    }

    public void addRoot(Compositable root) {
        this._roots.add(root);
    }

    public void removeRoot(Compositable root) {
        this._roots.remove(root);
    }

    public void addEffect(RenderEffect effect) {
        this._effects.add(effect);
    }

    public void removeEffect(RenderEffect effect) {
        this._effects.remove(effect);
    }

    public void renderView() {
        int nn = this._roots.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._roots.get(ii).composite();
        }
        Renderer renderer = this._ctx.getRenderer();
        renderer.resetStats();
        this._combinedEffects.addAll(this._effects);
        for (Dependency dependency : this._dependencies.values()) {
            dependency.resolve();
        }
        this.enqueueEnqueueables();
        this._group.sortQueues();
        this._camera.apply(renderer);
        QuickSort.sort(this._combinedEffects);
        this.renderPrevious(this._combinedEffects.size());
        this.clearDependencies();
        this._skipColorClear = false;
        this._group.clearQueues();
        this._combinedEffects.clear();
        renderer.cleanup();
    }

    public State prepareSubrender() {
        State state = this.getStateFromPool();
        state.swap(this);
        return state;
    }

    public void performSubrender(Object source) {
        Object osource = this._subrenderSource;
        this._subrenderSource = source;
        ++this._subrenderDepth;
        int nn = this._roots.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._roots.get(ii).composite();
        }
        for (Dependency dependency : this._dependencies.values()) {
            dependency.resolve();
        }
        this.enqueueEnqueueables();
        this._group.sortQueues();
        this._camera.apply(this._ctx.getRenderer());
        this.renderPrevious(0);
        this.clearDependencies();
        this._skipColorClear = false;
        this._group.clearQueues();
        this._subrenderSource = osource;
        --this._subrenderDepth;
    }

    public void cleanupSubrender(State ostate) {
        ostate.swap(this);
        this._statePool.add(new SoftReference<State>(ostate));
    }

    public int getSubrenderDepth() {
        return this._subrenderDepth;
    }

    public Object getSubrenderSource() {
        return this._subrenderSource;
    }

    public void addDependency(Dependency dependency) {
        Dependency previous = this._dependencies.put(dependency, dependency);
        if (previous != null) {
            dependency.merge(previous);
        }
    }

    public void clearDependencies() {
        for (Dependency dependency : this._dependencies.values()) {
            dependency.cleanup();
        }
        this._dependencies.clear();
    }

    public void setDependencies(Map<Dependency, Dependency> dependencies) {
        this._dependencies = dependencies;
    }

    public Map<Dependency, Dependency> getDependencies() {
        return this._dependencies;
    }

    public void addEnqueueable(Enqueueable enqueueable) {
        this._enqueueables.add(enqueueable);
    }

    public void addEnqueueable(Enqueueable enqueueable, int maxSubrenderDepth) {
        if (this._subrenderDepth <= maxSubrenderDepth) {
            this._enqueueables.add(enqueueable);
        }
    }

    public void enqueueEnqueueables() {
        int nn = this._enqueueables.size();
        for (int ii = 0; ii < nn; ++ii) {
            this._enqueueables.get(ii).enqueue();
        }
        this._enqueueables.clear();
    }

    public void setSkipColorClear() {
        this._skipColorClear = true;
    }

    public void addDependencyEffect(RenderEffectConfig config) {
        RenderEffect effect;
        SoftReference<RenderEffect> ref = this._cachedEffects.get(config);
        RenderEffect renderEffect = effect = ref == null ? null : ref.get();
        if (effect == null) {
            effect = new RenderEffect(this._ctx, (Scope)this._ctx.getScope(), config);
            this._cachedEffects.put(config, new SoftReference<RenderEffect>(effect));
        }
        this._combinedEffects.add(effect);
    }

    public void renderPrevious(int idx) {
        int minPriority = Integer.MIN_VALUE;
        int maxPriority = Integer.MAX_VALUE;
        if (idx > 0) {
            int pidx = idx - 1;
            RenderEffect peffect = this._combinedEffects.get(pidx);
            peffect.render(pidx);
            minPriority = peffect.getPriority() + 1;
        }
        if (idx < this._combinedEffects.size()) {
            maxPriority = this._combinedEffects.get(idx).getPriority();
        }
        this.renderQueues(minPriority, maxPriority);
    }

    public RenderQueue getQueue(String name) {
        return this._group.getQueue(name);
    }

    public void resetQueues() {
        this._group = new RenderQueue.Group(this._ctx);
    }

    public RenderQueue.Group getGroup() {
        return this._group;
    }

    protected void renderQueues(int minPriority, int maxPriority) {
        if (minPriority == Integer.MIN_VALUE) {
            Renderer renderer = this._ctx.getRenderer();
            int bits = 1280;
            if (!this._skipColorClear) {
                bits |= 0x4000;
                renderer.setClearColor(this._backgroundColor == null ? this._defaultBackgroundColor : this._backgroundColor);
                renderer.setState(ColorMaskState.ALL);
            }
            renderer.setClearDepth(1.0f);
            renderer.setState(DepthState.TEST_WRITE);
            renderer.setClearStencil(0);
            renderer.setState(StencilState.DISABLED);
            GL11.glClear((int)bits);
        }
        this._group.renderQueues("normal", minPriority, maxPriority);
    }

    protected State getStateFromPool() {
        for (int ii = this._statePool.size() - 1; ii >= 0; --ii) {
            State state = this._statePool.remove(ii).get();
            if (state == null) continue;
            return state;
        }
        return new State();
    }

    public static class State {
        protected Camera _camera = new Camera();
        protected Map<Dependency, Dependency> _dependencies = Maps.newHashMap();
        protected List<Enqueueable> _enqueueables = Lists.newArrayList();
        protected List<RenderEffect> _combinedEffects = Lists.newArrayList();
        protected boolean _skipColorClear;

        public void swap(Compositor compositor) {
            Camera ocamera = this._camera;
            this._camera = compositor._camera;
            compositor._camera = ocamera;
            Map<Dependency, Dependency> odeps = this._dependencies;
            this._dependencies = compositor._dependencies;
            compositor._dependencies = odeps;
            List<Enqueueable> oenqs = this._enqueueables;
            this._enqueueables = compositor._enqueueables;
            compositor._enqueueables = oenqs;
            List<RenderEffect> oeffects = this._combinedEffects;
            this._combinedEffects = compositor._combinedEffects;
            compositor._combinedEffects = oeffects;
            boolean oskip = this._skipColorClear;
            this._skipColorClear = compositor._skipColorClear;
            compositor._skipColorClear = oskip;
        }
    }
}

