/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl;

import com.threerings.opengl.GlCanvas;
import com.threerings.opengl.Log;
import java.awt.EventQueue;
import java.lang.reflect.Field;
import javax.swing.JPopupMenu;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Util;

public class AWTCanvas
extends AWTGLCanvas
implements GlCanvas {
    protected Runnable _updater;

    public AWTCanvas(PixelFormat pformat) throws LWJGLException {
        super(pformat);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
    }

    @Override
    public Drawable getDrawable() {
        return this;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void makeCurrent() {
        try {
            super.makeCurrent();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Failed to make context current.", new Object[]{e});
        }
    }

    public void swapBuffers() {
        try {
            super.swapBuffers();
        }
        catch (LWJGLException e) {
            Log.log.warning((Object)"Error swapping buffers.", new Object[]{e});
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.stopUpdating();
    }

    protected void initGL() {
        try {
            Field field = AWTGLCanvas.class.getDeclaredField("reentry_count");
            field.setAccessible(true);
            field.setInt(this, 2);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to access field.", new Object[]{e});
        }
        this.disableEvents(8192L);
        this.setIgnoreRepaint(true);
        this.didInit();
        this.startUpdating();
    }

    protected void paintGL() {
        this.renderView();
    }

    protected void didInit() {
    }

    protected void startUpdating() {
        this._updater = new Runnable(){

            @Override
            public void run() {
                if (AWTCanvas.this._updater != null) {
                    AWTCanvas.this.updateFrame();
                    EventQueue.invokeLater(this);
                }
            }
        };
        EventQueue.invokeLater(this._updater);
    }

    protected void stopUpdating() {
        this._updater = null;
    }

    protected void updateFrame() {
        try {
            this.updateView();
            if (this.isShowing()) {
                this.paint(null);
                this.swapBuffers();
            }
            Util.checkGLError();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Caught exception in frame loop.", new Object[]{e});
        }
    }

    protected void updateView() {
    }

    protected void renderView() {
    }
}

