/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.export.tools;

import com.samskivert.util.FileUtil;
import com.threerings.export.BinaryImporter;
import com.threerings.export.Log;
import com.threerings.export.XMLExporter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.DirectoryScanner;

public class BinaryToXMLConverter {
    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            BinaryToXMLConverter.convert(args[0], args[1]);
        } else if (args.length == 1) {
            BinaryToXMLConverter.convert(args[0]);
        } else {
            System.err.println("Usage: BinaryToXMLConverter <binary input file> <xml output file>");
            System.err.println("   or  BinaryToXMLConverter <binary input file pattern>");
        }
    }

    public static void convert(String pattern) throws IOException {
        Log.log.info((Object)"Starting conversion", new Object[]{"pattern", pattern, "pwd", new File(".").getCanonicalPath()});
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(".");
        scanner.setIncludes(new String[]{pattern});
        scanner.scan();
        int count = 0;
        for (String source : scanner.getIncludedFiles()) {
            try {
                BinaryToXMLConverter.convert(source, FileUtil.resuffix((File)new File(source), (String)".dat", (String)".xml"));
                ++count;
            }
            catch (Exception e) {
                Log.log.warning((Object)"Error converting file.", new Object[]{"file", source, e});
            }
        }
        Log.log.info((Object)"Finished conversion", new Object[]{"count", count});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String source, String dest) throws IOException {
        BinaryImporter in = new BinaryImporter(new FileInputStream(source));
        XMLExporter out = new XMLExporter(new FileOutputStream(dest));
        try {
            try {
                while (true) {
                    out.writeObject(in.readObject());
                }
            }
            catch (EOFException e) {
                in.close();
                out.close();
            }
        }
        catch (Throwable throwable) {
            in.close();
            out.close();
            throw throwable;
        }
    }
}

