/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.tudey.server.logic;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.threerings.math.Vector2f;
import com.threerings.tudey.Log;
import com.threerings.tudey.config.ExpressionConfig;
import com.threerings.tudey.data.EntityKey;
import com.threerings.tudey.server.TudeySceneManager;
import com.threerings.tudey.server.logic.Logic;
import com.threerings.tudey.server.logic.TargetLogic;
import java.util.List;

public abstract class ExpressionLogic
extends Logic {
    protected ExpressionConfig _config;
    protected Logic _source;

    public void init(TudeySceneManager scenemgr, ExpressionConfig config, Logic source) {
        super.init(scenemgr);
        this._config = config;
        this._source = source;
        this.didInit();
    }

    public abstract Object evaluate(Logic var1, Object var2);

    @Override
    public boolean isActive() {
        return this._source.isActive();
    }

    @Override
    public EntityKey getEntityKey() {
        return this._source.getEntityKey();
    }

    @Override
    public Vector2f getTranslation() {
        return this._source.getTranslation();
    }

    @Override
    public float getRotation() {
        return this._source.getRotation();
    }

    protected void didInit() {
    }

    protected static Object parseValue(String str) {
        if (str.equalsIgnoreCase("null")) {
            return null;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return str;
        }
    }

    protected static boolean coerceToBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        if (value instanceof String) {
            String str = (String)value;
            try {
                return Double.parseDouble(str) != 0.0;
            }
            catch (NumberFormatException e) {
                return Boolean.parseBoolean(str);
            }
        }
        Log.log.warning((Object)"Cannot coerce value to boolean.", new Object[]{"value", value});
        return false;
    }

    protected static double coerceToDouble(Object value) {
        if (value == null) {
            return 0.0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException e) {
                return Boolean.parseBoolean(str) ? 1.0 : 0.0;
            }
        }
        Log.log.warning((Object)"Cannot coerce value to double.", new Object[]{"value", value});
        return 0.0;
    }

    protected static int coerceToInteger(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = (String)value;
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException e) {
                return Boolean.parseBoolean(str) ? 1 : 0;
            }
        }
        Log.log.warning((Object)"Cannot coerce value to double.", new Object[]{"value", value});
        return 0;
    }

    public static class Add
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Add.coerceToDouble(this._firstOperand.evaluate(activator, previous)) + Add.coerceToDouble(this._secondOperand.evaluate(activator, previous));
        }
    }

    public static class And
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            if (And.coerceToBoolean(this._firstOperand.evaluate(activator, previous)) && And.coerceToBoolean(this._secondOperand.evaluate(activator, previous))) {
                return true;
            }
            return false;
        }
    }

    public static abstract class BinaryOperation
    extends ExpressionLogic {
        protected ExpressionLogic _firstOperand;
        protected ExpressionLogic _secondOperand;

        @Override
        protected void didInit() {
            ExpressionConfig.BinaryOperation config = (ExpressionConfig.BinaryOperation)this._config;
            this._firstOperand = this.createExpression(config.firstOperand, this._source);
            this._secondOperand = this.createExpression(config.secondOperand, this._source);
        }
    }

    public static class Constant
    extends ExpressionLogic {
        protected Object _value;

        @Override
        public Object evaluate(Logic activator, Object previous) {
            return this._value;
        }

        @Override
        protected void didInit() {
            this._value = Constant.parseValue(((ExpressionConfig.Constant)this._config).value);
        }
    }

    public static class Decrement
    extends ExpressionLogic {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Decrement.coerceToDouble(previous) - 1.0;
        }
    }

    public static class Divide
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Divide.coerceToDouble(this._firstOperand.evaluate(activator, previous)) / Divide.coerceToDouble(this._secondOperand.evaluate(activator, previous));
        }
    }

    public static class Equals
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Objects.equal((Object)this._firstOperand.evaluate(activator, previous), (Object)this._secondOperand.evaluate(activator, previous));
        }
    }

    public static class Greater
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            if (Greater.coerceToDouble(this._firstOperand.evaluate(activator, previous)) > Greater.coerceToDouble(this._secondOperand.evaluate(activator, previous))) {
                return true;
            }
            return false;
        }
    }

    public static class GreaterEquals
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            if (GreaterEquals.coerceToDouble(this._firstOperand.evaluate(activator, previous)) >= GreaterEquals.coerceToDouble(this._secondOperand.evaluate(activator, previous))) {
                return true;
            }
            return false;
        }
    }

    public static class Increment
    extends ExpressionLogic {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Increment.coerceToDouble(previous) + 1.0;
        }
    }

    public static class IntegerEquals
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            if (IntegerEquals.coerceToInteger(this._firstOperand.evaluate(activator, previous)) == IntegerEquals.coerceToInteger(this._secondOperand.evaluate(activator, previous))) {
                return true;
            }
            return false;
        }
    }

    public static class Less
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            if (Less.coerceToDouble(this._firstOperand.evaluate(activator, previous)) < Less.coerceToDouble(this._secondOperand.evaluate(activator, previous))) {
                return true;
            }
            return false;
        }
    }

    public static class LessEquals
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            if (LessEquals.coerceToDouble(this._firstOperand.evaluate(activator, previous)) <= LessEquals.coerceToDouble(this._secondOperand.evaluate(activator, previous))) {
                return true;
            }
            return false;
        }
    }

    public static class Multiply
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Multiply.coerceToDouble(this._firstOperand.evaluate(activator, previous)) * Multiply.coerceToDouble(this._secondOperand.evaluate(activator, previous));
        }
    }

    public static class Negate
    extends UnaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return -Negate.coerceToDouble(this._operand.evaluate(activator, previous));
        }
    }

    public static class Not
    extends UnaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return !Not.coerceToBoolean(this._operand.evaluate(activator, previous));
        }
    }

    public static class NumTargets
    extends ExpressionLogic {
        protected TargetLogic _target;
        protected List<Logic> _targets = Lists.newArrayList();

        @Override
        public Object evaluate(Logic activator, Object previous) {
            this._target.resolve(activator, this._targets);
            Integer numTargets = new Integer(this._targets.size());
            this._targets.clear();
            return numTargets;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ExpressionConfig.NumTargets)this._config).target, this._source);
        }
    }

    public static class Or
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            if (!Or.coerceToBoolean(this._firstOperand.evaluate(activator, previous)) && !Or.coerceToBoolean(this._secondOperand.evaluate(activator, previous))) {
                return false;
            }
            return true;
        }
    }

    public static class Parsed
    extends ExpressionLogic {
        protected ExpressionLogic _expr;

        @Override
        public Object evaluate(Logic activator, Object previous) {
            return this._expr.evaluate(activator, previous);
        }

        @Override
        protected void didInit() {
            this._expr = this.createExpression(((ExpressionConfig.Parsed)this._config).getExpression(), this._source);
        }
    }

    public static class Power
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Math.pow(Power.coerceToDouble(this._firstOperand.evaluate(activator, previous)), Power.coerceToDouble(this._secondOperand.evaluate(activator, previous)));
        }
    }

    public static class Previous
    extends ExpressionLogic {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return previous;
        }
    }

    public static class Reference
    extends ExpressionLogic {
        protected TargetLogic _target;
        protected List<Logic> _targets = Lists.newArrayList();

        @Override
        public Object evaluate(Logic activator, Object previous) {
            String name = ((ExpressionConfig.Reference)this._config).name;
            this._target.resolve(activator, this._targets);
            int ii = 0;
            int nn = this._targets.size();
            while (ii < nn) {
                Object value = this._targets.get(ii).getVariable(name);
                if (value != null) {
                    this._targets.clear();
                    return value;
                }
                ++ii;
            }
            this._targets.clear();
            return null;
        }

        @Override
        protected void didInit() {
            this._target = this.createTarget(((ExpressionConfig.Reference)this._config).target, this._source);
        }
    }

    public static class Remainder
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Remainder.coerceToDouble(this._firstOperand.evaluate(activator, previous)) % Remainder.coerceToDouble(this._secondOperand.evaluate(activator, previous));
        }
    }

    public static class Subtract
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Subtract.coerceToDouble(this._firstOperand.evaluate(activator, previous)) - Subtract.coerceToDouble(this._secondOperand.evaluate(activator, previous));
        }
    }

    public static abstract class UnaryOperation
    extends ExpressionLogic {
        protected ExpressionLogic _operand;

        @Override
        protected void didInit() {
            this._operand = this.createExpression(((ExpressionConfig.UnaryOperation)this._config).operand, this._source);
        }
    }

    public static class Variable
    extends ExpressionLogic {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Float.valueOf(((ExpressionConfig.Variable)this._config).variable.getValue());
        }
    }

    public static class Xor
    extends BinaryOperation {
        @Override
        public Object evaluate(Logic activator, Object previous) {
            return Xor.coerceToBoolean(this._firstOperand.evaluate(activator, previous)) ^ Xor.coerceToBoolean(this._secondOperand.evaluate(activator, previous));
        }
    }
}

