/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui.util;

public final class Rectangle {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle(int x, int y, int width, int height) {
        this.set(x, y, width, height);
    }

    public Rectangle(Rectangle other) {
        this.set(other);
    }

    public Rectangle() {
    }

    public int getArea() {
        return this.width * this.height;
    }

    public Rectangle intersectLocal(Rectangle other) {
        return this.intersect(other, this);
    }

    public Rectangle intersect(Rectangle other) {
        return this.intersect(other, new Rectangle());
    }

    public Rectangle intersect(Rectangle other, Rectangle result) {
        int x1 = Math.max(this.x, other.x);
        int y1 = Math.max(this.y, other.y);
        int x2 = Math.min(this.x + this.width, other.x + other.width);
        int y2 = Math.min(this.y + this.height, other.y + other.height);
        return result.set(x1, y1, Math.max(0, x2 - x1), Math.max(0, y2 - y1));
    }

    public Rectangle set(Rectangle other) {
        return this.set(other.x, other.y, other.width, other.height);
    }

    public Rectangle set(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public void add(int x, int y, int width, int height) {
        int fx = Math.max(this.x + this.width, x + width);
        int fy = Math.max(this.y + this.height, y + height);
        this.x = Math.min(x, this.x);
        this.y = Math.min(y, this.y);
        this.width = fx - this.x;
        this.height = fy - this.y;
    }

    public void grow(int h, int v) {
        this.x -= h;
        this.y -= v;
        this.width += h * 2;
        this.height += v * 2;
    }

    public boolean equals(Object other) {
        if (other instanceof Rectangle) {
            Rectangle orect = (Rectangle)other;
            return this.x == orect.x && this.y == orect.y && this.width == orect.width && this.height == orect.height;
        }
        return false;
    }

    public int hashCode() {
        return this.x ^ this.y ^ this.width ^ this.height;
    }

    public String toString() {
        return String.valueOf(this.width) + "x" + this.height + (this.x >= 0 ? "+" : "") + this.x + (this.y >= 0 ? "+" : "") + this.y;
    }
}

