/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.opengl.gui;

import com.google.common.annotations.Beta;
import com.samskivert.util.HashIntMap;
import com.samskivert.util.ObserverList;
import com.threerings.openal.Sound;
import com.threerings.openal.SoundGroup;
import com.threerings.opengl.gui.Component;
import com.threerings.opengl.gui.Cursor;
import com.threerings.opengl.gui.Log;
import com.threerings.opengl.gui.TransferHandler;
import com.threerings.opengl.gui.Window;
import com.threerings.opengl.gui.config.CursorConfig;
import com.threerings.opengl.gui.event.Event;
import com.threerings.opengl.gui.event.EventListener;
import com.threerings.opengl.gui.event.FocusEvent;
import com.threerings.opengl.gui.event.KeyEvent;
import com.threerings.opengl.gui.event.MouseEvent;
import com.threerings.opengl.gui.icon.Icon;
import com.threerings.opengl.gui.layout.BorderLayout;
import com.threerings.opengl.renderer.Color4f;
import com.threerings.opengl.renderer.Renderer;
import com.threerings.opengl.util.GlContext;
import com.threerings.opengl.util.SimpleOverlay;
import com.threerings.opengl.util.Tickable;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.im.InputContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import org.lwjgl.opengl.GL11;

public abstract class Root
extends SimpleOverlay
implements Tickable {
    public static final String DEFAULT_CURSOR = "Default";
    protected long _tickStamp;
    protected int _modifiers;
    protected int _mouseX;
    protected int _mouseY;
    protected Clipboard _clipboard;
    protected Window _tipwin;
    protected float _lastMoveTime;
    protected float _tipTime = 0.3f;
    protected float _lastTipTime;
    protected int _tipWidth = -1;
    protected Color4f _modalShade;
    protected InputContext _inputContext = InputContext.getInstance();
    protected ArrayList<Window> _windows = new ArrayList();
    protected Component _hcomponent;
    protected Component _ccomponent;
    protected Component _focus;
    protected ArrayList<Component> _defaults = new ArrayList();
    protected ObserverList<Tickable> _tickParticipants = ObserverList.newSafeInOrder();
    protected TickOp _tickOp = new TickOp();
    protected CopyOnWriteArrayList<EventListener> _globals = new CopyOnWriteArrayList();
    protected ArrayList<Component> _invalidRoots = new ArrayList();
    protected SoundGroup _soundGroup;
    protected Cursor _cursor;
    protected ButtonRecord[] _buttons = new ButtonRecord[]{new ButtonRecord(), new ButtonRecord(), new ButtonRecord()};
    protected HashIntMap<KeyRecord> _pressedKeys = new HashIntMap();
    protected int _px;
    protected int _py;
    protected TransferHandler _dhandler;
    protected Component _dsource;
    protected Transferable _ddata;
    protected int _daction;
    protected Icon _dicon;
    protected static final float TIP_MODE_RESET = 0.3f;
    protected static final long CLICK_INTERVAL = 250L;
    protected static final long CLICK_CHAIN_INTERVAL = 250L;
    protected static final int KEY_REPEAT_RATE = 25;
    protected static final long KEY_REPEAT_DELAY = 500L;
    protected static final int DRAG_DISTANCE = 16;
    protected static final int SOUND_SOURCES = 2;

    public Root(GlContext ctx) {
        super(ctx);
        this._soundGroup = ctx.getSoundManager().createGroup(ctx.getClipProvider(), 2);
    }

    public void dispose() {
        this._soundGroup.dispose();
    }

    public SoundGroup getSoundGroup() {
        return this._soundGroup;
    }

    public void playSound(String path) {
        this.getSound(path).play(true);
    }

    public Sound getSound(String path) {
        Sound sound = this._soundGroup.getSound(path);
        sound.setSourceRelative(true);
        return sound;
    }

    public long getTickStamp() {
        return this._tickStamp;
    }

    public int getModifiers() {
        return this._modifiers;
    }

    public Clipboard getClipboard() {
        return this._clipboard;
    }

    public String getClipboardText() {
        if (this._clipboard == null) {
            return null;
        }
        try {
            Transferable contents = this._clipboard.getContents(this);
            return contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor) ? (String)contents.getTransferData(DataFlavor.stringFlavor) : null;
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to access clipboard.", new Object[]{e});
            return null;
        }
    }

    public void setClipboardText(String text) {
        if (this._clipboard == null) {
            return;
        }
        StringSelection select = new StringSelection(text);
        this._clipboard.setContents(select, select);
    }

    public void addWindow(Window window) {
        this.addWindow(window, false);
    }

    public void addWindow(Window window, boolean topLayer) {
        Window curtop = this.getTopWindow();
        if (topLayer && curtop != null) {
            window.setLayer(Math.max(window.getLayer(), curtop.getLayer()));
        }
        this._windows.add(window);
        this.resortWindows();
        Component pendfocus = null;
        if (this._windows.get(this._windows.size() - 1) == window && !window.isOverlay()) {
            if (this._focus != null && curtop != null) {
                curtop._savedFocus = this._focus;
                this.setFocus(null);
            }
            pendfocus = window._savedFocus;
            window._savedFocus = null;
        }
        window.setRoot(this);
        if (this._focus == null && pendfocus != null) {
            this.setFocus(pendfocus);
        }
        this.updateHoverComponent(this._mouseX, this._mouseY);
    }

    public boolean isOnTop(Window window) {
        return window == this.getTopWindow();
    }

    public void moveToTop(Window window) {
        Window curtop = this.getTopWindow();
        if (curtop != null) {
            window.setLayer(Math.max(window.getLayer(), curtop.getLayer()));
            if (this._windows.remove(window)) {
                this._windows.add(window);
            }
        }
    }

    public Window getTopWindow() {
        int size = this._windows.size();
        return size == 0 ? null : this._windows.get(size - 1);
    }

    public void resortWindows() {
        Collections.sort(this._windows);
    }

    public void removeAllWindows() {
        this.setFocus(null);
        int ii = this._windows.size() - 1;
        while (ii >= 0) {
            Window window = this._windows.remove(ii);
            window.setRoot(null);
            --ii;
        }
        this.updateHoverComponent(this._mouseX, this._mouseY);
    }

    public void removeWindow(Window window) {
        if (this._focus != null && this._focus.getWindow() == window) {
            this.setFocus(null);
        }
        window._savedFocus = null;
        if (!this._windows.remove(window)) {
            Log.log.warning((Object)"Requested to remove unmanaged window.", new Object[]{"window", window, new Exception()});
            return;
        }
        this.updateHoverComponent(this._mouseX, this._mouseY);
        window.setRoot(null);
        Window[] windowArray = this._windows.toArray(new Window[this._windows.size()]);
        int n = windowArray.length;
        int n2 = 0;
        while (n2 < n) {
            Window owindow = windowArray[n2];
            if (owindow.getParentWindow() == window) {
                this.removeWindow(owindow);
            }
            ++n2;
        }
        if (this._windows.size() > 0) {
            Window top = this._windows.get(this._windows.size() - 1);
            top.gotFocus();
        }
    }

    public void addTickParticipant(Tickable participant) {
        this._tickParticipants.add((Object)participant);
    }

    public void removeTickParticipant(Tickable participant) {
        this._tickParticipants.remove((Object)participant);
    }

    public void setTooltipTimeout(float seconds) {
        this._tipTime = seconds;
    }

    public float getTooltipTimeout() {
        float htimeout = this._hcomponent == null ? -1.0f : this._hcomponent.getTooltipTimeout();
        return htimeout < 0.0f ? this._tipTime : htimeout;
    }

    public void setTooltipPreferredWidth(int width) {
        this._tipWidth = width;
    }

    public void addGlobalEventListener(EventListener listener) {
        this._globals.add(listener);
    }

    public void removeGlobalEventListener(EventListener listener) {
        this._globals.remove(listener);
    }

    public void rootInvalidated(Component root) {
        if (!this._invalidRoots.contains(root)) {
            this._invalidRoots.add(root);
        }
    }

    public void pushDefaultEventTarget(Component component) {
        this._defaults.add(component);
    }

    public void popDefaultEventTarget(Component component) {
        this._defaults.remove(component);
    }

    public void requestFocus(Component component) {
        this.setFocus(component);
    }

    public Component getFocus() {
        return this._focus != null && this._focus.isEnabled() ? this._focus : null;
    }

    public int getWindowCount() {
        return this._windows.size();
    }

    public Window getWindow(int index) {
        return this._windows.get(index);
    }

    public abstract int getDisplayWidth();

    public abstract int getDisplayHeight();

    public void setCursor(Cursor cursor) {
        if (this._cursor == cursor) {
            return;
        }
        this._cursor = cursor;
        if (!this.isDragging()) {
            this.updateCursor(cursor);
        }
    }

    public void setMousePosition(int x, int y) {
        this.mouseMoved(this._tickStamp, x, y, false);
    }

    @Beta
    public void setMouseDown(int button) {
        this.mousePressed(this._tickStamp, button, this._mouseX, this._mouseY, false);
    }

    @Beta
    public void setMouseUp(int button) {
        this.mouseReleased(this._tickStamp, button, this._mouseX, this._mouseY, false);
    }

    public int getMouseX() {
        return this._mouseX;
    }

    public int getMouseY() {
        return this._mouseY;
    }

    public String toString() {
        return "Root@" + this.hashCode();
    }

    public void tipTextChanged(Component component) {
        if (component == this._hcomponent) {
            this.clearTipWindow();
        }
    }

    public void setModalShade(Color4f color) {
        this._modalShade = color;
    }

    public void startDrag(TransferHandler handler, Component source, int action) {
        this._dhandler = handler;
        this._dsource = source;
        this._ddata = handler.createTransferable(source);
        this._daction = action;
        this._dicon = handler.getVisualRepresentation(this._ddata);
        long now = System.currentTimeMillis();
        this.dispatchMouseEvent(this._ccomponent, new MouseEvent(this, now, 0, 6, Integer.MIN_VALUE, Integer.MIN_VALUE));
        this.dispatchMouseEvent(this._ccomponent, new MouseEvent(this, now, 0, 1, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 1));
        this._ccomponent = null;
        this.updateCursor(null);
        this.updateHoverComponent(this._mouseX, this._mouseY);
    }

    public void clearDrag() {
        this._dhandler = null;
        this._dsource = null;
        this._ddata = null;
        this._dicon = null;
        this.updateCursor(this._cursor);
        this.updateHoverComponent(this._mouseX, this._mouseY);
    }

    public boolean isDragging() {
        return this._dhandler != null;
    }

    @Override
    public void tick(float elapsed) {
        String tiptext;
        this._tickStamp = System.currentTimeMillis();
        this._tickParticipants.apply((ObserverList.ObserverOp)this._tickOp.init(elapsed));
        if (!this._pressedKeys.isEmpty()) {
            for (KeyRecord key : this._pressedKeys.values()) {
                key.maybeRepeat();
            }
        }
        boolean updateHover = false;
        while (this._invalidRoots.size() > 0) {
            Component root = this._invalidRoots.remove(0);
            if (!root.isAdded()) continue;
            root.validate();
            updateHover = true;
        }
        if (updateHover) {
            this.updateHoverComponent(this._mouseX, this._mouseY);
        }
        this._lastMoveTime += elapsed;
        this._lastTipTime += elapsed;
        if (this._hcomponent == null || this._tipwin != null || this._lastMoveTime < this.getTooltipTimeout() && this._lastTipTime > 0.3f || (tiptext = this._hcomponent.getTooltipText()) == null) {
            if (this._tipwin != null) {
                this._lastTipTime = 0.0f;
            }
            return;
        }
        Window hwin = this._hcomponent.getWindow();
        Component tcomp = this._hcomponent.createTooltipComponent(tiptext);
        if (hwin == null || tcomp == null) {
            return;
        }
        this._tipwin = new Window(this._ctx, new BorderLayout()){

            @Override
            public boolean isOverlay() {
                return true;
            }
        };
        this.addWindow(this._tipwin, true);
        this._tipwin.setStyleConfig(this._hcomponent.getTooltipWindowStyle());
        this._tipwin.add(tcomp, BorderLayout.CENTER);
        if (this._tipwin == null) {
            return;
        }
        int width = this.getDisplayWidth();
        int height = this.getDisplayHeight();
        this._tipwin.pack(this._tipWidth == -1 ? width - 10 : this._tipWidth, height - 10);
        int tx = 0;
        int ty = 0;
        if (this._hcomponent.isTooltipRelativeToMouse()) {
            tx = this._mouseX - this._tipwin.getWidth() / 2;
            ty = this._mouseY + 10;
        } else {
            tx = this._hcomponent.getAbsoluteX() + (this._hcomponent.getWidth() - this._tipwin.getWidth()) / 2;
            ty = this._hcomponent.getAbsoluteY() + this._hcomponent.getHeight() + 10;
        }
        tx = Math.max(5, Math.min(tx, width - this._tipwin.getWidth() - 5));
        ty = Math.min(ty, height - this._tipwin.getHeight() - 5);
        this._tipwin.setLocation(tx, ty);
        this._tipwin.validate();
    }

    @Override
    protected void draw() {
        Window modalWin = null;
        if (this._modalShade != null) {
            int ii = this._windows.size() - 1;
            while (ii >= 0) {
                Window win = this._windows.get(ii);
                if (win.shouldShadeBehind()) {
                    modalWin = win;
                    break;
                }
                --ii;
            }
        }
        Renderer renderer = this._ctx.getRenderer();
        renderer.setMatrixMode(5888);
        int ii = 0;
        int ll = this._windows.size();
        while (ii < ll) {
            Window win = this._windows.get(ii);
            try {
                if (win == modalWin) {
                    this.renderModalShade(renderer);
                }
                win.render(renderer);
            }
            catch (Throwable t) {
                Log.log.warning((Object)(win + " failed in render()"), new Object[]{t});
            }
            ++ii;
        }
        if (this._dicon != null) {
            this._dicon.render(renderer, this._mouseX - this._dicon.getWidth() / 2, this._mouseY - this._dicon.getHeight() / 2, 0.5f);
        }
    }

    protected abstract void updateCursor(Cursor var1);

    protected Cursor getDefaultCursor() {
        CursorConfig config = this._ctx.getConfigManager().getConfig(CursorConfig.class, DEFAULT_CURSOR);
        return config == null ? null : config.getCursor(this._ctx);
    }

    protected void mousePressed(long when, int button, int x, int y, boolean consume) {
        this.checkMouseMoved(x, y);
        this._ccomponent = this.getTargetComponent();
        this.setFocus(this._ccomponent);
        MouseEvent event = new MouseEvent(this, when, this._modifiers, 0, button, x, y);
        if (consume) {
            event.consume();
        }
        if (button == 0) {
            this._px = x;
            this._py = y;
        }
        this.dispatchMouseEvent(this._ccomponent, event);
    }

    protected void mouseReleased(long when, int button, int x, int y, boolean consume) {
        this.checkMouseMoved(x, y);
        if (button == 0 && this._dhandler != null) {
            TransferHandler chandler;
            TransferHandler transferHandler = chandler = this._hcomponent == null ? null : this._hcomponent.getTransferHandler();
            if (chandler != null && chandler.importData(this._hcomponent, this._ddata)) {
                this._dhandler.exportDone(this._dsource, this._ddata, this._daction);
            }
            this.clearDrag();
        }
        MouseEvent event = new MouseEvent(this, when, this._modifiers, 1, button, x, y);
        if (consume) {
            event.consume();
        }
        this.dispatchMouseEvent(this.getTargetComponent(), event);
        this._ccomponent = null;
        this.updateHoverComponent(this._mouseX, this._mouseY);
    }

    protected void mouseMoved(long when, int x, int y, boolean consume) {
        if (!this.checkMouseMoved(x, y)) {
            return;
        }
        Component tcomponent = this.getTargetComponent();
        int type = tcomponent != null && tcomponent == this._ccomponent ? 6 : 5;
        MouseEvent event = new MouseEvent(this, when, this._modifiers, type, this._mouseX, this._mouseY);
        if (consume) {
            event.consume();
        }
        if (type == 6 && (this._modifiers & 1) != 0) {
            TransferHandler handler = tcomponent.getTransferHandler();
            int actions = handler == null ? 0 : handler.getSourceActions(tcomponent);
            int dist = Math.abs(x - this._px) + Math.abs(y - this._py);
            if (actions != 0 && dist >= 16) {
                handler.exportAsDrag(tcomponent, event, actions == 1 ? actions : 2);
            }
        }
        this.dispatchMouseEvent(tcomponent, event);
    }

    protected void mouseWheeled(long when, int x, int y, int delta, boolean consume) {
        this.checkMouseMoved(x, y);
        MouseEvent event = new MouseEvent(this, when, this._modifiers, 7, -1, x, y, 0, delta);
        if (consume) {
            event.consume();
        }
        this.dispatchMouseEvent(this.getTargetComponent(), event);
        this.updateHoverComponent(this._mouseX, this._mouseY);
    }

    protected boolean checkMouseMoved(int x, int y) {
        if (this._mouseX != x || this._mouseY != y) {
            this.mouseDidMove(x, y);
            return true;
        }
        return false;
    }

    protected void keyPressed(long when, char keyChar, int keyCode, boolean consume) {
        KeyEvent event = new KeyEvent(this, when, this._modifiers, 0, keyChar, keyCode, false);
        if (consume) {
            event.consume();
        }
        this.dispatchKeyEvent(this.getFocus(), event);
    }

    protected void keyReleased(long when, char keyChar, int keyCode, boolean consume) {
        KeyEvent event = new KeyEvent(this, when, this._modifiers, 1, keyChar, keyCode, false);
        if (consume) {
            event.consume();
        }
        this.dispatchKeyEvent(this.getFocus(), event);
    }

    protected boolean dispatchMouseEvent(Component target, MouseEvent event) {
        boolean dispatched = this.dispatchEvent(target, event);
        int type = event.getType();
        if (type == 0) {
            this._buttons[event.getButton()].wasPressed(target, event);
        } else if (type == 1) {
            this._buttons[event.getButton()].wasReleased(target, event);
        }
        return dispatched;
    }

    protected boolean dispatchKeyEvent(Component target, KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (keyCode != 0) {
            if (event.getType() == 0) {
                if (this._pressedKeys.containsKey(keyCode)) {
                    return false;
                }
                this._pressedKeys.put(keyCode, (Object)new KeyRecord(event));
            } else {
                this._pressedKeys.remove(event.getKeyCode());
            }
        }
        return this.dispatchEvent(target, event);
    }

    protected boolean dispatchEvent(Component target, Event event) {
        for (EventListener listener : this._globals) {
            try {
                listener.eventDispatched(event);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Global event listener choked.", new Object[]{"listener", listener, e});
            }
        }
        Window sentwin = null;
        if (target != null) {
            if (target.dispatchEvent(event)) {
                return true;
            }
            sentwin = target.getWindow();
        }
        int ii = this._windows.size() - 1;
        while (ii >= 0) {
            Window window = this._windows.get(ii);
            if (window.isModal()) {
                if (window == sentwin || !window.dispatchEvent(event)) break;
                return true;
            }
            --ii;
        }
        ii = this._defaults.size() - 1;
        while (ii >= 0) {
            Component deftarg = this._defaults.get(ii);
            if (deftarg.dispatchEvent(event)) {
                return true;
            }
            --ii;
        }
        return false;
    }

    protected void setFocus(Component focus) {
        if (focus != null) {
            focus = focus.getFocusTarget();
        }
        if (this._focus != focus) {
            Component oldFocus = this._focus;
            this._focus = focus;
            if (oldFocus != null) {
                oldFocus.dispatchEvent(new FocusEvent(this, this.getTickStamp(), 1));
            }
            if (this._focus != null) {
                this._focus.dispatchEvent(new FocusEvent(this, this.getTickStamp(), 0));
            }
        }
    }

    protected void windowDidMove(Window window) {
        this.updateHoverComponent(this._mouseX, this._mouseY);
    }

    protected void mouseDidMove(int mouseX, int mouseY) {
        this._mouseX = mouseX;
        this._mouseY = mouseY;
        this.updateHoverComponent(this._mouseX, this._mouseY);
        if (this._tipwin == null) {
            this._lastMoveTime = 0.0f;
        }
    }

    protected void updateHoverComponent(int mx, int my) {
        if (this._ccomponent != null) {
            return;
        }
        Component nhcomponent = null;
        int ii = this._windows.size() - 1;
        while (ii >= 0) {
            TransferHandler chandler;
            Window comp = this._windows.get(ii);
            nhcomponent = comp.getHitComponent(mx, my);
            if (nhcomponent != null && nhcomponent.getWindow() != this._tipwin && (this._dhandler == null || (chandler = nhcomponent.getTransferHandler()) != null && chandler.canImport(nhcomponent, this._ddata.getTransferDataFlavors())) || comp.isModal()) break;
            --ii;
        }
        if (this._hcomponent != nhcomponent) {
            if (this._hcomponent != null) {
                this._hcomponent.dispatchEvent(new MouseEvent(this, this.getTickStamp(), this._modifiers, 4, mx, my));
            }
            if (nhcomponent != null) {
                nhcomponent.dispatchEvent(new MouseEvent(this, this.getTickStamp(), this._modifiers, 3, mx, my));
            }
            this._hcomponent = nhcomponent;
            if (this._hcomponent == null || this._hcomponent.getWindow() != this._tipwin) {
                this.clearTipWindow();
            }
        }
    }

    protected Component getTargetComponent() {
        if (this._ccomponent != null) {
            return this._ccomponent;
        }
        if (this._hcomponent != null) {
            return this._hcomponent;
        }
        return null;
    }

    protected void clearTipWindow() {
        this._lastMoveTime = 0.0f;
        if (this._tipwin != null) {
            Window tipwin = this._tipwin;
            this._tipwin = null;
            this.removeWindow(tipwin);
        }
    }

    protected void renderModalShade(Renderer renderer) {
        int width = this.getDisplayWidth();
        int height = this.getDisplayHeight();
        renderer.setColorState(this._modalShade);
        renderer.setTextureState(null);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)width, (float)0.0f);
        GL11.glVertex2f((float)width, (float)height);
        GL11.glVertex2f((float)0.0f, (float)height);
        GL11.glEnd();
    }

    public InputContext getInputContext() {
        return this._inputContext;
    }

    protected class ButtonRecord {
        protected long _clickTime;
        protected long _chainTime;
        protected int _count;

        protected ButtonRecord() {
        }

        public void wasPressed(Component target, MouseEvent press) {
            long when = press.getWhen();
            this._clickTime = when + 250L;
            this._count = when < this._chainTime ? this._count + 1 : 1;
        }

        public void wasReleased(Component target, MouseEvent release) {
            long when = release.getWhen();
            if (when < this._clickTime) {
                MouseEvent event = new MouseEvent(Root.this, when, Root.this._modifiers, 2, release.getButton(), release.getX(), release.getY(), this._count);
                Root.this.dispatchEvent(target, event);
                this._chainTime = when + 250L;
            }
        }
    }

    protected class KeyRecord {
        protected KeyEvent _press;
        protected long _nextRepeat;

        public KeyRecord(KeyEvent press) {
            this._press = press;
            this._nextRepeat = press.getWhen() + 500L;
        }

        public KeyEvent getPress() {
            return this._press;
        }

        public void maybeRepeat() {
            if (Root.this._tickStamp < this._nextRepeat) {
                return;
            }
            KeyEvent event = new KeyEvent(Root.this, Root.this._tickStamp, Root.this._modifiers, 0, this._press.getKeyChar(), this._press.getKeyCode(), true);
            Root.this.dispatchEvent(Root.this.getFocus(), event);
            this._nextRepeat += 40L;
        }
    }

    protected static class TickOp
    implements ObserverList.ObserverOp<Tickable> {
        protected float _elapsed;

        protected TickOp() {
        }

        public TickOp init(float elapsed) {
            this._elapsed = elapsed;
            return this;
        }

        public boolean apply(Tickable tickable) {
            tickable.tick(this._elapsed);
            return true;
        }
    }
}

