/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.util;

import com.google.common.base.Objects;
import com.threerings.editor.Editable;
import com.threerings.export.Exportable;
import com.threerings.io.Streamable;
import com.threerings.util.DeepObject;
import com.threerings.util.Validatable;

public class DateRange
extends DeepObject
implements Streamable,
Exportable,
Validatable {
    protected long _startTime;
    protected long _stopTime;

    public boolean isActive(long now) {
        return now >= this._startTime && now < this._stopTime;
    }

    @Override
    public boolean isValid() {
        return this._startTime <= this._stopTime;
    }

    public Long getNextTime(long now) {
        return this._startTime >= this._stopTime || now >= this._stopTime ? null : Long.valueOf(now < this._startTime ? this._startTime : this._stopTime);
    }

    @Editable
    public Long getStartTime() {
        return this._startTime == Long.MIN_VALUE ? null : Long.valueOf(this._startTime);
    }

    @Editable(editor="datetime", nullable=true, mode="%INHERIT%", hgroup="a", weight=1.0)
    public void setStartTime(Long time) {
        this._startTime = time == null ? Long.MIN_VALUE : time;
    }

    @Editable
    public Long getStopTime() {
        return this._stopTime == Long.MAX_VALUE ? null : Long.valueOf(this._stopTime);
    }

    @Editable(editor="datetime", nullable=true, mode="%INHERIT%", hgroup="a", weight=2.0)
    public void setStopTime(Long time) {
        this._stopTime = time == null ? Long.MAX_VALUE : time;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)this).add("startTime", (Object)this.getStartTime()).add("stopTime", (Object)this.getStopTime()).toString();
    }

    @Override
    public DateRange clone() {
        return (DateRange)super.clone();
    }
}

